/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserException;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgColumnPrivilege;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgFunction;
import cz.startnet.utils.pgdiff.schema.PgRelation;
import cz.startnet.utils.pgdiff.schema.PgRelationPrivilege;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import cz.startnet.utils.pgdiff.schema.PgSequencePrivilege;
import cz.startnet.utils.pgdiff.schema.PgTable;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class GrantRevokeParser {
    public static void parse(PgDatabase pgDatabase, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        boolean bl2 = false;
        Parser parser = new Parser(string);
        boolean bl3 = parser.expect("GRANT", true);
        if (!bl3) {
            parser.expect("REVOKE");
            bl2 = parser.expect("GRANT OPTION FOR", true);
        }
        String string2 = parser.expectOptionalOneOf("ALL", "SELECT", "INSERT", "UPDATE", "DELETE", "TRUNCATE", "REFERENCES", "TRIGGER", "USAGE");
        List<String> list = null;
        if (string2 == null) {
            if (bl) {
                pgDatabase.addIgnoredStatement(string);
                return;
            }
            return;
        }
        if (string2 != null && "ALL".equalsIgnoreCase(string2)) {
            parser.expectOptional("PRIVILEGES");
        }
        list = string2 != null && "ALL".equalsIgnoreCase(string2) || "SELECT".equalsIgnoreCase(string2) || "INSERT".equalsIgnoreCase(string2) || "UPDATE".equalsIgnoreCase(string2) || "REFERENCES".equalsIgnoreCase(string2) ? GrantRevokeParser.parseColumns(parser, pgDatabase, string, bl) : null;
        arrayList.add(string2);
        arrayList2.add(list);
        while (string2 != null) {
            if (parser.expectOptional(",")) {
                string2 = parser.expectOptionalOneOf("SELECT", "INSERT", "UPDATE", "DELETE", "TRUNCATE", "REFERENCES", "TRIGGER", "USAGE");
                list = string2 != null && "ALL".equalsIgnoreCase(string2) || "SELECT".equalsIgnoreCase(string2) || "INSERT".equalsIgnoreCase(string2) || "UPDATE".equalsIgnoreCase(string2) || "REFERENCES".equalsIgnoreCase(string2) ? GrantRevokeParser.parseColumns(parser, pgDatabase, string, bl) : null;
                arrayList.add(string2);
                arrayList2.add(list);
                continue;
            }
            string2 = null;
        }
        boolean bl4 = parser.expectOptional("ON");
        if (!bl4 && bl) {
            pgDatabase.addIgnoredStatement(string);
            return;
        }
        String string3 = parser.expectOptionalOneOf("TABLE", "ALL TABLES IN SCHEMA", "SEQUENCE", "ALL SEQUENCES IN SCHEMA", "DATABASE", "DOMAIN", "FOREIGN DATA WRAPPER", "FOREIGN SERVER", "FUNCTION", "ALL FUNCTIONS IN SCHEMA", "LANGUAGE", "LARGE OBJECT", "SCHEMA", "TABLESPACE", "TYPE");
        if (string3 == null) {
            string3 = "TABLE";
        }
        String string4 = parser.parseIdentifier();
        if ("FUNCTION".equalsIgnoreCase(string3) || "ALL FUNCTIONS IN SCHEMA".equalsIgnoreCase(string3)) {
            GrantRevokeParser.parseConsumeFunctionSignature(parser, pgDatabase, string, bl);
        }
        arrayList3.add(string4);
        while (string4 != null) {
            if (parser.expectOptional(",")) {
                string4 = parser.parseIdentifier();
                if ("FUNCTION".equalsIgnoreCase(string3) || "ALL FUNCTIONS IN SCHEMA".equalsIgnoreCase(string3)) {
                    GrantRevokeParser.parseConsumeFunctionSignature(parser, pgDatabase, string, bl);
                }
                arrayList3.add(string4);
                continue;
            }
            string4 = null;
        }
        if (bl3) {
            parser.expect("TO");
        } else {
            parser.expect("FROM");
        }
        parser.expectOptional("GROUP");
        String string5 = parser.parseIdentifier();
        arrayList4.add(string5);
        while (string5 != null) {
            if (parser.expectOptional(",")) {
                parser.expectOptional("GROUP");
                string5 = parser.parseIdentifier();
                arrayList4.add(string5);
                continue;
            }
            string5 = null;
        }
        if (bl3) {
            bl2 = parser.expectOptional("WITH GRANT OPTION");
        } else {
            String string6 = parser.expectOptionalOneOf("RESTRICT", "CASCADE");
            if ("CASCADE".equalsIgnoreCase(string6) && bl) {
                pgDatabase.addIgnoredStatement(string);
                return;
            }
        }
        if ("TABLE".equalsIgnoreCase(string3)) {
            for (String string7 : arrayList3) {
                String string8 = ParserUtils.getSchemaName(string7, pgDatabase);
                PgSchema pgSchema = pgDatabase.getSchema(string8);
                if (pgSchema == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string8, string));
                }
                String string9 = ParserUtils.getObjectName(string7);
                PgTable pgTable = pgSchema.getTable(string9);
                PgView pgView = pgSchema.getView(string9);
                if (pgTable == null && pgView == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindObject"), string7, string));
                }
                PgRelation pgRelation = pgTable != null ? pgTable : pgView;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object object;
                    String string10 = (String)arrayList.get(i);
                    List list2 = (List)arrayList2.get(i);
                    if (list2 != null) {
                        for (String string11 : list2) {
                            if (pgRelation.containsColumn(string11)) {
                                object = pgRelation.getColumn(string11);
                                if (object == null) {
                                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), string11, pgRelation.getName(), parser.getString()));
                                }
                                for (String string12 : arrayList4) {
                                    PgColumnPrivilege pgColumnPrivilege = ((PgColumn)object).getPrivilege(string12);
                                    if (pgColumnPrivilege == null) {
                                        pgColumnPrivilege = new PgColumnPrivilege(string12);
                                        ((PgColumn)object).addPrivilege(pgColumnPrivilege);
                                    }
                                    pgColumnPrivilege.setPrivileges(string10, bl3, bl2);
                                }
                                continue;
                            }
                            throw new ParserException(MessageFormat.format(Resources.getString("CannotFindColumnInTable"), string11, pgRelation.getName()));
                        }
                        continue;
                    }
                    for (String string11 : arrayList4) {
                        object = pgRelation.getPrivilege(string11);
                        if (object == null) {
                            object = new PgRelationPrivilege(string11);
                            pgRelation.addPrivilege((PgRelationPrivilege)object);
                        }
                        ((PgRelationPrivilege)object).setPrivileges(string10, bl3, bl2);
                    }
                }
            }
        } else if ("SEQUENCE".equalsIgnoreCase(string3)) {
            for (String string13 : arrayList3) {
                String string14 = ParserUtils.getSchemaName(string13, pgDatabase);
                PgSchema pgSchema = pgDatabase.getSchema(string14);
                if (pgSchema == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string14, string));
                }
                String string15 = ParserUtils.getObjectName(string13);
                PgSequence pgSequence = pgSchema.getSequence(string15);
                if (pgSequence == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSequence"), string13, string));
                }
                for (String string16 : arrayList4) {
                    PgSequencePrivilege pgSequencePrivilege = pgSequence.getPrivilege(string16);
                    if (pgSequencePrivilege == null) {
                        pgSequencePrivilege = new PgSequencePrivilege(string16);
                        pgSequence.addPrivilege(pgSequencePrivilege);
                    }
                    for (String string17 : arrayList) {
                        pgSequencePrivilege.setPrivileges(string17, bl3, bl2);
                    }
                }
            }
        } else if (bl) {
            pgDatabase.addIgnoredStatement(string);
        }
    }

    private static void parseConsumeFunctionSignature(Parser parser, PgDatabase pgDatabase, String string, boolean bl) {
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            String string2 = parser.expectOptional("IN") ? "IN" : (parser.expectOptional("OUT") ? "OUT" : (parser.expectOptional("INOUT") ? "INOUT" : (parser.expectOptional("VARIADIC") ? "VARIADIC" : null)));
            int n = parser.getPosition();
            String string3 = null;
            String string4 = parser.parseDataType();
            int n2 = parser.getPosition();
            if (!parser.expectOptional(")") && !parser.expectOptional(",")) {
                parser.setPosition(n);
                string3 = ParserUtils.getObjectName(parser.parseIdentifier());
                string4 = parser.parseDataType();
            } else {
                parser.setPosition(n2);
            }
            PgFunction.Argument argument = new PgFunction.Argument();
            argument.setDataType(string4);
            argument.setMode(string2);
            argument.setName(string3);
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
    }

    private static List<String> parseColumns(Parser parser, PgDatabase pgDatabase, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = parser.expectOptional("(");
        if (!bl2) {
            return null;
        }
        String string2 = parser.parseIdentifier();
        arrayList.add(string2);
        String string3 = parser.expectOptionalOneOf(",", ")");
        while (string3 != null && ",".equalsIgnoreCase(string3)) {
            string2 = parser.parseIdentifier();
            arrayList.add(string2);
            string3 = parser.expectOptionalOneOf(",", ")");
        }
        return arrayList;
    }

    private GrantRevokeParser() {
    }
}

