MACRO(CONFIGURE_STATS_BACKEND _NAME_TARGET)
    SET(PREVIOUS_INVOCATION ${CONFIGURE_STATS_BACKEND_INVOKED_PREVIOUSLY})
    TARGET_COMPILE_DEFINITIONS(${_NAME_TARGET} PRIVATE -D USE_STATS)
    FIND_LIBRARY(MATH_LIBRARY m)
    IF(MATH_LIBRARY)
        TARGET_LINK_LIBRARIES(${_NAME_TARGET} PRIVATE ${MATH_LIBRARY})
    ENDIF()
    IF(NOT PREVIOUS_INVOCATION)
        MESSAGE(STATUS "Support for statistics backend - Ready")
    ENDIF()
    SET(CONFIGURE_STATS_BACKEND_INVOKED_PREVIOUSLY YES CACHE
        INTERNAL "Mark if CONFIGURE_STATS_BACKEND called successfully" FORCE)
ENDMACRO()
