/* Copyright (C) Teemu Suutari */

#ifndef LZW5DECOMPRESSOR_HPP
#define LZW5DECOMPRESSOR_HPP

#include "XPKDecompressor.hpp"

class LZW5Decompressor : public XPKDecompressor
{
public:
	LZW5Decompressor(uint32_t hdr,uint32_t recursionLevel,const Buffer &packedData,std::unique_ptr<XPKDecompressor::State> &state,bool verify);

	virtual ~LZW5Decompressor();

	virtual const std::string &getSubName() const noexcept override final;

	virtual void decompressImpl(Buffer &rawData,const Buffer &previousData,bool verify) override final;

	static bool detectHeaderXPK(uint32_t hdr) noexcept;
	static std::unique_ptr<XPKDecompressor> create(uint32_t hdr,uint32_t recursionLevel,const Buffer &packedData,std::unique_ptr<XPKDecompressor::State> &state,bool verify);

private:
	const Buffer	&_packedData;

	static XPKDecompressor::Registry<LZW5Decompressor> _XPKregistration;
};

#endif
