# ---------------------------------------------------------------------------
# - SEC0800.als                                                             -
# - afnix:sec module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2021 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   ecc curve test unit
# @author amaury darsch

# get the module
interp:library "afnix-sec"

# SECP192K1
trans p 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFEE37R
trans a 0R
trans b 3R
trans x 0xDB4FF10EC057E9AE26B07D0280B7F4341DA5D1B1EAE06C7DR
trans y 0x9B2F2F6D9C5628A7844163D015BE86344082AA88D95E2F9DR
trans g (afnix:sec:Ecp x y)
trans n 0xFFFFFFFFFFFFFFFFFFFFFFFE26F2FC170F69466A74DEFD8DR
trans h 1R
trans c (afnix:sec:Secp p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECP192R1
trans p 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFR
trans a 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFCR
trans b 0x64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1R
trans x 0x188DA80EB03090F67CBF20EB43A18800F4FF0AFD82FF1012R
trans y 0x07192B95FFC8DA78631011ED6B24CDD573F977A11E794811R
trans g (afnix:sec:Ecp x y)
trans n 0xFFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831R
trans h 1R
trans c (afnix:sec:Secp p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECP224K1
trans p 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56DR
trans a 0R
trans b 5R
trans x 0xA1455B334DF099DF30FC28A169A467E9E47075A90F7E650EB6B7A45CR
trans y 0x7E089FED7FBA344282CAFBD6F7E319F7C0B0BD59E2CA4BDB556D61A5R
trans g (afnix:sec:Ecp x y)
trans n 0x010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7R
trans h 1R
trans c (afnix:sec:Secp p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECP224R1
trans p 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001R
trans a 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFER
trans b 0xB4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4R
trans x 0xB70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21R
trans y 0xBD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34R
trans g (afnix:sec:Ecp x y)
trans n 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3DR
trans h 1R
trans c (afnix:sec:Secp p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECP256K1
trans p 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2FR
trans a 0R
trans b 7R
trans x 0x79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798R
trans y 0x483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8R
trans g (afnix:sec:Ecp x y)
trans n 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141R
trans h 1R
trans c (afnix:sec:Secp p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECP256R1
trans p 0xFFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFR
trans a 0xFFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFCR
trans b 0x5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604BR
trans x 0x6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296R
trans y 0x4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5R
trans g (afnix:sec:Ecp x y)
trans n 0xFFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551R
trans h 1R
trans c (afnix:sec:Secp p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECP384R1
trans p 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶FFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFFR
trans a 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶FFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFCR
trans b 0xB3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE814112◀
         ▶0314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEFR
trans x 0xAA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B98◀
         ▶59F741E082542A385502F25DBF55296C3A545E3872760AB7R
trans y 0x3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147C◀
         ▶E9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5FR
trans g (afnix:sec:Ecp x y)
trans n 0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶C7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973R
trans h 1R
trans c (afnix:sec:Secp p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECP521R1
trans p 0x01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFR
trans a 0x01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCR
trans b 0x0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109◀
         ▶E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00R
trans x 0x00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3D◀
         ▶BAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66R
trans y 0x011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E66◀
         ▶2C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650R
trans g (afnix:sec:Ecp x y)
trans n 0x01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶FA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409R
trans h 1R
trans c (afnix:sec:Secp p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT163K1
trans o 0x01R
trans p (+ (o:shl 163) 0xC9)
trans a 0x01R
trans b 0x01R
trans x 0x02FE13C0537BBC11ACAA07D793DE4E6D5E5C94EEE8R
trans y 0x0289070FB05D38FF58321F2E800536D538CCDAA3D9R
trans g (afnix:sec:Ecp x y)
trans n 0x04000000000000000000020108A2E0CC0D99F8A5EFR
trans h 2R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT163R1
trans o 0x01R
trans p (+ (o:shl 163) 0xC9)
trans a 0x07B6882CAAEFA84F9554FF8428BD88E246D2782AE2R
trans b 0x0713612DCDDCB40AAB946BDA29CA91F73AF958AFD9R
trans x 0x0369979697AB43897789566789567F787A7876A654R
trans y 0x00435EDB42EFAFB2989D51FEFCE3C80988F41FF883R
trans g (afnix:sec:Ecp x y)
trans n 0x03FFFFFFFFFFFFFFFFFFFF48AAB689C29CA710279BR
trans h 2R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT163R2
trans o 0x01R
trans p (+ (o:shl 163) 0xC9)
trans a 0x000000000000000000000000000000000000000001R
trans b 0x020A601907B8C953CA1481EB10512F78744A3205FDR
trans x 0x03F0EBA16286A2D57EA0991168D4994637E8343E36R
trans y 0x00D51FBC6C71A0094FA2CDD545B11C5C0C797324F1R
trans g (afnix:sec:Ecp x y)
trans n 0x040000000000000000000292FE77E70C12A4234C33R
trans h 2R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT233K1
trans o 0x01R
trans p (+ (+ (o:shl 233) (o:shl 74)) 0x01R)
trans a 0x00R
trans b 0x01R
trans x 0x017232BA853A7E731AF129F22FF4149563A419C26BF50A4C9D6EEFAD6126R
trans y 0x01DB537DECE819B7F70F555A67C427A8CD9BF18AEB9B56E0C11056FAE6A3R
trans g (afnix:sec:Ecp x y)
trans n 0x8000000000000000000000000000069D5BB915BCD46EFB1AD5F173ABDFR
trans h 4R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT233R1
trans o 0x01R
trans p (+ (+ (o:shl 233) (o:shl 74)) 0x01R)
trans a 0x01R
trans b 0x0066647EDE6C332C7F8C0923BB58213B333B20E9CE4281FE115F7D8F90ADR
trans x 0x00FAC9DFCBAC8313BB2139F1BB755FEF65BC391F8B36F8F8EB7371FD558BR
trans y 0x01006A08A41903350678E58528BEBF8A0BEFF867A7CA36716F7E01F81052R
trans g (afnix:sec:Ecp x y)
trans n 0x01000000000000000000000000000013E974E72F8A6922031D2603CFE0D7R
trans h 2R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT239K1
trans o 0x01R
trans p (+ (+ (o:shl 239) (o:shl 158)) 0x01R)
trans a 0x00R
trans b 0x01R
trans x 0x29A0B6A887A983E9730988A68727A8B2D126C44CC2CC7B2A6555193035DCR
trans y 0x76310804F12E549BDB011C103089E73510ACB275FC312A5DC6B76553F0CAR
trans g (afnix:sec:Ecp x y)
trans n 0x2000000000000000000000000000005A79FEC67CB6E91F1C1DA800E478A5R
trans h 4R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT283K1
trans o 0x01R
trans p (+ (+ (o:shl 283) (o:shl 12)) 0xA1R)
trans a 0x00R
trans b 0x01R
trans x 0x0503213F78CA44883F1A3B8162F188E553CD◀
         ▶265F23C1567A16876913B0C2AC2458492836R
trans y 0x01CCDA380F1C9E318D90F95D07E5426FE87E◀
         ▶45C0E8184698E45962364E34116177DD2259R
trans g (afnix:sec:Ecp x y)
trans n 0x01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶E9AE2ED07577265DFF7F94451E061E163C61R
trans h 4R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT283R1
trans o 0x01R
trans p (+ (+ (o:shl 283) (o:shl 12)) 0xA1R)
trans a 0x01R
trans b 0x027B680AC8B8596DA5A4AF8A19A0303FCA97◀
         ▶FD7645309FA2A581485AF6263E313B79A2F5R
trans x 0x05F939258DB7DD90E1934F8C70B0DFEC2EED◀
         ▶25B8557EAC9C80E2E198F8CDBECD86B12053R
trans y 0x03676854FE24141CB98FE6D4B20D02B4516F◀
         ▶F702350EDDB0826779C813F0DF45BE8112F4R
trans g (afnix:sec:Ecp x y)
trans n 0x03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶EF90399660FC938A90165B042A7CEFADB307R
trans h 2R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT409K1
trans o 0x01R
trans p (+ (+ (o:shl 409) (o:shl 87)) 0x01R)
trans a 0x00R
trans b 0x01R
trans x 0x0060F05F658F49C1AD3AB1890F7184210EFD0987E307C84C27AC◀
         ▶CFB8F9F67CC2C460189EB5AAAA62EE222EB1B35540CFE9023746R
trans y 0x01E369050B7C4E42ACBA1DACBF04299C3460782F918EA427E632◀
         ▶5165E9EA10E3DA5F6C42E9C55215AA9CA27A5863EC48D8E0286BR
trans g (afnix:sec:Ecp x y)
trans n 0x007FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶FE5F83B2D4EA20400EC4557D5ED3E3E7CA5B4B5C83B8E01E5FCFR
trans h 4R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT409K1
trans o 0x01R
trans p (+ (+ (o:shl 409) (o:shl 87)) 0x01R)
trans a 0x00R
trans b 0x01R
trans x 0x0060F05F658F49C1AD3AB1890F7184210EFD0987E307C84C27AC◀
         ▶CFB8F9F67CC2C460189EB5AAAA62EE222EB1B35540CFE9023746R
trans y 0x01E369050B7C4E42ACBA1DACBF04299C3460782F918EA427E632◀
         ▶5165E9EA10E3DA5F6C42E9C55215AA9CA27A5863EC48D8E0286BR
trans g (afnix:sec:Ecp x y)
trans n 0x007FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶FE5F83B2D4EA20400EC4557D5ED3E3E7CA5B4B5C83B8E01E5FCFR
trans h 4R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT409R1
trans o 0x01R
trans p (+ (+ (o:shl 409) (o:shl 87)) 0x01R)
trans a 0x01R
trans b 0x0021A5C2C8EE9FEB5C4B9A753B7B476B7FD6422EF1F3DD674761◀
         ▶FA99D6AC27C8A9A197B272822F6CD57A55AA4F50AE317B13545FR
trans x 0x015D4860D088DDB3496B0C6064756260441CDE4AF1771D4DB01F◀
         ▶FE5B34E59703DC255A868A1180515603AEAB60794E54BB7996A7R
trans y 0x0061B1CFAB6BE5F32BBFA78324ED106A7636B9C5A7BD198D0158◀
         ▶AA4F5488D08F38514F1FDF4B4F40D2181B3681C364BA0273C706R
trans g (afnix:sec:Ecp x y)
trans n 0x0100000000000000000000000000000000000000000000000000◀
         ▶01E2AAD6A612F33307BE5FA47C3C9E052F838164CD37D9A21173R
trans h 2R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT571K1
trans o 0x01R
trans p (+ (+ (o:shl 571) (o:shl 10)) 0x25R)
trans a 0x00R
trans b 0x01R
trans x 0x026EB7A859923FBC82189631F8103FE4AC9CA2970012D5D4◀
         ▶6024804801841CA44370958493B205E647DA304DB4CEB08C◀
         ▶BBD1BA39494776FB988B47174DCA88C7E2945283A01C8972R
trans y 0x0349DC807F4FBF374F4AEADE3BCA95314DD58CEC9F307A54◀
         ▶FFC61EFC006D8A2C9D4979C0AC44AEA74FBEBBB9F772AEDC◀
         ▶B620B01A7BA7AF1B320430C8591984F601CD4C143EF1C7A3R
trans g (afnix:sec:Ecp x y)
trans n 0x020000000000000000000000000000000000000000000000◀
         ▶000000000000000000000000131850E1F19A63E4B391A8DB◀
         ▶917F4138B630D84BE5D639381E91DEB45CFE778F637C1001R
trans h 4R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

# SECT571R1
trans o 0x01R
trans p (+ (+ (o:shl 571) (o:shl 10)) 0x25R)
trans a 0x01R
trans b 0x02F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1◀
         ▶CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E29◀
         ▶4AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727AR
trans x 0x0303001D34B856296C16C0D40D3CD7750A93D1D2955FA80A◀
         ▶A5F40FC8DB7B2ABDBDE53950F4C0D293CDD711A35B67FB14◀
         ▶99AE60038614F1394ABFA3B4C850D927E1E7769C8EEC2D19R
trans y 0x037BF27342DA639B6DCCFFFEB73D69D78C6C27A6009CBBCA◀
         ▶1980F8533921E8A684423E43BAB08A576291AF8F461BB2A8◀
         ▶B3531D2F0485C19B16E2F1516E23DD3C1A4827AF1B8AC15BR
trans g (afnix:sec:Ecp x y)
trans n 0x03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF◀
         ▶FFFFFFFFFFFFFFFFFFFFFFFFE661CE18FF55987308059B18◀
         ▶6823851EC7DD9CA1161DE93D5174D66E8382E9BB2FE84E47R
trans h 2R
trans c (afnix:sec:Sect p a b g n h)
assert true (c:valid-p)
assert true (c:valid-p g)

