!{\src2tex{textfont=tt}}
!!****f* ABINIT/wrqps
!! NAME
!! wrqps
!!
!! FUNCTION
!!  Write the _QPS file containing information on the quasi-particles
!!  energies and wavefunctions 
!!
!! COPYRIGHT
!!  Copyright (C) 2005-2007 ABINIT group (FBruneval, MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  dtfil= datafile type gathering all the variables related to files
!!  eigvec_qp(nb,nb,nk) 
!!  en_qp(nb,nk),kibz(3,nk)
!!  gwcalctype=integer defining the kind of the GW calculation (see input variable)
!!  m_lda_to_qp(nb,nb,nk)=
!!  nb=number of bands
!!  nk=number of irreducible k-points
!!  nscf=number of self consisten cycles performed
!!  kibz(3,nk)=reduced coordinates of the irreducible k-points
!!
!! OUTPUT
!!  Only write to file _QPS 
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wrqps(dtfil,gwcalctyp,nk,nb,ns,kibz,nscf,nr,en_qp,eigvec_qp,m_lda_to_qp,rho_qp,min_band_proc,max_band_proc)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: gwcalctyp,max_band_proc,min_band_proc,nb,nk,nr,ns,nscf
 type(datafiles_type),intent(in) :: dtfil
!arrays
 real(dp),intent(in) :: en_qp(min_band_proc:max_band_proc,nk,ns),kibz(3,nk)
 real(dp),intent(in) :: rho_qp(nr,ns)
 complex,intent(in) :: eigvec_qp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,nk,ns)
 complex,intent(in) :: m_lda_to_qp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,nk,ns)

!Local variables-------------------------------
!scalars
 integer,parameter :: unitfile=999
 integer :: ib,ik,is
 character(len=500) :: message
 character(len=fnlen) :: filnam
!arrays
 complex :: mtmp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,ns)

! *************************************************************************

!DEBUG
!write(6,*)' wrqps : enter ' 
!ENDDEBUG

!MG FIXME this check should be done before calling the subroutine!!!
 !if non self-consistent calculation, exit immediately
 if(gwcalctyp<10) return

 filnam=trim(dtfil%filnam_ds(4))//'_QPS'
 open(unit=unitfile,file=trim(filnam),form='formatted',status='unknown')
 write(message,'(2a)')' writing out the QP data in file ',trim(dtfil%filnam_ds(4))//'_QPS'
 call wrtout(06,message,'COLL')

 write(unitfile,*) nscf+1
 write(unitfile,*) nk
 write(unitfile,*) max_band_proc-min_band_proc+1
 write(unitfile,*) ns

 do is=1,ns
  do ik=1,nk
   !calculate the new m_lda_to_qp

!  WARNING : THIS WILL NOT EXECUTE CORRECTLY IN CASE OF BAND PARALLELISM

   mtmp(:,:,is)=matmul(m_lda_to_qp(:,:,ik,is),eigvec_qp(:,:,ik,is))

   write(unitfile,*) kibz(:,ik)

   do ib=min_band_proc,max_band_proc
    write(unitfile,*) en_qp(ib,ik,is)
    write(unitfile,*) mtmp(:,ib,is)
   end do !ib
  end do !ik
 end do !is

 write(unitfile,*) rho_qp(:,:)

 close(unitfile)

!DEBUG
!write(6,*)' wrqps : exit '
!ENDDEBUG

end subroutine wrqps
!!***
