#!/usr/bin/perl -w
# --- BEGIN COPYRIGHT BLOCK ---
# Copyright (C) 2001 Sun Microsystems, Inc. Used by permission.
# Copyright (C) 2005 Red Hat, Inc.
# All rights reserved.
#
# License: GPL (version 3 or any later version).
# See LICENSE for details. 
# --- END COPYRIGHT BLOCK ---

$patchdir = "/var/sadm/patch";

# key is the major patch number
# the value is a hash ref which has two keys 'iminor' and 'val'
# the value of key 'iminor' is the minor patch number
# the system keeps track of all revisions (minor number) for each patch (major number)
# we only want to list the highest revision, since on Solaris higher revisions include
# and supersede lower revisions
# the value of key 'val' is the string to print out
%patches = ();

opendir PATCHDIR, $patchdir or die "Error: could not open $patchdir: $!: you must be superuser to run this script\n";
while ($dir = readdir PATCHDIR) {
  if ($dir =~ /(\d+)\-(\d+)/) {
	$major = $1;
	$minor = $2;
	$iminor = int($2);
	if (! $patches{$major} || ! $patches{$major}->{iminor} || ($patches{$major}->{iminor} < $iminor)) {
	  open IN, "$patchdir/$dir/README.$major\-$minor" or die "Error: could not open $patchdir/$dir/README.$major\-$minor: $! - you must be superuser to run this script\n";
	  while (<IN>) {
		chop;
		if (/^Synopsis:\s+/) {
		  $desc = $';
		}
		if (/^Date:\s+/) {
		  $date = $';
		}
		if (/^SunOS Release:\s+(\d+)\.(\d+)/) {
		  $majrel = $1;
		  $minrel = $2;
		  last;
		}
	  }
	  $required = 1; # how to tell if patch is not required, only recommended?
	  $patches{$major}->{val} = "{$major,$iminor,$required,2$minrel,0,0,\"$date: $desc\"},\n";
	  close IN;
	  $patches{$major}->{iminor} = $iminor;
	}
  }
}
closedir PATCHDIR;

$date = gmtime;
$host = `hostname`;
$dom = `domainname`;
$rel = `cat /etc/release`;

chomp $host;
chomp $dom;
chomp $date;
print "/* This list was generated by $0 */\n";
print "/*   on $host.$dom */\n";
print "/*   at $date GMT */\n";
print "/* Here is the information from /etc/release:\n";
print $rel;
print " The following is a list of patches installed on the system */\n";
print "/* a patch that is commented out is either a duplicate or */\n";
print "/* a patch that is superseded by another patch */\n";

for $major (sort keys %patches) {
  print $patches{$major}->{val};
}
