/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;

public final class DRDAServerStarter
implements ModuleControl,
Runnable {
    private Object server;
    private Method runServerMethod;
    private Method serverShutdownMethod;
    private Thread serverThread;
    private static final String serverClassName = "org.apache.derby.impl.drda.NetworkServerControlImpl";
    private Class serverClass;
    private InetAddress listenAddress = null;
    private int portNumber = -1;
    private PrintWriter consoleWriter = null;
    static /* synthetic */ Class class$java$net$InetAddress;

    public void setStartInfo(InetAddress inetAddress, int n, PrintWriter printWriter) {
        this.listenAddress = inetAddress;
        this.portNumber = n;
        this.consoleWriter = printWriter != null ? new PrintWriter((Writer)printWriter, true) : printWriter;
    }

    private void findStartStopMethods(Class clazz) throws SecurityException, NoSuchMethodException {
        this.runServerMethod = clazz.getMethod("blockingStart", PrintWriter.class);
        this.serverShutdownMethod = clazz.getMethod("directShutdown", null);
    }

    public void boot(boolean bl, Properties properties) {
        if (this.server != null) {
            return;
        }
        try {
            this.serverClass = Class.forName(serverClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Monitor.logTextMessage("J100", serverClassName);
            return;
        }
        catch (Error error) {
            Monitor.logTextMessage("J101", serverClassName, error.getMessage());
            return;
        }
        try {
            Constructor constructor;
            try {
                constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException, SecurityException {
                        if (DRDAServerStarter.this.listenAddress == null) {
                            return DRDAServerStarter.this.serverClass.getConstructor(null);
                        }
                        return DRDAServerStarter.this.serverClass.getConstructor(class$java$net$InetAddress == null ? (class$java$net$InetAddress = DRDAServerStarter.class$("java.net.InetAddress")) : class$java$net$InetAddress, Integer.TYPE);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                Monitor.logTextMessage("J102", exception.getMessage());
                privilegedActionException.printStackTrace(Monitor.getStream().getPrintWriter());
                return;
            }
            this.findStartStopMethods(this.serverClass);
            this.server = this.listenAddress == null ? constructor.newInstance(null) : constructor.newInstance(this.listenAddress, new Integer(this.portNumber));
            this.serverThread = Monitor.getMonitor().getDaemonThread(this, "NetworkServerStarter", false);
            this.serverThread.start();
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J102", exception.getMessage());
            this.server = null;
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    public void run() {
        try {
            this.runServerMethod.invoke(this.server, this.consoleWriter);
        }
        catch (InvocationTargetException invocationTargetException) {
            Monitor.logTextMessage("J102", invocationTargetException.getTargetException().getMessage());
            invocationTargetException.printStackTrace(Monitor.getStream().getPrintWriter());
            this.server = null;
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J102", exception.getMessage());
            this.server = null;
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    public void stop() {
        try {
            if (this.serverThread != null && this.serverThread.isAlive()) {
                this.serverShutdownMethod.invoke(this.server, null);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        DRDAServerStarter.this.serverThread.interrupt();
                        return null;
                    }
                });
                this.serverThread = null;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Monitor.logTextMessage("J103", invocationTargetException.getTargetException().getMessage());
            invocationTargetException.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J103", exception.getMessage());
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        this.serverThread = null;
        this.server = null;
        this.serverClass = null;
        this.listenAddress = null;
        this.portNumber = -1;
        this.consoleWriter = null;
    }
}

