/*
 * Copyright 2010-2018 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */
#if !defined(CURAND_MRG32K3A_MATRICES_H_)
#define CURAND_MRG32K3A_MATRICES_H_

    /* base matrices */

    /* these are not actually used in the runtime code. They are   */
    /* used in computing the skipahead matrices, and are included  */
    /* for reference                                               */
    /*
    double M1[3][3] = {        0.,       1.,       0.,
                               0.,       0.,       1.,
                         -810728., 1403580.,       0. };

    double M2[3][3] = {        0.,       1.,       0.,
                               0.,       0.,       1.,
                        -1370589.,       0.,  527612. };

    */

    /* Base matrices to power 2 to the power n, n the first array index, from 0..63 */

static __device__ unsigned int mrg32k3aM1[64][3][3] = {
        {
            {               0u,               1u,               0u },
            {               0u,               0u,               1u },
            {      4294156359u,         1403580u,               0u }
        },
        {
            {               0u,               0u,               1u },
            {      4294156359u,         1403580u,               0u },
            {               0u,      4294156359u,         1403580u }
        },
        {
            {               0u,      4294156359u,         1403580u },
            {       244671815u,      2941890554u,      4294156359u },
            {       149925673u,       489343630u,      2941890554u }
        },
        {
            {      1527363550u,      2758233149u,      1831234280u },
            {      4072640363u,       939574583u,      2758233149u },
            {      2064391165u,      3228066636u,       939574583u }
        },
        {
            {       736416029u,      2961816100u,       342112271u },
            {       387300998u,      1062452522u,      2961816100u },
            {      2955879160u,       340793741u,      1062452522u }
        },
        {
            {      1243502014u,      2218748291u,      1709215645u },
            {      2019641772u,      3847560959u,      2218748291u },
            {      3866010231u,      2305448679u,      3847560959u }
        },
        {
            {      3241775219u,      3453352062u,      3721871040u },
            {      4062454730u,         3015754u,      3453352062u },
            {       919711945u,       613405362u,         3015754u }
        },
        {
            {      1955221006u,      1414472808u,      1746037714u },
            {      3653507277u,      1644962013u,      1414472808u },
            {      3501544776u,      2336229602u,      1644962013u }
        },
        {
            {      1170096663u,        49135452u,      3441537107u },
            {      1857945175u,      1649398389u,        49135452u },
            {       333002869u,      3109147376u,      1649398389u }
        },
        {
            {      2299034194u,      2297111910u,       862649200u },
            {      1399961132u,       996706937u,      2297111910u },
            {      3439056503u,      1481993076u,       996706937u }
        },
        {
            {      4146310528u,       458782589u,      1007330283u },
            {      4241015765u,      3979619964u,       458782589u },
            {       553886495u,      2186897562u,      3979619964u }
        },
        {
            {      3630027893u,      2130448350u,       292773857u },
            {      1392525159u,      1299285967u,      2130448350u },
            {      2589171163u,      1217405758u,      1299285967u }
        },
        {
            {       892409263u,      1999175811u,      2979225418u },
            {      1996163538u,      2148702503u,      1999175811u },
            {      3922720782u,       103819730u,      2148702503u }
        },
        {
            {      1586003016u,      2114210471u,      3240775579u },
            {      2777288607u,      1400478398u,      2114210471u },
            {      3018215420u,       535326008u,      1400478398u }
        },
        {
            {      2188531273u,      1783231160u,      3576659343u },
            {      1908318389u,       379210133u,      1783231160u },
            {       554369329u,       250053591u,       379210133u }
        },
        {
            {      4022841636u,      3951951872u,      2143424240u },
            {      1046219306u,      1591992468u,      3951951872u },
            {      1510277444u,       381333958u,      1591992468u }
        },
        {
            {      2256493727u,      3715182130u,       642697923u },
            {      3615342722u,      3975008370u,      3715182130u },
            {      2405650329u,       754337639u,      3975008370u }
        },
        {
            {      1286664224u,       627406673u,       963516608u },
            {      1541344588u,       460768826u,       627406673u },
            {      1089892553u,      2717717970u,       460768826u }
        },
        {
            {      2956342842u,      3471097641u,      2353092905u },
            {      2996150472u,       420480221u,      3471097641u },
            {      2221681883u,       372736411u,       420480221u }
        },
        {
            {       420492906u,       153526651u,      3499730988u },
            {      2662640502u,      3278195133u,       153526651u },
            {      4086436419u,      2510762118u,      3278195133u }
        },
        {
            {      3310184147u,      2228376089u,       823220763u },
            {      3992771814u,      1693168425u,      2228376089u },
            {      2295790366u,      1401872772u,      1693168425u }
        },
        {
            {      2529428830u,      1497104068u,      4253248635u },
            {      3746310018u,       630867741u,      1497104068u },
            {       627043435u,       721725795u,       630867741u }
        },
        {
            {      2571072593u,      3039669025u,      1591031831u },
            {       526054481u,       661344445u,      3039669025u },
            {      4246010312u,       735391270u,       661344445u }
        },
        {
            {      1847312821u,      4042890210u,      4241772463u },
            {       606605705u,      2644799309u,      4042890210u },
            {      2658402822u,      1342278931u,      2644799309u }
        },
        {
            {      2409846784u,      1096138313u,      1416249993u },
            {      1501878241u,       138013862u,      1096138313u },
            {      1617749306u,      1975136163u,       138013862u }
        },
        {
            {       599453422u,        73950522u,      2965395603u },
            {        55354701u,      3855242202u,        73950522u },
            {      3981734504u,      3354399019u,      3855242202u }
        },
        {
            {      4271076381u,       813410089u,      3461955319u },
            {      1044920137u,      3029005516u,       813410089u },
            {      3501837362u,      3321539504u,      3029005516u }
        },
        {
            {      3058183515u,       941408572u,      1783998098u },
            {      1546486080u,      4116985007u,       941408572u },
            {      2247500745u,      1460625377u,      4116985007u }
        },
        {
            {      4216782514u,      3352801941u,      2315095646u },
            {       639029973u,        94451952u,      3352801941u },
            {      1242898773u,      3964593332u,        94451952u }
        },
        {
            {      2264905138u,      1926285644u,      1108147171u },
            {      2390706911u,       385258225u,      1926285644u },
            {      3569882325u,      3728744670u,       385258225u }
        },
        {
            {       270679073u,      1065683096u,      2992662885u },
            {      4196917281u,      2886425156u,      1065683096u },
            {       749134119u,      1849148167u,      2886425156u }
        },
        {
            {        35689930u,      1378151623u,       951629713u },
            {       673810920u,       948843427u,      1378151623u },
            {      3808868984u,       927013635u,       948843427u }
        },
        {
            {      1891490872u,      1130489594u,      3734864133u },
            {      1457450350u,      3362920032u,      1130489594u },
            {       638998846u,      1401175590u,      3362920032u }
        },
        {
            {      2254459023u,      2384691454u,      1730098031u },
            {      2844861718u,      1807491073u,      2384691454u },
            {       351423668u,      1570264155u,      1807491073u }
        },
        {
            {      3047429268u,      4245359555u,      2449575498u },
            {      1797081212u,      1237196477u,      4245359555u },
            {       143400628u,      3663731096u,      1237196477u }
        },
        {
            {      3313321106u,      4263819658u,      1047529624u },
            {      3719941673u,      3155049403u,      4263819658u },
            {      1981313839u,      4281524426u,      3155049403u }
        },
        {
            {      2005252417u,      3263186729u,      1535805957u },
            {      2951515865u,      1729281525u,      3263186729u },
            {      1141249417u,      2268963059u,      1729281525u }
        },
        {
            {      2367065164u,        83908466u,      4294308508u },
            {      1352516724u,      1416676049u,        83908466u },
            {      1040867745u,      1304732377u,      1416676049u }
        },
        {
            {      3214147257u,      1434230503u,      2944821434u },
            {      2753040912u,      4041536918u,      1434230503u },
            {      1317260239u,       338830578u,      4041536918u }
        },
        {
            {       300628476u,      2054743463u,      1499597869u },
            {      1762244284u,      1422043015u,      2054743463u },
            {      3581125669u,      1207561803u,      1422043015u }
        },
        {
            {      4171745404u,      4064983592u,      1934508265u },
            {      3049723261u,      1744636487u,      4064983592u },
            {       947753516u,      3952135907u,      1744636487u }
        },
        {
            {      1625369148u,      3577024659u,      2778677259u },
            {      1729967818u,      1049600974u,      3577024659u },
            {      2089137344u,      1569794605u,      1049600974u }
        },
        {
            {      1373068765u,      3958611830u,       569117280u },
            {       410042396u,      3551255470u,      3958611830u },
            {       869476379u,      1680625376u,      3551255470u }
        },
        {
            {      2108618602u,      2543645250u,       913717833u },
            {      2111984988u,      1012482542u,      2543645250u },
            {      2545745615u,      3141042890u,      1012482542u }
        },
        {
            {      1157293598u,       584852249u,      2272893205u },
            {      1631801979u,      3013855247u,       584852249u },
            {      3977310441u,        82049263u,      3013855247u }
        },
        {
            {      3580234334u,      3137526662u,      2403875621u },
            {      3580869206u,      3670086228u,      3137526662u },
            {       656744553u,      1764904195u,      3670086228u }
        },
        {
            {      2792496861u,      3634185196u,      3887031679u },
            {      3601823850u,      3464838365u,      3634185196u },
            {      3136165138u,      2842987937u,      3464838365u }
        },
        {
            {      1362557480u,      3230022138u,      4278720212u },
            {      3427386258u,      3848976950u,      3230022138u },
            {      2109817045u,      2441486578u,      3848976950u }
        },
        {
            {      1198519135u,      2007945401u,         3868481u },
            {      3335076429u,      2082683147u,      2007945401u },
            {      2341088247u,       888193479u,      2082683147u }
        },
        {
            {      3473925387u,      3193380570u,       565138859u },
            {       307060547u,       782210925u,      3193380570u },
            {       167617770u,      2180014252u,       782210925u }
        },
        {
            {      3811588895u,      3303532086u,      2766583698u },
            {       908630605u,      2665400165u,      3303532086u },
            {      2499994113u,      3316180851u,      2665400165u }
        },
        {
            {      4288926968u,      3033075037u,      1505732852u },
            {      1531633406u,       645804125u,      3033075037u },
            {      2942690261u,      2205365640u,       645804125u }
        },
        {
            {      3976196483u,      3651411522u,      1652430357u },
            {      1690405883u,      1294990760u,      3651411522u },
            {       209339647u,      3088484327u,      1294990760u }
        },
        {
            {      3171589548u,      2291131070u,      2093793287u },
            {      2997812074u,      4093879780u,      2291131070u },
            {      3255666800u,       858124816u,      4093879780u }
        },
        {
            {      4113016361u,      2999667479u,      3995043314u },
            {      1333973326u,      4007774239u,      2999667479u },
            {      3322921863u,      4278103786u,      4007774239u }
        },
        {
            {       925786347u,      2109676036u,      1879981040u },
            {      1701566570u,      1489702270u,      2109676036u },
            {      2719807628u,       158549605u,      1489702270u }
        },
        {
            {      2255405265u,      3460246357u,       218033453u },
            {      2135115875u,       359516994u,      3460246357u },
            {      3568862459u,      3114762683u,       359516994u }
        },
        {
            {       773148471u,      4117539411u,      3073622315u },
            {      3807175775u,       186466108u,      4117539411u },
            {      2842197411u,       651334129u,       186466108u }
        },
        {
            {       615242951u,      1475251263u,      3586439101u },
            {      1693917167u,      3058812486u,      1475251263u },
            {       568701600u,      1164226398u,      3058812486u }
        },
        {
            {      1632636204u,        15370275u,      2061555515u },
            {      4187505695u,      1741164221u,        15370275u },
            {      2882176274u,      3978412194u,      1741164221u }
        },
        {
            {      3446066703u,       344820524u,        74213775u },
            {      1008543583u,      2579620192u,       344820524u },
            {      3753911358u,      1538453821u,      2579620192u }
        },
        {
            {      3600859892u,      1269921024u,      4069458760u },
            {      2050939727u,      2222725697u,      1269921024u },
            {      3208347646u,       690898125u,      2222725697u }
        },
        {
            {       599407451u,      2806239788u,      1742216102u },
            {       975123999u,       764869161u,      2806239788u },
            {      2729710367u,      1845257036u,       764869161u }
        },
        {
            {       967330218u,      3464884028u,      3444447102u },
            {       580449578u,      1343714307u,      3464884028u },
            {      1775329096u,      4027221761u,      1343714307u }
        }
    };

static unsigned int mrg32k3aM1Host[64][3][3] = {
        {
            {               0u,               1u,               0u },
            {               0u,               0u,               1u },
            {      4294156359u,         1403580u,               0u }
        },
        {
            {               0u,               0u,               1u },
            {      4294156359u,         1403580u,               0u },
            {               0u,      4294156359u,         1403580u }
        },
        {
            {               0u,      4294156359u,         1403580u },
            {       244671815u,      2941890554u,      4294156359u },
            {       149925673u,       489343630u,      2941890554u }
        },
        {
            {      1527363550u,      2758233149u,      1831234280u },
            {      4072640363u,       939574583u,      2758233149u },
            {      2064391165u,      3228066636u,       939574583u }
        },
        {
            {       736416029u,      2961816100u,       342112271u },
            {       387300998u,      1062452522u,      2961816100u },
            {      2955879160u,       340793741u,      1062452522u }
        },
        {
            {      1243502014u,      2218748291u,      1709215645u },
            {      2019641772u,      3847560959u,      2218748291u },
            {      3866010231u,      2305448679u,      3847560959u }
        },
        {
            {      3241775219u,      3453352062u,      3721871040u },
            {      4062454730u,         3015754u,      3453352062u },
            {       919711945u,       613405362u,         3015754u }
        },
        {
            {      1955221006u,      1414472808u,      1746037714u },
            {      3653507277u,      1644962013u,      1414472808u },
            {      3501544776u,      2336229602u,      1644962013u }
        },
        {
            {      1170096663u,        49135452u,      3441537107u },
            {      1857945175u,      1649398389u,        49135452u },
            {       333002869u,      3109147376u,      1649398389u }
        },
        {
            {      2299034194u,      2297111910u,       862649200u },
            {      1399961132u,       996706937u,      2297111910u },
            {      3439056503u,      1481993076u,       996706937u }
        },
        {
            {      4146310528u,       458782589u,      1007330283u },
            {      4241015765u,      3979619964u,       458782589u },
            {       553886495u,      2186897562u,      3979619964u }
        },
        {
            {      3630027893u,      2130448350u,       292773857u },
            {      1392525159u,      1299285967u,      2130448350u },
            {      2589171163u,      1217405758u,      1299285967u }
        },
        {
            {       892409263u,      1999175811u,      2979225418u },
            {      1996163538u,      2148702503u,      1999175811u },
            {      3922720782u,       103819730u,      2148702503u }
        },
        {
            {      1586003016u,      2114210471u,      3240775579u },
            {      2777288607u,      1400478398u,      2114210471u },
            {      3018215420u,       535326008u,      1400478398u }
        },
        {
            {      2188531273u,      1783231160u,      3576659343u },
            {      1908318389u,       379210133u,      1783231160u },
            {       554369329u,       250053591u,       379210133u }
        },
        {
            {      4022841636u,      3951951872u,      2143424240u },
            {      1046219306u,      1591992468u,      3951951872u },
            {      1510277444u,       381333958u,      1591992468u }
        },
        {
            {      2256493727u,      3715182130u,       642697923u },
            {      3615342722u,      3975008370u,      3715182130u },
            {      2405650329u,       754337639u,      3975008370u }
        },
        {
            {      1286664224u,       627406673u,       963516608u },
            {      1541344588u,       460768826u,       627406673u },
            {      1089892553u,      2717717970u,       460768826u }
        },
        {
            {      2956342842u,      3471097641u,      2353092905u },
            {      2996150472u,       420480221u,      3471097641u },
            {      2221681883u,       372736411u,       420480221u }
        },
        {
            {       420492906u,       153526651u,      3499730988u },
            {      2662640502u,      3278195133u,       153526651u },
            {      4086436419u,      2510762118u,      3278195133u }
        },
        {
            {      3310184147u,      2228376089u,       823220763u },
            {      3992771814u,      1693168425u,      2228376089u },
            {      2295790366u,      1401872772u,      1693168425u }
        },
        {
            {      2529428830u,      1497104068u,      4253248635u },
            {      3746310018u,       630867741u,      1497104068u },
            {       627043435u,       721725795u,       630867741u }
        },
        {
            {      2571072593u,      3039669025u,      1591031831u },
            {       526054481u,       661344445u,      3039669025u },
            {      4246010312u,       735391270u,       661344445u }
        },
        {
            {      1847312821u,      4042890210u,      4241772463u },
            {       606605705u,      2644799309u,      4042890210u },
            {      2658402822u,      1342278931u,      2644799309u }
        },
        {
            {      2409846784u,      1096138313u,      1416249993u },
            {      1501878241u,       138013862u,      1096138313u },
            {      1617749306u,      1975136163u,       138013862u }
        },
        {
            {       599453422u,        73950522u,      2965395603u },
            {        55354701u,      3855242202u,        73950522u },
            {      3981734504u,      3354399019u,      3855242202u }
        },
        {
            {      4271076381u,       813410089u,      3461955319u },
            {      1044920137u,      3029005516u,       813410089u },
            {      3501837362u,      3321539504u,      3029005516u }
        },
        {
            {      3058183515u,       941408572u,      1783998098u },
            {      1546486080u,      4116985007u,       941408572u },
            {      2247500745u,      1460625377u,      4116985007u }
        },
        {
            {      4216782514u,      3352801941u,      2315095646u },
            {       639029973u,        94451952u,      3352801941u },
            {      1242898773u,      3964593332u,        94451952u }
        },
        {
            {      2264905138u,      1926285644u,      1108147171u },
            {      2390706911u,       385258225u,      1926285644u },
            {      3569882325u,      3728744670u,       385258225u }
        },
        {
            {       270679073u,      1065683096u,      2992662885u },
            {      4196917281u,      2886425156u,      1065683096u },
            {       749134119u,      1849148167u,      2886425156u }
        },
        {
            {        35689930u,      1378151623u,       951629713u },
            {       673810920u,       948843427u,      1378151623u },
            {      3808868984u,       927013635u,       948843427u }
        },
        {
            {      1891490872u,      1130489594u,      3734864133u },
            {      1457450350u,      3362920032u,      1130489594u },
            {       638998846u,      1401175590u,      3362920032u }
        },
        {
            {      2254459023u,      2384691454u,      1730098031u },
            {      2844861718u,      1807491073u,      2384691454u },
            {       351423668u,      1570264155u,      1807491073u }
        },
        {
            {      3047429268u,      4245359555u,      2449575498u },
            {      1797081212u,      1237196477u,      4245359555u },
            {       143400628u,      3663731096u,      1237196477u }
        },
        {
            {      3313321106u,      4263819658u,      1047529624u },
            {      3719941673u,      3155049403u,      4263819658u },
            {      1981313839u,      4281524426u,      3155049403u }
        },
        {
            {      2005252417u,      3263186729u,      1535805957u },
            {      2951515865u,      1729281525u,      3263186729u },
            {      1141249417u,      2268963059u,      1729281525u }
        },
        {
            {      2367065164u,        83908466u,      4294308508u },
            {      1352516724u,      1416676049u,        83908466u },
            {      1040867745u,      1304732377u,      1416676049u }
        },
        {
            {      3214147257u,      1434230503u,      2944821434u },
            {      2753040912u,      4041536918u,      1434230503u },
            {      1317260239u,       338830578u,      4041536918u }
        },
        {
            {       300628476u,      2054743463u,      1499597869u },
            {      1762244284u,      1422043015u,      2054743463u },
            {      3581125669u,      1207561803u,      1422043015u }
        },
        {
            {      4171745404u,      4064983592u,      1934508265u },
            {      3049723261u,      1744636487u,      4064983592u },
            {       947753516u,      3952135907u,      1744636487u }
        },
        {
            {      1625369148u,      3577024659u,      2778677259u },
            {      1729967818u,      1049600974u,      3577024659u },
            {      2089137344u,      1569794605u,      1049600974u }
        },
        {
            {      1373068765u,      3958611830u,       569117280u },
            {       410042396u,      3551255470u,      3958611830u },
            {       869476379u,      1680625376u,      3551255470u }
        },
        {
            {      2108618602u,      2543645250u,       913717833u },
            {      2111984988u,      1012482542u,      2543645250u },
            {      2545745615u,      3141042890u,      1012482542u }
        },
        {
            {      1157293598u,       584852249u,      2272893205u },
            {      1631801979u,      3013855247u,       584852249u },
            {      3977310441u,        82049263u,      3013855247u }
        },
        {
            {      3580234334u,      3137526662u,      2403875621u },
            {      3580869206u,      3670086228u,      3137526662u },
            {       656744553u,      1764904195u,      3670086228u }
        },
        {
            {      2792496861u,      3634185196u,      3887031679u },
            {      3601823850u,      3464838365u,      3634185196u },
            {      3136165138u,      2842987937u,      3464838365u }
        },
        {
            {      1362557480u,      3230022138u,      4278720212u },
            {      3427386258u,      3848976950u,      3230022138u },
            {      2109817045u,      2441486578u,      3848976950u }
        },
        {
            {      1198519135u,      2007945401u,         3868481u },
            {      3335076429u,      2082683147u,      2007945401u },
            {      2341088247u,       888193479u,      2082683147u }
        },
        {
            {      3473925387u,      3193380570u,       565138859u },
            {       307060547u,       782210925u,      3193380570u },
            {       167617770u,      2180014252u,       782210925u }
        },
        {
            {      3811588895u,      3303532086u,      2766583698u },
            {       908630605u,      2665400165u,      3303532086u },
            {      2499994113u,      3316180851u,      2665400165u }
        },
        {
            {      4288926968u,      3033075037u,      1505732852u },
            {      1531633406u,       645804125u,      3033075037u },
            {      2942690261u,      2205365640u,       645804125u }
        },
        {
            {      3976196483u,      3651411522u,      1652430357u },
            {      1690405883u,      1294990760u,      3651411522u },
            {       209339647u,      3088484327u,      1294990760u }
        },
        {
            {      3171589548u,      2291131070u,      2093793287u },
            {      2997812074u,      4093879780u,      2291131070u },
            {      3255666800u,       858124816u,      4093879780u }
        },
        {
            {      4113016361u,      2999667479u,      3995043314u },
            {      1333973326u,      4007774239u,      2999667479u },
            {      3322921863u,      4278103786u,      4007774239u }
        },
        {
            {       925786347u,      2109676036u,      1879981040u },
            {      1701566570u,      1489702270u,      2109676036u },
            {      2719807628u,       158549605u,      1489702270u }
        },
        {
            {      2255405265u,      3460246357u,       218033453u },
            {      2135115875u,       359516994u,      3460246357u },
            {      3568862459u,      3114762683u,       359516994u }
        },
        {
            {       773148471u,      4117539411u,      3073622315u },
            {      3807175775u,       186466108u,      4117539411u },
            {      2842197411u,       651334129u,       186466108u }
        },
        {
            {       615242951u,      1475251263u,      3586439101u },
            {      1693917167u,      3058812486u,      1475251263u },
            {       568701600u,      1164226398u,      3058812486u }
        },
        {
            {      1632636204u,        15370275u,      2061555515u },
            {      4187505695u,      1741164221u,        15370275u },
            {      2882176274u,      3978412194u,      1741164221u }
        },
        {
            {      3446066703u,       344820524u,        74213775u },
            {      1008543583u,      2579620192u,       344820524u },
            {      3753911358u,      1538453821u,      2579620192u }
        },
        {
            {      3600859892u,      1269921024u,      4069458760u },
            {      2050939727u,      2222725697u,      1269921024u },
            {      3208347646u,       690898125u,      2222725697u }
        },
        {
            {       599407451u,      2806239788u,      1742216102u },
            {       975123999u,       764869161u,      2806239788u },
            {      2729710367u,      1845257036u,       764869161u }
        },
        {
            {       967330218u,      3464884028u,      3444447102u },
            {       580449578u,      1343714307u,      3464884028u },
            {      1775329096u,      4027221761u,      1343714307u }
        }
    };

static __device__ unsigned int mrg32k3aM2[64][3][3] = {
        {
            {               0u,               1u,               0u },
            {               0u,               0u,               1u },
            {      4293573854u,               0u,          527612u }
        },
        {
            {               0u,               0u,               1u },
            {      4293573854u,               0u,          527612u },
            {      2706407399u,      4293573854u,      3497978192u }
        },
        {
            {      2706407399u,      4293573854u,      3497978192u },
            {      1431525864u,      2706407399u,      3281754271u },
            {        97673890u,      1431525864u,      1673476130u }
        },
        {
            {      3405842137u,      2680076935u,       893509979u },
            {      4035147174u,      3405842137u,      3280220074u },
            {      2623373296u,      4035147174u,       361718588u }
        },
        {
            {       818368950u,      3790774567u,      3542344109u },
            {      1817134745u,       818368950u,      3321940838u },
            {      3493477402u,      1817134745u,      2854655037u }
        },
        {
            {       498682467u,      2928649385u,       811441367u },
            {      1777037472u,       498682467u,       479207863u },
            {      3058260025u,      1777037472u,      1528225099u }
        },
        {
            {      3893311647u,      3140922085u,        64039185u },
            {        82107183u,      3893311647u,      2655465224u },
            {      1674879036u,        82107183u,      1089381262u }
        },
        {
            {        28639152u,      3496041927u,      2231910770u },
            {      3174683233u,        28639152u,      2828785870u },
            {      3681140872u,      3174683233u,      3910194649u }
        },
        {
            {      1463826069u,       300842059u,      3313769518u },
            {      1799677538u,      1463826069u,      3174861078u },
            {      1882279394u,      1799677538u,      3509975160u }
        },
        {
            {      2092194020u,       184076987u,      2202401252u },
            {      3103629604u,      2092194020u,      3409560232u },
            {      4257445059u,      3103629604u,      2390202783u }
        },
        {
            {       812917091u,      2574011276u,      4168802395u },
            {       209817750u,       812917091u,      2974870628u },
            {      3238802184u,       209817750u,      3692836406u }
        },
        {
            {       477309738u,      3314523413u,      3442242150u },
            {      2755731404u,       477309738u,      2782713347u },
            {      1606221490u,      2755731404u,      1033463096u }
        },
        {
            {      2155469603u,      3326516116u,      3843369786u },
            {       288604458u,      2155469603u,       571673571u },
            {      1501677614u,       288604458u,      2928213494u }
        },
        {
            {      2082469029u,       749754403u,      3963963316u },
            {      2764859700u,      2082469029u,      3576428059u },
            {      2840894706u,      2764859700u,      1782279859u }
        },
        {
            {      3760163766u,      1041986082u,      1799196192u },
            {      1022129134u,      3760163766u,      1332558840u },
            {       276873446u,      1022129134u,      3979423632u }
        },
        {
            {      1021313167u,      1312544548u,      1716381787u },
            {      3037868518u,      1021313167u,       199085085u },
            {      2582787611u,      3037868518u,      3539882179u }
        },
        {
            {      2569413030u,      1631336015u,      2594942403u },
            {      1030618503u,      2569413030u,      3467650326u },
            {      1998739584u,      1030618503u,      3174552073u }
        },
        {
            {      2334639309u,      3114094203u,       601680947u },
            {      2110199318u,      2334639309u,       678342865u },
            {      1649523168u,      2110199318u,      2154948056u }
        },
        {
            {       563657176u,       191330473u,      1641595774u },
            {       780563537u,       563657176u,      3029522338u },
            {      2037330914u,       780563537u,      2084602709u }
        },
        {
            {      3414769923u,      1968799026u,      2238126504u },
            {       832866376u,      3414769923u,      3754780168u },
            {      2165145850u,       832866376u,      1594768331u }
        },
        {
            {      1646861218u,      2317984620u,      2301581548u },
            {      2672536210u,      1646861218u,       359763062u },
            {      2391283983u,      2672536210u,      1885870777u }
        },
        {
            {       841254072u,      3765813448u,      1635365181u },
            {      2013240130u,       841254072u,       605925849u },
            {      3743932305u,      2013240130u,       400681955u }
        },
        {
            {      1930213004u,      2072952279u,      3077694794u },
            {      3579956569u,      1930213004u,      2478539210u },
            {      1960229502u,      3579956569u,      1455652656u }
        },
        {
            {      1097613522u,      1784540933u,      1194440107u },
            {       321747515u,      1097613522u,      1225209584u },
            {        74521379u,       321747515u,      4288531000u }
        },
        {
            {       143812745u,      3254530816u,      3514348856u },
            {       769295000u,       143812745u,      2468210728u },
            {      1927161272u,       769295000u,       522705580u }
        },
        {
            {      2692035063u,      2596905012u,      1643240704u },
            {      1103432342u,      2692035063u,      1446182108u },
            {      4161111774u,      1103432342u,      3076435551u }
        },
        {
            {      2375319030u,      1391532370u,      3742334018u },
            {      1202100604u,      2375319030u,      4098434768u },
            {      2327872488u,      1202100604u,      1471526950u }
        },
        {
            {      4269164791u,      2795313144u,      2507855960u },
            {      4245372460u,      4269164791u,      4094914553u },
            {      3873219634u,      4245372460u,      1473695507u }
        },
        {
            {       513890845u,      1208902926u,      2870530442u },
            {      1984873167u,       513890845u,      1257532340u },
            {      1212627640u,      1984873167u,      2354363842u }
        },
        {
            {      1848364568u,      1552116673u,      3496528455u },
            {      4160778291u,      1848364568u,       141769900u },
            {      3611019106u,      4160778291u,       596424080u }
        },
        {
            {       364070020u,      3520039729u,       837362349u },
            {      2544671570u,       364070020u,      2188646679u },
            {       163978331u,      2544671570u,       672947816u }
        },
        {
            {      1192700714u,      3968150021u,       298357363u },
            {       635565666u,      1192700714u,      2589432341u },
            {      2548654227u,       635565666u,      3531570992u }
        },
        {
            {      2709640529u,       676525399u,       875361870u },
            {      1315499519u,      2709640529u,      3842690720u },
            {      3300994644u,      1315499519u,      2446760804u }
        },
        {
            {      2742149264u,      1410604392u,      3032350755u },
            {      3774935330u,      2742149264u,       597633965u },
            {      4085935803u,      3774935330u,      3952463556u }
        },
        {
            {      3878579563u,       845297523u,      1721916511u },
            {      2077922420u,      3878579563u,      3651360351u },
            {      2177255734u,      2077922420u,      3791239282u }
        },
        {
            {      1570315355u,      4252790045u,      3522351060u },
            {      2324624266u,      1570315355u,      3594939336u },
            {      1725087354u,      2324624266u,      1338343327u }
        },
        {
            {      2305761589u,       381933244u,      3663579047u },
            {      1355307047u,      2305761589u,       313617972u },
            {       992174375u,      1355307047u,      3881593435u }
        },
        {
            {      1667857811u,      1564715297u,      2263851601u },
            {      3791771273u,      1667857811u,      4196134923u },
            {      3347975047u,      3791771273u,       615040705u }
        },
        {
            {      4093947334u,      3454015638u,      2815567716u },
            {      4261953004u,      4093947334u,      3973733876u },
            {      2979573134u,      4261953004u,      3757047667u }
        },
        {
            {       250120061u,       570149551u,      1513430926u },
            {      3178644752u,       250120061u,      1701869032u },
            {      4172515680u,      3178644752u,      4213855850u }
        },
        {
            {      4158106802u,      3062358456u,      1815738463u },
            {      1379176112u,      4158106802u,      3926509890u },
            {      2842564878u,      1379176112u,      2852219546u }
        },
        {
            {       931848746u,       256263523u,      2633569246u },
            {      3284646837u,       931848746u,      2567084715u },
            {       415258465u,      3284646837u,      2017565947u }
        },
        {
            {      1648005210u,      1032291296u,      3987397422u },
            {      1831496020u,      1648005210u,      2829448427u },
            {      1821082272u,      1831496020u,      2917140265u }
        },
        {
            {      4161327077u,       489964129u,      3870847744u },
            {      1669447863u,      4161327077u,      4292947198u },
            {      1522417114u,      1669447863u,      2652286672u }
        },
        {
            {      1270934555u,      3136631324u,       505612043u },
            {      2981474723u,      1270934555u,      2528619024u },
            {       625182639u,      2981474723u,      1008985039u }
        },
        {
            {       280996820u,       143706137u,      3013099060u },
            {      1797675893u,       280996820u,      3743985508u },
            {      1123794455u,      1797675893u,      2460119169u }
        },
        {
            {       919218027u,      4154920441u,      1125672685u },
            {      3933041881u,       919218027u,       474242849u },
            {       564891116u,      3933041881u,      2263904321u }
        },
        {
            {      2920112852u,      1965329198u,      1177141043u },
            {      2135250851u,      2920112852u,       969184056u },
            {       296035385u,      2135250851u,      4267827987u }
        },
        {
            {      1481142942u,      4120754772u,      1088557292u },
            {       265491023u,      1481142942u,      2860005744u },
            {       301796252u,       265491023u,      1935975979u }
        },
        {
            {      2111859033u,      2813610100u,      1001476468u },
            {        73849832u,      2111859033u,      3980799998u },
            {      3330206241u,        73849832u,      1933943506u }
        },
        {
            {      1781286360u,      3661231931u,      3509383709u },
            {      2753158871u,      1781286360u,      3119883109u },
            {      3576525143u,      2753158871u,       551079002u }
        },
        {
            {      1185024844u,       587779104u,      1004942725u },
            {      3763632860u,      1185024844u,       947424568u },
            {      3811666068u,      3763632860u,      2352253462u }
        },
        {
            {      1310227170u,       218138208u,      3172947233u },
            {       766129426u,      1310227170u,      1808643264u },
            {      2226659371u,       766129426u,      3853798112u }
        },
        {
            {      2230902378u,      4243560874u,      2491962392u },
            {      3836629116u,      2230902378u,      3637515403u },
            {      2846140932u,      3836629116u,      3083355464u }
        },
        {
            {       999448569u,      1464488480u,      3344426626u },
            {       946166795u,       999448569u,       340856814u },
            {      3686999436u,       946166795u,      3231079441u }
        },
        {
            {      1226155368u,      3477563770u,       550006884u },
            {      2378667355u,      1226155368u,      1493409040u },
            {       260364836u,      2378667355u,      4133888397u }
        },
        {
            {      1277901832u,       310796286u,      2818511068u },
            {      3088910653u,      1277901832u,      3303406025u },
            {      2507911914u,      3088910653u,      3712928074u }
        },
        {
            {       481918378u,       339570348u,      1728801469u },
            {      1623163429u,       481918378u,      2209094694u },
            {      3146982514u,      1623163429u,       508445538u }
        },
        {
            {      3138921230u,      2381863183u,      1992357430u },
            {      1024510915u,      3138921230u,      2122851650u },
            {      1453455184u,      1024510915u,       941946604u }
        },
        {
            {      2465372719u,      1391015357u,      3328905025u },
            {      1821933605u,      2465372719u,      1343489680u },
            {      3648970313u,      1821933605u,      1816599716u }
        },
        {
            {       118634664u,      3358712512u,      2492792220u },
            {       348833376u,       118634664u,      2495544591u },
            {      3235582254u,       348833376u,      4043157504u }
        },
        {
            {      2303067090u,      3371139074u,      1967771133u },
            {       598630070u,      2303067090u,      1819012637u },
            {      2049250561u,       598630070u,      4093044926u }
        },
        {
            {      3035321857u,      3971176093u,       226779704u },
            {      3361614254u,      3035321857u,      2807125404u },
            {       326640887u,      3361614254u,      3147308542u }
        },
        {
            {      1774298149u,      4179629947u,      3145006948u },
            {      1688753503u,      1774298149u,        94869516u },
            {      2327946901u,      1688753503u,      2786835219u }
        }
    };

static unsigned int mrg32k3aM2Host[64][3][3] = {
        {
            {               0u,               1u,               0u },
            {               0u,               0u,               1u },
            {      4293573854u,               0u,          527612u }
        },
        {
            {               0u,               0u,               1u },
            {      4293573854u,               0u,          527612u },
            {      2706407399u,      4293573854u,      3497978192u }
        },
        {
            {      2706407399u,      4293573854u,      3497978192u },
            {      1431525864u,      2706407399u,      3281754271u },
            {        97673890u,      1431525864u,      1673476130u }
        },
        {
            {      3405842137u,      2680076935u,       893509979u },
            {      4035147174u,      3405842137u,      3280220074u },
            {      2623373296u,      4035147174u,       361718588u }
        },
        {
            {       818368950u,      3790774567u,      3542344109u },
            {      1817134745u,       818368950u,      3321940838u },
            {      3493477402u,      1817134745u,      2854655037u }
        },
        {
            {       498682467u,      2928649385u,       811441367u },
            {      1777037472u,       498682467u,       479207863u },
            {      3058260025u,      1777037472u,      1528225099u }
        },
        {
            {      3893311647u,      3140922085u,        64039185u },
            {        82107183u,      3893311647u,      2655465224u },
            {      1674879036u,        82107183u,      1089381262u }
        },
        {
            {        28639152u,      3496041927u,      2231910770u },
            {      3174683233u,        28639152u,      2828785870u },
            {      3681140872u,      3174683233u,      3910194649u }
        },
        {
            {      1463826069u,       300842059u,      3313769518u },
            {      1799677538u,      1463826069u,      3174861078u },
            {      1882279394u,      1799677538u,      3509975160u }
        },
        {
            {      2092194020u,       184076987u,      2202401252u },
            {      3103629604u,      2092194020u,      3409560232u },
            {      4257445059u,      3103629604u,      2390202783u }
        },
        {
            {       812917091u,      2574011276u,      4168802395u },
            {       209817750u,       812917091u,      2974870628u },
            {      3238802184u,       209817750u,      3692836406u }
        },
        {
            {       477309738u,      3314523413u,      3442242150u },
            {      2755731404u,       477309738u,      2782713347u },
            {      1606221490u,      2755731404u,      1033463096u }
        },
        {
            {      2155469603u,      3326516116u,      3843369786u },
            {       288604458u,      2155469603u,       571673571u },
            {      1501677614u,       288604458u,      2928213494u }
        },
        {
            {      2082469029u,       749754403u,      3963963316u },
            {      2764859700u,      2082469029u,      3576428059u },
            {      2840894706u,      2764859700u,      1782279859u }
        },
        {
            {      3760163766u,      1041986082u,      1799196192u },
            {      1022129134u,      3760163766u,      1332558840u },
            {       276873446u,      1022129134u,      3979423632u }
        },
        {
            {      1021313167u,      1312544548u,      1716381787u },
            {      3037868518u,      1021313167u,       199085085u },
            {      2582787611u,      3037868518u,      3539882179u }
        },
        {
            {      2569413030u,      1631336015u,      2594942403u },
            {      1030618503u,      2569413030u,      3467650326u },
            {      1998739584u,      1030618503u,      3174552073u }
        },
        {
            {      2334639309u,      3114094203u,       601680947u },
            {      2110199318u,      2334639309u,       678342865u },
            {      1649523168u,      2110199318u,      2154948056u }
        },
        {
            {       563657176u,       191330473u,      1641595774u },
            {       780563537u,       563657176u,      3029522338u },
            {      2037330914u,       780563537u,      2084602709u }
        },
        {
            {      3414769923u,      1968799026u,      2238126504u },
            {       832866376u,      3414769923u,      3754780168u },
            {      2165145850u,       832866376u,      1594768331u }
        },
        {
            {      1646861218u,      2317984620u,      2301581548u },
            {      2672536210u,      1646861218u,       359763062u },
            {      2391283983u,      2672536210u,      1885870777u }
        },
        {
            {       841254072u,      3765813448u,      1635365181u },
            {      2013240130u,       841254072u,       605925849u },
            {      3743932305u,      2013240130u,       400681955u }
        },
        {
            {      1930213004u,      2072952279u,      3077694794u },
            {      3579956569u,      1930213004u,      2478539210u },
            {      1960229502u,      3579956569u,      1455652656u }
        },
        {
            {      1097613522u,      1784540933u,      1194440107u },
            {       321747515u,      1097613522u,      1225209584u },
            {        74521379u,       321747515u,      4288531000u }
        },
        {
            {       143812745u,      3254530816u,      3514348856u },
            {       769295000u,       143812745u,      2468210728u },
            {      1927161272u,       769295000u,       522705580u }
        },
        {
            {      2692035063u,      2596905012u,      1643240704u },
            {      1103432342u,      2692035063u,      1446182108u },
            {      4161111774u,      1103432342u,      3076435551u }
        },
        {
            {      2375319030u,      1391532370u,      3742334018u },
            {      1202100604u,      2375319030u,      4098434768u },
            {      2327872488u,      1202100604u,      1471526950u }
        },
        {
            {      4269164791u,      2795313144u,      2507855960u },
            {      4245372460u,      4269164791u,      4094914553u },
            {      3873219634u,      4245372460u,      1473695507u }
        },
        {
            {       513890845u,      1208902926u,      2870530442u },
            {      1984873167u,       513890845u,      1257532340u },
            {      1212627640u,      1984873167u,      2354363842u }
        },
        {
            {      1848364568u,      1552116673u,      3496528455u },
            {      4160778291u,      1848364568u,       141769900u },
            {      3611019106u,      4160778291u,       596424080u }
        },
        {
            {       364070020u,      3520039729u,       837362349u },
            {      2544671570u,       364070020u,      2188646679u },
            {       163978331u,      2544671570u,       672947816u }
        },
        {
            {      1192700714u,      3968150021u,       298357363u },
            {       635565666u,      1192700714u,      2589432341u },
            {      2548654227u,       635565666u,      3531570992u }
        },
        {
            {      2709640529u,       676525399u,       875361870u },
            {      1315499519u,      2709640529u,      3842690720u },
            {      3300994644u,      1315499519u,      2446760804u }
        },
        {
            {      2742149264u,      1410604392u,      3032350755u },
            {      3774935330u,      2742149264u,       597633965u },
            {      4085935803u,      3774935330u,      3952463556u }
        },
        {
            {      3878579563u,       845297523u,      1721916511u },
            {      2077922420u,      3878579563u,      3651360351u },
            {      2177255734u,      2077922420u,      3791239282u }
        },
        {
            {      1570315355u,      4252790045u,      3522351060u },
            {      2324624266u,      1570315355u,      3594939336u },
            {      1725087354u,      2324624266u,      1338343327u }
        },
        {
            {      2305761589u,       381933244u,      3663579047u },
            {      1355307047u,      2305761589u,       313617972u },
            {       992174375u,      1355307047u,      3881593435u }
        },
        {
            {      1667857811u,      1564715297u,      2263851601u },
            {      3791771273u,      1667857811u,      4196134923u },
            {      3347975047u,      3791771273u,       615040705u }
        },
        {
            {      4093947334u,      3454015638u,      2815567716u },
            {      4261953004u,      4093947334u,      3973733876u },
            {      2979573134u,      4261953004u,      3757047667u }
        },
        {
            {       250120061u,       570149551u,      1513430926u },
            {      3178644752u,       250120061u,      1701869032u },
            {      4172515680u,      3178644752u,      4213855850u }
        },
        {
            {      4158106802u,      3062358456u,      1815738463u },
            {      1379176112u,      4158106802u,      3926509890u },
            {      2842564878u,      1379176112u,      2852219546u }
        },
        {
            {       931848746u,       256263523u,      2633569246u },
            {      3284646837u,       931848746u,      2567084715u },
            {       415258465u,      3284646837u,      2017565947u }
        },
        {
            {      1648005210u,      1032291296u,      3987397422u },
            {      1831496020u,      1648005210u,      2829448427u },
            {      1821082272u,      1831496020u,      2917140265u }
        },
        {
            {      4161327077u,       489964129u,      3870847744u },
            {      1669447863u,      4161327077u,      4292947198u },
            {      1522417114u,      1669447863u,      2652286672u }
        },
        {
            {      1270934555u,      3136631324u,       505612043u },
            {      2981474723u,      1270934555u,      2528619024u },
            {       625182639u,      2981474723u,      1008985039u }
        },
        {
            {       280996820u,       143706137u,      3013099060u },
            {      1797675893u,       280996820u,      3743985508u },
            {      1123794455u,      1797675893u,      2460119169u }
        },
        {
            {       919218027u,      4154920441u,      1125672685u },
            {      3933041881u,       919218027u,       474242849u },
            {       564891116u,      3933041881u,      2263904321u }
        },
        {
            {      2920112852u,      1965329198u,      1177141043u },
            {      2135250851u,      2920112852u,       969184056u },
            {       296035385u,      2135250851u,      4267827987u }
        },
        {
            {      1481142942u,      4120754772u,      1088557292u },
            {       265491023u,      1481142942u,      2860005744u },
            {       301796252u,       265491023u,      1935975979u }
        },
        {
            {      2111859033u,      2813610100u,      1001476468u },
            {        73849832u,      2111859033u,      3980799998u },
            {      3330206241u,        73849832u,      1933943506u }
        },
        {
            {      1781286360u,      3661231931u,      3509383709u },
            {      2753158871u,      1781286360u,      3119883109u },
            {      3576525143u,      2753158871u,       551079002u }
        },
        {
            {      1185024844u,       587779104u,      1004942725u },
            {      3763632860u,      1185024844u,       947424568u },
            {      3811666068u,      3763632860u,      2352253462u }
        },
        {
            {      1310227170u,       218138208u,      3172947233u },
            {       766129426u,      1310227170u,      1808643264u },
            {      2226659371u,       766129426u,      3853798112u }
        },
        {
            {      2230902378u,      4243560874u,      2491962392u },
            {      3836629116u,      2230902378u,      3637515403u },
            {      2846140932u,      3836629116u,      3083355464u }
        },
        {
            {       999448569u,      1464488480u,      3344426626u },
            {       946166795u,       999448569u,       340856814u },
            {      3686999436u,       946166795u,      3231079441u }
        },
        {
            {      1226155368u,      3477563770u,       550006884u },
            {      2378667355u,      1226155368u,      1493409040u },
            {       260364836u,      2378667355u,      4133888397u }
        },
        {
            {      1277901832u,       310796286u,      2818511068u },
            {      3088910653u,      1277901832u,      3303406025u },
            {      2507911914u,      3088910653u,      3712928074u }
        },
        {
            {       481918378u,       339570348u,      1728801469u },
            {      1623163429u,       481918378u,      2209094694u },
            {      3146982514u,      1623163429u,       508445538u }
        },
        {
            {      3138921230u,      2381863183u,      1992357430u },
            {      1024510915u,      3138921230u,      2122851650u },
            {      1453455184u,      1024510915u,       941946604u }
        },
        {
            {      2465372719u,      1391015357u,      3328905025u },
            {      1821933605u,      2465372719u,      1343489680u },
            {      3648970313u,      1821933605u,      1816599716u }
        },
        {
            {       118634664u,      3358712512u,      2492792220u },
            {       348833376u,       118634664u,      2495544591u },
            {      3235582254u,       348833376u,      4043157504u }
        },
        {
            {      2303067090u,      3371139074u,      1967771133u },
            {       598630070u,      2303067090u,      1819012637u },
            {      2049250561u,       598630070u,      4093044926u }
        },
        {
            {      3035321857u,      3971176093u,       226779704u },
            {      3361614254u,      3035321857u,      2807125404u },
            {       326640887u,      3361614254u,      3147308542u }
        },
        {
            {      1774298149u,      4179629947u,      3145006948u },
            {      1688753503u,      1774298149u,        94869516u },
            {      2327946901u,      1688753503u,      2786835219u }
        }
    };

    /*Base matrices to power (2 to the power 76) to power 2 to power n + 1u, n the first array index, from 0..63*/

static __device__ unsigned int mrg32k3aM1SubSeq[56][3][3] = {
        {
            {        82758667u,      1871391091u,      4127413238u },
            {      3672831523u,        69195019u,      1871391091u },
            {      3672091415u,      3528743235u,        69195019u }
        },
        {
            {      3361372532u,      2329303404u,        99651939u },
            {      2008671965u,      2931758910u,      2329303404u },
            {      1113529483u,      2374097189u,      2931758910u }
        },
        {
            {      1831590873u,      1588259595u,      1314332382u },
            {      2385989343u,      2508077280u,      1588259595u },
            {      1787615788u,       661437137u,      2508077280u }
        },
        {
            {      2326052247u,      4183591379u,      4049009082u },
            {      2604529491u,      1453913233u,      4183591379u },
            {      2311925423u,      1805360390u,      1453913233u }
        },
        {
            {      3956367490u,       604461629u,      1257432102u },
            {       794711716u,      1155867175u,       604461629u },
            {      1777070788u,       429445904u,      1155867175u }
        },
        {
            {      1686241617u,      1257046062u,      1427609439u },
            {       490376081u,       387798431u,      1257046062u },
            {       235551485u,      1312672615u,       387798431u }
        },
        {
            {      2362447880u,      3445363024u,      3160262066u },
            {      2426867845u,      4194339866u,      3445363024u },
            {      1046144413u,      4177893681u,      4194339866u }
        },
        {
            {      4251175413u,      3559576374u,      3107663662u },
            {       697539134u,      1909472435u,      3559576374u },
            {       280754246u,       375835695u,      1909472435u }
        },
        {
            {      1099512970u,       712404985u,      1571467521u },
            {       546519870u,      1135109300u,       712404985u },
            {      3325312332u,      2352874613u,      1135109300u }
        },
        {
            {      1945425936u,      1653045514u,       381988982u },
            {      3733376326u,       414410025u,      1653045514u },
            {      1181583679u,      1185848176u,       414410025u }
        },
        {
            {      2526336124u,      3019211015u,      4215964965u },
            {      2683163472u,      4188191530u,      3019211015u },
            {      2964651598u,       293801056u,      4188191530u }
        },
        {
            {      1444052678u,      2253324417u,        39719589u },
            {      1880267534u,      2391992038u,      2253324417u },
            {       987740265u,      3691889508u,      2391992038u }
        },
        {
            {       166599066u,      2335494420u,      1232261118u },
            {      2227597731u,      2570600780u,      2335494420u },
            {      2700034538u,      3460843234u,      2570600780u }
        },
        {
            {      2511338360u,      1188954576u,      1251401239u },
            {      2511664974u,       292276982u,      1188954576u },
            {       697844082u,      3093661552u,       292276982u }
        },
        {
            {      3624650744u,        51993077u,      3540268009u },
            {      3252828938u,      3710319575u,        51993077u },
            {      2858628849u,      3910069381u,      3710319575u }
        },
        {
            {       655966702u,       754002362u,      1646581402u },
            {      1958331075u,       475572423u,       754002362u },
            {      3248619000u,      3228514800u,       475572423u }
        },
        {
            {      2760311307u,      4166372813u,       741596417u },
            {      2282679206u,      3090782630u,      4166372813u },
            {      3242468721u,      1628442374u,      3090782630u }
        },
        {
            {      4265279407u,      3532111852u,      1754687396u },
            {       500404765u,      2603727025u,      3532111852u },
            {      1428367254u,      3149485478u,      2603727025u }
        },
        {
            {      2873769531u,      2081104178u,       596284397u },
            {      4153800443u,      1261269623u,      2081104178u },
            {      3967600061u,      1830023157u,      1261269623u }
        },
        {
            {       278611533u,      2229285304u,      3443204327u },
            {      3110641420u,        77498444u,      2229285304u },
            {      3904070810u,      1070507239u,        77498444u }
        },
        {
            {       544639534u,       568528663u,      2177189807u },
            {      2475829068u,       121482268u,       568528663u },
            {       876978915u,      3116647617u,       121482268u }
        },
        {
            {      1547862823u,      2404658587u,      4191448009u },
            {      2158188804u,      2976916793u,      2404658587u },
            {       168571747u,      1691884706u,      2976916793u }
        },
        {
            {      3208213311u,      4212638780u,      3235157352u },
            {       671148556u,      2951207765u,      4212638780u },
            {      2075145516u,      2395485231u,      2951207765u }
        },
        {
            {      4080517315u,      2133433101u,      4043998180u },
            {      2044221845u,       867670560u,      2133433101u },
            {       834432416u,      3613001199u,       867670560u }
        },
        {
            {      4102885735u,      1319434267u,      2678775073u },
            {       740092580u,       607380970u,      1319434267u },
            {      2198271844u,      2610193258u,       607380970u }
        },
        {
            {      1165218048u,      1317690360u,      1189150958u },
            {       399240205u,      2507168618u,      1317690360u },
            {      2988334517u,      2687593413u,      2507168618u }
        },
        {
            {      1028861702u,      4082006648u,       338232527u },
            {      1888486946u,      1842080991u,      4082006648u },
            {      3903826366u,      3109935091u,      1842080991u }
        },
        {
            {       614134826u,      2261996505u,      2888080641u },
            {       710199359u,      2773979788u,      2261996505u },
            {      1144301620u,      2554371815u,      2773979788u }
        },
        {
            {      4056173823u,      1285620078u,       357420018u },
            {      2423072612u,      2309408315u,      1285620078u },
            {      1533175115u,      2760088020u,      2309408315u }
        },
        {
            {      4264130267u,       815015434u,      3142242173u },
            {       180649975u,      2500813569u,       815015434u },
            {      3378723563u,       829683767u,      2500813569u }
        },
        {
            {      4174387531u,      1030729435u,      2812778314u },
            {      1752988797u,      4044178729u,      1030729435u },
            {       467969301u,       554748104u,      4044178729u }
        },
        {
            {      1348429235u,      2928743274u,      3776082629u },
            {      3607529209u,      3069812185u,      2928743274u },
            {      2542432347u,      3208181168u,      3069812185u }
        },
        {
            {      4064845753u,       668285756u,      3816217625u },
            {      3713143233u,      1380634204u,       668285756u },
            {      3533700508u,      1192551435u,      1380634204u }
        },
        {
            {      1515684518u,      1706771705u,       728123349u },
            {      3174850469u,      2057456462u,      1706771705u },
            {      3410402985u,      2897339640u,      2057456462u }
        },
        {
            {      3082272717u,       531091457u,      1390161328u },
            {      3895139973u,      2171402857u,       531091457u },
            {      4030688141u,      3049703400u,      2171402857u }
        },
        {
            {      1241147206u,      3193892819u,      1244284192u },
            {        65180262u,      4065669017u,      3193892819u },
            {      1484817937u,      3661081858u,      4065669017u }
        },
        {
            {      1438760812u,      3491341751u,      3414470157u },
            {      2805337292u,       272266053u,      3491341751u },
            {       824109230u,      3202556526u,       272266053u }
        },
        {
            {       135412706u,      3627115412u,      2345042216u },
            {      1565169824u,      2166856449u,      3627115412u },
            {      1026946745u,      3467845248u,      2166856449u }
        },
        {
            {      1889419951u,      3256876154u,      1240505488u },
            {      1254783743u,       989966800u,      3256876154u },
            {      1995297400u,      3692472918u,       989966800u }
        },
        {
            {      3206226875u,       285700890u,       496017472u },
            {      2515316194u,      2129675196u,       285700890u },
            {      1863853990u,      2673457552u,      2129675196u }
        },
        {
            {      4163770641u,       255160418u,       772100749u },
            {      1987092456u,      3237660221u,       255160418u },
            {      1394381051u,      4216039401u,      3237660221u }
        },
        {
            {      2133915627u,      2713747584u,       627765421u },
            {      2300605925u,        35690583u,      2713747584u },
            {      2918902946u,      2638220304u,        35690583u }
        },
        {
            {      2587549655u,       998684270u,      4292130625u },
            {      1791772791u,      2820705344u,       998684270u },
            {       124590158u,      3831143549u,      2820705344u }
        },
        {
            {       978482299u,      3200877282u,       497605289u },
            {      3717741518u,      3737164414u,      3200877282u },
            {      4046686626u,       861393946u,      3737164414u }
        },
        {
            {      2665561897u,       300934584u,      3179822945u },
            {       893043137u,      2031413512u,       300934584u },
            {      3806926970u,      2413249929u,      2031413512u }
        },
        {
            {      1417581911u,      3071835354u,      2575196237u },
            {      4101127251u,      1375339216u,      3071835354u },
            {       847617977u,      3632503316u,      1375339216u }
        },
        {
            {      2747488994u,      3296604805u,       898095468u },
            {      1742777145u,       219265369u,      3296604805u },
            {       823714885u,       667779292u,       219265369u }
        },
        {
            {      2640209692u,      3040506537u,      3626115220u },
            {       161827078u,       852668118u,      3040506537u },
            {      3856381322u,      3360242076u,       852668118u }
        },
        {
            {      3734246393u,      4151553160u,      4177051283u },
            {       266522866u,      1731798531u,      4151553160u },
            {       632196679u,      3864297722u,      1731798531u }
        },
        {
            {      1694175127u,      1087914338u,      2384195794u },
            {      2764925057u,       505782858u,      1087914338u },
            {      3235634082u,       807915248u,       505782858u }
        },
        {
            {      2402749950u,      2353776151u,        75909174u },
            {       890570951u,      1752665661u,      2353776151u },
            {      3120241607u,      3862435696u,      1752665661u }
        }
    };

static unsigned int mrg32k3aM1SubSeqHost[56][3][3] = {
        {
            {        82758667u,      1871391091u,      4127413238u },
            {      3672831523u,        69195019u,      1871391091u },
            {      3672091415u,      3528743235u,        69195019u }
        },
        {
            {      3361372532u,      2329303404u,        99651939u },
            {      2008671965u,      2931758910u,      2329303404u },
            {      1113529483u,      2374097189u,      2931758910u }
        },
        {
            {      1831590873u,      1588259595u,      1314332382u },
            {      2385989343u,      2508077280u,      1588259595u },
            {      1787615788u,       661437137u,      2508077280u }
        },
        {
            {      2326052247u,      4183591379u,      4049009082u },
            {      2604529491u,      1453913233u,      4183591379u },
            {      2311925423u,      1805360390u,      1453913233u }
        },
        {
            {      3956367490u,       604461629u,      1257432102u },
            {       794711716u,      1155867175u,       604461629u },
            {      1777070788u,       429445904u,      1155867175u }
        },
        {
            {      1686241617u,      1257046062u,      1427609439u },
            {       490376081u,       387798431u,      1257046062u },
            {       235551485u,      1312672615u,       387798431u }
        },
        {
            {      2362447880u,      3445363024u,      3160262066u },
            {      2426867845u,      4194339866u,      3445363024u },
            {      1046144413u,      4177893681u,      4194339866u }
        },
        {
            {      4251175413u,      3559576374u,      3107663662u },
            {       697539134u,      1909472435u,      3559576374u },
            {       280754246u,       375835695u,      1909472435u }
        },
        {
            {      1099512970u,       712404985u,      1571467521u },
            {       546519870u,      1135109300u,       712404985u },
            {      3325312332u,      2352874613u,      1135109300u }
        },
        {
            {      1945425936u,      1653045514u,       381988982u },
            {      3733376326u,       414410025u,      1653045514u },
            {      1181583679u,      1185848176u,       414410025u }
        },
        {
            {      2526336124u,      3019211015u,      4215964965u },
            {      2683163472u,      4188191530u,      3019211015u },
            {      2964651598u,       293801056u,      4188191530u }
        },
        {
            {      1444052678u,      2253324417u,        39719589u },
            {      1880267534u,      2391992038u,      2253324417u },
            {       987740265u,      3691889508u,      2391992038u }
        },
        {
            {       166599066u,      2335494420u,      1232261118u },
            {      2227597731u,      2570600780u,      2335494420u },
            {      2700034538u,      3460843234u,      2570600780u }
        },
        {
            {      2511338360u,      1188954576u,      1251401239u },
            {      2511664974u,       292276982u,      1188954576u },
            {       697844082u,      3093661552u,       292276982u }
        },
        {
            {      3624650744u,        51993077u,      3540268009u },
            {      3252828938u,      3710319575u,        51993077u },
            {      2858628849u,      3910069381u,      3710319575u }
        },
        {
            {       655966702u,       754002362u,      1646581402u },
            {      1958331075u,       475572423u,       754002362u },
            {      3248619000u,      3228514800u,       475572423u }
        },
        {
            {      2760311307u,      4166372813u,       741596417u },
            {      2282679206u,      3090782630u,      4166372813u },
            {      3242468721u,      1628442374u,      3090782630u }
        },
        {
            {      4265279407u,      3532111852u,      1754687396u },
            {       500404765u,      2603727025u,      3532111852u },
            {      1428367254u,      3149485478u,      2603727025u }
        },
        {
            {      2873769531u,      2081104178u,       596284397u },
            {      4153800443u,      1261269623u,      2081104178u },
            {      3967600061u,      1830023157u,      1261269623u }
        },
        {
            {       278611533u,      2229285304u,      3443204327u },
            {      3110641420u,        77498444u,      2229285304u },
            {      3904070810u,      1070507239u,        77498444u }
        },
        {
            {       544639534u,       568528663u,      2177189807u },
            {      2475829068u,       121482268u,       568528663u },
            {       876978915u,      3116647617u,       121482268u }
        },
        {
            {      1547862823u,      2404658587u,      4191448009u },
            {      2158188804u,      2976916793u,      2404658587u },
            {       168571747u,      1691884706u,      2976916793u }
        },
        {
            {      3208213311u,      4212638780u,      3235157352u },
            {       671148556u,      2951207765u,      4212638780u },
            {      2075145516u,      2395485231u,      2951207765u }
        },
        {
            {      4080517315u,      2133433101u,      4043998180u },
            {      2044221845u,       867670560u,      2133433101u },
            {       834432416u,      3613001199u,       867670560u }
        },
        {
            {      4102885735u,      1319434267u,      2678775073u },
            {       740092580u,       607380970u,      1319434267u },
            {      2198271844u,      2610193258u,       607380970u }
        },
        {
            {      1165218048u,      1317690360u,      1189150958u },
            {       399240205u,      2507168618u,      1317690360u },
            {      2988334517u,      2687593413u,      2507168618u }
        },
        {
            {      1028861702u,      4082006648u,       338232527u },
            {      1888486946u,      1842080991u,      4082006648u },
            {      3903826366u,      3109935091u,      1842080991u }
        },
        {
            {       614134826u,      2261996505u,      2888080641u },
            {       710199359u,      2773979788u,      2261996505u },
            {      1144301620u,      2554371815u,      2773979788u }
        },
        {
            {      4056173823u,      1285620078u,       357420018u },
            {      2423072612u,      2309408315u,      1285620078u },
            {      1533175115u,      2760088020u,      2309408315u }
        },
        {
            {      4264130267u,       815015434u,      3142242173u },
            {       180649975u,      2500813569u,       815015434u },
            {      3378723563u,       829683767u,      2500813569u }
        },
        {
            {      4174387531u,      1030729435u,      2812778314u },
            {      1752988797u,      4044178729u,      1030729435u },
            {       467969301u,       554748104u,      4044178729u }
        },
        {
            {      1348429235u,      2928743274u,      3776082629u },
            {      3607529209u,      3069812185u,      2928743274u },
            {      2542432347u,      3208181168u,      3069812185u }
        },
        {
            {      4064845753u,       668285756u,      3816217625u },
            {      3713143233u,      1380634204u,       668285756u },
            {      3533700508u,      1192551435u,      1380634204u }
        },
        {
            {      1515684518u,      1706771705u,       728123349u },
            {      3174850469u,      2057456462u,      1706771705u },
            {      3410402985u,      2897339640u,      2057456462u }
        },
        {
            {      3082272717u,       531091457u,      1390161328u },
            {      3895139973u,      2171402857u,       531091457u },
            {      4030688141u,      3049703400u,      2171402857u }
        },
        {
            {      1241147206u,      3193892819u,      1244284192u },
            {        65180262u,      4065669017u,      3193892819u },
            {      1484817937u,      3661081858u,      4065669017u }
        },
        {
            {      1438760812u,      3491341751u,      3414470157u },
            {      2805337292u,       272266053u,      3491341751u },
            {       824109230u,      3202556526u,       272266053u }
        },
        {
            {       135412706u,      3627115412u,      2345042216u },
            {      1565169824u,      2166856449u,      3627115412u },
            {      1026946745u,      3467845248u,      2166856449u }
        },
        {
            {      1889419951u,      3256876154u,      1240505488u },
            {      1254783743u,       989966800u,      3256876154u },
            {      1995297400u,      3692472918u,       989966800u }
        },
        {
            {      3206226875u,       285700890u,       496017472u },
            {      2515316194u,      2129675196u,       285700890u },
            {      1863853990u,      2673457552u,      2129675196u }
        },
        {
            {      4163770641u,       255160418u,       772100749u },
            {      1987092456u,      3237660221u,       255160418u },
            {      1394381051u,      4216039401u,      3237660221u }
        },
        {
            {      2133915627u,      2713747584u,       627765421u },
            {      2300605925u,        35690583u,      2713747584u },
            {      2918902946u,      2638220304u,        35690583u }
        },
        {
            {      2587549655u,       998684270u,      4292130625u },
            {      1791772791u,      2820705344u,       998684270u },
            {       124590158u,      3831143549u,      2820705344u }
        },
        {
            {       978482299u,      3200877282u,       497605289u },
            {      3717741518u,      3737164414u,      3200877282u },
            {      4046686626u,       861393946u,      3737164414u }
        },
        {
            {      2665561897u,       300934584u,      3179822945u },
            {       893043137u,      2031413512u,       300934584u },
            {      3806926970u,      2413249929u,      2031413512u }
        },
        {
            {      1417581911u,      3071835354u,      2575196237u },
            {      4101127251u,      1375339216u,      3071835354u },
            {       847617977u,      3632503316u,      1375339216u }
        },
        {
            {      2747488994u,      3296604805u,       898095468u },
            {      1742777145u,       219265369u,      3296604805u },
            {       823714885u,       667779292u,       219265369u }
        },
        {
            {      2640209692u,      3040506537u,      3626115220u },
            {       161827078u,       852668118u,      3040506537u },
            {      3856381322u,      3360242076u,       852668118u }
        },
        {
            {      3734246393u,      4151553160u,      4177051283u },
            {       266522866u,      1731798531u,      4151553160u },
            {       632196679u,      3864297722u,      1731798531u }
        },
        {
            {      1694175127u,      1087914338u,      2384195794u },
            {      2764925057u,       505782858u,      1087914338u },
            {      3235634082u,       807915248u,       505782858u }
        },
        {
            {      2402749950u,      2353776151u,        75909174u },
            {       890570951u,      1752665661u,      2353776151u },
            {      3120241607u,      3862435696u,      1752665661u }
        }
    };

static __device__ unsigned int mrg32k3aM2SubSeq[56][3][3] = {
        {
            {      1511326704u,      3759209742u,      1610795712u },
            {      4292754251u,      1511326704u,      3889917532u },
            {      3859662829u,      4292754251u,      3708466080u }
        },
        {
            {       972103006u,       964807713u,       878035866u },
            {      4248550197u,       972103006u,      1926628839u },
            {      1448629089u,      4248550197u,      3196114006u }
        },
        {
            {      3497384788u,      3174249442u,      3182508868u },
            {      3864816447u,      3497384788u,      3038399593u },
            {      2546884738u,      3864816447u,      2980208068u }
        },
        {
            {      1776335558u,      1189944887u,      4095757548u },
            {      3813600746u,      1776335558u,       789475914u },
            {      4119698302u,      3813600746u,      2145357457u }
        },
        {
            {      4022832294u,      4130146837u,      1942923647u },
            {      1675130777u,      4022832294u,       916677004u },
            {      4089786548u,      1675130777u,       116540512u }
        },
        {
            {       165639584u,      1205513289u,      2037453462u },
            {      1444587280u,       165639584u,       161923120u },
            {      2617085459u,      1444587280u,      2006913311u }
        },
        {
            {      3458099202u,      3062421748u,      4052486999u },
            {      1064270720u,      3458099202u,       230768332u },
            {      4056228301u,      1064270720u,      2219267779u }
        },
        {
            {       296275263u,      3452455838u,      2081462173u },
            {      1789143993u,       296275263u,      3463234943u },
            {      2097389984u,      1789143993u,      3447191459u }
        },
        {
            {      2828288883u,      3866690251u,       410553827u },
            {      1587005542u,      2828288883u,      1469478670u },
            {      2766486018u,      1587005542u,      2627363449u }
        },
        {
            {      3288027530u,       412403981u,      2458742268u },
            {      4267121909u,      3288027530u,       138566505u },
            {       420803572u,      4267121909u,      4094554844u }
        },
        {
            {      3844599430u,      2430152838u,      3283485436u },
            {      2486244684u,      3844599430u,      4252427633u },
            {      3560842909u,      2486244684u,      3960267499u }
        },
        {
            {        67933059u,      1294996291u,      2657888382u },
            {       513233413u,        67933059u,      1379805031u },
            {        44564058u,       513233413u,        86971645u }
        },
        {
            {      2732588524u,      1866530072u,       818237694u },
            {      2540507736u,      2732588524u,      3257104212u },
            {      1164400003u,      2540507736u,      1124501551u }
        },
        {
            {      4199239222u,      3155848463u,      2121388468u },
            {      1135554501u,      4199239222u,      2056492193u },
            {      3251740389u,      1135554501u,      2343537248u }
        },
        {
            {       550710036u,       500329021u,      1075236085u },
            {       356444753u,       550710036u,      1634965500u },
            {        58733535u,       356444753u,      1261552815u }
        },
        {
            {       708689546u,       419139045u,      2012018174u },
            {       706488081u,       708689546u,      1113760995u },
            {       585555005u,       706488081u,        76092226u }
        },
        {
            {      1293182265u,      3168473803u,       366230236u },
            {      3319068849u,      1293182265u,      1085259665u },
            {      1675229290u,      3319068849u,      3912300371u }
        },
        {
            {      3186089068u,      4188864734u,      1211781402u },
            {       756122322u,      3186089068u,       578262892u },
            {      2518961174u,       756122322u,      1658665581u }
        },
        {
            {      1347291439u,      2050427676u,       736113023u },
            {      4102191254u,      1347291439u,       878627148u },
            {      1293500383u,      4102191254u,       745646810u }
        },
        {
            {      4196897331u,      3436564969u,      1900167098u },
            {      3108887846u,      4196897331u,      2697923227u },
            {      1405263476u,      3108887846u,       314631094u }
        },
        {
            {       958383622u,      3694638688u,      1150087061u },
            {      3770009830u,       958383622u,       793326651u },
            {       533700213u,      3770009830u,      1513734026u }
        },
        {
            {      4119603367u,      3479396923u,      3534176399u },
            {      3765397477u,      4119603367u,      1458031003u },
            {      3380901602u,      3765397477u,      2684083587u }
        },
        {
            {       980937351u,      2094378936u,       448446028u },
            {      1421333909u,       980937351u,      3405683645u },
            {       323724368u,      1421333909u,       338680738u }
        },
        {
            {      2942968846u,      4293637338u,      3549906544u },
            {       527851489u,      2942968846u,      3852871282u },
            {      4209198933u,       527851489u,      1091268872u }
        },
        {
            {      1975983015u,      2092556693u,       611187071u },
            {      3982652344u,      1975983015u,      3001736262u },
            {      2055073597u,      3982652344u,      1875181995u }
        },
        {
            {      2970221269u,       880904779u,      2447465272u },
            {      2888742196u,      2970221269u,      3521651749u },
            {      3019977656u,      2888742196u,      2712717326u }
        },
        {
            {       419134859u,      2976059897u,       747864206u },
            {      4101695717u,       419134859u,      4264593116u },
            {      2657991148u,      4101695717u,      2542621682u }
        },
        {
            {      4043135299u,      1612983166u,      1149778656u },
            {      1267010518u,      4043135299u,      3496325546u },
            {      3094232897u,      1267010518u,      2949176293u }
        },
        {
            {      3949395794u,      1774568686u,      2123036003u },
            {      2182983404u,      3949395794u,      2355671350u },
            {      2820933455u,      2182983404u,       513963325u }
        },
        {
            {      3046911698u,      2576744453u,      2492729814u },
            {      4277866093u,      3046911698u,      3146977604u },
            {      2249371766u,      4277866093u,      3622293976u }
        },
        {
            {      1391529818u,       423458502u,      2587125255u },
            {      3536237833u,      1391529818u,       985347517u },
            {       157623850u,      3536237833u,      1015566287u }
        },
        {
            {        48329260u,      2599277669u,       821961664u },
            {       902187690u,        48329260u,      1716556555u },
            {      4019658974u,       902187690u,       950730510u }
        },
        {
            {      1318489562u,      1530977112u,      3713577419u },
            {      4270158447u,      1318489562u,      1654940598u },
            {      2679964938u,      4270158447u,      1337075195u }
        },
        {
            {       770600793u,      3249576224u,      3578552768u },
            {      2710443459u,       770600793u,      2990852339u },
            {      3098163705u,      2710443459u,       522138188u }
        },
        {
            {      2803285489u,      1922250286u,      3164022812u },
            {       477609731u,      2803285489u,      2140252218u },
            {      2252852611u,       477609731u,      3058519788u }
        },
        {
            {       208329741u,      3633562083u,      3548346666u },
            {      3892091460u,       208329741u,       516833304u },
            {      3440632377u,      3892091460u,      1638833719u }
        },
        {
            {      1816075033u,      3570111203u,       959489356u },
            {      3482051486u,      1816075033u,       861657108u },
            {      3119495098u,      3482051486u,      2576849579u }
        },
        {
            {      4240216888u,      2891584407u,      2102314945u },
            {      4064489450u,      4240216888u,      1427441010u },
            {      2441164913u,      4064489450u,      3558527186u }
        },
        {
            {      2918371295u,        65155283u,      3469357011u },
            {      3579773554u,      2918371295u,      3494391959u },
            {      3266584309u,      3579773554u,      3837485479u }
        },
        {
            {      2959420453u,      1365016881u,      4082486022u },
            {       236489012u,      2959420453u,      3802558529u },
            {      2687043642u,       236489012u,      2547086826u }
        },
        {
            {      4185325422u,      2762854843u,      3200044912u },
            {      3664909559u,      4185325422u,      3543921700u },
            {      4240262918u,      3664909559u,      2853212443u }
        },
        {
            {      2618500928u,      4237264351u,      1470046497u },
            {      1893990098u,      2618500928u,      2982567031u },
            {      3017062825u,      1893990098u,      3195556801u }
        },
        {
            {      1868464655u,      3407681142u,      1652841784u },
            {      1678569574u,      1868464655u,      4162480901u },
            {      1477016185u,      1678569574u,      4145063890u }
        },
        {
            {       792188465u,      4251338402u,      2219407026u },
            {      3840340879u,       792188465u,      3493367465u },
            {      2979958414u,      3840340879u,      2338974139u }
        },
        {
            {       478845700u,      2378167062u,       882114621u },
            {      1674533845u,       478845700u,      3572905305u },
            {      3571222880u,      1674533845u,      1242316901u }
        },
        {
            {      2636090868u,      1972761498u,        71690719u },
            {      1228103463u,      2636090868u,      1280685025u },
            {      3741735502u,      1228103463u,       994061750u }
        },
        {
            {      1156725261u,      1100755307u,       221922891u },
            {      2892200461u,      1156725261u,      1505716533u },
            {      2287613563u,      2892200461u,      3689457190u }
        },
        {
            {      1387244644u,      3135090808u,      1243609165u },
            {      1724967466u,      1387244644u,      3296353235u },
            {      1064364031u,      1724967466u,      2107521044u }
        },
        {
            {      2822471992u,      2034317853u,      2071407475u },
            {       170903528u,      2822471992u,      1322162887u },
            {      2524982332u,       170903528u,      2656231333u }
        },
        {
            {      3653936868u,      3893194049u,      2484299328u },
            {      1313746234u,      3653936868u,      1705346273u },
            {      1397638018u,      1313746234u,      4015529545u }
        },
        {
            {      4129760842u,      1671665759u,      1677834656u },
            {      3200005334u,      4129760842u,      3486207172u },
            {      2850728736u,      3200005334u,      3076201597u }
        }
    };

static unsigned int mrg32k3aM2SubSeqHost[56][3][3] = {
        {
            {      1511326704u,      3759209742u,      1610795712u },
            {      4292754251u,      1511326704u,      3889917532u },
            {      3859662829u,      4292754251u,      3708466080u }
        },
        {
            {       972103006u,       964807713u,       878035866u },
            {      4248550197u,       972103006u,      1926628839u },
            {      1448629089u,      4248550197u,      3196114006u }
        },
        {
            {      3497384788u,      3174249442u,      3182508868u },
            {      3864816447u,      3497384788u,      3038399593u },
            {      2546884738u,      3864816447u,      2980208068u }
        },
        {
            {      1776335558u,      1189944887u,      4095757548u },
            {      3813600746u,      1776335558u,       789475914u },
            {      4119698302u,      3813600746u,      2145357457u }
        },
        {
            {      4022832294u,      4130146837u,      1942923647u },
            {      1675130777u,      4022832294u,       916677004u },
            {      4089786548u,      1675130777u,       116540512u }
        },
        {
            {       165639584u,      1205513289u,      2037453462u },
            {      1444587280u,       165639584u,       161923120u },
            {      2617085459u,      1444587280u,      2006913311u }
        },
        {
            {      3458099202u,      3062421748u,      4052486999u },
            {      1064270720u,      3458099202u,       230768332u },
            {      4056228301u,      1064270720u,      2219267779u }
        },
        {
            {       296275263u,      3452455838u,      2081462173u },
            {      1789143993u,       296275263u,      3463234943u },
            {      2097389984u,      1789143993u,      3447191459u }
        },
        {
            {      2828288883u,      3866690251u,       410553827u },
            {      1587005542u,      2828288883u,      1469478670u },
            {      2766486018u,      1587005542u,      2627363449u }
        },
        {
            {      3288027530u,       412403981u,      2458742268u },
            {      4267121909u,      3288027530u,       138566505u },
            {       420803572u,      4267121909u,      4094554844u }
        },
        {
            {      3844599430u,      2430152838u,      3283485436u },
            {      2486244684u,      3844599430u,      4252427633u },
            {      3560842909u,      2486244684u,      3960267499u }
        },
        {
            {        67933059u,      1294996291u,      2657888382u },
            {       513233413u,        67933059u,      1379805031u },
            {        44564058u,       513233413u,        86971645u }
        },
        {
            {      2732588524u,      1866530072u,       818237694u },
            {      2540507736u,      2732588524u,      3257104212u },
            {      1164400003u,      2540507736u,      1124501551u }
        },
        {
            {      4199239222u,      3155848463u,      2121388468u },
            {      1135554501u,      4199239222u,      2056492193u },
            {      3251740389u,      1135554501u,      2343537248u }
        },
        {
            {       550710036u,       500329021u,      1075236085u },
            {       356444753u,       550710036u,      1634965500u },
            {        58733535u,       356444753u,      1261552815u }
        },
        {
            {       708689546u,       419139045u,      2012018174u },
            {       706488081u,       708689546u,      1113760995u },
            {       585555005u,       706488081u,        76092226u }
        },
        {
            {      1293182265u,      3168473803u,       366230236u },
            {      3319068849u,      1293182265u,      1085259665u },
            {      1675229290u,      3319068849u,      3912300371u }
        },
        {
            {      3186089068u,      4188864734u,      1211781402u },
            {       756122322u,      3186089068u,       578262892u },
            {      2518961174u,       756122322u,      1658665581u }
        },
        {
            {      1347291439u,      2050427676u,       736113023u },
            {      4102191254u,      1347291439u,       878627148u },
            {      1293500383u,      4102191254u,       745646810u }
        },
        {
            {      4196897331u,      3436564969u,      1900167098u },
            {      3108887846u,      4196897331u,      2697923227u },
            {      1405263476u,      3108887846u,       314631094u }
        },
        {
            {       958383622u,      3694638688u,      1150087061u },
            {      3770009830u,       958383622u,       793326651u },
            {       533700213u,      3770009830u,      1513734026u }
        },
        {
            {      4119603367u,      3479396923u,      3534176399u },
            {      3765397477u,      4119603367u,      1458031003u },
            {      3380901602u,      3765397477u,      2684083587u }
        },
        {
            {       980937351u,      2094378936u,       448446028u },
            {      1421333909u,       980937351u,      3405683645u },
            {       323724368u,      1421333909u,       338680738u }
        },
        {
            {      2942968846u,      4293637338u,      3549906544u },
            {       527851489u,      2942968846u,      3852871282u },
            {      4209198933u,       527851489u,      1091268872u }
        },
        {
            {      1975983015u,      2092556693u,       611187071u },
            {      3982652344u,      1975983015u,      3001736262u },
            {      2055073597u,      3982652344u,      1875181995u }
        },
        {
            {      2970221269u,       880904779u,      2447465272u },
            {      2888742196u,      2970221269u,      3521651749u },
            {      3019977656u,      2888742196u,      2712717326u }
        },
        {
            {       419134859u,      2976059897u,       747864206u },
            {      4101695717u,       419134859u,      4264593116u },
            {      2657991148u,      4101695717u,      2542621682u }
        },
        {
            {      4043135299u,      1612983166u,      1149778656u },
            {      1267010518u,      4043135299u,      3496325546u },
            {      3094232897u,      1267010518u,      2949176293u }
        },
        {
            {      3949395794u,      1774568686u,      2123036003u },
            {      2182983404u,      3949395794u,      2355671350u },
            {      2820933455u,      2182983404u,       513963325u }
        },
        {
            {      3046911698u,      2576744453u,      2492729814u },
            {      4277866093u,      3046911698u,      3146977604u },
            {      2249371766u,      4277866093u,      3622293976u }
        },
        {
            {      1391529818u,       423458502u,      2587125255u },
            {      3536237833u,      1391529818u,       985347517u },
            {       157623850u,      3536237833u,      1015566287u }
        },
        {
            {        48329260u,      2599277669u,       821961664u },
            {       902187690u,        48329260u,      1716556555u },
            {      4019658974u,       902187690u,       950730510u }
        },
        {
            {      1318489562u,      1530977112u,      3713577419u },
            {      4270158447u,      1318489562u,      1654940598u },
            {      2679964938u,      4270158447u,      1337075195u }
        },
        {
            {       770600793u,      3249576224u,      3578552768u },
            {      2710443459u,       770600793u,      2990852339u },
            {      3098163705u,      2710443459u,       522138188u }
        },
        {
            {      2803285489u,      1922250286u,      3164022812u },
            {       477609731u,      2803285489u,      2140252218u },
            {      2252852611u,       477609731u,      3058519788u }
        },
        {
            {       208329741u,      3633562083u,      3548346666u },
            {      3892091460u,       208329741u,       516833304u },
            {      3440632377u,      3892091460u,      1638833719u }
        },
        {
            {      1816075033u,      3570111203u,       959489356u },
            {      3482051486u,      1816075033u,       861657108u },
            {      3119495098u,      3482051486u,      2576849579u }
        },
        {
            {      4240216888u,      2891584407u,      2102314945u },
            {      4064489450u,      4240216888u,      1427441010u },
            {      2441164913u,      4064489450u,      3558527186u }
        },
        {
            {      2918371295u,        65155283u,      3469357011u },
            {      3579773554u,      2918371295u,      3494391959u },
            {      3266584309u,      3579773554u,      3837485479u }
        },
        {
            {      2959420453u,      1365016881u,      4082486022u },
            {       236489012u,      2959420453u,      3802558529u },
            {      2687043642u,       236489012u,      2547086826u }
        },
        {
            {      4185325422u,      2762854843u,      3200044912u },
            {      3664909559u,      4185325422u,      3543921700u },
            {      4240262918u,      3664909559u,      2853212443u }
        },
        {
            {      2618500928u,      4237264351u,      1470046497u },
            {      1893990098u,      2618500928u,      2982567031u },
            {      3017062825u,      1893990098u,      3195556801u }
        },
        {
            {      1868464655u,      3407681142u,      1652841784u },
            {      1678569574u,      1868464655u,      4162480901u },
            {      1477016185u,      1678569574u,      4145063890u }
        },
        {
            {       792188465u,      4251338402u,      2219407026u },
            {      3840340879u,       792188465u,      3493367465u },
            {      2979958414u,      3840340879u,      2338974139u }
        },
        {
            {       478845700u,      2378167062u,       882114621u },
            {      1674533845u,       478845700u,      3572905305u },
            {      3571222880u,      1674533845u,      1242316901u }
        },
        {
            {      2636090868u,      1972761498u,        71690719u },
            {      1228103463u,      2636090868u,      1280685025u },
            {      3741735502u,      1228103463u,       994061750u }
        },
        {
            {      1156725261u,      1100755307u,       221922891u },
            {      2892200461u,      1156725261u,      1505716533u },
            {      2287613563u,      2892200461u,      3689457190u }
        },
        {
            {      1387244644u,      3135090808u,      1243609165u },
            {      1724967466u,      1387244644u,      3296353235u },
            {      1064364031u,      1724967466u,      2107521044u }
        },
        {
            {      2822471992u,      2034317853u,      2071407475u },
            {       170903528u,      2822471992u,      1322162887u },
            {      2524982332u,       170903528u,      2656231333u }
        },
        {
            {      3653936868u,      3893194049u,      2484299328u },
            {      1313746234u,      3653936868u,      1705346273u },
            {      1397638018u,      1313746234u,      4015529545u }
        },
        {
            {      4129760842u,      1671665759u,      1677834656u },
            {      3200005334u,      4129760842u,      3486207172u },
            {      2850728736u,      3200005334u,      3076201597u }
        }
    };

    /*Base matrices to power (2 to the power 127) to power 2 to power n+1u, n the first array index, from 0..63*/

static __device__ unsigned int mrg32k3aM1Seq[64][3][3] = {
        {
            {      2427906178u,      3580155704u,       949770784u },
            {       226153695u,      1230515664u,      3580155704u },
            {      1988835001u,       986791581u,      1230515664u }
        },
        {
            {      1774047142u,      3199155377u,      3106427820u },
            {      1901920839u,      4290900039u,      3199155377u },
            {      4178980191u,       280623348u,      4290900039u }
        },
        {
            {      3567524348u,      1934119675u,      3188270128u },
            {      2997767678u,       826363896u,      1934119675u },
            {       262952343u,       614326610u,       826363896u }
        },
        {
            {      1625613062u,      4288164505u,      2481284279u },
            {      4273461426u,      1177260757u,      4288164505u },
            {       305959988u,      4017252267u,      1177260757u }
        },
        {
            {       337929267u,       333342539u,       418300166u },
            {      2944208672u,       379097734u,       333342539u },
            {      2084056909u,      3625475947u,       379097734u }
        },
        {
            {      1189899255u,      1307754719u,      1214919992u },
            {      3736721708u,      3514751918u,      1307754719u },
            {       732435953u,      2021244538u,      3514751918u }
        },
        {
            {      4089172695u,      1533534334u,       525643282u },
            {      1497577018u,      1335684482u,      1533534334u },
            {      2079007086u,      3977541427u,      1335684482u }
        },
        {
            {      3075256652u,      2762754934u,      3846844247u },
            {      3057872364u,      3274545167u,      2762754934u },
            {      4028573983u,       938934351u,      3274545167u }
        },
        {
            {      2597859300u,      2880151048u,      2523330453u },
            {      1121709186u,       175667448u,      2880151048u },
            {      4182510911u,      1723133625u,       175667448u }
        },
        {
            {       484148868u,      1404283933u,      2982534313u },
            {      3736767353u,      3179865161u,      1404283933u },
            {       391120388u,      3758716888u,      3179865161u }
        },
        {
            {      2138867468u,      1128973399u,      2133702321u },
            {      1613561693u,      3622350766u,      1128973399u },
            {      1500151924u,      3759983985u,      3622350766u }
        },
        {
            {      3027706760u,      3786576552u,      2698781808u },
            {      2810527099u,        90498489u,      3786576552u },
            {      4220122612u,      1855245979u,        90498489u }
        },
        {
            {      3739389517u,      1110440720u,       917457922u },
            {      2163873618u,      3707591763u,      1110440720u },
            {      2667061910u,      2533383962u,      3707591763u }
        },
        {
            {      1545226000u,      1812182123u,      3693349190u },
            {      3422065122u,      3291428549u,      1812182123u },
            {      1193168720u,      2072837757u,      3291428549u }
        },
        {
            {      3230096243u,      2131723358u,      3262178024u },
            {      2882890127u,      4088518247u,      2131723358u },
            {      3991553306u,      1282224087u,      4088518247u }
        },
        {
            {       301207261u,      1722796810u,      3697719854u },
            {      3350228505u,      3410986694u,      1722796810u },
            {      3684514720u,      2846958957u,      3410986694u }
        },
        {
            {      1532963114u,      4236235786u,      3871128158u },
            {      3540401964u,      1285250577u,      4236235786u },
            {      1105070646u,      2764245175u,      1285250577u }
        },
        {
            {       210906218u,      3068599594u,      3034582784u },
            {       340633153u,      4004365908u,      3068599594u },
            {      4238928187u,      2299166464u,      4004365908u }
        },
        {
            {      2274701639u,      3955606166u,      3081246407u },
            {      3199954992u,      3948054919u,      3955606166u },
            {      2399101442u,      3438340286u,      3948054919u }
        },
        {
            {       504137100u,      1182303684u,       201533985u },
            {      4188299661u,      3042453580u,      1182303684u },
            {      2578519273u,      2674782930u,      3042453580u }
        },
        {
            {      1382964588u,      2578452047u,      3140440866u },
            {       261861891u,      1076783073u,      2578452047u },
            {      1634588989u,       164438428u,      1076783073u }
        },
        {
            {      2529186343u,       526867394u,      3102803247u },
            {      2687252475u,      2908898908u,       526867394u },
            {      1213100579u,        86050422u,      2908898908u }
        },
        {
            {      2690118316u,       538108523u,       790337895u },
            {      4193870709u,      1053552056u,       538108523u },
            {      1635227281u,      4002399925u,      1053552056u }
        },
        {
            {      2123712957u,      4205383007u,      1812304090u },
            {      1095349745u,       166243972u,      4205383007u },
            {       428569070u,      2128782357u,       166243972u }
        },
        {
            {      1330151766u,      3569679412u,      4107175982u },
            {      3808641551u,      3621125056u,      3569679412u },
            {      4262164578u,      1927692878u,      3621125056u }
        },
        {
            {      3606295184u,      2442739556u,      3894922338u },
            {      1629626641u,      2729678535u,      2442739556u },
            {      3379124758u,      4279360935u,      2729678535u }
        },
        {
            {      1052092278u,      4249024666u,       919210106u },
            {      3253349463u,      3629539480u,      4249024666u },
            {       852514024u,      4025926501u,      3629539480u }
        },
        {
            {        12394571u,      1252747620u,      2133571953u },
            {      4227339509u,      3197545170u,      1252747620u },
            {      1884529704u,      1976203831u,      3197545170u }
        },
        {
            {      2986331025u,      2671019282u,      2847338542u },
            {      3173738401u,      3542657885u,      2671019282u },
            {       745203060u,      1546667401u,      3542657885u }
        },
        {
            {      2613012997u,      2311336951u,      2911336433u },
            {      1493974713u,        92565032u,      2311336951u },
            {      2786645250u,       257065974u,        92565032u }
        },
        {
            {      3424925004u,      2776053372u,      2204068573u },
            {      3770626858u,      2509257810u,      2776053372u },
            {      2979919489u,      1146336783u,      2509257810u }
        },
        {
            {      1474384834u,       827894421u,       515339473u },
            {      1373055755u,      1949809417u,       827894421u },
            {      3088339524u,      1194193824u,      1949809417u }
        },
        {
            {      1825805135u,      1289872272u,      3700877161u },
            {      3433422861u,      4062509844u,      1289872272u },
            {      3019008744u,      2060641859u,      4062509844u }
        },
        {
            {      3842597153u,      4253338264u,      3424495942u },
            {       698444416u,        60268595u,      4253338264u },
            {      4096010585u,        47309624u,        60268595u }
        },
        {
            {      2662288323u,      2043518992u,      1593435980u },
            {      1330201507u,      3618850300u,      2043518992u },
            {      2538793204u,       271787962u,      3618850300u }
        },
        {
            {       741020448u,       997594656u,      2398808739u },
            {      1160477043u,      1522130854u,       997594656u },
            {      3036916315u,      2847712653u,      1522130854u }
        },
        {
            {      2654964886u,      1889728930u,        53329096u },
            {      2042322941u,      1621136330u,      1889728930u },
            {      1553642730u,       784545882u,      1621136330u }
        },
        {
            {      1715219514u,      2831829177u,       929124824u },
            {       997274536u,       404228189u,      2831829177u },
            {      1386575385u,      4107238699u,       404228189u }
        },
        {
            {      3928131551u,      2912523524u,      1840499723u },
            {      4216003022u,      2970489088u,      2912523524u },
            {      1158689953u,      1425511081u,      2970489088u }
        },
        {
            {      2807004452u,      2510299562u,       271603006u },
            {      2505735035u,      2370490899u,      2510299562u },
            {        10873814u,      2450376936u,      2370490899u }
        },
        {
            {      2000734342u,      1113679064u,      2502160539u },
            {      1475266926u,      2787925323u,      1113679064u },
            {      1475797635u,      3044470744u,      2787925323u }
        },
        {
            {      1457157056u,      1252556678u,      3073232607u },
            {      1926798761u,      3639907189u,      1252556678u },
            {      2067740348u,      2256217204u,      3639907189u }
        },
        {
            {      3740999688u,      1035400458u,      3162437311u },
            {      4126312242u,       686702830u,      1035400458u },
            {      1699805291u,       667792040u,       686702830u }
        },
        {
            {      2422495016u,      3203768688u,      1858240466u },
            {       848719394u,      4092709154u,      3203768688u },
            {       659945473u,      1863075174u,      4092709154u }
        },
        {
            {       246817944u,       871751352u,      2834051003u },
            {      3976202597u,      3721214025u,       871751352u },
            {       783929942u,       745295675u,      3721214025u }
        },
        {
            {      3811740424u,      3603608092u,      2365398362u },
            {      3826150877u,      2906557036u,      3603608092u },
            {      2300510686u,       966815948u,      2906557036u }
        },
        {
            {      2816329160u,        18201123u,      3367710570u },
            {       437309679u,      2220769388u,        18201123u },
            {      1346863388u,       705296543u,      2220769388u }
        },
        {
            {      3310028953u,      1662315499u,       132645114u },
            {      2572908401u,      3105849797u,      1662315499u },
            {      1937586849u,      1735620028u,      3105849797u }
        },
        {
            {       461386353u,      1359675853u,      3599822966u },
            {       106675209u,      2044154050u,      1359675853u },
            {      1787730088u,      1149892630u,      2044154050u }
        },
        {
            {      3303902397u,       345146034u,      1417149696u },
            {      2231869247u,      1116882637u,       345146034u },
            {      1846832385u,        79626976u,      1116882637u }
        },
        {
            {      2765049417u,      3117782790u,      1805260159u },
            {      3796182890u,      1101141726u,      3117782790u },
            {       224270120u,      1004001443u,      1101141726u }
        },
        {
            {        89118668u,      2494198515u,      1356989069u },
            {      2490435731u,       997151755u,      2494198515u },
            {      1175528637u,      3444341166u,       997151755u }
        },
        {
            {      2340639019u,       510225634u,       286119182u },
            {      2045217287u,      1194574818u,       510225634u },
            {      2662281592u,      1728500627u,      1194574818u }
        },
        {
            {       210787847u,      1189120688u,      2848040407u },
            {      1087786165u,      2343328484u,      1189120688u },
            {      3465141330u,      2893041005u,      2343328484u }
        },
        {
            {      3438170226u,      3236285682u,       962036916u },
            {      2873263091u,       215280489u,      3236285682u },
            {       730413847u,      1474823842u,       215280489u }
        },
        {
            {      1566461658u,       133010024u,      2886695328u },
            {      2835827516u,       653809404u,       133010024u },
            {      3082882924u,      3710942807u,       653809404u }
        },
        {
            {      4201558916u,      1263786956u,       326001602u },
            {       762846463u,       621546357u,      1263786956u },
            {      2697142404u,      1156650856u,       621546357u }
        },
        {
            {      2655768102u,      2339029465u,      2430211448u },
            {      2669906627u,       403962847u,      2339029465u },
            {      1483118807u,       639660658u,       403962847u }
        },
        {
            {      3508595200u,      4228486662u,       754946994u },
            {      1913148390u,      3500531602u,      4228486662u },
            {           24637u,      3773159052u,      3500531602u }
        },
        {
            {      4024866227u,      1143874914u,      3205058469u },
            {      2970344133u,      2873927273u,      1143874914u },
            {      2167114735u,      4095476435u,      2873927273u }
        },
        {
            {      1479401095u,      2958366486u,      3027708794u },
            {      2704486034u,      3574053987u,      2958366486u },
            {      3630964515u,      1276667706u,      3574053987u }
        },
        {
            {      2035927380u,      1363628533u,       818363998u },
            {      3023327955u,      3968427114u,      1363628533u },
            {      1284825950u,      2871663372u,      3968427114u }
        },
        {
            {      3827747418u,      3897287251u,      4106993377u },
            {      1527779946u,      3221052941u,      3897287251u },
            {      4178727866u,      4281160673u,      3221052941u }
        },
        {
            {      1174358892u,      2835476193u,       959978619u },
            {       850076464u,      3774782533u,      2835476193u },
            {      3880910680u,      3237990203u,      3774782533u }
        }
    };

static unsigned int mrg32k3aM1SeqHost[64][3][3] = {
        {
            {      2427906178u,      3580155704u,       949770784u },
            {       226153695u,      1230515664u,      3580155704u },
            {      1988835001u,       986791581u,      1230515664u }
        },
        {
            {      1774047142u,      3199155377u,      3106427820u },
            {      1901920839u,      4290900039u,      3199155377u },
            {      4178980191u,       280623348u,      4290900039u }
        },
        {
            {      3567524348u,      1934119675u,      3188270128u },
            {      2997767678u,       826363896u,      1934119675u },
            {       262952343u,       614326610u,       826363896u }
        },
        {
            {      1625613062u,      4288164505u,      2481284279u },
            {      4273461426u,      1177260757u,      4288164505u },
            {       305959988u,      4017252267u,      1177260757u }
        },
        {
            {       337929267u,       333342539u,       418300166u },
            {      2944208672u,       379097734u,       333342539u },
            {      2084056909u,      3625475947u,       379097734u }
        },
        {
            {      1189899255u,      1307754719u,      1214919992u },
            {      3736721708u,      3514751918u,      1307754719u },
            {       732435953u,      2021244538u,      3514751918u }
        },
        {
            {      4089172695u,      1533534334u,       525643282u },
            {      1497577018u,      1335684482u,      1533534334u },
            {      2079007086u,      3977541427u,      1335684482u }
        },
        {
            {      3075256652u,      2762754934u,      3846844247u },
            {      3057872364u,      3274545167u,      2762754934u },
            {      4028573983u,       938934351u,      3274545167u }
        },
        {
            {      2597859300u,      2880151048u,      2523330453u },
            {      1121709186u,       175667448u,      2880151048u },
            {      4182510911u,      1723133625u,       175667448u }
        },
        {
            {       484148868u,      1404283933u,      2982534313u },
            {      3736767353u,      3179865161u,      1404283933u },
            {       391120388u,      3758716888u,      3179865161u }
        },
        {
            {      2138867468u,      1128973399u,      2133702321u },
            {      1613561693u,      3622350766u,      1128973399u },
            {      1500151924u,      3759983985u,      3622350766u }
        },
        {
            {      3027706760u,      3786576552u,      2698781808u },
            {      2810527099u,        90498489u,      3786576552u },
            {      4220122612u,      1855245979u,        90498489u }
        },
        {
            {      3739389517u,      1110440720u,       917457922u },
            {      2163873618u,      3707591763u,      1110440720u },
            {      2667061910u,      2533383962u,      3707591763u }
        },
        {
            {      1545226000u,      1812182123u,      3693349190u },
            {      3422065122u,      3291428549u,      1812182123u },
            {      1193168720u,      2072837757u,      3291428549u }
        },
        {
            {      3230096243u,      2131723358u,      3262178024u },
            {      2882890127u,      4088518247u,      2131723358u },
            {      3991553306u,      1282224087u,      4088518247u }
        },
        {
            {       301207261u,      1722796810u,      3697719854u },
            {      3350228505u,      3410986694u,      1722796810u },
            {      3684514720u,      2846958957u,      3410986694u }
        },
        {
            {      1532963114u,      4236235786u,      3871128158u },
            {      3540401964u,      1285250577u,      4236235786u },
            {      1105070646u,      2764245175u,      1285250577u }
        },
        {
            {       210906218u,      3068599594u,      3034582784u },
            {       340633153u,      4004365908u,      3068599594u },
            {      4238928187u,      2299166464u,      4004365908u }
        },
        {
            {      2274701639u,      3955606166u,      3081246407u },
            {      3199954992u,      3948054919u,      3955606166u },
            {      2399101442u,      3438340286u,      3948054919u }
        },
        {
            {       504137100u,      1182303684u,       201533985u },
            {      4188299661u,      3042453580u,      1182303684u },
            {      2578519273u,      2674782930u,      3042453580u }
        },
        {
            {      1382964588u,      2578452047u,      3140440866u },
            {       261861891u,      1076783073u,      2578452047u },
            {      1634588989u,       164438428u,      1076783073u }
        },
        {
            {      2529186343u,       526867394u,      3102803247u },
            {      2687252475u,      2908898908u,       526867394u },
            {      1213100579u,        86050422u,      2908898908u }
        },
        {
            {      2690118316u,       538108523u,       790337895u },
            {      4193870709u,      1053552056u,       538108523u },
            {      1635227281u,      4002399925u,      1053552056u }
        },
        {
            {      2123712957u,      4205383007u,      1812304090u },
            {      1095349745u,       166243972u,      4205383007u },
            {       428569070u,      2128782357u,       166243972u }
        },
        {
            {      1330151766u,      3569679412u,      4107175982u },
            {      3808641551u,      3621125056u,      3569679412u },
            {      4262164578u,      1927692878u,      3621125056u }
        },
        {
            {      3606295184u,      2442739556u,      3894922338u },
            {      1629626641u,      2729678535u,      2442739556u },
            {      3379124758u,      4279360935u,      2729678535u }
        },
        {
            {      1052092278u,      4249024666u,       919210106u },
            {      3253349463u,      3629539480u,      4249024666u },
            {       852514024u,      4025926501u,      3629539480u }
        },
        {
            {        12394571u,      1252747620u,      2133571953u },
            {      4227339509u,      3197545170u,      1252747620u },
            {      1884529704u,      1976203831u,      3197545170u }
        },
        {
            {      2986331025u,      2671019282u,      2847338542u },
            {      3173738401u,      3542657885u,      2671019282u },
            {       745203060u,      1546667401u,      3542657885u }
        },
        {
            {      2613012997u,      2311336951u,      2911336433u },
            {      1493974713u,        92565032u,      2311336951u },
            {      2786645250u,       257065974u,        92565032u }
        },
        {
            {      3424925004u,      2776053372u,      2204068573u },
            {      3770626858u,      2509257810u,      2776053372u },
            {      2979919489u,      1146336783u,      2509257810u }
        },
        {
            {      1474384834u,       827894421u,       515339473u },
            {      1373055755u,      1949809417u,       827894421u },
            {      3088339524u,      1194193824u,      1949809417u }
        },
        {
            {      1825805135u,      1289872272u,      3700877161u },
            {      3433422861u,      4062509844u,      1289872272u },
            {      3019008744u,      2060641859u,      4062509844u }
        },
        {
            {      3842597153u,      4253338264u,      3424495942u },
            {       698444416u,        60268595u,      4253338264u },
            {      4096010585u,        47309624u,        60268595u }
        },
        {
            {      2662288323u,      2043518992u,      1593435980u },
            {      1330201507u,      3618850300u,      2043518992u },
            {      2538793204u,       271787962u,      3618850300u }
        },
        {
            {       741020448u,       997594656u,      2398808739u },
            {      1160477043u,      1522130854u,       997594656u },
            {      3036916315u,      2847712653u,      1522130854u }
        },
        {
            {      2654964886u,      1889728930u,        53329096u },
            {      2042322941u,      1621136330u,      1889728930u },
            {      1553642730u,       784545882u,      1621136330u }
        },
        {
            {      1715219514u,      2831829177u,       929124824u },
            {       997274536u,       404228189u,      2831829177u },
            {      1386575385u,      4107238699u,       404228189u }
        },
        {
            {      3928131551u,      2912523524u,      1840499723u },
            {      4216003022u,      2970489088u,      2912523524u },
            {      1158689953u,      1425511081u,      2970489088u }
        },
        {
            {      2807004452u,      2510299562u,       271603006u },
            {      2505735035u,      2370490899u,      2510299562u },
            {        10873814u,      2450376936u,      2370490899u }
        },
        {
            {      2000734342u,      1113679064u,      2502160539u },
            {      1475266926u,      2787925323u,      1113679064u },
            {      1475797635u,      3044470744u,      2787925323u }
        },
        {
            {      1457157056u,      1252556678u,      3073232607u },
            {      1926798761u,      3639907189u,      1252556678u },
            {      2067740348u,      2256217204u,      3639907189u }
        },
        {
            {      3740999688u,      1035400458u,      3162437311u },
            {      4126312242u,       686702830u,      1035400458u },
            {      1699805291u,       667792040u,       686702830u }
        },
        {
            {      2422495016u,      3203768688u,      1858240466u },
            {       848719394u,      4092709154u,      3203768688u },
            {       659945473u,      1863075174u,      4092709154u }
        },
        {
            {       246817944u,       871751352u,      2834051003u },
            {      3976202597u,      3721214025u,       871751352u },
            {       783929942u,       745295675u,      3721214025u }
        },
        {
            {      3811740424u,      3603608092u,      2365398362u },
            {      3826150877u,      2906557036u,      3603608092u },
            {      2300510686u,       966815948u,      2906557036u }
        },
        {
            {      2816329160u,        18201123u,      3367710570u },
            {       437309679u,      2220769388u,        18201123u },
            {      1346863388u,       705296543u,      2220769388u }
        },
        {
            {      3310028953u,      1662315499u,       132645114u },
            {      2572908401u,      3105849797u,      1662315499u },
            {      1937586849u,      1735620028u,      3105849797u }
        },
        {
            {       461386353u,      1359675853u,      3599822966u },
            {       106675209u,      2044154050u,      1359675853u },
            {      1787730088u,      1149892630u,      2044154050u }
        },
        {
            {      3303902397u,       345146034u,      1417149696u },
            {      2231869247u,      1116882637u,       345146034u },
            {      1846832385u,        79626976u,      1116882637u }
        },
        {
            {      2765049417u,      3117782790u,      1805260159u },
            {      3796182890u,      1101141726u,      3117782790u },
            {       224270120u,      1004001443u,      1101141726u }
        },
        {
            {        89118668u,      2494198515u,      1356989069u },
            {      2490435731u,       997151755u,      2494198515u },
            {      1175528637u,      3444341166u,       997151755u }
        },
        {
            {      2340639019u,       510225634u,       286119182u },
            {      2045217287u,      1194574818u,       510225634u },
            {      2662281592u,      1728500627u,      1194574818u }
        },
        {
            {       210787847u,      1189120688u,      2848040407u },
            {      1087786165u,      2343328484u,      1189120688u },
            {      3465141330u,      2893041005u,      2343328484u }
        },
        {
            {      3438170226u,      3236285682u,       962036916u },
            {      2873263091u,       215280489u,      3236285682u },
            {       730413847u,      1474823842u,       215280489u }
        },
        {
            {      1566461658u,       133010024u,      2886695328u },
            {      2835827516u,       653809404u,       133010024u },
            {      3082882924u,      3710942807u,       653809404u }
        },
        {
            {      4201558916u,      1263786956u,       326001602u },
            {       762846463u,       621546357u,      1263786956u },
            {      2697142404u,      1156650856u,       621546357u }
        },
        {
            {      2655768102u,      2339029465u,      2430211448u },
            {      2669906627u,       403962847u,      2339029465u },
            {      1483118807u,       639660658u,       403962847u }
        },
        {
            {      3508595200u,      4228486662u,       754946994u },
            {      1913148390u,      3500531602u,      4228486662u },
            {           24637u,      3773159052u,      3500531602u }
        },
        {
            {      4024866227u,      1143874914u,      3205058469u },
            {      2970344133u,      2873927273u,      1143874914u },
            {      2167114735u,      4095476435u,      2873927273u }
        },
        {
            {      1479401095u,      2958366486u,      3027708794u },
            {      2704486034u,      3574053987u,      2958366486u },
            {      3630964515u,      1276667706u,      3574053987u }
        },
        {
            {      2035927380u,      1363628533u,       818363998u },
            {      3023327955u,      3968427114u,      1363628533u },
            {      1284825950u,      2871663372u,      3968427114u }
        },
        {
            {      3827747418u,      3897287251u,      4106993377u },
            {      1527779946u,      3221052941u,      3897287251u },
            {      4178727866u,      4281160673u,      3221052941u }
        },
        {
            {      1174358892u,      2835476193u,       959978619u },
            {       850076464u,      3774782533u,      2835476193u },
            {      3880910680u,      3237990203u,      3774782533u }
        }
    };

static __device__ unsigned int mrg32k3aM2Seq[64][3][3] = {
        {
            {      1464411153u,       277697599u,      1610723613u },
            {        32183930u,      1464411153u,      1022607788u },
            {      2824425944u,        32183930u,      2093834863u }
        },
        {
            {      3492361727u,      1027004383u,      3167429889u },
            {      3674905362u,      3492361727u,      3572939265u },
            {      4270409313u,      3674905362u,       698814233u }
        },
        {
            {       880482061u,       205175925u,      4070445105u },
            {      2208329119u,       880482061u,      1933248566u },
            {      3741227945u,      2208329119u,      3962062826u }
        },
        {
            {      4184605179u,      1189429800u,       567967482u },
            {       107217966u,      4184605179u,       784865788u },
            {       549462420u,       107217966u,      3134382704u }
        },
        {
            {      2732536445u,      1231107067u,      3374588386u },
            {       409954030u,      2732536445u,      1044831206u },
            {      3398162498u,       409954030u,      3505648581u }
        },
        {
            {      2169560691u,      1076348534u,       637306236u },
            {      3704346564u,      2169560691u,       293694496u },
            {       632453145u,      3704346564u,      1609425246u }
        },
        {
            {       372115891u,      3928812480u,      2830541169u },
            {      3056527841u,       372115891u,      1924239834u },
            {      3044937468u,      3056527841u,       547142630u }
        },
        {
            {      1660852083u,      3635660815u,      1389092450u },
            {      1025573319u,      1660852083u,      3276803366u },
            {      4036331438u,      1025573319u,      4092197741u }
        },
        {
            {      1360732901u,      2887812973u,      4101068693u },
            {        52572783u,      1360732901u,       112458461u },
            {      2636566855u,        52572783u,      1136777988u }
        },
        {
            {      3455696508u,       536919193u,      3978804036u },
            {      3094157668u,      3455696508u,      3821833900u },
            {      2278849016u,      3094157668u,      2531965909u }
        },
        {
            {      2125991744u,       890897326u,      3790557569u },
            {      1433592392u,      2125991744u,      3671109604u },
            {       808215503u,      1433592392u,      2446306581u }
        },
        {
            {      3524411799u,       932865240u,      1838275365u },
            {      1789634890u,      3524411799u,      4130736474u },
            {      2252266098u,      1789634890u,      3048775967u }
        },
        {
            {      1773339925u,       948403862u,      1999624391u },
            {       983864203u,      1773339925u,      3734776305u },
            {       314407045u,       983864203u,      2648614071u }
        },
        {
            {       321802921u,      1099164995u,      2112167358u },
            {      3760936985u,       321802921u,      1003573324u },
            {      3758858458u,      3760936985u,      4014658840u }
        },
        {
            {      2196438580u,       805386227u,      4266375092u },
            {      4124675351u,      2196438580u,      2527961345u },
            {        94452540u,      4124675351u,      2825656399u }
        },
        {
            {        66735368u,      2228005807u,      4186703168u },
            {      2624855312u,        66735368u,      2708679078u },
            {      4098470056u,      2624855312u,      1773862183u }
        },
        {
            {      3072642883u,      2746897053u,      2690305546u },
            {      1105106652u,      3072642883u,      4047666135u },
            {      2862886282u,      1105106652u,      3597347398u }
        },
        {
            {       232906611u,      3873338256u,      4051554873u },
            {      3027413363u,       232906611u,      3159432673u },
            {      3872967050u,      3027413363u,       987156327u }
        },
        {
            {      1160686753u,      3676603152u,      1635979789u },
            {      1447386846u,      1160686753u,      2670438424u },
            {       816212890u,      1447386846u,      4288868534u }
        },
        {
            {      3825238244u,      1445162354u,      2362389441u },
            {      3440193648u,      3825238244u,      3520937545u },
            {      2652790808u,      3440193648u,       405299994u }
        },
        {
            {      1984094858u,       532165989u,      2027397575u },
            {      1455977136u,      1984094858u,      2433255524u },
            {      1039994763u,      1455977136u,      2069333087u }
        },
        {
            {      3680843319u,      2332949611u,      3516795313u },
            {      2033851810u,      3680843319u,      3843367307u },
            {      3686294589u,      2033851810u,      3912995069u }
        },
        {
            {       967423689u,      1724183394u,       635932799u },
            {       641380480u,       967423689u,      2145297779u },
            {      1723000412u,       641380480u,       455633660u }
        },
        {
            {      2130938335u,      1534972306u,      2511584766u },
            {       273828453u,      2130938335u,      3112810093u },
            {      4084843716u,       273828453u,      1399334152u }
        },
        {
            {       168278549u,       541167592u,       190177712u },
            {       403188859u,       168278549u,      2092073970u },
            {        58789558u,       403188859u,      2777887189u }
        },
        {
            {       634843389u,      4082275720u,      2092828966u },
            {       351187677u,       634843389u,      1312056270u },
            {      3347241070u,       351187677u,      2417192332u }
        },
        {
            {       443276110u,      1113643788u,       271102234u },
            {      3083745876u,       443276110u,      3370743767u },
            {      4200577503u,      3083745876u,      3298601960u }
        },
        {
            {      3533393557u,       764977733u,      3400275098u },
            {       144639933u,      3533393557u,      2646475951u },
            {        77963866u,       144639933u,      3794766611u }
        },
        {
            {      4064854722u,      1198665008u,      2872196602u },
            {      3274748603u,      4064854722u,      4164637970u },
            {      4238693771u,      3274748603u,      1981721347u }
        },
        {
            {      2279220396u,      2355957139u,      1417574285u },
            {       885864931u,      2279220396u,      1344421653u },
            {      1895527787u,       885864931u,      3726919367u }
        },
        {
            {      2898100178u,      2427331008u,       348923199u },
            {      3175444953u,      2898100178u,      4290541487u },
            {       246118669u,      3175444953u,      3410622769u }
        },
        {
            {       284442065u,      4064194676u,      2295560707u },
            {      4182706556u,       284442065u,      3696899246u },
            {      1201342255u,      4182706556u,      1145356382u }
        },
        {
            {       656615546u,       442908965u,      3724738272u },
            {      1624967553u,       656615546u,       798014134u },
            {      1157949454u,      1624967553u,       496247378u }
        },
        {
            {       265689579u,       675056541u,      3009083380u },
            {      3820679930u,       265689579u,      2961990151u },
            {       562287964u,      3820679930u,      1853486796u }
        },
        {
            {      1675739167u,      2319843005u,       760605578u },
            {      4161492847u,      1675739167u,       226142150u },
            {      1017447188u,      4161492847u,      3431158427u }
        },
        {
            {      1759873736u,      2334568602u,      2154570180u },
            {      1812793060u,      1759873736u,      2111094408u },
            {      1168460586u,      1812793060u,      2495653141u }
        },
        {
            {       317621194u,       868104288u,       664971082u },
            {      2340275074u,       317621194u,      2168960688u },
            {       725706104u,      2340275074u,      3532023115u }
        },
        {
            {      3926931954u,      2907684453u,       615601328u },
            {      1132340715u,      3926931954u,       676995757u },
            {      1154819290u,      1132340715u,      1662727700u }
        },
        {
            {      3921782078u,      3376494857u,      2969567377u },
            {       475345024u,      3921782078u,      4206379953u },
            {      1795936544u,       475345024u,       934679595u }
        },
        {
            {      3119292228u,       741613041u,      2083352304u },
            {      1047885963u,      3119292228u,      1581078542u },
            {      1065969969u,      1047885963u,       661718928u }
        },
        {
            {      3643472111u,      2870554228u,      3995474529u },
            {      3804264051u,      3643472111u,      1366457944u },
            {      1246805564u,      3804264051u,       993186530u }
        },
        {
            {       796711791u,      3878204845u,      3160293932u },
            {       255632881u,       796711791u,      3778927111u },
            {      3472564181u,       255632881u,       388382377u }
        },
        {
            {      1776984101u,      1742284034u,      3449763933u },
            {      1349354417u,      1776984101u,      1264780832u },
            {       715722511u,      1349354417u,      1213319489u }
        },
        {
            {      4261866865u,      1914382786u,       201872335u },
            {       614207188u,      4261866865u,      1853554849u },
            {      2046042882u,       614207188u,      3193186353u }
        },
        {
            {      2210205512u,      2847073169u,      3324925707u },
            {      1251969297u,      2210205512u,      3491451503u },
            {       470400916u,      1251969297u,      2184392547u }
        },
        {
            {      1523590942u,      2391111113u,        68341529u },
            {       295466806u,      1523590942u,      4143310876u },
            {      3527253079u,       295466806u,      4059123142u }
        },
        {
            {      1406902110u,      3735012720u,      1774518130u },
            {      1814959027u,      1406902110u,      1560544267u },
            {       346472965u,      1814959027u,       964257199u }
        },
        {
            {       855309653u,      4208503105u,      1518467541u },
            {      2025248418u,       855309653u,      4148125749u },
            {      1349947330u,      2025248418u,      1168504873u }
        },
        {
            {      2375338156u,      3629519168u,       409696181u },
            {       252401654u,      2375338156u,      3992097193u },
            {      2793725401u,       252401654u,      1350184085u }
        },
        {
            {       873141039u,      3885583138u,       361604799u },
            {      3554143374u,       873141039u,       894746180u },
            {      1919765327u,      3554143374u,       876210854u }
        },
        {
            {       246368794u,      1703793169u,      2317362874u },
            {      2300930144u,       246368794u,      2560214589u },
            {      2016163623u,      2300930144u,      1504276775u }
        },
        {
            {      1574610921u,      2147546631u,      4103450226u },
            {       107416526u,      1574610921u,      1773803959u },
            {      1402542742u,       107416526u,       550063800u }
        },
        {
            {       363388665u,       592194244u,      1746615522u },
            {      2637234667u,       363388665u,      4031408742u },
            {      2895130475u,      2637234667u,       296510335u }
        },
        {
            {      3997368560u,      3047771871u,      3178383826u },
            {      1160174754u,      3997368560u,      4027094919u },
            {      1234984211u,      1160174754u,      4226264344u }
        },
        {
            {      3303179301u,      4243968063u,      3235964171u },
            {      1776841674u,      3303179301u,      2867287469u },
            {      1500495759u,      1776841674u,      1708226553u }
        },
        {
            {      1482944153u,      3192311574u,       354466071u },
            {      3932773012u,      1482944153u,       389193591u },
            {      3350181058u,      3932773012u,      3398059015u }
        },
        {
            {       640968550u,      3226860971u,       922372912u },
            {      1254989667u,       640968550u,      2383815228u },
            {      2027371896u,      1254989667u,      2925300409u }
        },
        {
            {      2313146046u,      3910187183u,      1377591475u },
            {      1689291784u,      2313146046u,      4255405993u },
            {      1650609719u,      1689291784u,      1897624297u }
        },
        {
            {      3656310954u,       882924050u,      2702189958u },
            {      3185020283u,      3656310954u,      1923190496u },
            {      2449669145u,      3185020283u,      4235849984u }
        },
        {
            {       377232416u,      1498446142u,      4229103619u },
            {      3926377906u,       377232416u,       600268838u },
            {       511317726u,      3926377906u,       216160452u }
        },
        {
            {      1969399344u,      3273966859u,      4220943579u },
            {      3952111894u,      1969399344u,       575096961u },
            {      3815277103u,      3952111894u,       792177412u }
        },
        {
            {      2957238169u,      1410010554u,      1523740068u },
            {      3949237584u,      2957238169u,        74149658u },
            {      2564746147u,      3949237584u,      2557663578u }
        },
        {
            {      3377318569u,      1927835240u,      2556102508u },
            {      3022040116u,      3377318569u,      2549406364u },
            {      2387074241u,      3022040116u,      1477293711u }
        },
        {
            {       257306870u,      1748489735u,       547809226u },
            {      3708493374u,       257306870u,      4183546362u },
            {         4435502u,      3708493374u,      1607696753u }
        }
    };

static unsigned int mrg32k3aM2SeqHost[64][3][3] = {
        {
            {      1464411153u,       277697599u,      1610723613u },
            {        32183930u,      1464411153u,      1022607788u },
            {      2824425944u,        32183930u,      2093834863u }
        },
        {
            {      3492361727u,      1027004383u,      3167429889u },
            {      3674905362u,      3492361727u,      3572939265u },
            {      4270409313u,      3674905362u,       698814233u }
        },
        {
            {       880482061u,       205175925u,      4070445105u },
            {      2208329119u,       880482061u,      1933248566u },
            {      3741227945u,      2208329119u,      3962062826u }
        },
        {
            {      4184605179u,      1189429800u,       567967482u },
            {       107217966u,      4184605179u,       784865788u },
            {       549462420u,       107217966u,      3134382704u }
        },
        {
            {      2732536445u,      1231107067u,      3374588386u },
            {       409954030u,      2732536445u,      1044831206u },
            {      3398162498u,       409954030u,      3505648581u }
        },
        {
            {      2169560691u,      1076348534u,       637306236u },
            {      3704346564u,      2169560691u,       293694496u },
            {       632453145u,      3704346564u,      1609425246u }
        },
        {
            {       372115891u,      3928812480u,      2830541169u },
            {      3056527841u,       372115891u,      1924239834u },
            {      3044937468u,      3056527841u,       547142630u }
        },
        {
            {      1660852083u,      3635660815u,      1389092450u },
            {      1025573319u,      1660852083u,      3276803366u },
            {      4036331438u,      1025573319u,      4092197741u }
        },
        {
            {      1360732901u,      2887812973u,      4101068693u },
            {        52572783u,      1360732901u,       112458461u },
            {      2636566855u,        52572783u,      1136777988u }
        },
        {
            {      3455696508u,       536919193u,      3978804036u },
            {      3094157668u,      3455696508u,      3821833900u },
            {      2278849016u,      3094157668u,      2531965909u }
        },
        {
            {      2125991744u,       890897326u,      3790557569u },
            {      1433592392u,      2125991744u,      3671109604u },
            {       808215503u,      1433592392u,      2446306581u }
        },
        {
            {      3524411799u,       932865240u,      1838275365u },
            {      1789634890u,      3524411799u,      4130736474u },
            {      2252266098u,      1789634890u,      3048775967u }
        },
        {
            {      1773339925u,       948403862u,      1999624391u },
            {       983864203u,      1773339925u,      3734776305u },
            {       314407045u,       983864203u,      2648614071u }
        },
        {
            {       321802921u,      1099164995u,      2112167358u },
            {      3760936985u,       321802921u,      1003573324u },
            {      3758858458u,      3760936985u,      4014658840u }
        },
        {
            {      2196438580u,       805386227u,      4266375092u },
            {      4124675351u,      2196438580u,      2527961345u },
            {        94452540u,      4124675351u,      2825656399u }
        },
        {
            {        66735368u,      2228005807u,      4186703168u },
            {      2624855312u,        66735368u,      2708679078u },
            {      4098470056u,      2624855312u,      1773862183u }
        },
        {
            {      3072642883u,      2746897053u,      2690305546u },
            {      1105106652u,      3072642883u,      4047666135u },
            {      2862886282u,      1105106652u,      3597347398u }
        },
        {
            {       232906611u,      3873338256u,      4051554873u },
            {      3027413363u,       232906611u,      3159432673u },
            {      3872967050u,      3027413363u,       987156327u }
        },
        {
            {      1160686753u,      3676603152u,      1635979789u },
            {      1447386846u,      1160686753u,      2670438424u },
            {       816212890u,      1447386846u,      4288868534u }
        },
        {
            {      3825238244u,      1445162354u,      2362389441u },
            {      3440193648u,      3825238244u,      3520937545u },
            {      2652790808u,      3440193648u,       405299994u }
        },
        {
            {      1984094858u,       532165989u,      2027397575u },
            {      1455977136u,      1984094858u,      2433255524u },
            {      1039994763u,      1455977136u,      2069333087u }
        },
        {
            {      3680843319u,      2332949611u,      3516795313u },
            {      2033851810u,      3680843319u,      3843367307u },
            {      3686294589u,      2033851810u,      3912995069u }
        },
        {
            {       967423689u,      1724183394u,       635932799u },
            {       641380480u,       967423689u,      2145297779u },
            {      1723000412u,       641380480u,       455633660u }
        },
        {
            {      2130938335u,      1534972306u,      2511584766u },
            {       273828453u,      2130938335u,      3112810093u },
            {      4084843716u,       273828453u,      1399334152u }
        },
        {
            {       168278549u,       541167592u,       190177712u },
            {       403188859u,       168278549u,      2092073970u },
            {        58789558u,       403188859u,      2777887189u }
        },
        {
            {       634843389u,      4082275720u,      2092828966u },
            {       351187677u,       634843389u,      1312056270u },
            {      3347241070u,       351187677u,      2417192332u }
        },
        {
            {       443276110u,      1113643788u,       271102234u },
            {      3083745876u,       443276110u,      3370743767u },
            {      4200577503u,      3083745876u,      3298601960u }
        },
        {
            {      3533393557u,       764977733u,      3400275098u },
            {       144639933u,      3533393557u,      2646475951u },
            {        77963866u,       144639933u,      3794766611u }
        },
        {
            {      4064854722u,      1198665008u,      2872196602u },
            {      3274748603u,      4064854722u,      4164637970u },
            {      4238693771u,      3274748603u,      1981721347u }
        },
        {
            {      2279220396u,      2355957139u,      1417574285u },
            {       885864931u,      2279220396u,      1344421653u },
            {      1895527787u,       885864931u,      3726919367u }
        },
        {
            {      2898100178u,      2427331008u,       348923199u },
            {      3175444953u,      2898100178u,      4290541487u },
            {       246118669u,      3175444953u,      3410622769u }
        },
        {
            {       284442065u,      4064194676u,      2295560707u },
            {      4182706556u,       284442065u,      3696899246u },
            {      1201342255u,      4182706556u,      1145356382u }
        },
        {
            {       656615546u,       442908965u,      3724738272u },
            {      1624967553u,       656615546u,       798014134u },
            {      1157949454u,      1624967553u,       496247378u }
        },
        {
            {       265689579u,       675056541u,      3009083380u },
            {      3820679930u,       265689579u,      2961990151u },
            {       562287964u,      3820679930u,      1853486796u }
        },
        {
            {      1675739167u,      2319843005u,       760605578u },
            {      4161492847u,      1675739167u,       226142150u },
            {      1017447188u,      4161492847u,      3431158427u }
        },
        {
            {      1759873736u,      2334568602u,      2154570180u },
            {      1812793060u,      1759873736u,      2111094408u },
            {      1168460586u,      1812793060u,      2495653141u }
        },
        {
            {       317621194u,       868104288u,       664971082u },
            {      2340275074u,       317621194u,      2168960688u },
            {       725706104u,      2340275074u,      3532023115u }
        },
        {
            {      3926931954u,      2907684453u,       615601328u },
            {      1132340715u,      3926931954u,       676995757u },
            {      1154819290u,      1132340715u,      1662727700u }
        },
        {
            {      3921782078u,      3376494857u,      2969567377u },
            {       475345024u,      3921782078u,      4206379953u },
            {      1795936544u,       475345024u,       934679595u }
        },
        {
            {      3119292228u,       741613041u,      2083352304u },
            {      1047885963u,      3119292228u,      1581078542u },
            {      1065969969u,      1047885963u,       661718928u }
        },
        {
            {      3643472111u,      2870554228u,      3995474529u },
            {      3804264051u,      3643472111u,      1366457944u },
            {      1246805564u,      3804264051u,       993186530u }
        },
        {
            {       796711791u,      3878204845u,      3160293932u },
            {       255632881u,       796711791u,      3778927111u },
            {      3472564181u,       255632881u,       388382377u }
        },
        {
            {      1776984101u,      1742284034u,      3449763933u },
            {      1349354417u,      1776984101u,      1264780832u },
            {       715722511u,      1349354417u,      1213319489u }
        },
        {
            {      4261866865u,      1914382786u,       201872335u },
            {       614207188u,      4261866865u,      1853554849u },
            {      2046042882u,       614207188u,      3193186353u }
        },
        {
            {      2210205512u,      2847073169u,      3324925707u },
            {      1251969297u,      2210205512u,      3491451503u },
            {       470400916u,      1251969297u,      2184392547u }
        },
        {
            {      1523590942u,      2391111113u,        68341529u },
            {       295466806u,      1523590942u,      4143310876u },
            {      3527253079u,       295466806u,      4059123142u }
        },
        {
            {      1406902110u,      3735012720u,      1774518130u },
            {      1814959027u,      1406902110u,      1560544267u },
            {       346472965u,      1814959027u,       964257199u }
        },
        {
            {       855309653u,      4208503105u,      1518467541u },
            {      2025248418u,       855309653u,      4148125749u },
            {      1349947330u,      2025248418u,      1168504873u }
        },
        {
            {      2375338156u,      3629519168u,       409696181u },
            {       252401654u,      2375338156u,      3992097193u },
            {      2793725401u,       252401654u,      1350184085u }
        },
        {
            {       873141039u,      3885583138u,       361604799u },
            {      3554143374u,       873141039u,       894746180u },
            {      1919765327u,      3554143374u,       876210854u }
        },
        {
            {       246368794u,      1703793169u,      2317362874u },
            {      2300930144u,       246368794u,      2560214589u },
            {      2016163623u,      2300930144u,      1504276775u }
        },
        {
            {      1574610921u,      2147546631u,      4103450226u },
            {       107416526u,      1574610921u,      1773803959u },
            {      1402542742u,       107416526u,       550063800u }
        },
        {
            {       363388665u,       592194244u,      1746615522u },
            {      2637234667u,       363388665u,      4031408742u },
            {      2895130475u,      2637234667u,       296510335u }
        },
        {
            {      3997368560u,      3047771871u,      3178383826u },
            {      1160174754u,      3997368560u,      4027094919u },
            {      1234984211u,      1160174754u,      4226264344u }
        },
        {
            {      3303179301u,      4243968063u,      3235964171u },
            {      1776841674u,      3303179301u,      2867287469u },
            {      1500495759u,      1776841674u,      1708226553u }
        },
        {
            {      1482944153u,      3192311574u,       354466071u },
            {      3932773012u,      1482944153u,       389193591u },
            {      3350181058u,      3932773012u,      3398059015u }
        },
        {
            {       640968550u,      3226860971u,       922372912u },
            {      1254989667u,       640968550u,      2383815228u },
            {      2027371896u,      1254989667u,      2925300409u }
        },
        {
            {      2313146046u,      3910187183u,      1377591475u },
            {      1689291784u,      2313146046u,      4255405993u },
            {      1650609719u,      1689291784u,      1897624297u }
        },
        {
            {      3656310954u,       882924050u,      2702189958u },
            {      3185020283u,      3656310954u,      1923190496u },
            {      2449669145u,      3185020283u,      4235849984u }
        },
        {
            {       377232416u,      1498446142u,      4229103619u },
            {      3926377906u,       377232416u,       600268838u },
            {       511317726u,      3926377906u,       216160452u }
        },
        {
            {      1969399344u,      3273966859u,      4220943579u },
            {      3952111894u,      1969399344u,       575096961u },
            {      3815277103u,      3952111894u,       792177412u }
        },
        {
            {      2957238169u,      1410010554u,      1523740068u },
            {      3949237584u,      2957238169u,        74149658u },
            {      2564746147u,      3949237584u,      2557663578u }
        },
        {
            {      3377318569u,      1927835240u,      2556102508u },
            {      3022040116u,      3377318569u,      2549406364u },
            {      2387074241u,      3022040116u,      1477293711u }
        },
        {
            {       257306870u,      1748489735u,       547809226u },
            {      3708493374u,       257306870u,      4183546362u },
            {         4435502u,      3708493374u,      1607696753u }
        }
    };

#endif /* !defined(CURAND_MRG32K3A_MATRICES_H_) */
