/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import java.awt.event.ActionEvent;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class OptionArgument
extends AbstractArgument {
    private TreeMap<String, Entry> options = new TreeMap();

    public OptionArgument(AbstractTool abstractTool, String string, String string2) {
        super(abstractTool, string, string2, null);
    }

    public void addOption(Object object, Object object2) {
        this.options.put(object2.toString(), new Entry(object, object2));
    }

    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return this.options.get(this.value).getValue();
        }
        catch (Exception exception) {
            throw new InstantiationException(exception.getMessage());
        }
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer(super.getUsage());
        stringBuffer.append("    possible options:\n");
        for (Entry entry : this.options.values()) {
            stringBuffer.append("    - ");
            stringBuffer.append(entry.getValueToString());
            stringBuffer.append(": ");
            stringBuffer.append(entry.toString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[2];
        objectArray[0] = "Choose one of the following options:";
        JComboBox<Entry> jComboBox = new JComboBox<Entry>();
        for (Entry entry : this.options.values()) {
            jComboBox.addItem(entry);
        }
        objectArray[1] = jComboBox;
        int n = JOptionPane.showOptionDialog(this.tool.getInternalFrame(), objectArray, this.description, 2, 3, null, null, null);
        if (n == 0) {
            Entry entry;
            entry = (Entry)jComboBox.getSelectedItem();
            this.setValue(entry.getValueToString());
        }
    }

    public class Entry {
        private Object description;
        private Object value;

        public Entry(Object object) {
            this.value = object;
            this.description = object;
        }

        public Entry(Object object, Object object2) {
            this.description = object;
            this.value = object2;
        }

        public String toString() {
            return this.description.toString();
        }

        public String getValueToString() {
            return this.value.toString();
        }

        public Object getDescription() {
            return this.description;
        }

        public void setDescription(Object object) {
            this.description = object;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }
    }
}

