/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.common.device.ICudaDevice;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.core.ModuleParameters;
import com.nvidia.cuda.ide.build.project.AbstractCudaModule;
import com.nvidia.cuda.ide.build.project.Cubin;
import com.nvidia.cuda.ide.build.project.CudaProjectConfigurationImpl;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.devices.CudaDevice;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;

public final class DeclareCudaModulesProcess
extends ProcessRunner {
    private static final String ATTR_DEVICE_LINKER = "deviceLinker";
    private static final String ATTR_PHYSICAL_ARCH_MASK = "pmask";
    private static final String ATTR_VIRTUAL_ARCH_MASK = "vmask";
    private static final String PREFERENCE_DEVICE_LINKING = "newproject.device.linking";
    private static final String PREFERENCE_PHYSICAL_ARCH = "newproject.physical.arch";
    private static final String PREFERENCE_VIRTUAL_ARCH = "newproject.virtual.arch";

    public static int getDefaultPtxArchitectures() {
        return DeclareCudaModulesProcess.readArchs(PREFERENCE_VIRTUAL_ARCH);
    }

    public static int getDefaultSassArchitectures() {
        return DeclareCudaModulesProcess.readArchs(PREFERENCE_PHYSICAL_ARCH);
    }

    public static boolean getDeviceLinkerDefault() {
        return DeclareCudaModulesProcess.getPreferenceStore().getBoolean(PREFERENCE_DEVICE_LINKING);
    }

    private static IFile getFile(IProject project, String file) throws ProcessFailureException {
        IFile f = project.getFile((IPath)new Path(file));
        if (!f.isAccessible()) {
            throw new ProcessFailureException(String.format("File %s is not accessible", f.getFullPath().toOSString()));
        }
        return f;
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static void initializeNewProjectDefaults(IPreferenceStore store) {
        TreeSet<Architecture> parchitecture = new TreeSet<Architecture>();
        TreeSet<Architecture> varchitecture = new TreeSet<Architecture>();
        ICudaDevice[] devices = CudaDevice.getDevices((boolean)false, null);
        if (devices != null) {
            ICudaDevice[] iCudaDeviceArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                ICudaDevice device = iCudaDeviceArray[n2];
                Architecture arch1 = Architecture.get(device.getVersionMajor(), device.getVersionMinor());
                parchitecture.add(arch1);
                varchitecture.add(arch1.getVirtual());
                ++n2;
            }
        }
        int pMask = 0;
        int vMask = 0;
        if (!parchitecture.isEmpty()) {
            Architecture[] all = Architecture.all();
            int i = 0;
            while (i < all.length) {
                Architecture a = all[i];
                if (parchitecture.contains(a)) {
                    pMask |= a.getBit();
                }
                if (vMask == 0 && varchitecture.contains(a)) {
                    vMask = a.getBit();
                }
                ++i;
            }
        } else {
            pMask = vMask = Architecture.getDefaultArchitecture().getBit();
        }
        store.setDefault(PREFERENCE_PHYSICAL_ARCH, pMask);
        store.setDefault(PREFERENCE_VIRTUAL_ARCH, vMask);
        store.setDefault(PREFERENCE_DEVICE_LINKING, false);
    }

    public static void initializeTemplateParams(Map<String, String> data, int virtual, int physical, boolean deviceLink) {
        data.put(ATTR_VIRTUAL_ARCH_MASK, String.valueOf(virtual));
        data.put(ATTR_PHYSICAL_ARCH_MASK, String.valueOf(physical));
        data.put(ATTR_DEVICE_LINKER, String.valueOf(deviceLink));
    }

    private static int readArchs(String preference) {
        return DeclareCudaModulesProcess.getPreferenceStore().getInt(preference);
    }

    public static void savePreferences(Integer virtual, Integer physical, Boolean linkerValue) {
        IPreferenceStore preferenceStore = DeclareCudaModulesProcess.getPreferenceStore();
        if (virtual != null) {
            preferenceStore.setValue(PREFERENCE_VIRTUAL_ARCH, virtual.intValue());
        }
        if (physical != null) {
            preferenceStore.setValue(PREFERENCE_PHYSICAL_ARCH, physical.intValue());
        }
        if (linkerValue != null) {
            preferenceStore.setValue(PREFERENCE_DEVICE_LINKING, linkerValue.booleanValue());
        }
    }

    private AbstractCudaModule getModule(CudaProjectConfigurationImpl cuda, ModuleParameters parameters) {
        if (parameters.path != null) {
            Cubin module = cuda.newModule(parameters.path);
            module.setType(ICudaModule.Type.fatbin);
            return module;
        }
        return cuda.getExecutable();
    }

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = null;
        String[] excluded = new String[]{};
        LinkedList<ModuleParameters> modules = new LinkedList<ModuleParameters>();
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            ProcessArgument[][] processArgumentArray2;
            ProcessArgument[][] value;
            ProcessArgument arg = processArgumentArray[n2];
            if ("projectName".equals(arg.getName())) {
                projectName = arg.getSimpleValue();
            } else if ("modules".equals(arg.getName())) {
                processArgumentArray2 = value = arg.getComplexArrayValue();
                n4 = value.length;
                n3 = 0;
                while (n3 < n4) {
                    ProcessArgument[] processArguments = processArgumentArray2[n3];
                    modules.add(this.readModuleParameters(processArguments));
                    ++n3;
                }
            } else if ("executable".equals(arg.getName())) {
                processArgumentArray2 = value = arg.getComplexValue();
                n4 = value.length;
                n3 = 0;
                while (n3 < n4) {
                    ProcessArgument[] processArgument = processArgumentArray2[n3];
                    if ("excluded".equals(processArgument.getName())) {
                        excluded = processArgument.getSimpleArrayValue();
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.isAccessible()) {
            throw new ProcessFailureException(String.format("Project %s is not accessible", project.getName()));
        }
        this.setupProject(project, modules, excluded);
    }

    private ModuleParameters readModuleParameters(ProcessArgument[] arg) throws ProcessFailureException {
        Path path = null;
        int phys = 0;
        int virt = 0;
        boolean deviceLinker = false;
        String[] files = new String[]{};
        ProcessArgument[] processArgumentArray = arg;
        int n = arg.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument processArgument = processArgumentArray[n2];
            if ("name".equals(processArgument.getName())) {
                if (processArgument.getSimpleValue().trim().length() > 0) {
                    path = new Path(processArgument.getSimpleValue());
                }
            } else if ("files".equals(processArgument.getName())) {
                files = processArgument.getSimpleArrayValue();
            } else if ("physical-mask".equals(processArgument.getName())) {
                phys = Integer.parseInt(processArgument.getSimpleValue());
            } else if ("virtual-mask".equals(processArgument.getName())) {
                virt = Integer.parseInt(processArgument.getSimpleValue());
            } else if ("device-linker".equals(processArgument.getName())) {
                deviceLinker = Boolean.parseBoolean(processArgument.getSimpleValue());
            }
            ++n2;
        }
        return new ModuleParameters((IPath)path, phys, virt, deviceLinker, files);
    }

    private void setupProject(IProject project, Collection<ModuleParameters> modules, String[] excluded) throws ProcessFailureException {
        try {
            ICConfigurationDescription[] configurations;
            ICProjectDescription projectDescription = CCorePlugin.getDefault().getProjectDescription(project);
            projectDescription.setReadOnly(false, true);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configurations = projectDescription.getConfigurations();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription configuration = iCConfigurationDescriptionArray[n2];
                CudaProjectConfigurationImpl cuda = new CudaProjectConfigurationImpl(configuration);
                cuda.reload();
                for (ModuleParameters moduleData : modules) {
                    AbstractCudaModule module = this.getModule(cuda, moduleData);
                    module.setPhysicalArchitectures(moduleData.phys);
                    module.setVirtualArchitectures(moduleData.virts);
                    module.setDeviceLinkerEnabled(moduleData.deviceLinker);
                    String[] stringArray = moduleData.files;
                    int n3 = moduleData.files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String file = stringArray[n4];
                        module.include(DeclareCudaModulesProcess.getFile(project, file));
                        ++n4;
                    }
                }
                String[] stringArray = excluded;
                int n5 = excluded.length;
                int n6 = 0;
                while (n6 < n5) {
                    String file = stringArray[n6];
                    IFile f = DeclareCudaModulesProcess.getFile(project, file);
                    cuda.getExecutable().exclude(f);
                    ++n6;
                }
                ++n2;
            }
            CCorePlugin.getDefault().setProjectDescription(project, projectDescription);
        }
        catch (CoreException e) {
            throw new ProcessFailureException((Throwable)e);
        }
    }

    static interface A<E extends Exception> {
        public int dostuff() throws E;
    }
}

