/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.cuda.ide.build.project.AbstractCudaModule;
import com.nvidia.cuda.ide.build.project.CudaExecutable;
import com.nvidia.cuda.ide.build.project.CudaProjectConfigurationImpl;
import com.nvidia.cuda.ide.build.project.ICubinModule;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class Cubin
extends AbstractCudaModule
implements ICubinModule {
    private static final String ATTR_ID = "id";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_TYPE = "type";
    private final ICStorageElement element;

    public Cubin(CudaProjectConfigurationImpl projectConfiguration, ICStorageElement element) {
        super(projectConfiguration);
        this.element = element;
    }

    public Cubin(CudaProjectConfigurationImpl projectConfiguration, String moduleId, ICStorageElement element) {
        this(projectConfiguration, element);
        element.setAttribute(ATTR_ID, String.valueOf(moduleId));
    }

    private void changeModuleList(int id, IFile file, boolean add) throws CoreException {
        ICResourceDescription description = CudaProjectUtil.getFileDescription((IResource)file, this.projectConfiguration.getConfigurationDescription());
        TreeSet modules = CudaProjectUtil.getCompilerOptionValue(description, "nvcc.compiler.modules");
        if (modules == null) {
            modules = new TreeSet();
        }
        if (modules instanceof Collection) {
            boolean changed;
            Collection collection = modules;
            if (add) {
                description.setExcluded(false);
                changed = true;
                collection.add(String.valueOf(id));
                this.projectConfiguration.getModuleFiles(this.getId()).add(file);
            } else {
                changed = collection.remove(String.valueOf(id));
                this.projectConfiguration.getModuleFiles(this.getId()).remove(file);
            }
            if (changed) {
                String[] value = collection.toArray(new String[collection.size()]);
                CudaProjectUtil.setCompilerOptionValue(description, "nvcc.compiler.modules", value);
                CudaExecutable executable = this.projectConfiguration.getExecutable();
                if (executable.includes(file)) {
                    executable.include(file);
                } else {
                    executable.exclude(file);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ICubinModule)) {
            return false;
        }
        ICubinModule other = (ICubinModule)obj;
        return this.getPath().equals((Object)other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode() * 31;
    }

    @Override
    public void exclude(IFile file) throws CoreException {
        this.changeModuleList(this.getId(), file, false);
        this.firePropertyChanged("files");
    }

    @Override
    protected ICStorageElement getElement(boolean create) {
        return this.element;
    }

    @Override
    public IFile[] getFiles() {
        Collection<IFile> files = this.projectConfiguration.getModuleFiles(this.getId());
        return files != null ? files.toArray(new IFile[files.size()]) : new IFile[]{};
    }

    public final int getId() {
        ICStorageElement el = this.getElement(false);
        return el != null ? Integer.valueOf(el.getAttribute(ATTR_ID)) : -1;
    }

    @Override
    public IPath getPath() {
        ICStorageElement el = this.getElement(false);
        return el != null ? Path.fromPortableString((String)el.getAttribute(ATTR_PATH)) : new Path("");
    }

    @Override
    public ICudaModule.Type getType() {
        ICStorageElement el = this.getElement(false);
        if (el == null || !el.hasAttribute(ATTR_TYPE)) {
            return ICudaModule.Type.fatbin;
        }
        return ICudaModule.Type.valueOf(el.getAttribute(ATTR_TYPE));
    }

    @Override
    public void include(IFile file) throws CoreException {
        boolean done = false;
        if (!this.isDeviceLinkingEnabled()) {
            IFile[] files;
            IFile[] iFileArray = files = this.getFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (!file.equals((Object)f)) {
                    this.exclude(f);
                } else {
                    done = true;
                }
                ++n2;
            }
        }
        if (!done) {
            this.changeModuleList(this.getId(), file, true);
        }
    }

    @Override
    public boolean includes(IFile file) {
        IFile[] files;
        IFile[] iFileArray = files = this.getFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile f = iFileArray[n2];
            if (f.equals((Object)file)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void remove() throws CoreException {
        IFile[] f;
        int id = this.getId();
        IFile[] iFileArray = f = this.getFiles();
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            this.changeModuleList(id, file, false);
            ++n2;
        }
        ICStorageElement el = this.getElement(false);
        if (el != null) {
            el.getParent().removeChild(el);
        }
        this.projectConfiguration.fireModuleRemoved(this);
    }

    public void setPath(IPath path) {
        this.getElement(true).setAttribute(ATTR_PATH, path.toPortableString());
        this.firePropertyChanged(ATTR_PATH);
    }

    public void setType(ICudaModule.Type type) {
        this.getElement(true).setAttribute(ATTR_TYPE, type.name());
        this.firePropertyChanged(ATTR_TYPE);
    }

    public String toString() {
        return this.getPath().toOSString();
    }
}

