/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelOccupancy;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.DataGridAndLabelSVG;
import com.nvidia.viper.ui.analysis.KernelOccupancyDataGrid;
import com.nvidia.viper.ui.analysis.OccupancyDataTablePainter;
import com.nvidia.viper.ui.analysis.SVGGraphics2DUtils;
import org.apache.batik.svggen.SVGGraphics2D;

public class KernelOccupancyResultSVG
extends DataGridAndLabelSVG {
    private DataGrid headerTable;
    private DataGrid tableRegisters;
    private DataGrid tableSharedMemory;
    private DataGrid tableSM;
    private DataGrid tableWarps;
    private final AnalysisResult result;
    private boolean initialized = false;

    public KernelOccupancyResultSVG(AnalysisResult result) {
        this.result = result;
    }

    @Override
    protected void initTables(SVGGraphics2D svg2d) {
        if (!this.initialized) {
            double avgWidth = SVGGraphics2DUtils.getAvgFontWidth(svg2d);
            int charWidth = (int)avgWidth;
            this.headerTable = this.setupTable(charWidth);
            this.components.add(this.headerTable);
            this.headerTable.setHeader(true);
            this.tableSM = this.createDataTable("Occupancy Per SM", charWidth);
            this.tableWarps = this.createDataTable("Warps", charWidth);
            this.tableRegisters = this.createDataTable("Registers", charWidth);
            this.tableSharedMemory = this.createDataTable("Shared Memory", charWidth);
            this.fillData(this.getResult().getKernel(), this.getResult().getAchievedOccupancy(), this.getResult().getOccupancyCalculator());
            this.initialized = true;
        }
    }

    private AnalysisResultKernelOccupancy getResult() {
        return (AnalysisResultKernelOccupancy)this.result;
    }

    private DataGrid createDataTable(String label, int charWidth) {
        this.components.add(label);
        DataGrid table = this.setupTable(charWidth);
        this.components.add(table);
        return table;
    }

    public void fillData(TimelineIntervalKernel kernel, double achievedOccupancy, OccupancyCalculator calculator) {
        this.headerTable.clear();
        this.headerTable.addRow("Variable", "Achieved", "Theoretical", "Device Limit", KernelOccupancyDataGrid.kernelInfoString(this.getResult().getKernel()));
        KernelOccupancyDataGrid.fillSMTable(this.tableSM, kernel, achievedOccupancy, calculator);
        KernelOccupancyDataGrid.fillWarpsTable(this.tableWarps, kernel, calculator, calculator.getLimiter() == OccupancyCalculator.Limiter.BLOCK);
        KernelOccupancyDataGrid.fillRegistersTable(this.tableRegisters, kernel, calculator, calculator.getLimiter() == OccupancyCalculator.Limiter.REGISTER);
        KernelOccupancyDataGrid.fillSharedMemoryTable(this.tableSharedMemory, kernel, calculator, calculator.getLimiter() == OccupancyCalculator.Limiter.SHARED_MEMORY);
    }

    private DataGrid setupTable(int charWidth) {
        DataGrid table = new DataGrid(new OccupancyDataTablePainter());
        table.addColumn(charWidth * 24, 16384);
        table.addColumn(charWidth * 14, 0x1000000);
        table.addColumn(charWidth * 14, 0x1000000);
        table.addColumn(charWidth * 14, 0x1000000);
        return table;
    }
}

