/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViewUtils;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.ViperMessageDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NvprofMessageDialog
extends ViperMessageDialog {
    private static Button doNotShowAgain;

    private NvprofMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    protected Control createCustomArea(Composite parent) {
        doNotShowAgain = new Button(parent, 32);
        doNotShowAgain.setText(ViperMessages.Remember_Choice_Message);
        doNotShowAgain.setSelection(false);
        return doNotShowAgain;
    }

    public static boolean openWarning(Session session) {
        NvprofMessageDialog messageDialog;
        int returnCode;
        if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
            ViperRunMode.recordDialogOpen(2, ViperMessages.Nvprof_Warning_Title);
            System.out.println(String.valueOf(ViperMessages.Nvprof_Warning_Message) + " OK");
            return true;
        }
        String doNotShow = Activator.getDefault().getPreferenceStore().getString("ShowNvprofWarningInfo");
        return NvprofMessageDialog.isWarningInConsole(session) && (doNotShow.equals("Prompt") ? (returnCode = (messageDialog = new NvprofMessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), ViperMessages.Nvprof_Warning_Title, null, ViperMessages.Nvprof_Warning_Message, 2, new String[]{IDialogConstants.OK_LABEL, "Show Console"}, 0)).open()) == 1 : doNotShow.equals("Always"));
    }

    private static boolean isWarningInConsole(Session session) {
        try {
            Executable exe = session != null ? session.getExecutable() : null;
            String conName = exe != null ? exe.getConnectionName() : null;
            FileSystem fileSystem = FileSystem.getFilesystem(conName);
            return fileSystem.readAndResetNvprofWarningStatus();
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            return false;
        }
    }

    public boolean close() {
        int returnCode = this.getReturnCode();
        if (returnCode == 1) {
            ViewUtils.showConsoleInDisplayThread();
        }
        if (doNotShowAgain.getSelection()) {
            String preference = null;
            switch (returnCode) {
                case 0: {
                    preference = "Never";
                    break;
                }
                case 1: {
                    preference = "Always";
                    break;
                }
            }
            if (preference != null) {
                Activator.getDefault().getPreferenceStore().setValue("ShowNvprofWarningInfo", preference);
            }
        }
        return super.close();
    }
}

