/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultMemoryStat;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import java.util.ArrayList;
import java.util.List;

public class KernelInstanceMemoryStatAnalysis
extends AnalysisBase {
    public static final String[] MEMORY_CHART_METRICS = new String[]{"inst_executed_tex_ops", "inst_executed_local_loads", "inst_executed_local_stores", "inst_executed_global_loads", "inst_executed_global_stores", "inst_executed_global_atomics", "inst_executed_global_reductions", "inst_executed_shared_loads", "inst_executed_shared_stores", "inst_executed_shared_atomics", "inst_executed_surface_loads", "inst_executed_surface_stores", "inst_executed_surface_atomics", "inst_executed_surface_reductions", "local_load_requests", "local_store_requests", "global_load_requests", "global_atomic_requests", "global_store_requests", "global_reduction_requests", "shared_load_transactions", "shared_store_transactions", "l2_global_atomic_store_bytes", "l2_global_load_bytes", "l2_local_load_bytes", "l2_surface_load_bytes", "l2_surface_atomic_store_bytes", "l2_global_reduction_bytes", "l2_local_global_store_bytes", "l2_surface_store_bytes", "l2_surface_reduction_bytes", "dram_read_bytes", "dram_write_bytes", "surface_load_requests", "surface_atomic_requests", "surface_store_requests", "surface_reduction_requests", "tex_cache_hit_rate", "l2_tex_hit_rate", "sysmem_read_bytes", "sysmem_write_bytes", "texture_load_requests"};

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        Analysis analysis = session.getAnalysis();
        if (analysis != null) {
            TimelineIntervalKernel interval = AnalysisStage.getHostLaunchedKernel(analysis.getActiveScopeInterval());
            if (interval == null || generateAllResults) {
                results.add(new AnalysisResult(AnalysisDescriptor.MEMORY_STAT_NO_DATA));
            }
            if (interval instanceof TimelineIntervalKernel) {
                TimelineIntervalKernel kernel = interval;
                ArrayList<Number> metricValue = new ArrayList<Number>();
                int i = 0;
                while (i < MEMORY_CHART_METRICS.length) {
                    Number value = KernelInstanceMemoryStatAnalysis.getAggregateMetricValue(kernel, MEMORY_CHART_METRICS[i]);
                    if (value != null) {
                        metricValue.add(value);
                    }
                    ++i;
                }
                if (metricValue.size() == 0) {
                    results.add(new AnalysisResult(AnalysisDescriptor.MEMORY_STAT_NO_DATA));
                } else {
                    results.add(new AnalysisResultMemoryStat(session, kernel, AnalysisDescriptor.MEMORY_STAT));
                    ret = true;
                }
            }
        }
        return ret;
    }
}

