/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.KernelOccupancyChartsGraphicFactory;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.Collections;
import java.util.List;

public class AnalysisResultOccupancyCharts
extends AnalysisResult {
    private final OccupancyCalculator calculator;
    private final TimelineIntervalKernel kernel;

    public AnalysisResultOccupancyCharts(TimelineIntervalKernel kernel, OccupancyCalculator calculator) {
        super(AnalysisDescriptor.KERNEL_OCCUPANCY_CHARTS);
        this.kernel = kernel;
        this.calculator = calculator;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        return Collections.singletonList(new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel));
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelOccupancyChartsGraphicFactory();
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public OccupancyCalculator getOccupancyCalculator() {
        return this.calculator;
    }

    @Override
    public String getLabel(ResultOutput otpt) {
        if (ResultOutput.REPORT.equals((Object)otpt)) {
            return ViperMessages.KernelLatency_Occupancy_Charts_Report_Label;
        }
        return super.getLabel(otpt);
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        if (ResultOutput.REPORT.equals((Object)otpt)) {
            return ViperMessages.KernelLatency_Occupancy_Charts_Report_Desc;
        }
        return super.getDescription(otpt);
    }
}

