/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiOpenAccConstructKind;
import com.nvidia.viper.activity.CuptiOpenAccEventKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;

public class CuptiActivityOpenAcc
extends CuptiActivityBase
implements ICuptiActivity {
    public int eventKind;
    public int parentConstruct;
    public int version;
    public int implicit;
    public int deviceType;
    public int deviceNumber;
    public int threadId;
    public long async;
    public long asyncMap;
    public int lineNo;
    public int endLineNo;
    public int funcLineNo;
    public int funcEndLineNo;
    public long start;
    public long end;
    public int cuDeviceId;
    public int cuContextId;
    public int cuStreamId;
    public int cuProcessId;
    public int cuThreadId;
    public int externalId;
    public String srcFile;
    public String funcName;
    public long bytes;
    public long hostPtr;
    public long devicePtr;
    public String varName;
    public long numGangs;
    public long numWorkers;
    public long vectorLength;
    public String kernelName;
    public Set<Integer> correlations;

    public CuptiActivityOpenAcc() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
        this.start = 0L;
        this.end = 0L;
        this.externalId = 0;
        this.bytes = 0L;
        this.hostPtr = 0L;
        this.devicePtr = 0L;
        this.varName = null;
        this.numGangs = 0L;
        this.numWorkers = 0L;
        this.vectorLength = 0L;
        this.kernelName = null;
        this.correlations = new HashSet<Integer>();
    }

    public CuptiActivityOpenAcc(CuptiActivityKind kind, int eventKind, int parentConstruct, int version, int implicit, int deviceType, int deviceNumber, int threadId, long async, long asyncMap, int lineNo, int endLineNo, int funcLineNo, int funcEndLineNo, long start, long end, int cuDeviceId, int cuContextId, int cuStreamId, int cuProcessId, int cuThreadId, String srcFile, String funcName, int externalId) {
        this.kind = kind.getCode();
        this.eventKind = eventKind;
        this.parentConstruct = parentConstruct;
        this.version = version;
        this.implicit = implicit;
        this.deviceType = deviceType;
        this.deviceNumber = deviceNumber;
        this.threadId = threadId;
        this.async = async;
        this.asyncMap = asyncMap;
        this.lineNo = lineNo;
        this.endLineNo = endLineNo;
        this.funcLineNo = funcLineNo;
        this.funcEndLineNo = funcEndLineNo;
        this.start = start;
        this.end = end;
        this.cuDeviceId = cuDeviceId;
        this.cuContextId = cuContextId;
        this.cuStreamId = cuStreamId;
        this.cuProcessId = cuProcessId;
        this.cuThreadId = cuThreadId;
        this.srcFile = srcFile;
        this.funcName = funcName;
        this.externalId = externalId;
        this.correlations = new HashSet<Integer>();
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.start > 0L && this.end > 0L && this.start < this.end;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }

    public static String getCuptiEventName(CuptiOpenAccEventKind event) {
        switch (event) {
            case CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT: {
                return "acc_device_init";
            }
            case CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN: {
                return "acc_device_shutdown";
            }
            case CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN: {
                return "acc_runtime_shutdown";
            }
            case CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH: {
                return "acc_enqueue_launch";
            }
            case CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD: {
                return "acc_enqueue_upload";
            }
            case CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD: {
                return "acc_enqueue_download";
            }
            case CUPTI_OPENACC_EVENT_KIND_WAIT: {
                return "acc_wait";
            }
            case CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT: {
                return "acc_implicit_wait";
            }
            case CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT: {
                return "acc_compute_construct";
            }
            case CUPTI_OPENACC_EVENT_KIND_UPDATE: {
                return "acc_update";
            }
            case CUPTI_OPENACC_EVENT_KIND_ENTER_DATA: {
                return "acc_enter_data";
            }
            case CUPTI_OPENACC_EVENT_KIND_EXIT_DATA: {
                return "acc_exit_data";
            }
            case CUPTI_OPENACC_EVENT_KIND_CREATE: {
                return "acc_create";
            }
            case CUPTI_OPENACC_EVENT_KIND_DELETE: {
                return "acc_delete";
            }
            case CUPTI_OPENACC_EVENT_KIND_ALLOC: {
                return "acc_alloc";
            }
            case CUPTI_OPENACC_EVENT_KIND_FREE: {
                return "acc_free";
            }
        }
        return "<unknown>";
    }

    public static String getCuptiConstructName(CuptiOpenAccConstructKind construct) {
        switch (construct) {
            case CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN: {
                return "unknown";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL: {
                return "parallel";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS: {
                return "kernels";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_LOOP: {
                return "loop";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_DATA: {
                return "data";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA: {
                return "enter data";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA: {
                return "exit data";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA: {
                return "host data";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC: {
                return "atomic";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE: {
                return "declare";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_INIT: {
                return "init";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN: {
                return "shutdown";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_SET: {
                return "set";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE: {
                return "update";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE: {
                return "routine";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_WAIT: {
                return "wait";
            }
            case CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API: {
                return "runtime api";
            }
        }
        return "<unknown>";
    }

    public static String getOpenAccDeviceTypeName(int deviceType) {
        switch (deviceType) {
            case 0: {
                return "none";
            }
            case 1: {
                return "acc_device_default";
            }
            case 2: {
                return "acc_device_host";
            }
            case 3: {
                return "acc_device_not_host";
            }
            case 4: {
                return "acc_device_nvidia";
            }
            case 5: {
                return "acc_device_radeon";
            }
            case 6: {
                return "acc_device_xeonphi";
            }
            case 7: {
                return "acc_device_pgi_opencl";
            }
            case 8: {
                return "acc_device_nvidia_opencl";
            }
            case 9: {
                return "acc_device_opencl";
            }
        }
        return "<unknown>";
    }

    public String getName() {
        String name = CuptiActivityOpenAcc.getCuptiEventName(CuptiOpenAccEventKind.valueOf(this.eventKind));
        if (this.srcFile != null) {
            String fileName = Paths.get(this.srcFile, new String[0]).getFileName().toString();
            name = String.valueOf(name) + "@" + fileName;
            if (this.lineNo != 0) {
                name = String.valueOf(name) + ":" + this.lineNo;
            }
        }
        return name;
    }

    public boolean isOpenAccData() {
        return this.kind == CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_DATA.getCode();
    }

    public boolean isOpenAccLaunch() {
        return this.kind == CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH.getCode();
    }

    public boolean isOpenAccOther() {
        return this.kind == CuptiActivityKind.CUPTI_ACTIVITY_KIND_OPENACC_OTHER.getCode();
    }

    public String getRelativePath() {
        return FileUtils.getRelativePath(this.srcFile);
    }
}

