/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.CherryPickOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.handler.SelectionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CherryPickHandler
extends SelectionHandler {
    public static final String ID = "org.eclipse.egit.ui.commit.CherryPick";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RevCommit commit = this.getSelectedItem(RevCommit.class, event);
        if (commit == null) {
            return null;
        }
        Repository repo = this.getSelectedItem(Repository.class, event);
        if (repo == null) {
            return null;
        }
        final Shell parent = this.getPart(event).getSite().getShell();
        if (!this.confirmCherryPick(parent, repo, commit)) {
            return null;
        }
        final CherryPickOperation op = new CherryPickOperation(repo, commit);
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(UIText.CherryPickHandler_JobName, commit.name())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                    CherryPickResult cherryPickResult = op.getResult();
                    RevCommit newHead = cherryPickResult.getNewHead();
                    if (newHead != null && cherryPickResult.getCherryPickedRefs().isEmpty()) {
                        CherryPickHandler.this.showNotPerformedDialog(parent);
                    }
                    if (newHead == null) {
                        CherryPickResult.CherryPickStatus status = cherryPickResult.getStatus();
                        switch (status) {
                            case CONFLICTING: {
                                CherryPickHandler.this.showConflictDialog(parent);
                                break;
                            }
                            case FAILED: {
                                CherryPickHandler.this.showFailure(cherryPickResult);
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.logError(UIText.CherryPickOperation_InternalError, e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.CHERRY_PICK.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }

    private boolean confirmCherryPick(final Shell shell, Repository repository, RevCommit commit) throws ExecutionException {
        String message;
        final AtomicBoolean confirmed = new AtomicBoolean(false);
        try {
            message = MessageFormat.format(UIText.CherryPickHandler_ConfirmMessage, commit.abbreviate(7).name(), repository.getBranch());
        }
        catch (IOException e) {
            throw new ExecutionException("Exception obtaining current repository branch", (Throwable)e);
        }
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                confirmed.set(MessageDialog.openConfirm((Shell)shell, (String)UIText.CherryPickHandler_ConfirmTitle, (String)message));
            }
        });
        return confirmed.get();
    }

    private void showNotPerformedDialog(final Shell shell) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)UIText.CherryPickHandler_NoCherryPickPerformedTitle, (String)UIText.CherryPickHandler_NoCherryPickPerformedMessage);
            }
        });
    }

    private void showConflictDialog(final Shell shell) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)UIText.CherryPickHandler_CherryPickConflictsTitle, (String)UIText.CherryPickHandler_CherryPickConflictsMessage);
            }
        });
    }

    private void showFailure(CherryPickResult result) {
        IStatus details = this.getErrorList(result.getFailingPaths());
        Activator.showErrorStatus(UIText.CherryPickHandler_CherryPickFailedMessage, details);
    }

    private IStatus getErrorList(Map<String, ResolveMerger.MergeFailureReason> failingPaths) {
        MultiStatus result = new MultiStatus(Activator.getPluginId(), 4, UIText.CherryPickHandler_CherryPickFailedMessage, null);
        for (Map.Entry<String, ResolveMerger.MergeFailureReason> entry : failingPaths.entrySet()) {
            String path = entry.getKey();
            String reason = this.getReason(entry.getValue());
            String errorMessage = NLS.bind((String)UIText.CherryPickHandler_ErrorMsgTemplate, (Object)path, (Object)reason);
            result.add(Activator.createErrorStatus(errorMessage));
        }
        return result;
    }

    private String getReason(ResolveMerger.MergeFailureReason mergeFailureReason) {
        switch (mergeFailureReason) {
            case COULD_NOT_DELETE: {
                return UIText.CherryPickHandler_CouldNotDeleteFile;
            }
            case DIRTY_INDEX: {
                return UIText.CherryPickHandler_IndexDirty;
            }
            case DIRTY_WORKTREE: {
                return UIText.CherryPickHandler_WorktreeDirty;
            }
        }
        return UIText.CherryPickHandler_unknown;
    }
}

