/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisResultKernelInstructionClass;
import com.nvidia.viper.chart.ui.AxesConfiguration;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ViperChartSeries;
import java.util.LinkedList;
import java.util.List;

public final class KernelInstructionClassChart
implements IViperChart {
    private final AnalysisResultKernelInstructionClass result;

    public KernelInstructionClassChart(AnalysisResultKernelInstructionClass result) {
        this.result = result;
    }

    public ViperChartSeries[] getSeries() {
        long maxThreadExecCount = this.result.getTotalExecCount() * 32L;
        long usefulThreadExecCount = 0L;
        List<AnalysisResultKernelInstructionClass.InstructionClass> ics = this.result.getInstructionClasses();
        LinkedList<Double> values = new LinkedList<Double>();
        for (AnalysisResultKernelInstructionClass.InstructionClass ic : ics) {
            long icThreadExecCount = this.result.getInstructionClassExecCount(ic);
            usefulThreadExecCount += icThreadExecCount;
            values.add(100.0 * (double)icThreadExecCount / (double)maxThreadExecCount);
        }
        values.add(100.0 * (double)(maxThreadExecCount - usefulThreadExecCount) / (double)maxThreadExecCount);
        return new ViperChartSeries[]{new ViperChartSeries(values.toArray(new Double[0]), ViperChartSeries.Type.STACKED_BAR, "Execution Count")};
    }

    public String getTitle() {
        return null;
    }

    public boolean isHighlighted() {
        return false;
    }

    public boolean showLegend() {
        return false;
    }

    public int getHeight() {
        return 300;
    }

    public int getWidth() {
        return 1000;
    }

    public AxesConfiguration getAxesConfiguration() {
        return new AxesConfiguration(null, "Execution Count (% of total)", true, Integer.valueOf(100), Integer.valueOf(10), null, Integer.valueOf(10), true, new String[]{"10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%"}, false);
    }

    public String[] getLabels() {
        List<AnalysisResultKernelInstructionClass.InstructionClass> ics = this.result.getInstructionClasses();
        LinkedList<String> labels = new LinkedList<String>();
        for (AnalysisResultKernelInstructionClass.InstructionClass ic : ics) {
            labels.add(ic.toString());
        }
        labels.add(ViperMessages.KernelSM_InstClass_Inactive_Label);
        return labels.toArray(new String[0]);
    }

    public boolean colorBySeries() {
        return true;
    }
}

