/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.activity.CuptiActivityUvmAccessKind;
import com.nvidia.viper.activity.CuptiActivityUvmMigrationCause;
import com.nvidia.viper.activity.CuptiActivityUvmRemoteMapCause;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalUVM;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class UvmFilterChecksFamily
extends Composite {
    private Button parentCheck;
    private Button[] childChecks;
    private Map<Integer, Integer> children;
    private CLabel checkLabel;
    private UvmFilterCheckState uvmFilterCheckState;
    private TimelineIntervalKind kind;
    private int numChecked = 0;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$nvidia$viper$activity$CuptiActivityUvmAccessKind;

    public UvmFilterChecksFamily(Composite parent, int style, TimelineIntervalKind filterKind) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.kind = filterKind;
        this.checkLabel = new CLabel((Composite)this, 0);
        this.parentCheck = new Button((Composite)this, 32);
        this.children = new LinkedHashMap<Integer, Integer>();
        int childIndex = 0;
        CuptiActivityUvmMigrationCause unknownMigrationCause = CuptiActivityUvmMigrationCause.CUPTI_ACTIVITY_UVM_MIGRATION_CAUSE_UNKNOWN;
        switch (filterKind) {
            case UVM_PAGE_FAULT: {
                Enum uvmAccessKind;
                this.parentCheck.setText("CPU Page Faults");
                this.checkLabel.setText("Access Type:");
                Enum[] enumArray = CuptiActivityUvmAccessKind.values();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    uvmAccessKind = enumArray[n2];
                    switch (UvmFilterChecksFamily.$SWITCH_TABLE$com$nvidia$viper$activity$CuptiActivityUvmAccessKind()[uvmAccessKind.ordinal()]) {
                        case 2: 
                        case 3: {
                            this.children.put(((CuptiActivityUvmAccessKind)uvmAccessKind).getCode(), childIndex++);
                            break;
                        }
                    }
                    ++n2;
                }
                break;
            }
            case UVM_GPU_PAGE_FAULT: {
                Enum uvmAccessKind;
                this.parentCheck.setText("GPU Page Faults");
                this.checkLabel.setText("Access Type:");
                Enum[] enumArray = CuptiActivityUvmAccessKind.values();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    uvmAccessKind = enumArray[n2];
                    if (uvmAccessKind != CuptiActivityUvmAccessKind.CUPTI_ACTIVITY_UVM_ACCESS_KIND_UNKNOWN) {
                        this.children.put(((CuptiActivityUvmAccessKind)uvmAccessKind).getCode(), childIndex++);
                    }
                    ++n2;
                }
                break;
            }
            case UVM_MEMCPY_HTOD: {
                Enum migrationCause;
                this.parentCheck.setText("HtoD Migrations");
                this.checkLabel.setText("Reason:");
                Enum[] enumArray = CuptiActivityUvmMigrationCause.values();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    migrationCause = enumArray[n2];
                    if (migrationCause != unknownMigrationCause && migrationCause != CuptiActivityUvmMigrationCause.CUPTI_ACTIVITY_UVM_MIGRATION_CAUSE_ACCESS_COUNTERS) {
                        this.children.put(((CuptiActivityUvmMigrationCause)migrationCause).getCode(), childIndex++);
                    }
                    ++n2;
                }
                this.children.put(unknownMigrationCause.getCode(), childIndex++);
                break;
            }
            case UVM_MEMCPY_DTOH: {
                Enum migrationCause;
                this.parentCheck.setText("DtoH Migrations");
                this.checkLabel.setText("Reason:");
                Enum[] enumArray = CuptiActivityUvmMigrationCause.values();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    migrationCause = enumArray[n2];
                    if (migrationCause != unknownMigrationCause) {
                        this.children.put(((CuptiActivityUvmMigrationCause)migrationCause).getCode(), childIndex++);
                    }
                    ++n2;
                }
                this.children.put(unknownMigrationCause.getCode(), childIndex++);
                break;
            }
            case UVM_MEMCPY_DTOD: {
                Enum migrationCause;
                this.parentCheck.setText("DtoD Migrations");
                this.checkLabel.setText("Reason:");
                Enum[] enumArray = CuptiActivityUvmMigrationCause.values();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    migrationCause = enumArray[n2];
                    if (migrationCause != unknownMigrationCause) {
                        this.children.put(((CuptiActivityUvmMigrationCause)migrationCause).getCode(), childIndex++);
                    }
                    ++n2;
                }
                break;
            }
            case UVM_REMOTE_MAP: {
                this.parentCheck.setText("Remote Map");
                this.checkLabel.setText("Reason");
                Enum[] enumArray = CuptiActivityUvmRemoteMapCause.values();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Enum remoteMapCause = enumArray[n2];
                    if (remoteMapCause != CuptiActivityUvmRemoteMapCause.CUPTI_ACTIVITY_UVM_REMOTE_MAP_CAUSE_UNKNOWN) {
                        this.children.put(((CuptiActivityUvmRemoteMapCause)remoteMapCause).getCode(), childIndex++);
                    }
                    ++n2;
                }
                break;
            }
        }
        int numChildren = this.children.size();
        this.childChecks = new Button[numChildren];
        int i = 0;
        while (i < numChildren) {
            this.childChecks[i] = new Button((Composite)this, 32);
            this.childChecks[i].setSelection(true);
            ++i;
        }
        this.numChecked = numChildren;
        this.parentCheck.setSelection(true);
        this.addSelectionListner();
    }

    public void setState(UvmFilterCheckState state) {
        if (state == null) {
            this.uvmFilterCheckState = new UvmFilterCheckState();
            this.setEnabled(false);
        } else {
            this.uvmFilterCheckState = state;
            this.setEnabled(true);
            this.numChecked = 0;
            this.parentCheck.setSelection(state.parentCheckState);
            int i = 0;
            while (i < this.children.size()) {
                this.childChecks[i].setSelection(state.childChecksState[i]);
                if (state.childChecksState[i]) {
                    ++this.numChecked;
                }
                ++i;
            }
        }
    }

    public void setLayout(Control left) {
        int tabSpace = 110;
        int indentationSpace = 30;
        this.parentCheck.setLayoutData((Object)new FormData());
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.parentCheck, 4);
        int parentSize = this.parentCheck.computeSize((int)-1, (int)-1).x;
        layoutData.left = new FormAttachment((Control)this.parentCheck, indentationSpace - parentSize);
        this.checkLabel.setLayoutData((Object)layoutData);
        int i = 0;
        for (int child : this.children.keySet()) {
            switch (this.kind) {
                case UVM_PAGE_FAULT: 
                case UVM_GPU_PAGE_FAULT: {
                    this.childChecks[i].setText(CuptiActivityUvmAccessKind.valueOf(child).getName());
                    break;
                }
                case UVM_MEMCPY_HTOD: 
                case UVM_MEMCPY_DTOH: 
                case UVM_MEMCPY_DTOD: {
                    this.childChecks[i].setText(CuptiActivityUvmMigrationCause.valueOf(child).getName());
                    break;
                }
                case UVM_REMOTE_MAP: {
                    this.childChecks[i].setText(CuptiActivityUvmRemoteMapCause.valueOf(child).getName());
                    break;
                }
            }
            FormData formData = new FormData();
            if (i == 0) {
                int leftControlWidth = this.checkLabel.computeSize((int)-1, (int)-1).x;
                formData.left = new FormAttachment((Control)this.checkLabel, tabSpace - leftControlWidth);
            } else {
                int leftChildWidth = this.childChecks[i - 1].computeSize((int)-1, (int)-1).x;
                formData.left = new FormAttachment((Control)this.childChecks[i - 1], tabSpace - leftChildWidth);
            }
            formData.top = new FormAttachment((Control)this.parentCheck, 4);
            this.childChecks[i].setLayoutData((Object)formData);
            ++i;
        }
        this.setLayoutData(new GridData(1, 0x1000000, true, false));
    }

    private void addSelectionListner() {
        final int numChildren = this.children.size();
        this.parentCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UvmFilterChecksFamily.this.parentCheck.getSelection()) {
                    int i = 0;
                    while (i < numChildren) {
                        UvmFilterChecksFamily.this.childChecks[i].setSelection(true);
                        ++i;
                    }
                    UvmFilterChecksFamily.this.numChecked = numChildren;
                } else {
                    int i = 0;
                    while (i < numChildren) {
                        UvmFilterChecksFamily.this.childChecks[i].setSelection(false);
                        ++i;
                    }
                    UvmFilterChecksFamily.this.numChecked = 0;
                }
            }
        });
        int i = 0;
        while (i < numChildren) {
            this.addChildSelectionListner(this.childChecks[i]);
            ++i;
        }
    }

    private void addChildSelectionListner(final Button child) {
        child.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (child.getSelection()) {
                    UvmFilterChecksFamily.this.parentCheck.setSelection(true);
                    UvmFilterChecksFamily uvmFilterChecksFamily = UvmFilterChecksFamily.this;
                    uvmFilterChecksFamily.numChecked = uvmFilterChecksFamily.numChecked + 1;
                } else {
                    UvmFilterChecksFamily uvmFilterChecksFamily = UvmFilterChecksFamily.this;
                    uvmFilterChecksFamily.numChecked = uvmFilterChecksFamily.numChecked - 1;
                    if (UvmFilterChecksFamily.this.numChecked <= 0) {
                        UvmFilterChecksFamily.this.parentCheck.setSelection(false);
                    }
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.parentCheck.setEnabled(enabled);
        int i = 0;
        while (i < this.children.size()) {
            this.childChecks[i].setEnabled(enabled);
            ++i;
        }
    }

    public UvmFilterCheckState getState() {
        this.uvmFilterCheckState.parentCheckState = this.parentCheck.getSelection();
        this.uvmFilterCheckState.childChecksState = new boolean[this.children.size()];
        int i = 0;
        while (i < this.children.size()) {
            ((UvmFilterCheckState)this.uvmFilterCheckState).childChecksState[i] = this.childChecks[i].getSelection();
            ++i;
        }
        return this.uvmFilterCheckState;
    }

    public TimelineIntervalKind getKind() {
        return this.kind;
    }

    public List<Long> getFilteredIntervals(HashSet<ITimelineInterval> intervals, long startAddress, long endAddress) {
        this.uvmFilterCheckState.totalValue = 0L;
        this.uvmFilterCheckState.filteredAddresses = new HashSet();
        ArrayList<Long> filteredIntervalIds = new ArrayList<Long>();
        if (this.parentCheck.getSelection()) {
            for (ITimelineInterval interval : intervals) {
                int flag;
                TimelineIntervalUVM UVMInterval = (TimelineIntervalUVM)interval;
                if (this.kind == TimelineIntervalKind.UVM_REMOTE_MAP && UVMInterval.getKind() != TimelineIntervalKind.UVM_REMOTE_MAP || UVMInterval.getAddress() < startAddress || UVMInterval.getAddress() > endAddress || !this.children.containsKey(flag = UVMInterval.getFlags().intValue()) || !this.childChecks[this.children.get(flag)].getSelection()) continue;
                filteredIntervalIds.add(interval.getID());
                this.uvmFilterCheckState.filteredAddresses.add(UVMInterval.getAddress());
                switch (this.kind) {
                    case UVM_PAGE_FAULT: {
                        UvmFilterCheckState uvmFilterCheckState = this.uvmFilterCheckState;
                        uvmFilterCheckState.totalValue = uvmFilterCheckState.totalValue + 1L;
                        break;
                    }
                    case UVM_MEMCPY_HTOD: 
                    case UVM_MEMCPY_DTOH: 
                    case UVM_MEMCPY_DTOD: 
                    case UVM_GPU_PAGE_FAULT: 
                    case UVM_REMOTE_MAP: {
                        UvmFilterCheckState uvmFilterCheckState = this.uvmFilterCheckState;
                        uvmFilterCheckState.totalValue = uvmFilterCheckState.totalValue + UVMInterval.getCounterValue();
                    }
                }
            }
        }
        return filteredIntervalIds;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$nvidia$viper$activity$CuptiActivityUvmAccessKind() {
        if ($SWITCH_TABLE$com$nvidia$viper$activity$CuptiActivityUvmAccessKind != null) {
            return $SWITCH_TABLE$com$nvidia$viper$activity$CuptiActivityUvmAccessKind;
        }
        int[] nArray = new int[CuptiActivityUvmAccessKind.values().length];
        try {
            nArray[CuptiActivityUvmAccessKind.CUPTI_ACTIVITY_UVM_ACCESS_KIND_ATOMIC.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CuptiActivityUvmAccessKind.CUPTI_ACTIVITY_UVM_ACCESS_KIND_PREFETCH.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CuptiActivityUvmAccessKind.CUPTI_ACTIVITY_UVM_ACCESS_KIND_READ.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CuptiActivityUvmAccessKind.CUPTI_ACTIVITY_UVM_ACCESS_KIND_UNKNOWN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CuptiActivityUvmAccessKind.CUPTI_ACTIVITY_UVM_ACCESS_KIND_WRITE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$nvidia$viper$activity$CuptiActivityUvmAccessKind = nArray;
        return nArray;
    }

    public static class UvmFilterCheckState {
        private boolean parentCheckState;
        private boolean[] childChecksState;
        private Set<Long> filteredAddresses;
        private long totalValue;

        public long getTotalValue() {
            return this.totalValue;
        }

        public Set<Long> getFilteredAddresses() {
            return this.filteredAddresses;
        }
    }
}

