/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.jni.NativeRebel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import com.nvidia.viper.ui.analysis.AnalysisViewModeDelegate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class RebelReportModeDelegate
implements AnalysisViewModeDelegate {
    private final Group resultsGroup;
    private final ScrolledComposite scrolledResultsComposite;
    private final Composite resultsComposite;
    private long reportHandle = -1L;

    public RebelReportModeDelegate(Composite resultsParent) {
        this.resultsGroup = new Group(resultsParent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.resultsGroup.setLayout((Layout)gl);
        this.resultsGroup.setText("Results");
        this.scrolledResultsComposite = new ScrolledComposite((Composite)this.resultsGroup, 768);
        this.scrolledResultsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledResultsComposite.setExpandHorizontal(true);
        this.scrolledResultsComposite.setExpandVertical(true);
        this.resultsComposite = new Composite((Composite)this.scrolledResultsComposite, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 2;
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        this.resultsComposite.setLayout((Layout)gl);
        this.scrolledResultsComposite.setContent((Control)this.resultsComposite);
        this.resultsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    @Override
    public void activate() {
    }

    @Override
    public AnalysisViewMode getAssociatedMode() {
        return AnalysisViewMode.rebelreport;
    }

    @Override
    public Control getButtons() {
        return null;
    }

    @Override
    public Control getDetails() {
        return this.resultsGroup;
    }

    @Override
    public Control getOutline() {
        return null;
    }

    @Override
    public void handlePropertyChange(String propertyName) {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void setSession(Session session) {
        this.refreshAnalysisControl(session);
    }

    private long getEmbededHandle() {
        long embeddedHandle = 0L;
        try {
            Class<?> myClass = Class.forName("org.eclipse.swt.widgets.Composite");
            Class[] partypes = new Class[]{Composite.class, Integer.TYPE};
            Constructor<?> ct = myClass.getConstructor(partypes);
            Object[] arglist = new Object[]{this.resultsComposite, 0x1040000};
            Object obj = ct.newInstance(arglist);
            Composite host = (Composite)obj;
            if (host instanceof Composite) {
                GridData layoutData = new GridData(1808);
                host.setLayoutData((Object)layoutData);
                this.scrolledResultsComposite.setMinSize(this.resultsComposite.computeSize(-1, -1));
                host.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        NativeRebel.dispose(RebelReportModeDelegate.this.reportHandle);
                        RebelReportModeDelegate.this.reportHandle = -1L;
                        System.out.println("SWT disposed");
                    }
                });
            }
            Field field = myClass.getDeclaredField("embeddedHandle");
            embeddedHandle = (Long)field.get(obj);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchFieldException e1) {
            e1.printStackTrace();
        }
        return embeddedHandle;
    }

    private void refreshAnalysisControl(Session session) {
        String reportPath;
        Control[] controlArray = this.resultsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (session != null && this.reportHandle == -1L && (reportPath = session.getRebelReportPath()) != null) {
            long embeddedHandle = this.getEmbededHandle();
            if (embeddedHandle == 0L) {
                return;
            }
            String strHandle = Long.toString(embeddedHandle);
            this.reportHandle = NativeRebel.embedReport(reportPath, strHandle);
            this.resultsComposite.layout(true);
        }
    }
}

