/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.Activator;
import com.nvidia.viper.SessionEditorContributedContents;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.OpenManagePathsDialogAction;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.ContextManager;
import com.nvidia.viper.ui.IContextOwner;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.ViperMessageDialog;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import com.nvidia.viper.ui.analysis.AnalysisViewModeDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class AnalysisView
extends ViewPart
implements ISessionPropertyChangeListener,
IContextOwner {
    private Session activeSession;
    private OpenManagePathsDialogAction managePathsAction;
    private AnalysisViewModeDelegate[] modeDelegates;
    private AnalysisViewModeDelegate activeModeDelegate;
    private ActivePartListener asListener = new ActivePartListener();
    private PageBook outlinePageBook;
    private PageBook buttonsPageBook;
    private PageBook detailsPageBook;
    private ToolBar modesToolbar;

    public void createPartControl(Composite parent) {
        this.createControls(parent);
        this.createActions();
        this.createToolbar();
        this.refreshActions();
        this.handleNewActivePart((IWorkbenchPart)ContextManager.getSingleton().getActiveSessionEditor());
        ContextManager.getSingleton().addPossibleOwner(this);
        ViperHelp.setContextHelp((Control)parent, ViperHelp.ANALYSIS_VIEW_CONTEXT_ID);
    }

    private void createControls(Composite parent) {
        SashForm form = new SashForm(parent, 256);
        Composite leftPane = new Composite((Composite)form, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        leftPane.setLayout((Layout)layout);
        this.detailsPageBook = new PageBook((Composite)form, 0);
        form.setWeights(new int[]{25, 75});
        this.modesToolbar = new ToolBar(leftPane, 0x800000);
        GridData layoutData = new GridData(16);
        layoutData.heightHint = 10;
        new Label(leftPane, 514).setLayoutData((Object)layoutData);
        this.buttonsPageBook = new PageBook(leftPane, 0);
        GridData d2 = new GridData(768);
        d2.horizontalSpan = 3;
        new Label(leftPane, 258).setLayoutData((Object)d2);
        this.outlinePageBook = new PageBook(leftPane, 0);
        this.outlinePageBook.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.initModes();
        int width = Integer.MIN_VALUE;
        int height = Integer.MIN_VALUE;
        Control[] controlArray = this.buttonsPageBook.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            Point size = control.computeSize(-1, -1);
            width = Math.max(width, size.x);
            height = Math.max(height, size.y);
            ++n2;
        }
        GridData d = new GridData(68);
        d.heightHint = height;
        d.widthHint = width;
        this.buttonsPageBook.setLayoutData((Object)d);
    }

    private void initModes() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalysisView.this.activeSession != null && AnalysisView.this.activeSession.getAnalysis() != null) {
                    AnalysisViewModeDelegate delegate = (AnalysisViewModeDelegate)e.widget.getData();
                    AnalysisView.this.activeSession.getAnalysis().setCurrentAnalysisMode(delegate.getAssociatedMode());
                }
            }
        };
        int numModes = System.getenv("EMBED_REBEL") != null ? AnalysisViewMode.values().length : AnalysisViewMode.values().length - 1;
        this.modeDelegates = new AnalysisViewModeDelegate[numModes];
        int i = 0;
        while (i < this.modeDelegates.length) {
            AnalysisViewMode mode = AnalysisViewMode.values()[i];
            if (!AnalysisViewMode.rebelreport.equals((Object)mode) || System.getenv("EMBED_REBEL") != null) {
                this.modeDelegates[i] = mode.create((Composite)this.buttonsPageBook, (Composite)this.outlinePageBook, (Composite)this.detailsPageBook);
                ToolItem item = new ToolItem(this.modesToolbar, 16);
                item.setImage(mode.getIcon());
                item.setToolTipText(mode.getTitle());
                item.setData((Object)this.modeDelegates[i]);
                item.addSelectionListener((SelectionListener)listener);
            }
            ++i;
        }
        ToolItem showAnalyzedKernel = new ToolItem(this.modesToolbar, 0);
        showAnalyzedKernel.setImage(ViperImages.get("icons/en/select_prev.gif"));
        showAnalyzedKernel.setToolTipText(ViperMessages.Analyzed_Kernel_Select_Tooltip);
        showAnalyzedKernel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalysisView.this.activeSession != null) {
                    String title = null;
                    String message = null;
                    if (AnalysisView.this.activeSession.getExecutable() == null) {
                        title = ViperMessages.Analyzed_Kernel_Import_Title;
                        message = ViperMessages.Analyzed_Kernel_Import_Message;
                    } else if (!AnalysisView.this.activeSession.selectAnalyzedKernel()) {
                        title = ViperMessages.No_Analyzed_Kernel_Found_Title;
                        message = ViperMessages.No_Analyzed_Kernel_Found_Message;
                    }
                    if (title != null && message != null) {
                        ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message);
                    }
                }
            }
        });
        this.setMode(this.modeDelegates[AnalysisViewMode.guided.ordinal()]);
    }

    private void setMode(AnalysisViewModeDelegate mode) {
        int n;
        int n2;
        ToolItem[] toolItemArray;
        if (this.activeModeDelegate == null || !this.activeModeDelegate.equals(mode)) {
            this.activeModeDelegate = mode;
            mode.activate();
            toolItemArray = this.modesToolbar.getItems();
            n2 = toolItemArray.length;
            n = 0;
            while (n < n2) {
                ToolItem toolItem;
                toolItem.setSelection((toolItem = toolItemArray[n]).getData() == mode);
                ++n;
            }
            boolean rebel = AnalysisViewMode.rebelreport.equals((Object)mode.getAssociatedMode());
            if (!rebel) {
                this.outlinePageBook.showPage(mode.getOutline());
                this.buttonsPageBook.showPage(mode.getButtons());
            }
            this.detailsPageBook.showPage(mode.getDetails());
            this.buttonsPageBook.setVisible(!rebel);
            this.outlinePageBook.setVisible(!rebel);
        }
        toolItemArray = this.modesToolbar.getItems();
        n2 = toolItemArray.length;
        n = 0;
        while (n < n2) {
            ToolItem toolItem = toolItemArray[n];
            AnalysisViewModeDelegate delegate = (AnalysisViewModeDelegate)toolItem.getData();
            if (this.activeSession != null && delegate != null && delegate.getAssociatedMode().equals((Object)AnalysisViewMode.guided)) {
                toolItem.setEnabled(!this.activeSession.isProfileInRebel());
            }
            ++n;
        }
    }

    protected void createActions() {
        if (Activator.getDefault().getViperWorkbench().requiresPathMappingWizard()) {
            this.managePathsAction = new OpenManagePathsDialogAction();
        }
    }

    protected void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        if (this.managePathsAction != null) {
            mgr.add((IAction)this.managePathsAction);
        }
    }

    protected void refreshActions() {
        if (this.managePathsAction != null) {
            this.managePathsAction.setActiveSession(this.activeSession);
        }
    }

    protected void refreshMode() {
        if (this.activeSession != null && this.activeSession.getAnalysis() != null) {
            AnalysisViewMode mode = this.activeSession.getAnalysis().getCurrentAnalysisMode();
            int index = AnalysisViewMode.guided.ordinal();
            if (this.activeSession.isProfileInRebel()) {
                index = AnalysisViewMode.unguided.ordinal();
            } else if (mode != null) {
                index = mode.ordinal();
            }
            this.setMode(this.modeDelegates[index]);
        }
    }

    protected void handleNewActivePart(IWorkbenchPart part) {
        Session newSession = null;
        if (part instanceof SessionEditor) {
            newSession = ((SessionEditor)part).getSession();
            this.updateActiveSession(newSession);
        } else if (part instanceof SourceSassEditor) {
            newSession = ((SourceSassEditor)part).getSession();
            this.updateActiveSession(newSession);
        }
    }

    private void updateActiveSession(Session newSession) {
        if (newSession != null && this.activeSession != newSession) {
            if (this.activeSession != null) {
                this.activeSession.removePropertyChangeListener(this);
                if (this.activeSession.getAnalysis() != null) {
                    this.activeSession.getAnalysis().removePropertyChangeListener(this);
                }
                if (this.activeSession.getExpertSystem() != null) {
                    this.activeSession.getExpertSystem().removePropertyChangeListener(this);
                }
            }
            this.activeSession = newSession;
            this.activeSession.addPropertyChangeListener(this);
            if (this.activeSession.getAnalysis() != null) {
                this.activeSession.getAnalysis().addPropertyChangeListener(this);
            }
            if (this.activeSession.getExpertSystem() != null) {
                this.activeSession.getExpertSystem().addPropertyChangeListener(this);
            }
            AnalysisViewModeDelegate[] analysisViewModeDelegateArray = this.modeDelegates;
            int n = this.modeDelegates.length;
            int n2 = 0;
            while (n2 < n) {
                AnalysisViewModeDelegate delegate = analysisViewModeDelegateArray[n2];
                delegate.setSession(this.activeSession);
                ++n2;
            }
            this.refreshActions();
            this.refreshMode();
        }
    }

    protected void handleClosedPart(IWorkbenchPart part) {
        if (part instanceof SessionEditor && this.activeSession == ((SessionEditor)part).getSession()) {
            this.activeSession.removePropertyChangeListener(this);
            if (this.activeSession.getAnalysis() != null) {
                this.activeSession.getAnalysis().removePropertyChangeListener(this);
            }
            if (this.activeSession.getExpertSystem() != null) {
                this.activeSession.getExpertSystem().removePropertyChangeListener(this);
            }
            this.activeSession = null;
            AnalysisViewModeDelegate[] analysisViewModeDelegateArray = this.modeDelegates;
            int n = this.modeDelegates.length;
            int n2 = 0;
            while (n2 < n) {
                AnalysisViewModeDelegate delegate = analysisViewModeDelegateArray[n2];
                delegate.setSession(null);
                ++n2;
            }
            this.refreshActions();
            this.refreshMode();
        }
    }

    @Override
    public void ownerChanged(IContextOwner oldOwner, IContextOwner newOwner) {
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("analysis:guided".equals(propertyName)) {
            this.refreshMode();
        }
        if (this.activeModeDelegate != null) {
            this.activeModeDelegate.handlePropertyChange(propertyName);
        }
    }

    public void setFocus() {
        if (this.activeModeDelegate != null) {
            this.activeModeDelegate.setFocus();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.asListener);
    }

    public void dispose() {
        super.dispose();
        if (this.activeSession != null) {
            this.activeSession.removePropertyChangeListener(this);
            if (this.activeSession.getAnalysis() != null) {
                this.activeSession.getAnalysis().removePropertyChangeListener(this);
            }
            if (this.activeSession.getExpertSystem() != null) {
                this.activeSession.getExpertSystem().removePropertyChangeListener(this);
            }
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.asListener);
        ContextManager.getSingleton().removePossibleOwner(this);
    }

    public Object getAdapter(Class adapter) {
        if (IContributedContentsView.class.equals((Object)adapter)) {
            return new SessionEditorContributedContents();
        }
        return super.getAdapter(adapter);
    }

    private class ActivePartListener
    implements IPartListener {
        private ActivePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            AnalysisView.this.handleNewActivePart(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            AnalysisView.this.handleNewActivePart(part);
        }

        public void partOpened(IWorkbenchPart part) {
            AnalysisView.this.handleNewActivePart(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            AnalysisView.this.handleClosedPart(part);
        }
    }
}

