/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityPCSamplingStallReason;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.editor.IViewerColumnsManager;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.editor.ViewerControl;
import com.nvidia.viper.editor.ViperAnnotation;
import com.nvidia.viper.model.SourceSassModel;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.widgets.Composite;

public abstract class ViperViewerBase
extends SourceViewer {
    private ViewerCaretListener caretListener;
    protected ViewerControl viewerControl;
    protected AnalysisResultSourceLevelKind currentAnnotationKind;

    public ViperViewerBase(ViewerControl parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super((Composite)parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.viewerControl = parent;
        this.setEditable(false);
    }

    protected void createControl(Composite parent, int styles) {
        super.createControl(parent, styles);
        this.addCaretListener();
    }

    public void addCaretListener() {
        if (this.caretListener == null) {
            this.caretListener = new ViewerCaretListener();
        }
        this.getTextWidget().addCaretListener((CaretListener)this.caretListener);
    }

    public void removeCaretListener() {
        if (this.caretListener != null) {
            this.getTextWidget().removeCaretListener((CaretListener)this.caretListener);
        }
    }

    public abstract long getMaxInstructionExecuted();

    public abstract long getAverageNonZeroInstructionExecuted();

    public abstract long getInstructionExecuted(int var1);

    public abstract long getThreadInstructionExecuted(int var1);

    public abstract long getNoPredicateOff(int var1);

    public abstract long getMaxNumSamples();

    public abstract long getMaxNumLatencySamples();

    public abstract long getMaxNumStallNoneSamples();

    public abstract long getAverageNonZeroSamples();

    public abstract long getAverageNonZeroLatencySamples();

    public abstract long getNumSamples(int var1);

    public abstract long getNumSamples(int var1, CuptiActivityPCSamplingStallReason var2);

    public abstract long getNumLatencySamples(int var1);

    public abstract long getNumLatencySamples(int var1, CuptiActivityPCSamplingStallReason var2);

    public abstract long getTheoreticalL2Transactions(int var1);

    public abstract long getL2Transactions(int var1);

    public abstract long getL2InstExecuted(int var1);

    public abstract long getTheoreticalSharedTransactions(int var1);

    public abstract long getSharedTransactions(int var1);

    public abstract long getSharedInstExecuted(int var1);

    public abstract long getNumDivergedBranch(int var1);

    public abstract long getDivergeInstExecuted(int var1);

    public abstract long getMaxL2Transactions();

    public abstract long getMaxSharedTransactions();

    public abstract long getMaxDivergentBranch();

    public abstract long getAverageDivergentBranch();

    public abstract long getAverageL2Transactions();

    public abstract long getAverageSharedTransactions();

    public abstract void highlightLine(int var1);

    public abstract void highlightCorrespondingLines(int var1);

    public void createAnnotationsForPCSampling(IAnnotationModel annotationModel) {
        AnalysisResultSourceLevelKind previous = this.currentAnnotationKind;
        if (this.currentAnnotationKind != AnalysisResultSourceLevelKind.PC_SAMPLING_KIND && this.removeAnnotations()) {
            long avgSamples = this.getAverageNonZeroSamples();
            long sumSquares = 0L;
            int cnt = 0;
            int lineNum = 0;
            while (lineNum < this.getDocument().getNumberOfLines()) {
                long sampleCnt = this.getNumSamples(lineNum);
                if (sampleCnt > 0L) {
                    long diff = sampleCnt - avgSamples;
                    sumSquares += diff * diff;
                    ++cnt;
                }
                ++lineNum;
            }
            if (cnt > 0) {
                double variance = sumSquares / (long)cnt;
                double stddev = Math.sqrt(variance);
                int lineNum2 = 0;
                while (lineNum2 < this.getDocument().getNumberOfLines()) {
                    long sampleCnt = this.getNumSamples(lineNum2);
                    if (sampleCnt > 0L) {
                        long diff = sampleCnt - avgSamples;
                        if ((double)diff >= 2.0 * stddev) {
                            this.createAnnotation(annotationModel, ViperMessages.SamplesAnnotation_tooltip, this.getSamplesPercent(lineNum2), lineNum2, SourceSassEditor.AnnotationType.HOTSPOT_HIGH);
                        } else if ((double)diff >= stddev) {
                            this.createAnnotation(annotationModel, ViperMessages.SamplesAnnotation_tooltip, this.getSamplesPercent(lineNum2), lineNum2, SourceSassEditor.AnnotationType.HOTSPOT_MED);
                        }
                    }
                    ++lineNum2;
                }
            }
            this.currentAnnotationKind = AnalysisResultSourceLevelKind.PC_SAMPLING_KIND;
            this.refreshColumns(previous);
        }
    }

    public void createAnnotationsForLatencyPCSampling(IAnnotationModel annotationModel) {
        AnalysisResultSourceLevelKind previous = this.currentAnnotationKind;
        if (this.currentAnnotationKind != AnalysisResultSourceLevelKind.PC_SAMPLING_LATENCY_KIND && this.removeAnnotations()) {
            long avgLatencySamples = this.getAverageNonZeroLatencySamples();
            long sumSquares = 0L;
            int cnt = 0;
            int lineNum = 0;
            while (lineNum < this.getDocument().getNumberOfLines()) {
                long latencySampleCnt = this.getNumLatencySamples(lineNum);
                if (latencySampleCnt > 0L) {
                    long diff = latencySampleCnt - avgLatencySamples;
                    sumSquares += diff * diff;
                    ++cnt;
                }
                ++lineNum;
            }
            if (cnt > 0) {
                double variance = sumSquares / (long)cnt;
                double stddev = Math.sqrt(variance);
                int lineNum2 = 0;
                while (lineNum2 < this.getDocument().getNumberOfLines()) {
                    long latencySampleCnt = this.getNumLatencySamples(lineNum2);
                    if (latencySampleCnt > 0L) {
                        long diff = latencySampleCnt - avgLatencySamples;
                        if ((double)diff >= 2.0 * stddev) {
                            this.createAnnotation(annotationModel, ViperMessages.SamplesAnnotation_tooltip, this.getLatencySamplesPercent(lineNum2), lineNum2, SourceSassEditor.AnnotationType.HOTSPOT_HIGH);
                        } else if ((double)diff >= stddev) {
                            this.createAnnotation(annotationModel, ViperMessages.SamplesAnnotation_tooltip, this.getLatencySamplesPercent(lineNum2), lineNum2, SourceSassEditor.AnnotationType.HOTSPOT_MED);
                        }
                    }
                    ++lineNum2;
                }
            }
            this.currentAnnotationKind = AnalysisResultSourceLevelKind.PC_SAMPLING_LATENCY_KIND;
            this.refreshColumns(previous);
        }
    }

    public void createAnnotationsForInstructionExecution(IAnnotationModel annotationModel) {
        AnalysisResultSourceLevelKind previous = this.currentAnnotationKind;
        if (this.currentAnnotationKind != AnalysisResultSourceLevelKind.INSTRUCTION_EXECUTION_KIND && this.removeAnnotations()) {
            long avgExecCnt = this.getAverageNonZeroInstructionExecuted();
            long sumSquares = 0L;
            int cnt = 0;
            int lineNum = 0;
            while (lineNum < this.getDocument().getNumberOfLines()) {
                long execCnt = this.getInstructionExecuted(lineNum);
                if (execCnt > 0L) {
                    long diff = execCnt - avgExecCnt;
                    sumSquares += diff * diff;
                    ++cnt;
                }
                ++lineNum;
            }
            if (cnt > 0) {
                double variance = sumSquares / (long)cnt;
                double stddev = Math.sqrt(variance);
                int lineNum2 = 0;
                while (lineNum2 < this.getDocument().getNumberOfLines()) {
                    long execCnt = this.getInstructionExecuted(lineNum2);
                    if (execCnt > 0L) {
                        long diff = execCnt - avgExecCnt;
                        if ((double)diff > 2.0 * stddev) {
                            this.createAnnotation(annotationModel, ViperMessages.ExecCountAnnotation_tooltip, this.getInstExecutedPercent(lineNum2), lineNum2, SourceSassEditor.AnnotationType.HOTSPOT_HIGH);
                        } else if ((double)diff > stddev) {
                            this.createAnnotation(annotationModel, ViperMessages.ExecCountAnnotation_tooltip, this.getInstExecutedPercent(lineNum2), lineNum2, SourceSassEditor.AnnotationType.HOTSPOT_MED);
                        }
                    }
                    ++lineNum2;
                }
            }
            this.currentAnnotationKind = AnalysisResultSourceLevelKind.INSTRUCTION_EXECUTION_KIND;
            this.refreshColumns(previous);
        }
    }

    protected void refreshColumns(AnalysisResultSourceLevelKind kind) {
        this.refreshColumn(this.currentAnnotationKind, ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
        this.refreshColumn(this.currentAnnotationKind, ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL);
        this.refreshColumn(kind, ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
        this.refreshColumn(kind, ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL);
    }

    private void refreshColumn(AnalysisResultSourceLevelKind kind, ViewerControl.ViewerControlType viewerType) {
        IViewerColumnsManager mgr;
        if (kind != null && (mgr = kind.getColumnsManager(viewerType)) != null) {
            mgr.refreshColumn();
        }
    }

    public void createAnnotationsForDivergentBranch(IAnnotationModel annotationModel) {
        AnalysisResultSourceLevelKind previous = this.currentAnnotationKind;
        if (this.currentAnnotationKind != AnalysisResultSourceLevelKind.DIVERGENT_EXECUTION_KIND && this.removeAnnotations()) {
            int lineNum = 0;
            while (lineNum < this.getDocument().getNumberOfLines()) {
                int divergencePercent = this.getDivergencePercent(lineNum);
                if (divergencePercent >= 75) {
                    this.createAnnotation(annotationModel, ViperMessages.DivergenceAnnotation_tooltip, divergencePercent, lineNum, SourceSassEditor.AnnotationType.HOTSPOT_HIGH);
                } else if (divergencePercent >= 50) {
                    this.createAnnotation(annotationModel, ViperMessages.DivergenceAnnotation_tooltip, divergencePercent, lineNum, SourceSassEditor.AnnotationType.HOTSPOT_MED);
                }
                ++lineNum;
            }
            this.currentAnnotationKind = AnalysisResultSourceLevelKind.DIVERGENT_EXECUTION_KIND;
            this.refreshColumns(previous);
        }
    }

    public void createAnnotationsForGlobalAccess(IAnnotationModel annotationModel) {
        AnalysisResultSourceLevelKind previous = this.currentAnnotationKind;
        if (this.currentAnnotationKind != AnalysisResultSourceLevelKind.GLOBAL_ACCESS_KIND && this.removeAnnotations()) {
            int lineNum = 0;
            while (lineNum < this.getDocument().getNumberOfLines()) {
                int l2TransactionsPercent = this.getL2TransactionsPercent(lineNum);
                if (l2TransactionsPercent >= 80) {
                    this.createAnnotation(annotationModel, ViperMessages.L2TransactionsAnnotation_tooltip, l2TransactionsPercent, lineNum, SourceSassEditor.AnnotationType.HOTSPOT_HIGH);
                } else if (l2TransactionsPercent >= 60) {
                    this.createAnnotation(annotationModel, ViperMessages.L2TransactionsAnnotation_tooltip, l2TransactionsPercent, lineNum, SourceSassEditor.AnnotationType.HOTSPOT_MED);
                }
                ++lineNum;
            }
            this.currentAnnotationKind = AnalysisResultSourceLevelKind.GLOBAL_ACCESS_KIND;
            this.refreshColumns(previous);
        }
    }

    public void createAnnotationsForSharedAccess(IAnnotationModel annotationModel) {
        AnalysisResultSourceLevelKind previous = this.currentAnnotationKind;
        if (this.currentAnnotationKind != AnalysisResultSourceLevelKind.SHARED_ACCESS_KIND && this.removeAnnotations()) {
            int lineNum = 0;
            while (lineNum < this.getDocument().getNumberOfLines()) {
                int sharedTransactionsPercent = this.getSharedTransactionsPercent(lineNum);
                if (sharedTransactionsPercent >= 80) {
                    this.createAnnotation(annotationModel, ViperMessages.SharedTransactionsAnnotation_tooltip, sharedTransactionsPercent, lineNum, SourceSassEditor.AnnotationType.HOTSPOT_HIGH);
                } else if (sharedTransactionsPercent >= 60) {
                    this.createAnnotation(annotationModel, ViperMessages.SharedTransactionsAnnotation_tooltip, sharedTransactionsPercent, lineNum, SourceSassEditor.AnnotationType.HOTSPOT_MED);
                }
                ++lineNum;
            }
            this.currentAnnotationKind = AnalysisResultSourceLevelKind.SHARED_ACCESS_KIND;
            this.refreshColumns(previous);
        }
    }

    protected void createAnnotation(IAnnotationModel annotationModel, String annotationToolTip, long percent, int lineNum, SourceSassEditor.AnnotationType type) {
        ViperAnnotation annotation = new ViperAnnotation(lineNum, type);
        annotation.setText(String.format(annotationToolTip, percent, type.getDescription(), this.getTextWidget().getLine(lineNum).trim()));
        try {
            int offset = this.getDocument().getLineOffset(lineNum);
            int length = this.getDocument().getLineLength(lineNum) - 1;
            annotationModel.addAnnotation((Annotation)annotation, new Position(offset, length));
        }
        catch (BadLocationException e) {
            ViperExceptionHandler.logError(e.getMessage());
        }
    }

    public long getInstExecutedPercent(int lineNumber) {
        int percent = -1;
        long count = this.getInstructionExecuted(lineNumber);
        if (count > 0L) {
            long maxCount = this.getMaxInstructionExecuted();
            if (maxCount == 0L) {
                percent = 0;
            } else if (maxCount > 0L) {
                percent = (int)((double)count / (double)maxCount * 100.0);
            }
        }
        return percent;
    }

    public int getSamplesPercent(int lineNumber) {
        int percent = -1;
        long samples = this.getNumSamples(lineNumber);
        if (samples > 0L) {
            long maxSamples = this.getMaxNumSamples();
            if (maxSamples == 0L) {
                percent = 0;
            } else if (maxSamples > 0L) {
                percent = (int)((double)samples / (double)maxSamples * 100.0);
            }
        }
        return percent;
    }

    public int getLatencySamplesPercent(int lineNumber) {
        int percent = -1;
        long latencySamples = this.getNumLatencySamples(lineNumber);
        if (latencySamples > 0L) {
            long maxLatencySamples = this.getMaxNumLatencySamples();
            if (maxLatencySamples == 0L) {
                percent = 0;
            } else if (maxLatencySamples > 0L) {
                percent = (int)((double)latencySamples / (double)maxLatencySamples * 100.0);
            }
        }
        return percent;
    }

    private int getDivergencePercent(int lineNumber) {
        int percent = -1;
        long divergedBranch = this.getNumDivergedBranch(lineNumber);
        if (divergedBranch > 0L) {
            long maxDivergedBranch = this.getMaxDivergentBranch();
            if (maxDivergedBranch == 0L) {
                percent = 0;
            } else if (maxDivergedBranch > 0L) {
                percent = (int)((double)divergedBranch / (double)maxDivergedBranch * 100.0);
            }
        }
        return percent;
    }

    private int getL2TransactionsPercent(int lineNumber) {
        int percent = -1;
        long l2Transactions = this.getL2Transactions(lineNumber);
        if (l2Transactions > 0L) {
            long maxL2Transactions = this.getMaxL2Transactions();
            if (maxL2Transactions == 0L) {
                percent = 0;
            } else if (maxL2Transactions > 0L) {
                percent = (int)((double)l2Transactions / (double)maxL2Transactions * 100.0);
            }
        }
        return percent;
    }

    private int getSharedTransactionsPercent(int lineNumber) {
        int percent = -1;
        long sharedTransactions = this.getSharedTransactions(lineNumber);
        if (sharedTransactions > 0L) {
            long maxSharedTransactions = this.getMaxSharedTransactions();
            if (maxSharedTransactions == 0L) {
                percent = 0;
            } else if (maxSharedTransactions > 0L) {
                percent = (int)((double)sharedTransactions / (double)maxSharedTransactions * 100.0);
            }
        }
        return percent;
    }

    public int getStallNoneSamplesPercent(int lineNumber) {
        int percent = -1;
        long stallNoneSamples = this.getNumSamples(lineNumber, CuptiActivityPCSamplingStallReason.CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE);
        if (stallNoneSamples > 0L) {
            long maxStallNoneSamples = this.getMaxNumStallNoneSamples();
            if (maxStallNoneSamples == 0L) {
                percent = 0;
            } else if (maxStallNoneSamples > 0L) {
                percent = (int)((double)stallNoneSamples / (double)maxStallNoneSamples * 100.0);
            }
        }
        return percent;
    }

    public SourceSassModel getModel() {
        return this.viewerControl.getEditor().getSourceSassModel();
    }

    public AnalysisResultSourceLevelKind getCurrentAnnotationKind() {
        return this.currentAnnotationKind;
    }

    public boolean removeAnnotations() {
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel != null) {
            Iterator ite = annotationModel.getAnnotationIterator();
            while (ite.hasNext()) {
                annotationModel.removeAnnotation((Annotation)ite.next());
            }
            this.refreshColumn(this.currentAnnotationKind, ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
            this.refreshColumn(this.currentAnnotationKind, ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL);
            this.currentAnnotationKind = null;
            return true;
        }
        return false;
    }

    class ViewerCaretListener
    implements CaretListener {
        ViewerCaretListener() {
        }

        public void caretMoved(CaretEvent event) {
            IDocument doc = ViperViewerBase.this.getDocument();
            int line = -1;
            if (doc != null) {
                try {
                    line = doc.getLineOfOffset(event.caretOffset);
                }
                catch (BadLocationException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
                ViperViewerBase.this.highlightCorrespondingLines(line);
                ViperViewerBase.this.highlightLine(line);
            }
        }
    }
}

