/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.model.Session;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UVMSegmentComposite
extends Composite {
    private Session session;
    private Text segmentsText;
    private Button uvmCheck;
    private Label label;

    public UVMSegmentComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createControls();
    }

    public void setInput(Session session) {
        this.session = session;
    }

    public void init(Session session) {
        if (session != null) {
            this.uvmCheck.setSelection(session.isUVMSegmentEnabled());
            this.label.setEnabled(session.isUVMSegmentEnabled());
            this.segmentsText.setEnabled(session.isUVMSegmentEnabled());
            String str = String.valueOf(session.getNumSegmentsUVM());
            this.segmentsText.setText(str);
        }
    }

    private void createControls() {
        this.uvmCheck = new Button((Composite)this, 32);
        this.uvmCheck.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.uvmCheck.setText("Use fixed width segments for Unified memory timeline");
        this.label = new Label((Composite)this, 0);
        this.label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.label.setText("Number of segments");
        this.segmentsText = new Text((Composite)this, 2052);
        this.segmentsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.segmentsText.setMessage("Specify the number of segments for unified memory timelines [default " + Session.UVM_NUM_SEGMENT_DEFAULT + "]");
        this.segmentsText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.isEmpty() ? true : e.text.matches("[0-9]+");
            }
        });
        this.segmentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UVMSegmentComposite.this.session != null) {
                    String segments = UVMSegmentComposite.this.segmentsText.getText();
                    if (segments.isEmpty()) {
                        UVMSegmentComposite.this.session.setNumSegmentsUVM(Session.UVM_NUM_SEGMENT_DEFAULT);
                    } else {
                        UVMSegmentComposite.this.session.setNumSegmentsUVM(Integer.parseInt(segments));
                    }
                }
            }
        });
        this.uvmCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UVMSegmentComposite.this.label.setEnabled(UVMSegmentComposite.this.uvmCheck.getSelection());
                UVMSegmentComposite.this.segmentsText.setEnabled(UVMSegmentComposite.this.uvmCheck.getSelection());
                if (UVMSegmentComposite.this.session != null) {
                    UVMSegmentComposite.this.session.setIsUVMSegmentEnabled(UVMSegmentComposite.this.uvmCheck.getSelection());
                }
            }
        });
        this.uvmCheck.setSelection(true);
    }

    public void enable(boolean enabled) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!enabled) {
                child.setEnabled(enabled);
            } else if (child == this.uvmCheck) {
                child.setEnabled(enabled);
            } else {
                child.setEnabled(this.uvmCheck.getSelection());
            }
            ++n2;
        }
    }

    public int getNumSegments() {
        if (this.segmentsText.getText() != null && !this.segmentsText.getText().isEmpty()) {
            return Integer.parseInt(this.segmentsText.getText());
        }
        return Session.UVM_NUM_SEGMENT_DEFAULT;
    }

    public boolean isSegmentEnabled() {
        return this.uvmCheck.getSelection();
    }

    public void updateSelection() {
        this.uvmCheck.setSelection(this.session.isUVMSegmentEnabled());
    }

    public void updateTimelineOptions(Session session) {
        if (session != null) {
            session.setIsUVMSegmentEnabled(this.isSegmentEnabled());
            session.setNumSegmentsUVM(this.getNumSegments());
        }
    }
}

