/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiDeviceAttribute;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineKind;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PCIePropertyControl
extends Composite {
    public int labelWidth;
    private Session session = null;
    private TimelineDevice[] deviceTimelines = null;
    private Combo deviceCombo;
    private CLabel genDefault;
    private CLabel widthDefault;
    private CLabel rateDefault;
    private Text genOverride;
    private Text widthOverride;
    private Text rateOverride;

    public PCIePropertyControl(Composite parent, int style) {
        super(parent, style);
        this.setLabelWidth(parent.getFont());
        this.setLayout((Layout)new FormLayout());
        Group group = new Group((Composite)this, 2048);
        group.setLayout((Layout)new FormLayout());
        group.setText("PCIe Override: Rerun analysis after updating");
        FormData groupData = new FormData();
        groupData.top = new FormAttachment(0, 0);
        groupData.bottom = new FormAttachment(100, 0);
        groupData.left = new FormAttachment(0, 0);
        groupData.right = new FormAttachment(100, 0);
        group.setLayoutData((Object)groupData);
        CLabel deviceLabel = new CLabel((Composite)group, 0);
        deviceLabel.setText("Device: ");
        this.deviceCombo = new Combo((Composite)group, 12);
        this.deviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PCIePropertyControl.this.refreshDefaults();
            }
        });
        this.refreshDeviceCombo();
        FormData labelData = new FormData();
        FormData comboData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        comboData.left = new FormAttachment((Control)deviceLabel, 0);
        comboData.top = new FormAttachment((Control)deviceLabel, 0, 0x1000000);
        deviceLabel.setLayoutData((Object)labelData);
        this.deviceCombo.setLayoutData((Object)comboData);
        this.genOverride = new Text((Composite)group, 18436);
        this.genOverride.setMessage(ViperMessages.PCIeGen_Message);
        this.genOverride.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.isEmpty() ? true : e.text.matches("[23]?");
            }
        });
        this.genOverride.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TimelineDevice tl;
                if (PCIePropertyControl.this.session != null && PCIePropertyControl.this.session.getAnalysis() != null && (tl = PCIePropertyControl.this.getComboDevice()) != null) {
                    Long gen = null;
                    try {
                        gen = Long.parseLong(PCIePropertyControl.this.genOverride.getText());
                        if (gen != 2L && gen != 3L) {
                            gen = null;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        gen = null;
                    }
                    PCIePropertyControl.this.session.getAnalysis().setPCIeGeneration(tl.getId(), gen);
                }
            }
        });
        this.widthOverride = new Text((Composite)group, 18436);
        this.widthOverride.setMessage(ViperMessages.PCIeLinkWidth_Message);
        this.widthOverride.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.isEmpty() ? true : e.text.matches("[123468]+");
            }
        });
        this.widthOverride.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TimelineDevice tl;
                if (PCIePropertyControl.this.session != null && PCIePropertyControl.this.session.getAnalysis() != null && (tl = PCIePropertyControl.this.getComboDevice()) != null) {
                    Long width = null;
                    try {
                        width = Long.parseLong(PCIePropertyControl.this.widthOverride.getText());
                        if (width != 1L && width != 2L && width != 4L && width != 8L && width != 16L && width != 32L) {
                            width = null;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        width = null;
                    }
                    PCIePropertyControl.this.session.getAnalysis().setPCIeLinkWidth(tl.getId(), width);
                }
            }
        });
        this.rateOverride = new Text((Composite)group, 18436);
        this.rateOverride.setMessage(ViperMessages.PCIeLinkRate_Message);
        this.rateOverride.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.isEmpty() ? true : e.text.matches("[0-9]+");
            }
        });
        this.rateOverride.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TimelineDevice tl;
                if (PCIePropertyControl.this.session != null && PCIePropertyControl.this.session.getAnalysis() != null && (tl = PCIePropertyControl.this.getComboDevice()) != null) {
                    Long rate = null;
                    try {
                        rate = Long.parseLong(PCIePropertyControl.this.rateOverride.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        rate = null;
                    }
                    PCIePropertyControl.this.session.getAnalysis().setPCIeLinkRate(tl.getId(), rate);
                }
            }
        });
        this.genDefault = this.createOverride((Composite)group, (Control)deviceLabel, ViperMessages.PCIeGen_Label, this.genOverride);
        this.widthDefault = this.createOverride((Composite)group, (Control)this.genDefault, ViperMessages.PCIeLinkWidth_Label, this.widthOverride);
        this.rateDefault = this.createOverride((Composite)group, (Control)this.widthDefault, ViperMessages.PCIeLinkRate_Label, this.rateOverride);
        this.refreshDefaults();
        this.setFocus();
    }

    private CLabel createOverride(Composite parent, Control prev, String labelText, Text overrideText) {
        CLabel label = new CLabel(parent, 0);
        label.setText(labelText);
        CLabel defLabel = new CLabel(parent, 0);
        CLabel overrideLabel = new CLabel(parent, 0);
        overrideLabel.setText("Override:");
        FormData labelData = new FormData();
        FormData defData = new FormData();
        FormData overrideLabelData = new FormData();
        FormData overrideData = new FormData();
        defData.left = new FormAttachment(0, this.labelWidth + 5 + 6 + 2);
        defData.top = prev == null ? new FormAttachment(0, 4) : new FormAttachment(prev, 4);
        overrideLabelData.left = new FormAttachment(0, 2 * (this.labelWidth + 5 + 6 + 2));
        overrideLabelData.top = new FormAttachment((Control)defLabel, 0, 0x1000000);
        overrideData.left = new FormAttachment((Control)overrideLabel, 0);
        overrideData.right = new FormAttachment(100, 0);
        overrideData.top = new FormAttachment((Control)defLabel, 0, 0x1000000);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)defLabel, 0);
        labelData.top = new FormAttachment((Control)defLabel, 0, 0x1000000);
        defData.right = new FormAttachment((Control)overrideLabel, 0);
        label.setLayoutData((Object)labelData);
        defLabel.setLayoutData((Object)defData);
        overrideLabel.setLayoutData((Object)overrideLabelData);
        overrideText.setLayoutData((Object)overrideData);
        return defLabel;
    }

    public void setInput(Session session) {
        this.session = session;
    }

    private TimelineDevice getComboDevice() {
        int idx;
        if (this.deviceTimelines != null && (idx = this.deviceCombo.getSelectionIndex()) >= 0 && idx < this.deviceTimelines.length) {
            return this.deviceTimelines[idx];
        }
        return null;
    }

    private void refreshSessionDevices() {
        List<Timeline> timelines;
        this.deviceTimelines = null;
        if (this.session != null && !(timelines = this.session.getTimelines(TimelineKind.DEVICE)).isEmpty()) {
            this.deviceTimelines = timelines.toArray(new TimelineDevice[0]);
        }
    }

    private void refreshDeviceCombo() {
        this.deviceCombo.removeAll();
        this.deviceCombo.setEnabled(false);
        if (this.deviceTimelines != null) {
            LinkedList<String> deviceNames = new LinkedList<String>();
            TimelineDevice[] timelineDeviceArray = this.deviceTimelines;
            int n = this.deviceTimelines.length;
            int n2 = 0;
            while (n2 < n) {
                TimelineDevice tl = timelineDeviceArray[n2];
                deviceNames.add(tl.getDisplayName(false));
                ++n2;
            }
            if (!deviceNames.isEmpty()) {
                this.deviceCombo.setItems(deviceNames.toArray(new String[0]));
                this.deviceCombo.setEnabled(true);
                this.deviceCombo.select(0);
            }
        }
    }

    private void refreshDefaults() {
        TimelineDevice tl = this.getComboDevice();
        if (tl == null) {
            this.genDefault.setText("");
            this.widthDefault.setText("");
            this.rateDefault.setText("");
            this.genOverride.setText("");
            this.widthOverride.setText("");
            this.rateOverride.setText("");
        } else {
            Number genNumber = tl.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_GEN);
            this.genDefault.setText(genNumber instanceof Long ? Long.toString(genNumber.longValue()) : "");
            Number widthNumber = tl.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH);
            this.widthDefault.setText(widthNumber instanceof Long ? Long.toString(widthNumber.longValue()) : "");
            Number rateNumber = tl.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_RATE);
            this.rateDefault.setText(rateNumber instanceof Long ? new BandwidthFormatter(ByteSizeFormatter.Base.KILOBIT).format(rateNumber.longValue() * 1000L * 1000L) : "");
            if (this.session.getAnalysis() == null) {
                this.genOverride.setText("");
                this.widthOverride.setText("");
                this.rateOverride.setText("");
            } else {
                Long gen = this.session.getAnalysis().getPCIeGeneration(tl.getId());
                this.genOverride.setText(gen != null ? gen.toString() : "");
                Long width = this.session.getAnalysis().getPCIeLinkWidth(tl.getId());
                this.widthOverride.setText(width != null ? width.toString() : "");
                Long rate = this.session.getAnalysis().getPCIeLinkRate(tl.getId());
                this.rateOverride.setText(rate != null ? rate.toString() : "");
            }
        }
    }

    private void setLabelWidth(Font font) {
        Dimension textSize = FigureUtilities.getStringExtents((String)ViperMessages.PCIeLinkWidth_Label, (Font)font);
        textSize = textSize.getUnioned(FigureUtilities.getStringExtents((String)ViperMessages.PCIeLinkRate_Label, (Font)font));
        textSize = textSize.getUnioned(FigureUtilities.getStringExtents((String)ViperMessages.PCIeGen_Label, (Font)font));
        this.labelWidth = textSize.width;
    }

    public void refresh() {
        this.refreshSessionDevices();
        this.refreshDeviceCombo();
        this.refreshDefaults();
    }
}

