/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.ui.connection.ConnectionWorkingCopy;
import com.nvidia.cuda.ide.remote.internal.ui.connection.RSEConnectionManager;
import com.nvidia.cuda.ide.remote.ui.connection.RemoteConnectionCombo;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.RemoteConnectionToolkitWizard;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.OpenSessionAction;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.IProfileMultiProcess;
import com.nvidia.viper.model.ProfileAllProcesses;
import com.nvidia.viper.model.ProfileMPIProcesses;
import com.nvidia.viper.properties.EnvDialog;
import com.nvidia.viper.properties.ExecutablePropertySection;
import com.nvidia.viper.ui.MultiProcessCombo;
import com.nvidia.viper.ui.UIUtils;
import com.nvidia.viper.ui.ViperObservables;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public abstract class ExecutablePropertyControl
extends Composite {
    private static final int REMOTE_VALIDATION_DELAY = 200;
    private RemoteConnectionCombo connectionCombo;
    private Text toolkitName;
    private Text pathText;
    private Text cwdText;
    private Text argsText;
    private Table envTable;
    public int labelWidth;
    private Executable executable = null;
    private IRunnableContext runnableContext;
    private Button newToolkitButton;
    private Link connectLink;
    private IProfileMultiProcess currentMultiProcOption = null;
    private ScheduledExecutorService validatorThread = Executors.newSingleThreadScheduledExecutor();
    private final WritableValue executableHandle = WritableValue.withValueType(Executable.class);
    private final AtomicReference<ValidatorRunnable> runnable = new AtomicReference();
    private MultiProcessCombo multiProcessCombo;
    private ISelectionChangedListener multiProcessComboListener;
    private ExpandableComposite mpiExpandableComposite;
    private Text mpiLaunchText;
    private Text mpiArgText;
    private Button mpiBrowseButton;
    private Button pathButton;
    private Button cwdButton;
    private Text mpiCommand;
    private ExecutablePropertySection.MultiProcessSettingListener multiProcessSettingListener = null;

    private String validateStringSubstitution(String value) {
        VariablesPlugin vp = VariablesPlugin.getDefault();
        try {
            vp.getStringVariableManager().performStringSubstitution(value);
        }
        catch (CoreException e) {
            return e.getMessage();
        }
        return null;
    }

    private IStatus validateValues(String path, String cwd, String mpiLauncher, boolean customScript, FileSystem system) {
        if (this.currentMultiProcOption instanceof ProfileAllProcesses) {
            return Status.OK_STATUS;
        }
        boolean profileMPIProcesses = this.currentMultiProcOption instanceof ProfileMPIProcesses;
        String mpiWarning = profileMPIProcesses ? "\n" + ViperMessages.NewSession_Wizard_MPI_MultiNode_Message : "";
        String errorMessage = null;
        String warningMessage = null;
        try {
            if (customScript && !CoreUtil.isNullOrEmpty((String)path)) {
                return Status.OK_STATUS;
            }
            if (CoreUtil.isNullOrEmpty((String)path)) {
                errorMessage = ViperMessages.NewSession_Wizard_Missing_Executable_Message;
            } else if (!system.isConnected()) {
                warningMessage = String.valueOf(ViperMessages.NewSession_Wizard_Not_Connected_Message) + mpiWarning;
            } else if (!system.isExistingFile(path.trim())) {
                errorMessage = ViperMessages.NewSession_Wizard_File_Message;
            } else if (!cwd.isEmpty() && !system.isExistingDirectory(cwd.trim())) {
                errorMessage = ViperMessages.NewSession_Wizard_WorkDir_Message;
            } else if (profileMPIProcesses) {
                if (!system.isExistingFile(mpiLauncher.trim())) {
                    errorMessage = ViperMessages.NewSession_Wizard_MPILaunch_Message;
                } else {
                    warningMessage = ViperMessages.NewSession_Wizard_MPI_MultiNode_Message;
                }
            }
        }
        catch (ViperException e) {
            errorMessage = null;
            warningMessage = ViperMessages.NewSession_Wizard_Validation_Exception_Message;
            ViperExceptionHandler.handle(ViperMessages.NewSession_Label, warningMessage, e);
        }
        if (errorMessage == null) {
            for (Map.Entry<String, String> entry : this.executable.getEnv().entrySet()) {
                String msg = this.validateStringSubstitution(entry.getValue());
                if (msg == null) continue;
                errorMessage = String.format("Value of environment variable %s is invalid: %s", entry.getKey(), msg);
                break;
            }
        }
        if (errorMessage != null) {
            return CoreUtil.errorStatus((String)(String.valueOf(errorMessage) + mpiWarning), (Object[])new Object[0]);
        }
        if (warningMessage != null) {
            return CoreUtil.warningStatus((String)warningMessage, (Object[])new Object[0]);
        }
        return Status.OK_STATUS;
    }

    private static Dimension getLargestLabelDimensions(Font font, String ... labels) {
        Dimension dimension = new Dimension(0, 0);
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            dimension = dimension.getUnioned(FigureUtilities.getTextExtents((String)string, (Font)font));
            ++n2;
        }
        return dimension;
    }

    public ExecutablePropertyControl(Composite parent, int style, IRunnableContext runnableContext) {
        super(parent, style);
        this.runnableContext = runnableContext;
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        this.setLabelWidth(parent.getFont());
        this.connectionCombo = this.createConnectionCombo(null);
        this.toolkitName = this.createToolkitField(this.connectionCombo.getControl());
        Control[] browse = this.createFileBrowse((Control)this.toolkitName, ViperMessages.FilePath_Label, false);
        this.pathText = (Text)browse[1];
        this.pathButton = (Button)browse[2];
        this.pathText.setMessage(ViperMessages.FilePath_Message);
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExecutablePropertyControl.this.pathText.getText().isEmpty()) {
                    ExecutablePropertyControl.this.executable.setFilename(null);
                } else {
                    ExecutablePropertyControl.this.executable.setFilename(ExecutablePropertyControl.this.pathText.getText().trim());
                }
                if (!CoreUtil.isNullOrEmpty((String)System.getenv("VIPER_DEBUG"))) {
                    ExecutablePropertyControl.this.mpiCommand.setText(ExecutablePropertyControl.this.getMPICommand());
                }
                ExecutablePropertyControl.this.revalidate();
            }
        });
        browse = this.createFileBrowse((Control)this.pathText, ViperMessages.CurrentWorkDir_Label, true);
        this.cwdText = (Text)browse[1];
        this.cwdButton = (Button)browse[2];
        this.cwdText.setMessage(ViperMessages.CurrentWorkDir_Message);
        this.cwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExecutablePropertyControl.this.cwdText.getText().isEmpty()) {
                    ExecutablePropertyControl.this.executable.setWorkingDir(null);
                } else {
                    ExecutablePropertyControl.this.executable.setWorkingDir(ExecutablePropertyControl.this.cwdText.getText());
                }
                ExecutablePropertyControl.this.revalidate();
            }
        });
        Control[] text = this.createText((Control)this.cwdText, ViperMessages.CmdArgs_Label);
        this.argsText = (Text)text[1];
        this.argsText.setMessage(ViperMessages.CmdArgs_Message);
        this.argsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExecutablePropertyControl.this.argsText.getText().isEmpty()) {
                    ExecutablePropertyControl.this.executable.setArgs(null);
                } else {
                    ExecutablePropertyControl.this.executable.setArgs(ExecutablePropertyControl.this.argsText.getText());
                }
                if (!CoreUtil.isNullOrEmpty((String)System.getenv("VIPER_DEBUG"))) {
                    ExecutablePropertyControl.this.mpiCommand.setText(ExecutablePropertyControl.this.getMPICommand());
                }
            }
        });
        this.multiProcessCombo = this.createMultiProcessCombo(this.argsText);
        Control prev = this.multiProcessCombo.getControl();
        if (!CoreUtil.isNullOrEmpty((String)System.getenv("VIPER_DEBUG"))) {
            this.setupMPIControls();
            prev = this.mpiExpandableComposite;
        }
        this.envTable = this.createNameValueTable(prev, ViperMessages.EnvironmentVar_Label);
        this.envTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item != null) {
                    String name = ((TableItem)e.item).getText(0);
                    String value = ((TableItem)e.item).getText(1);
                    EnvDialog ed = new EnvDialog(ExecutablePropertyControl.this.envTable.getShell(), "Edit Environment Variable", name, value);
                    if (ed.open() == 0) {
                        ExecutablePropertyControl.this.executable.addEnvVar(ed.getName(), ed.getValue());
                        ExecutablePropertyControl.this.refreshNameValueTable(ExecutablePropertyControl.this.envTable, ExecutablePropertyControl.this.executable.getEnv());
                    }
                }
            }
        });
        this.connectLink = new Link((Composite)this, 0);
        this.connectLink.setText("<a>Connect to a remote system</a>");
        FormData linkData = new FormData();
        linkData.right = new FormAttachment(100);
        linkData.top = new FormAttachment((Control)this.envTable, 8);
        this.connectLink.setLayoutData((Object)linkData);
        this.connectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutablePropertyControl.this.connect();
            }
        });
        this.setupBindings();
    }

    private void setupMPIControls() {
        this.mpiExpandableComposite = new ExpandableComposite((Composite)this, 0);
        this.layoutUnderneath(this.multiProcessCombo.getControl(), (Control)this.mpiExpandableComposite);
        this.mpiExpandableComposite.setText("MPI Parameters");
        this.mpiExpandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ExecutablePropertyControl.this.mpiExpandableComposite.getParent().layout();
            }
        });
        Composite mpiControlsComposite = new Composite((Composite)this.mpiExpandableComposite, 2048);
        this.mpiExpandableComposite.setClient((Control)mpiControlsComposite);
        mpiControlsComposite.setLayout((Layout)new FormLayout());
        Control[] browse = this.createFileBrowse(mpiControlsComposite, null, ViperMessages.MPILauncher_Label, false);
        this.mpiBrowseButton = (Button)browse[2];
        this.mpiLaunchText = (Text)browse[1];
        this.mpiLaunchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutablePropertyControl.this.executable.setMPILauncher(ExecutablePropertyControl.this.mpiLaunchText.getText());
                ExecutablePropertyControl.this.mpiCommand.setText(ExecutablePropertyControl.this.getMPICommand());
                ExecutablePropertyControl.this.revalidate();
            }
        });
        Control[] text = this.createText(mpiControlsComposite, (Control)this.mpiLaunchText, ViperMessages.MPIArgs_Label);
        this.mpiArgText = (Text)text[1];
        this.mpiArgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutablePropertyControl.this.executable.setMPIArg(ExecutablePropertyControl.this.mpiArgText.getText());
                ExecutablePropertyControl.this.mpiCommand.setText(ExecutablePropertyControl.this.getMPICommand());
            }
        });
        text = this.createText(mpiControlsComposite, (Control)this.mpiArgText, "MPI Command:");
        this.mpiCommand = (Text)text[1];
        this.mpiCommand.setEditable(false);
        this.setMPIControlEnabled(false);
    }

    private void setupBindings() {
        DataBindingContext context = new DataBindingContext();
        final IObservableValue model = ViperObservables.observeConnection((IObservableValue)this.executableHandle);
        context.bindValue(this.connectionCombo.observeSelection(), model);
        ComputedValue offlineMode = new ComputedValue(Boolean.class){

            protected Object calculate() {
                Object value = model.getValue();
                if (value instanceof IRemoteConnection) {
                    return !((IRemoteConnection)value).isConnected(IRemoteConnection.Service.Files);
                }
                return false;
            }
        };
        context.bindValue((IObservableValue)SWTObservables.observeVisible((Control)this.connectLink), (IObservableValue)offlineMode);
        context.bindValue((IObservableValue)new ValidationTrigger(IRemoteConnection.class), model);
        context.bindValue((IObservableValue)new ValidationTrigger(Boolean.class), (IObservableValue)offlineMode);
        context.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.newToolkitButton), (IObservableValue)new ComputedValue(Boolean.class){

            protected Object calculate() {
                IRemoteConnection value = (IRemoteConnection)model.getValue();
                if (value != null && !value.isLocalSystem()) {
                    return true;
                }
                return false;
            }
        });
        context.bindValue((IObservableValue)SWTObservables.observeText((Control)this.toolkitName), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                ExecutablePropertyControl.this.revalidate();
                ExecutablePropertyControl.this.refreshControls();
                IRemoteConnection c = (IRemoteConnection)model.getValue();
                if (c != null) {
                    ICudaToolkit tk = (ICudaToolkit)c.observeToolkit().getValue();
                    if (tk == null) {
                        return "";
                    }
                    if (tk.isCustomScript(ICudaToolkit.Tool.Nvprof)) {
                        return tk.getToolPath(ICudaToolkit.Tool.Nvprof);
                    }
                    return tk.getName();
                }
                return null;
            }
        });
    }

    private boolean isUsingCustomScript() {
        IRemoteConnection conn = this.connectionCombo.getSelection();
        return conn != null && conn.getToolkit() != null && conn.getToolkit().isCustomScript(ICudaToolkit.Tool.Nvprof);
    }

    private void refreshControls() {
        StructuredSelection sel = (StructuredSelection)this.multiProcessCombo.getSelection();
        IProfileMultiProcess proc = (IProfileMultiProcess)sel.getFirstElement();
        boolean allProcesses = proc.getType().equals((Object)IProfileMultiProcess.Type.ALL_PROCESSES);
        this.argsText.setEnabled(!allProcesses);
        this.pathText.setEnabled(!allProcesses);
        this.pathButton.setEnabled(!allProcesses);
        this.cwdText.setEnabled(!allProcesses && !this.isUsingCustomScript());
        this.cwdButton.setEnabled(!allProcesses && !this.isUsingCustomScript());
        IRemoteConnection conn = this.connectionCombo.getSelection();
        if (conn == null || conn.getToolkit() == null) {
            this.toolkitName.setText("");
        } else if (this.isUsingCustomScript()) {
            this.toolkitName.setText(conn.getToolkit().getToolPath(ICudaToolkit.Tool.Nvprof));
        } else {
            this.toolkitName.setText(conn.getToolkit().getName());
        }
    }

    private final void revalidate() {
        FileSystem system;
        String path = this.pathText.getText();
        String cwd = this.cwdText.getText();
        String mpiLauncher = "";
        if (!CoreUtil.isNullOrEmpty((String)System.getenv("VIPER_DEBUG"))) {
            mpiLauncher = this.mpiLaunchText.getText();
        }
        if ((system = this.getFileSystem()).isLocal()) {
            this.setValidationStatus(this.validateValues(path, cwd, mpiLauncher, this.isUsingCustomScript(), system));
        } else {
            this.runnable.set(new ValidatorRunnable(system, path, cwd, mpiLauncher, this.isUsingCustomScript()));
            this.validatorThread.schedule(this.runnable.get(), 200L, TimeUnit.MILLISECONDS);
        }
    }

    public abstract void setValidationStatus(IStatus var1);

    protected void connect() {
        block4: {
            final IRemoteConnection connection = this.connectionCombo.getSelection();
            if (connection != null && !connection.isConnected(IRemoteConnection.Service.Files)) {
                try {
                    this.runnableContext.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                connection.connect(IRemoteConnection.Service.Files, monitor);
                            }
                            catch (CoreException e) {
                                if (e.getCause() instanceof OperationCanceledException) {
                                    CoreUtil.throwInterruptedException((Throwable)e.getCause());
                                }
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    ViperExceptionHandler.handle(ViperMessages.NewSession_Wizard_Title, "Unable to connect", (Exception)e.getCause());
                }
                catch (InterruptedException e) {
                    if (e.getCause() instanceof OperationCanceledException) break block4;
                    ViperExceptionHandler.logError(null, e);
                }
            }
        }
    }

    private RemoteConnectionCombo createConnectionCombo(Control prev) {
        CLabel connectionLabel = new CLabel((Composite)this, 0);
        connectionLabel.setText(ViperMessages.Connection_Label);
        Button newConnectionButton = new Button((Composite)this, 8);
        newConnectionButton.setText("Manage connections...");
        final RemoteConnectionCombo connectionCombo = new RemoteConnectionCombo((Composite)this);
        connectionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                IRemoteConnection conn = (IRemoteConnection)selection.getFirstElement();
                if (conn != null) {
                    if (conn.getName().equals("Add connection...")) {
                        ExecutablePropertyControl.this.manage(connectionCombo);
                    } else {
                        connectionCombo.setPreviousSelected(conn);
                    }
                }
                ExecutablePropertyControl.this.refreshControls();
                if (ExecutablePropertyControl.this.executable != null) {
                    ExecutablePropertyControl.this.executable.setFileSystem(ExecutablePropertyControl.this.getFileSystem());
                }
            }
        });
        connectionCombo.setRemovedConnectionsListener(new RemoteConnectionCombo.RemovedConnectionsListener(){

            public void connectionsRemoved(Collection<ConnectionWorkingCopy> removedConnections) {
                ArrayList<String> removedConnectionNames = new ArrayList<String>();
                for (ConnectionWorkingCopy connection : removedConnections) {
                    removedConnectionNames.add((String)connection.getProperty(ConnectionWorkingCopy.PROPERTY_LABEL));
                }
                FileSystem.removeConnections(removedConnectionNames);
            }
        });
        newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutablePropertyControl.this.manage(connectionCombo);
            }
        });
        this.layoutControls(prev, (Control)connectionLabel, connectionCombo.getControl(), (Control)newConnectionButton);
        return connectionCombo;
    }

    private MultiProcessCombo createMultiProcessCombo(Text prev) {
        CLabel multiProcLabel = new CLabel((Composite)this, 0);
        multiProcLabel.setText("");
        MultiProcessCombo comboView = new MultiProcessCombo(this);
        this.multiProcessComboListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection slection = (StructuredSelection)event.getSelection();
                IProfileMultiProcess selected = (IProfileMultiProcess)slection.getFirstElement();
                ExecutablePropertyControl.this.executable.setMultiProcessProfile(selected);
                ExecutablePropertyControl.this.updateMultiProcessUI(selected);
                if (ExecutablePropertyControl.this.multiProcessSettingListener != null) {
                    ExecutablePropertyControl.this.multiProcessSettingListener.updateOptions();
                }
                ExecutablePropertyControl.this.revalidate();
            }
        };
        comboView.addSelectionChangedListener(this.multiProcessComboListener);
        this.layoutControls((Control)prev, (Control)multiProcLabel, comboView.getControl(), null);
        return comboView;
    }

    private void updateMultiProcessUI(IProfileMultiProcess selected) {
        boolean mpiSelected = IProfileMultiProcess.Type.MPI.equals((Object)selected.getType());
        this.currentMultiProcOption = selected;
        this.refreshControls();
        this.setMPIControlEnabled(mpiSelected);
        if (mpiSelected && !this.mpiExpandableComposite.isExpanded()) {
            this.mpiExpandableComposite.setExpanded(true);
            this.layout();
        }
    }

    private void setMPIControlEnabled(boolean enabled) {
        if (!CoreUtil.isNullOrEmpty((String)System.getenv("VIPER_DEBUG"))) {
            this.mpiLaunchText.setEnabled(enabled);
            this.mpiBrowseButton.setEnabled(enabled);
            this.mpiArgText.setEnabled(enabled);
            this.mpiCommand.setEnabled(enabled);
        }
    }

    private Text createToolkitField(Control prev) {
        CLabel toolkitLabel = new CLabel((Composite)this, 0);
        toolkitLabel.setText(ViperMessages.Toolkit_Label);
        this.toolkitName = new Text((Composite)this, 2060);
        this.newToolkitButton = new Button((Composite)this, 8);
        this.newToolkitButton.setText("Manage...");
        this.newToolkitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutablePropertyControl.this.editToolkit(ExecutablePropertyControl.this.toolkitName);
            }
        });
        this.layoutControls(prev, (Control)toolkitLabel, (Control)this.toolkitName, (Control)this.newToolkitButton);
        return this.toolkitName;
    }

    public void setInput(Executable executable) {
        this.executable = executable;
        this.executableHandle.setValue((Object)executable);
        if (executable != null && executable.getRemoreArgs() != null) {
            OpenSessionAction.RemoteConnectionArgs remoreArgs = executable.getRemoreArgs();
            List conns = RSEConnectionManager.getAllConnectionWorkingCopies((IObservableList)new WritableList());
            ConnectionWorkingCopy newCopy = new ConnectionWorkingCopy(null, (Collection)conns, SWTObservables.getRealm((Display)this.getShell().getDisplay()));
            newCopy.setProperties(remoreArgs.host, remoreArgs.user, remoreArgs.port, remoreArgs.type);
            this.connectionCombo.addConnection(newCopy);
            if (remoreArgs.toolkit != null) {
                this.toolkitName.setText(remoreArgs.toolkit);
            }
        }
        if (executable != null) {
            executable.setFileSystem(this.getFileSystem());
        }
    }

    protected void setLabelWidth(Font font) {
        this.labelWidth = ExecutablePropertyControl.getLargestLabelDimensions((Font)font, (String[])new String[]{ViperMessages.Connection_Label, ViperMessages.Toolkit_Label, ViperMessages.FilePath_Label, ViperMessages.CurrentWorkDir_Label, ViperMessages.CmdArgs_Label, ViperMessages.EnvironmentVar_Label}).width;
    }

    protected Control[] createFileBrowse(Control prev, String labelText, boolean dir) {
        return this.createFileBrowse(this, prev, labelText, dir);
    }

    protected Control[] createFileBrowse(Composite parent, Control prev, String labelText, boolean dir) {
        CLabel pathLabel = new CLabel(parent, 0);
        pathLabel.setText(labelText);
        final Text fileText = new Text(parent, 18436);
        final Button browseButton = new Button(parent, 8);
        browseButton.setText("Browse...");
        this.layoutControls(prev, (Control)pathLabel, (Control)fileText, (Control)browseButton);
        if (dir) {
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.browseForDir(fileText, ExecutablePropertyControl.this.cwdText.getText(), browseButton, ExecutablePropertyControl.this.getFileSystem(), ExecutablePropertyControl.this.runnableContext);
                }
            });
        } else {
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.browseForFile(fileText, ExecutablePropertyControl.this.pathText.getText(), browseButton, ExecutablePropertyControl.this.getFileSystem(), ExecutablePropertyControl.this.runnableContext);
                }
            });
        }
        return new Control[]{pathLabel, fileText, browseButton};
    }

    protected FileSystem getFileSystem() {
        IRemoteConnection connection = this.connectionCombo.getSelection();
        String connectionName = connection == null ? null : connection.getName();
        try {
            return FileSystem.getFilesystem(connectionName);
        }
        catch (ConnectionNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private void layoutControls(Control prev, Control label, Control entry, Control button) {
        FormData entryData = new FormData();
        FormData buttonData = new FormData();
        FormData labelData = new FormData();
        entryData.left = new FormAttachment(0, this.labelWidth + 5 + 6 + 2);
        entryData.top = prev == null ? new FormAttachment(0, 4) : new FormAttachment(prev, 4);
        if (button != null) {
            buttonData.right = new FormAttachment(100, 0);
            entryData.right = new FormAttachment(button, -5);
            buttonData.top = new FormAttachment(entry, 0, 0x1000000);
        } else {
            entryData.right = new FormAttachment(100, 0);
        }
        entryData.width = SWTUtil.getTextExtent((Drawable)entry, (String)"W").x * 30;
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(entry, 0);
        labelData.top = new FormAttachment(entry, 0, 0x1000000);
        label.setLayoutData((Object)labelData);
        entry.setLayoutData((Object)entryData);
        if (button != null) {
            button.setLayoutData((Object)buttonData);
        }
    }

    private void layoutUnderneath(Control top, Control bottom) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(top, 4);
        data.right = new FormAttachment(100, 0);
        bottom.setLayoutData((Object)data);
    }

    protected Control[] createText(Control prev, String labelText) {
        return this.createText(this, prev, labelText);
    }

    protected Control[] createText(Composite parent, Control prev, String labelText) {
        CLabel label = new CLabel(parent, 0);
        label.setText(labelText);
        Text text = new Text(parent, 18436);
        FormData textData = new FormData();
        FormData labelData = new FormData();
        textData.left = new FormAttachment(0, this.labelWidth + 5 + 6 + 2);
        textData.top = prev == null ? new FormAttachment(0, 4) : new FormAttachment(prev, 4);
        textData.right = new FormAttachment(100, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)text, 0);
        labelData.top = new FormAttachment((Control)text, 0, 0x1000000);
        text.setLayoutData((Object)textData);
        label.setLayoutData((Object)labelData);
        return new Control[]{label, text};
    }

    protected Table createNameValueTable(Control prev, String labelText) {
        ExecutablePropertyControl parent = this;
        CLabel label = new CLabel((Composite)parent, 0);
        label.setText(labelText);
        final Button addButton = new Button((Composite)parent, 8);
        addButton.setText("Add");
        Button removeButton = new Button((Composite)parent, 8);
        removeButton.setText("Delete");
        Table table = new Table((Composite)parent, 2048);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText("Name");
        TableColumn valueColumn = new TableColumn(table, 0);
        valueColumn.setText("Value");
        nameColumn.pack();
        valueColumn.pack();
        FormData labelData = new FormData();
        FormData tableData = new FormData();
        FormData addData = new FormData();
        FormData removeData = new FormData();
        tableData.height = table.getHeaderHeight() + 2 * table.getItemHeight();
        addData.width = removeButton.computeSize((int)-1, (int)-1).x;
        tableData.left = new FormAttachment(0, this.labelWidth + 5 + 6 + 2);
        tableData.top = prev == null ? new FormAttachment(0, 4) : new FormAttachment(prev, 4);
        addData.right = new FormAttachment(100, 0);
        removeData.right = new FormAttachment(100, 0);
        tableData.right = new FormAttachment((Control)removeButton, -5);
        addData.top = new FormAttachment((Control)table, 4, 128);
        removeData.top = new FormAttachment((Control)addButton, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment((Control)table, 0);
        labelData.top = new FormAttachment((Control)table, 0, 128);
        label.setLayoutData((Object)labelData);
        table.setLayoutData((Object)tableData);
        addButton.setLayoutData((Object)addData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvDialog ed = new EnvDialog(addButton.getShell(), "Create Environment Variable", null, null);
                if (ed.open() == 0) {
                    ExecutablePropertyControl.this.executable.addEnvVar(ed.getName(), ed.getValue());
                    ExecutablePropertyControl.this.refreshNameValueTable(ExecutablePropertyControl.this.envTable, ExecutablePropertyControl.this.executable.getEnv());
                }
            }
        });
        removeButton.setLayoutData((Object)removeData);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ExecutablePropertyControl.this.envTable.getSelection();
                if (items != null && items.length > 0 && items[0] != null) {
                    String name = items[0].getText(0);
                    ExecutablePropertyControl.this.executable.removeEnvVar(name);
                    ExecutablePropertyControl.this.refreshNameValueTable(ExecutablePropertyControl.this.envTable, ExecutablePropertyControl.this.executable.getEnv());
                }
            }
        });
        return table;
    }

    public Text getPathText() {
        return this.pathText;
    }

    public void setPathText(Text pathText) {
        this.pathText = pathText;
    }

    public Text getCwdText() {
        return this.cwdText;
    }

    public void setCwdText(Text cwdText) {
        this.cwdText = cwdText;
    }

    public void refresh() {
        this.refreshFilePath(this.pathText, this.executable == null ? null : this.executable.getFilename());
        this.refreshMultiProcess(this.executable == null ? null : this.executable.getMultiProcessProfile());
        this.refreshFilePath(this.cwdText, this.executable == null ? null : this.executable.getWorkingDir());
        this.refreshString(this.argsText, this.executable == null ? null : this.executable.getArgs());
        this.refreshNameValueTable(this.envTable, this.executable == null ? null : this.executable.getEnv());
    }

    private void refreshMultiProcess(IProfileMultiProcess newSelection) {
        int index;
        IProfileMultiProcess existing;
        if (newSelection != null && newSelection != (existing = (IProfileMultiProcess)this.multiProcessCombo.getElementAt(index = newSelection.getType().ordinal()))) {
            if (this.multiProcessComboListener != null) {
                this.multiProcessCombo.removeSelectionChangedListener(this.multiProcessComboListener);
            }
            this.multiProcessCombo.setElement(index, newSelection);
            this.multiProcessCombo.setSelection((ISelection)new StructuredSelection((Object)newSelection));
            if (newSelection instanceof ProfileMPIProcesses) {
                ProfileMPIProcesses mpi = (ProfileMPIProcesses)newSelection;
                this.mpiArgText.setText(mpi.getMPIArg() == null ? "" : mpi.getMPIArg());
                this.mpiLaunchText.setText(mpi.getMPILauncher() == null ? "" : mpi.getMPILauncher());
            }
            this.updateMultiProcessUI(newSelection);
            if (this.multiProcessComboListener != null) {
                this.multiProcessCombo.addSelectionChangedListener(this.multiProcessComboListener);
            }
        }
    }

    protected void refreshFilePath(Text text, String path) {
        text.setText(path == null ? "" : path);
    }

    protected void refreshString(Text text, String string) {
        text.setText(string == null ? "" : string);
    }

    protected void refreshNameValueTable(Table table, Map<String, String> nameValuePairs) {
        table.removeAll();
        if (nameValuePairs != null) {
            for (String name : nameValuePairs.keySet()) {
                String value = nameValuePairs.get(name);
                TableItem item = new TableItem(table, 0);
                item.setText(new String[]{name, value});
            }
        }
        this.revalidate();
    }

    private void manage(RemoteConnectionCombo connectionCombo) {
        IRemoteConnection newSelection = connectionCombo.manage();
        this.executable.setConnectionName(newSelection == null ? null : newSelection.getName());
    }

    private void editToolkit(Text text) {
        IRemoteConnection connection = this.connectionCombo.getSelection();
        if (connection != null) {
            RemoteConnectionToolkitWizard wizard = new RemoteConnectionToolkitWizard(connection);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    private String getMPICommand() {
        return String.valueOf(this.mpiLaunchText.getText()) + " " + this.mpiArgText.getText() + " " + this.pathText.getText() + " " + this.argsText.getText();
    }

    public void initConnection() {
        this.connectionCombo.initConnectionSelection();
    }

    public void setListener(ExecutablePropertySection.MultiProcessSettingListener multiProcessSettingListener) {
        this.multiProcessSettingListener = multiProcessSettingListener;
    }

    private final class ValidationTrigger
    extends AbstractObservableValue {
        private Class<?> valueType;

        public ValidationTrigger(Class<?> type) {
            this.valueType = type;
        }

        public Object getValueType() {
            return this.valueType;
        }

        protected Object doGetValue() {
            return null;
        }

        protected void doSetValue(Object value) {
            ExecutablePropertyControl.this.revalidate();
        }
    }

    private final class ValidatorRunnable
    implements Runnable {
        private final FileSystem system;
        private final String executablePath;
        private final String cwd;
        private final String mpiLauncher;
        private final boolean customScript;

        private ValidatorRunnable(FileSystem system, String executablePath, String cwd, String mpiLauncher, boolean customScript) {
            this.system = system;
            this.executablePath = executablePath;
            this.cwd = cwd;
            this.mpiLauncher = mpiLauncher;
            this.customScript = customScript;
        }

        @Override
        public void run() {
            if (ExecutablePropertyControl.this.runnable.get() == this) {
                final IStatus status = ExecutablePropertyControl.this.validateValues(this.executablePath, this.cwd, this.mpiLauncher, this.customScript, this.system);
                if (ExecutablePropertyControl.this.runnable.get() == this) {
                    ExecutablePropertyControl.this.pathText.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ExecutablePropertyControl.this.runnable.get() == ValidatorRunnable.this) {
                                ExecutablePropertyControl.this.setValidationStatus(status);
                                ExecutablePropertyControl.this.runnable.set(null);
                            }
                        }
                    });
                }
            }
        }
    }
}

