/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.properties;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.expert.ExpertCheckStateProvider;
import com.nvidia.viper.expert.ExpertEventContentProvider;
import com.nvidia.viper.expert.ExpertLabelProvider;
import com.nvidia.viper.expert.ExpertMetricContentProvider;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.EventCategory;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.IProfilingData;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.MetricAggregate;
import com.nvidia.viper.model.MetricCategory;
import com.nvidia.viper.model.Session;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ExpertPropertyDialog
extends TitleAreaDialog {
    public static final int APPLY_AND_RUN = 1024;
    private static int rememberedDevice = -1;
    private static int rememberedTab = -1;
    private final IDevicesData deviceData;
    private final Session session;
    private Combo deviceCombo;
    private CheckboxTreeViewer eventTreeViewer;
    private CheckboxTreeViewer metricTreeViewer;
    private Button applyAndRunButton;
    private final Map<String, Collection<Metric>> metrics = new HashMap<String, Collection<Metric>>();
    private final Map<String, Collection<Event>> events = new HashMap<String, Collection<Event>>();
    private TabFolder tabFolder;

    public ExpertPropertyDialog(Shell shell, Session session, IDevicesData deviceData) {
        super(shell);
        this.session = session;
        this.deviceData = deviceData;
        Expert expert = session.getExpert();
        String[] stringArray = deviceData.getDeviceTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String deviceType = stringArray[n2];
            HashSet<Metric> mSet = new HashSet<Metric>();
            HashSet<Event> eSet = new HashSet<Event>();
            this.metrics.put(deviceType, mSet);
            this.events.put(deviceType, eSet);
            for (IProfilingData metric : expert.getEnabledEventsMetrics(deviceType, null, IProfilingData.Kind.aggregate_metric)) {
                if (metric instanceof MetricAggregate) {
                    mSet.add(((MetricAggregate)metric).getMetric());
                    continue;
                }
                ViperExceptionHandler.logError("expected MetricAggregate for Kind.aggregate_metric");
            }
            for (IProfilingData event : expert.getEnabledEventsMetrics(deviceType, null, IProfilingData.Kind.event)) {
                if (event instanceof Event) {
                    eSet.add((Event)event);
                    continue;
                }
                ViperExceptionHandler.logError("expected Event for Kind.event");
            }
            ++n2;
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x80 | 0x400);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Metrics and Events");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection("metricsevents");
        if (section == null) {
            section = settings.addNewSection("metricsevents");
        }
        return section;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Metrics and Events");
        this.setMessage("Select metrics and events to be collected on individual devices");
        Composite pane = (Composite)super.createDialogArea(parent);
        Composite form = new Composite(pane, 0);
        GridData formData = new GridData(1808);
        formData.heightHint = 500;
        form.setLayoutData((Object)formData);
        form.setLayout((Layout)new GridLayout(2, false));
        new Label(form, 0).setText("Device:");
        this.deviceCombo = new Combo(form, 12);
        this.deviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpertPropertyDialog.this.refreshEventTree(ExpertPropertyDialog.this.getActiveDeviceDescriptor());
                ExpertPropertyDialog.this.refreshMetricTree(ExpertPropertyDialog.this.getActiveDeviceDescriptor());
            }
        });
        this.refreshDeviceCombo();
        this.tabFolder = new TabFolder(form, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TabItem metricTab = new TabItem(this.tabFolder, 0);
        metricTab.setText("Metrics");
        this.metricTreeViewer = new CheckboxTreeViewer((Composite)this.tabFolder);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.metricTreeViewer);
        this.metricTreeViewer.setContentProvider((IContentProvider)new ExpertMetricContentProvider(this.deviceData));
        this.metricTreeViewer.setLabelProvider((IBaseLabelProvider)new ExpertLabelProvider());
        this.metricTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent csevent) {
                Object element = csevent.getElement();
                boolean checked = csevent.getChecked();
                Collection metricList = (Collection)ExpertPropertyDialog.this.metrics.get(ExpertPropertyDialog.this.getActiveDeviceDescriptor());
                ExpertPropertyDialog.this.metricTreeViewer.setSubtreeChecked(csevent.getElement(), csevent.getChecked());
                if (element instanceof MetricCategory) {
                    Set<Metric> set = ((MetricCategory)element).getAggregateMetrics();
                    if (checked) {
                        metricList.addAll(set);
                    } else {
                        metricList.removeAll(set);
                    }
                } else if (checked) {
                    metricList.add((Metric)element);
                } else {
                    metricList.remove(element);
                }
                ExpertPropertyDialog.this.metricTreeViewer.refresh();
                ExpertPropertyDialog.this.updateApplyAndRunButton();
            }
        });
        metricTab.setControl(this.metricTreeViewer.getControl());
        TabItem eventTab = new TabItem(this.tabFolder, 0);
        eventTab.setText("Events");
        this.eventTreeViewer = new CheckboxTreeViewer((Composite)this.tabFolder);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.eventTreeViewer);
        this.eventTreeViewer.setContentProvider((IContentProvider)new ExpertEventContentProvider(this.deviceData));
        this.eventTreeViewer.setLabelProvider((IBaseLabelProvider)new ExpertLabelProvider());
        this.eventTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent csevent) {
                Object element = csevent.getElement();
                boolean checked = csevent.getChecked();
                Collection eventList = (Collection)ExpertPropertyDialog.this.events.get(ExpertPropertyDialog.this.getActiveDeviceDescriptor());
                ExpertPropertyDialog.this.eventTreeViewer.setSubtreeChecked(element, checked);
                if (element instanceof EventCategory) {
                    Set<Event> set = ((EventCategory)element).getEvents();
                    if (checked) {
                        eventList.addAll(set);
                    } else {
                        eventList.removeAll(set);
                    }
                } else if (checked) {
                    eventList.add((Event)element);
                } else {
                    eventList.remove(element);
                }
                ExpertPropertyDialog.this.eventTreeViewer.refresh();
                ExpertPropertyDialog.this.updateApplyAndRunButton();
            }
        });
        eventTab.setControl(this.eventTreeViewer.getControl());
        if (rememberedDevice >= 0) {
            this.deviceCombo.select(rememberedDevice);
        }
        if (rememberedTab >= 0) {
            this.tabFolder.setSelection(rememberedTab);
        }
        this.refreshEventTree(this.getActiveDeviceDescriptor());
        this.refreshMetricTree(this.getActiveDeviceDescriptor());
        ViperHelp.setContextHelp((Control)parent, ViperHelp.SETTINGS_VIEW_CONTEXT_ID);
        return pane;
    }

    protected void refreshDeviceCombo() {
        this.deviceCombo.removeAll();
        this.deviceCombo.setEnabled(false);
        this.deviceCombo.setItems(this.deviceData.getDeviceTypes());
        this.deviceCombo.setEnabled(true);
        this.deviceCombo.select(0);
    }

    protected void refreshEventTree(String deviceType) {
        this.eventTreeViewer.getTree().setEnabled(deviceType != null);
        this.eventTreeViewer.setInput((Object)deviceType);
        this.eventTreeViewer.expandAll();
        this.eventTreeViewer.setCheckStateProvider((ICheckStateProvider)new ExpertCheckStateProvider(this.events.get(deviceType)));
    }

    protected void refreshMetricTree(String deviceType) {
        this.metricTreeViewer.getTree().setEnabled(deviceType != null);
        this.metricTreeViewer.setInput((Object)deviceType);
        this.metricTreeViewer.expandAll();
        this.metricTreeViewer.setCheckStateProvider((ICheckStateProvider)new ExpertCheckStateProvider(this.metrics.get(deviceType)));
    }

    protected String getActiveDeviceDescriptor() {
        String activeDeviceName = this.deviceCombo.getText();
        if (activeDeviceName == null || activeDeviceName.isEmpty()) {
            return null;
        }
        return activeDeviceName;
    }

    private boolean updateApplyAndRunButton() {
        boolean enable = false;
        for (Collection<Metric> collection : this.metrics.values()) {
            if (!(collection != null & !collection.isEmpty())) continue;
            enable = true;
        }
        for (Collection<Comparable<Metric>> collection : this.events.values()) {
            if (!(collection != null & !collection.isEmpty())) continue;
            enable = true;
        }
        this.applyAndRunButton.setEnabled(enable);
        return enable;
    }

    private boolean apply() {
        Expert expert = this.session.getExpert();
        boolean dirty = false;
        String[] stringArray = this.deviceData.getDeviceTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String deviceType = stringArray[n2];
            Set<IProfilingData> sessionEventsMetrics = expert.getEnabledEventsMetrics(deviceType, null);
            HashSet<Comparable<MetricAggregate>> newEventsMetrics = new HashSet<Comparable<MetricAggregate>>(this.metrics.get(deviceType).size() + this.events.get(deviceType).size());
            for (Metric metric : this.metrics.get(deviceType)) {
                newEventsMetrics.add(new MetricAggregate(metric));
            }
            newEventsMetrics.addAll(this.events.get(deviceType));
            dirty |= !sessionEventsMetrics.equals(newEventsMetrics);
            expert.disableAll(deviceType, null, sessionEventsMetrics);
            expert.enableAll(deviceType, null, newEventsMetrics);
            ++n2;
        }
        if (dirty) {
            this.session.setDirty(dirty);
        }
        return dirty;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.apply();
            this.setReturnCode(1024);
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.apply();
        super.okPressed();
    }

    public boolean close() {
        rememberedDevice = this.deviceCombo.getSelectionIndex();
        rememberedTab = this.tabFolder.getSelectionIndex();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.applyAndRunButton = this.createButton(parent, 1024, "Apply and Run", false);
        this.updateApplyAndRunButton();
        super.createButtonsForButtonBar(parent);
    }
}

