/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalOverhead;
import com.nvidia.viper.model.TimelineKind;
import java.util.List;

public class TimelineOverhead
extends Timeline
implements IModel {
    private long minTime = -1L;
    private long maxTime = 0L;
    private long averageTime = 0L;
    private long totalTime;
    private int compilerOverhead = 0;
    private int bufferOverhead = 0;
    private int instrumentationOverhead = 0;
    private int resourceOverhead = 0;
    private boolean isInit = false;

    public TimelineOverhead(String name, TimelineKind kind) {
        super(name, kind);
    }

    private void init() {
        if (!this.isInit) {
            List<ITimelineInterval> intervals = this.getIntervals(true);
            this.totalTime = 0L;
            for (ITimelineInterval interval : intervals) {
                long duration = interval.getDuration();
                if (this.minTime < 0L || duration < this.minTime) {
                    this.minTime = duration;
                } else if (duration > this.maxTime) {
                    this.maxTime = duration;
                }
                this.totalTime += duration;
                TimelineIntervalOverhead intervalOverhead = (TimelineIntervalOverhead)interval;
                switch (intervalOverhead.activity.getOverheadKind()) {
                    case CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER: {
                        ++this.compilerOverhead;
                        break;
                    }
                    case CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH: {
                        ++this.bufferOverhead;
                        break;
                    }
                    case CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION: {
                        ++this.instrumentationOverhead;
                        break;
                    }
                    case CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE: {
                        ++this.resourceOverhead;
                    }
                }
            }
            this.averageTime = this.totalTime / (long)intervals.size();
            this.isInit = true;
        }
    }

    @Override
    public long getTotalTime() {
        this.init();
        return this.totalTime;
    }

    public long getMinTime() {
        this.init();
        return this.minTime;
    }

    public long getMaxTime() {
        this.init();
        return this.maxTime;
    }

    public long getAverageTime() {
        this.init();
        return this.averageTime;
    }

    public int getCompilerOverhead() {
        this.init();
        return this.compilerOverhead;
    }

    public int getActivityBufferFlushOverhead() {
        this.init();
        return this.bufferOverhead;
    }

    public int getCuptiInstrumentationOverhead() {
        this.init();
        return this.instrumentationOverhead;
    }

    public int getCuptiResourceOverhead() {
        this.init();
        return this.resourceOverhead;
    }
}

