/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineKind;

public class TimelineMemcpy
extends Timeline
implements IModel {
    private long totalExecTime;
    private long totalBytes = 0L;

    public TimelineMemcpy(String name, TimelineKind kind) {
        super(name, kind);
    }

    public long getTotalExecTime() {
        return this.totalExecTime;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void prepareInterval(long id, long start, long end, long bytes) {
        this.totalExecTime += end - start;
        if (bytes > 0L) {
            this.totalBytes += bytes;
        }
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        for (ITimelineInterval interval : this.getIntervals(true)) {
            TimelineIntervalMemcpy intervalMemcpy = (TimelineIntervalMemcpy)interval;
            if (intervalMemcpy.isP2PMemcopy()) {
                TimelineDevice deviceTl = (TimelineDevice)this.getAncestor(TimelineKind.DEVICE);
                if (deviceTl.getId() != intervalMemcpy.getSourceDeviceId()) continue;
                interval.appendToPDM(pdm);
                continue;
            }
            interval.appendToPDM(pdm);
        }
    }
}

