/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.common.util.XmlUtil;
import com.nvidia.viper.EventManager;
import com.nvidia.viper.MetricManager;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.IProfilingData;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.MetricAggregate;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.TimelineIntervalKernel;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.gef.Disposable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Expert
extends ModelWithProperties
implements IModel,
ISessionSerializable,
Disposable {
    public static final String PROPERTY_COLUMNORDER = "expert:corder";
    public static final String PROPERTY_COLUMNPROP = "expert:cprop";
    public static final ITimelineInterval NULL_INTERVAL = new TimelineIntervalKernel(null);
    private ConcurrentMap<String, ConcurrentMap<ITimelineInterval, Set<IProfilingData>>> enabledEventsMetrics = new ConcurrentHashMap<String, ConcurrentMap<ITimelineInterval, Set<IProfilingData>>>();
    private ColumnOrder columnOrder = new ColumnOrder();
    private Map<ColumnId, ColumnProperties> columnPropertyMap = new HashMap<ColumnId, ColumnProperties>();

    public Expert() {
    }

    public Expert(Element el) throws ViperException {
        this();
        this.read(el);
    }

    public void dispose() {
    }

    public boolean isEnabled(String deviceName, ITimelineInterval interval, IProfilingData data) {
        ITimelineInterval key;
        Set intervalData;
        Map deviceData = (Map)this.enabledEventsMetrics.get(deviceName);
        if (deviceData != null && (intervalData = (Set)deviceData.get(key = interval != null ? interval : NULL_INTERVAL)) != null) {
            return intervalData.contains(data);
        }
        return false;
    }

    public void enable(String deviceName, ITimelineInterval interval, IProfilingData event) {
        this.getIntervalData(deviceName, interval, true).add(event);
    }

    private Set<IProfilingData> getIntervalData(String device, ITimelineInterval interval, boolean create) {
        ITimelineInterval key;
        HashSet data;
        ConcurrentHashMap deviceData = (ConcurrentHashMap)this.enabledEventsMetrics.get(device);
        if (deviceData == null) {
            if (create) {
                deviceData = new ConcurrentHashMap();
                this.enabledEventsMetrics.putIfAbsent(device, deviceData);
            } else {
                return null;
            }
        }
        if ((data = (HashSet)deviceData.get(key = interval == null ? NULL_INTERVAL : interval)) == null && create) {
            data = new HashSet();
            deviceData.putIfAbsent(key, data);
        }
        return data;
    }

    public void disable(String deviceName, ITimelineInterval interval, IProfilingData event) {
        Set<IProfilingData> set = this.getIntervalData(deviceName, interval, false);
        if (set != null) {
            set.remove(event);
        }
    }

    public void enableAll(String deviceName, ITimelineInterval interval, Set<? extends IProfilingData> events) {
        this.getIntervalData(deviceName, interval, true).addAll(events);
    }

    public void disableAll(String deviceName, ITimelineInterval interval, Set<? extends IProfilingData> eventsMetrics) {
        Set<IProfilingData> set = this.getIntervalData(deviceName, interval, false);
        if (set != null) {
            set.removeAll(eventsMetrics);
        }
    }

    public Map<ITimelineInterval, Set<IProfilingData>> getAllEnabledEventsMetrics(String deviceName) {
        ConcurrentMap data = (ConcurrentMap)this.enabledEventsMetrics.get(deviceName);
        if (data == null) {
            return Collections.emptyMap();
        }
        Iterator i = data.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!((Set)entry.getValue()).isEmpty()) continue;
            i.remove();
        }
        return data;
    }

    public Set<IProfilingData> getEnabledEventsMetrics(String deviceName, ITimelineInterval interval) {
        Map<ITimelineInterval, Set<IProfilingData>> eventsMetrics = this.getAllEnabledEventsMetrics(deviceName);
        Set<IProfilingData> set = eventsMetrics.get(interval == null ? NULL_INTERVAL : interval);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Collection<IProfilingData> getEnabledEventsMetrics(String deviceName, ITimelineInterval interval, IProfilingData.Kind kind) {
        Set<IProfilingData> eventsMetrics = this.getEnabledEventsMetrics(deviceName, interval);
        if (!eventsMetrics.isEmpty()) {
            HashSet<IProfilingData> set = new HashSet<IProfilingData>();
            for (IProfilingData data : eventsMetrics) {
                if (data.getProfileDataKind() != kind) continue;
                set.add(data);
            }
            return set;
        }
        return eventsMetrics;
    }

    public ColumnOrder getColumnOrder() {
        return this.columnOrder;
    }

    public void setColumnOrder(ColumnOrder order) {
        if (!this.columnOrder.equals(order)) {
            this.columnOrder = order;
            this.firePropertyChange(PROPERTY_COLUMNORDER);
        }
    }

    public ColumnProperties getColumnProperties(String kind, String label) {
        ColumnId propsId = new ColumnId(kind, label);
        ColumnProperties props = this.columnPropertyMap.get(propsId);
        if (props == null) {
            props = new ColumnProperties();
            this.columnPropertyMap.put(propsId, props);
        }
        return new ColumnProperties(props);
    }

    public void setColumnProperties(String kind, String label, ColumnProperties props) {
        ColumnId propsId = new ColumnId(kind, label);
        ColumnProperties curr = this.columnPropertyMap.get(propsId);
        if (props == null && curr != null || props != null && !props.equals(curr)) {
            if (props == null) {
                this.columnPropertyMap.remove(propsId);
            } else {
                this.columnPropertyMap.put(propsId, props);
            }
            this.firePropertyChange(PROPERTY_COLUMNPROP);
        }
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<expert>");
            for (Map.Entry deviceData : this.enabledEventsMetrics.entrySet()) {
                Set set = (Set)((ConcurrentMap)deviceData.getValue()).get(NULL_INTERVAL);
                if (set == null || set.isEmpty()) continue;
                boolean hasEvents = false;
                boolean hasMetrics = false;
                StringBuilder eventsXml = new StringBuilder();
                StringBuilder metricsXml = new StringBuilder();
                for (IProfilingData data : set) {
                    switch (data.getProfileDataKind()) {
                        case event: {
                            hasEvents = true;
                            Event event = (Event)data;
                            eventsXml.append("<event domain=\"");
                            eventsXml.append(event.getDomain());
                            eventsXml.append("\" id=\"").append(event.getId());
                            eventsXml.append("\"/>");
                            break;
                        }
                        case aggregate_metric: {
                            hasMetrics = true;
                            Metric metric = ((MetricAggregate)data).getMetric();
                            metricsXml.append("<metric id=\"");
                            metricsXml.append(metric.getId()).append("\"/>");
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(data.getProfileDataKind().name());
                        }
                    }
                }
                if (!hasEvents && !hasMetrics) continue;
                w.write("<device name=\"" + XmlUtil.escapeString((String)((String)deviceData.getKey())) + "\">");
                if (hasEvents) {
                    w.write("<enabledevents>");
                    w.write(eventsXml.toString());
                    w.write("</enabledevents>");
                }
                if (hasMetrics) {
                    w.write("<enabledmetrics>");
                    w.write(metricsXml.toString());
                    w.write("</enabledmetrics>");
                }
                w.write("</device>");
            }
            if (!this.columnPropertyMap.isEmpty()) {
                w.write("<columnprops>");
                for (ColumnId id : this.columnPropertyMap.keySet()) {
                    ColumnProperties props = this.columnPropertyMap.get(id);
                    if (props.getWidth() == null) continue;
                    w.write("<column");
                    if (id.kind != null) {
                        w.write(" kind=\"" + XmlUtil.escapeString((String)id.kind) + "\"");
                    }
                    if (id.label != null) {
                        w.write(" label=\"" + XmlUtil.escapeString((String)id.label) + "\"");
                    }
                    w.write(" width=\"" + props.getWidth() + "\"");
                    w.write("/>");
                }
                w.write("</columnprops>\n");
            }
            this.columnOrder.write(w);
            w.write("</expert>\n");
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }

    protected void read(Element el) throws ViperException {
        if (!"expert".equals(el.getTagName())) {
            throw new ViperException("expected \"expert\" tag, got " + el.getTagName());
        }
        NodeList deviceList = el.getElementsByTagName("device");
        int d = 0;
        while (d < deviceList.getLength()) {
            Element deviceElement = (Element)deviceList.item(d);
            if (!"device".equals(deviceElement.getTagName())) {
                throw new ViperException("expected \"device\" tag, got " + deviceElement.getTagName());
            }
            String deviceName = StringUtils.emptyToNull(deviceElement.getAttribute("name"));
            if (deviceName == null) {
                throw new ViperException("expected \"device\" tag to have \"name\" attribute");
            }
            NodeList eventList = deviceElement.getElementsByTagName("event");
            int e = 0;
            while (e < eventList.getLength()) {
                int id;
                Element eventElement = (Element)eventList.item(e);
                if (!"event".equals(eventElement.getTagName())) {
                    throw new ViperException("expected \"event\" tag, got " + eventElement.getTagName());
                }
                String eventDomainStr = StringUtils.emptyToNull(eventElement.getAttribute("domain"));
                String eventIdStr = StringUtils.emptyToNull(eventElement.getAttribute("id"));
                if (eventDomainStr == null || eventIdStr == null) {
                    throw new ViperException("expected \"event\" tag to have \"domain\" and \"id\" attributes");
                }
                int domain = Integer.parseInt(eventDomainStr);
                Event event = EventManager.getEvent(domain, id = Integer.parseInt(eventIdStr));
                if (event == null) {
                    throw new ViperException("can't find event " + domain + " / " + id + " for device \"" + deviceName + "\"");
                }
                this.enable(deviceName, null, event);
                ++e;
            }
            NodeList metricList = deviceElement.getElementsByTagName("metric");
            int e2 = 0;
            while (e2 < metricList.getLength()) {
                Element metricElement = (Element)metricList.item(e2);
                if (!"metric".equals(metricElement.getTagName())) {
                    throw new ViperException("expected \"metric\" tag, got " + metricElement.getTagName());
                }
                String metricIdStr = StringUtils.emptyToNull(metricElement.getAttribute("id"));
                if (metricIdStr == null) {
                    throw new ViperException("expected \"metric\" tag to have \"id\" attribute");
                }
                int id = Integer.parseInt(metricIdStr);
                Metric metric = MetricManager.getMetric(id);
                if (metric == null) {
                    throw new ViperException("can't find metric " + id + " for device \"" + deviceName + "\"");
                }
                this.enable(deviceName, null, new MetricAggregate(metric));
                ++e2;
            }
            ++d;
        }
        NodeList propList = el.getElementsByTagName("columnprops");
        if (propList.getLength() > 1) {
            ViperExceptionHandler.logError("expected 0 or 1 columnprops tags, got " + propList.getLength());
        } else if (propList.getLength() == 1) {
            Element propElement = (Element)propList.item(0);
            if (!"columnprops".equals(propElement.getTagName())) {
                throw new ViperException("expected \"columnprops\" tag, got " + propElement.getTagName());
            }
            NodeList columnList = propElement.getElementsByTagName("column");
            int i = 0;
            while (i < columnList.getLength()) {
                Element columnElement = (Element)columnList.item(i);
                if (!"column".equals(columnElement.getTagName())) {
                    throw new ViperException("expected \"column\" tag, got " + columnElement.getTagName());
                }
                String kind = StringUtils.emptyToNull(columnElement.getAttribute("kind"));
                String label = StringUtils.emptyToNull(columnElement.getAttribute("label"));
                if (kind != null || label != null) {
                    ColumnId id = new ColumnId(kind, label);
                    String width = StringUtils.emptyToNull(columnElement.getAttribute("width"));
                    if (width != null) {
                        ColumnProperties props = new ColumnProperties();
                        props.setWidth(Integer.parseInt(width));
                        this.columnPropertyMap.put(id, props);
                    }
                }
                ++i;
            }
        }
        this.columnOrder.read(el);
    }

    public boolean isEmpty() {
        this.enabledEventsMetrics.entrySet();
        Iterator i = this.enabledEventsMetrics.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Set entrySet = ((ConcurrentMap)entry.getValue()).entrySet();
            Iterator j = entrySet.iterator();
            while (j.hasNext()) {
                Map.Entry ent = j.next();
                if (((Set)ent.getValue()).isEmpty()) {
                    j.remove();
                    continue;
                }
                return false;
            }
            i.remove();
        }
        return true;
    }

    public static class ColumnId {
        public String kind;
        public String label;

        public ColumnId(String kind, String label) {
            this.kind = kind;
            this.label = label;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColumnId)) {
                return false;
            }
            ColumnId other = (ColumnId)obj;
            return StringUtils.equals(this.kind, other.kind) && StringUtils.equals(this.label, other.label);
        }

        public int hashCode() {
            return this.kind.hashCode() + (this.label == null ? 0 : this.label.hashCode());
        }

        public String toString() {
            return "[ColumnId " + this.kind + (this.label == null ? "" : " " + this.label) + "]";
        }
    }

    public static class ColumnOrder {
        public Vector<ColumnId> ids = new Vector();

        public void add(String kind, String label) {
            this.ids.add(new ColumnId(kind, label));
        }

        public void add(ColumnId id) {
            this.ids.add(id);
        }

        public int getSize() {
            return this.ids.size();
        }

        public String getKind(int i) {
            try {
                return this.ids.get((int)i).kind;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        public String getLabel(int i) {
            try {
                return this.ids.get((int)i).label;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        public void read(Element el) throws ViperException {
            NodeList orderList = el.getElementsByTagName("columnorder");
            if (orderList.getLength() > 1) {
                ViperExceptionHandler.logError("expected 0 or 1 columnorder tags, got " + orderList.getLength());
            } else if (orderList.getLength() == 1) {
                Element orderElement = (Element)orderList.item(0);
                if (!"columnorder".equals(orderElement.getTagName())) {
                    throw new ViperException("expected \"columnorder\" tag, got " + orderElement.getTagName());
                }
                NodeList columnList = orderElement.getElementsByTagName("column");
                int i = 0;
                while (i < columnList.getLength()) {
                    Element columnElement = (Element)columnList.item(i);
                    if (!"column".equals(columnElement.getTagName())) {
                        throw new ViperException("expected \"column\" tag, got " + columnElement.getTagName());
                    }
                    String kind = StringUtils.emptyToNull(columnElement.getAttribute("kind"));
                    String label = StringUtils.emptyToNull(columnElement.getAttribute("label"));
                    if (kind != null || label != null) {
                        this.add(kind, label);
                    }
                    ++i;
                }
            }
        }

        public void write(Writer w) throws IOException {
            if (!this.ids.isEmpty()) {
                w.write("<columnorder>");
                int i = 0;
                while (i < this.ids.size()) {
                    String kind = this.getKind(i);
                    String label = this.getLabel(i);
                    if (kind != null || label != null) {
                        w.write("<column");
                        if (kind != null) {
                            w.write(" kind=\"" + XmlUtil.escapeString((String)kind) + "\"");
                        }
                        if (label != null) {
                            w.write(" label=\"" + XmlUtil.escapeString((String)label) + "\"");
                        }
                        w.write("/>");
                    }
                    ++i;
                }
                w.write("</columnorder>\n");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColumnOrder)) {
                return false;
            }
            ColumnOrder other = (ColumnOrder)obj;
            if (this.ids.size() != other.ids.size()) {
                return false;
            }
            int i = 0;
            while (i < this.ids.size()) {
                if (!this.ids.get(i).equals(other.ids.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class ColumnProperties {
        public Integer width;

        public ColumnProperties() {
            this.width = null;
        }

        public ColumnProperties(ColumnProperties props) {
            this.width = props.width;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColumnProperties)) {
                return false;
            }
            ColumnProperties other = (ColumnProperties)obj;
            return this.width == other.width || this.width != null && this.width.equals(other.width);
        }
    }
}

