/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiActivitySharedAccess;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultSharedAccess;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import java.util.List;

public class KernelInstanceSharedAccessAnalysis
extends AnalysisBase {
    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        Analysis analysis = session.getAnalysis();
        if (analysis != null) {
            TimelineIntervalKernel interval = AnalysisStage.getHostLaunchedKernel(analysis.getActiveScopeInterval());
            if (interval == null || generateAllResults) {
                results.add(new AnalysisResult(AnalysisDescriptor.SL_SHAREDACCESS_NO_KERNEL));
            }
            if (interval instanceof TimelineIntervalKernel) {
                TimelineIntervalKernel kernel = interval;
                int totalResults = 0;
                int droppedResults = 0;
                AnalysisResultSharedAccess sma = new AnalysisResultSharedAccess(session, kernel, AnalysisDescriptor.SL_SHAREDACCESS_BAD);
                for (ICuptiActivitySourceLevelResult result : kernel.getSourceLevelResults()) {
                    if (!(result instanceof CuptiActivitySharedAccess)) continue;
                    ++totalResults;
                    ret = true;
                    if (sma.addResult(result)) continue;
                    ++droppedResults;
                }
                if (!sma.getMarkerSourceLevelResults().isEmpty() || generateAllResults) {
                    results.add(sma);
                    if (droppedResults > 0 || generateAllResults) {
                        AnalysisDescriptor desc = droppedResults == totalResults ? AnalysisDescriptor.SL_SHAREDACCESS_NO_SOURCE : AnalysisDescriptor.SL_SHAREDACCESS_FEW_SOURCE;
                        results.add(new AnalysisResult(desc));
                    }
                }
                if (totalResults <= 0 || generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.SL_SHAREDACCESS_NO_DATA));
                }
            }
        }
        return ret;
    }
}

