/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiActivityNvLink;
import com.nvidia.viper.activity.CuptiDevType;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.NVLinkGraphicsFactory;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;

public class AnalysisResultNVLink
extends AnalysisResult {
    private Set<CuptiActivityNvLink> nvLinks = null;
    private Map<Integer, Rectangle> deviceRectMap = new HashMap<Integer, Rectangle>();

    public AnalysisResultNVLink(AnalysisDescriptor desc) {
        super(desc);
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new NVLinkGraphicsFactory();
    }

    public void setLinks(Set<CuptiActivityNvLink> nvLinks) {
        this.nvLinks = nvLinks;
    }

    public Set<CuptiActivityNvLink> getLinks() {
        return this.nvLinks;
    }

    public void setBoxRectangle(int deviceId, Rectangle rect) {
        this.deviceRectMap.put(deviceId, rect);
    }

    public Rectangle getBoxRectangle(int deviceId) {
        if (this.deviceRectMap.containsKey(deviceId)) {
            return this.deviceRectMap.get(deviceId);
        }
        return new Rectangle(-1, -1, -1, -1);
    }

    public boolean needRestore() {
        return !this.deviceRectMap.isEmpty();
    }

    private static int getNpuIdFromGpu(byte[] gpuUuid, Set<CuptiActivityNvLink> linkRecords) {
        for (CuptiActivityNvLink link : linkRecords) {
            if (link.typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode() && Arrays.equals(link.uuidDev1, gpuUuid)) {
                return link.domainNPU0;
            }
            if (link.typeDev1 != CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode() || !Arrays.equals(link.uuidDev0, gpuUuid)) continue;
            return link.domainNPU1;
        }
        return -1;
    }

    public static boolean isDirectLink(int typeDev0, int typeDev1, byte[] uuid0, byte[] uuid1, Set<CuptiActivityNvLink> linkRecords) {
        if (typeDev0 == CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode() || typeDev1 == CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode()) {
            return true;
        }
        boolean isDirect = AnalysisResultNVLink.getNpuIdFromGpu(uuid0, linkRecords) == AnalysisResultNVLink.getNpuIdFromGpu(uuid1, linkRecords);
        return isDirect;
    }
}

