/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.analysis.PerSMAchievedGraphicFactory;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.AnalysisResultGraphicFactory;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class AnalysisResultKernelAchievedOccupancy
extends AnalysisResult {
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private final TimelineDevice device;
    private final TimelineIntervalKernel kernel;
    private final double avgAchievedOccupancy;
    private final Double[] smActivity;

    static {
        percentFormatter.setMaximumFractionDigits(1);
        percentFormatter.setGroupingUsed(false);
    }

    public AnalysisResultKernelAchievedOccupancy(AnalysisDescriptor desc, TimelineDevice device, TimelineIntervalKernel kernel, double avgAchievedOccupancy, Metric perSmActivityMetric) {
        super(desc);
        List<CuptiActivityMetric> perSmActivity;
        this.device = device;
        this.kernel = kernel;
        this.avgAchievedOccupancy = avgAchievedOccupancy;
        Double[] lsmActivity = null;
        if (perSmActivityMetric != null && (perSmActivity = kernel.getInstanceMetricActivities(perSmActivityMetric)) != null && device.getNumMultiprocessors() == perSmActivity.size()) {
            lsmActivity = new Double[perSmActivity.size()];
            for (CuptiActivityMetric metric : perSmActivity) {
                lsmActivity[metric.getInstance()] = (Double)metric.getValue();
            }
        }
        this.smActivity = lsmActivity;
    }

    public Double[] getSMActivity() {
        return this.smActivity;
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = super.getDescription(otpt);
        if (AnalysisDescriptor.KERNEL_LATENCY_BAD_ACHIEVED.equals((Object)this.getDescriptor())) {
            desc = String.valueOf(ViperMessages.ExpertSystem_Latency_DescOccupancy) + " " + desc;
        }
        desc = desc.replace("%ACHIEVED%", percentFormatter.format(this.avgAchievedOccupancy));
        OccupancyCalculator oc = new OccupancyCalculator(this.kernel, this.device);
        double theoretical = oc.getTheoreticOccupancy();
        desc = desc.replace("%THEORETICAL%", percentFormatter.format(theoretical));
        return desc;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        if (this.getSMActivity() != null) {
            return new PerSMAchievedGraphicFactory();
        }
        return new AnalysisResultGraphicFactory();
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.OCCUPANCY);
            }
        };
    }
}

