/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.ActiveEditorAction;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CloneSessionAction
extends ActiveEditorAction {
    public CloneSessionAction(IWorkbenchWindow window) {
        super(ViperMessages.CloneSession_Label, window);
        this.setToolTipText(ViperMessages.CloneSession_Tooltip);
        this.setId("com.nvidia.viper.sessionclone");
        this.setActionDefinitionId("com.nvidia.viper.command.clonesession");
    }

    public void run() {
        super.run();
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SessionEditor editor = (SessionEditor)activePage.getActiveEditor();
            Session currSession = editor.getSession();
            Session newSession = currSession.cloneSession();
            editor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(newSession), "com.nvidia.viper.sessioneditor");
            editor.scaleToFit();
            editor.setDirty(true);
            newSession.setDirty(true);
        }
        catch (Exception e2) {
            ViperException e2;
            if (!(e2 instanceof ViperException)) {
                e2 = new ViperException(e2);
            }
            ViperExceptionHandler.handle(ViperMessages.Clone_Fail_Title, ViperMessages.Clone_Fail_Message, e2);
        }
    }

    @Override
    protected void updateState() {
        super.updateState();
        this.setEnabled(this.getActiveEditor() != null && this.getActiveEditor() instanceof SessionEditor);
    }
}

