/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets.services;

import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.Property;
import org.eclipse.rse.internal.ui.view.SystemComboBoxPropertyDescriptor;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class PropertyElement {
    private IPropertyDescriptor _propertyDescriptor;
    private IProperty _property;
    private IProperty _originalProperty;
    private String _value;

    public PropertyElement(ServiceElement parent, IProperty property) {
        this._property = property;
        this._originalProperty = new Property(this._property);
        this._value = this._property.getValue();
    }

    public IPropertyType getType() {
        return this._property.getType();
    }

    public String getKey() {
        return this._property.getKey();
    }

    public String getName() {
        return this.getLabel();
    }

    public String getLabel() {
        return this._property.getLabel();
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
        this._property.setValue(this._value);
    }

    public IPropertyDescriptor getPropertyDescriptor() {
        if (this._propertyDescriptor == null) {
            switch (this._property.getType().getType()) {
                case 1: {
                    this._propertyDescriptor = new TextPropertyDescriptor((Object)this.getKey(), this.getLabel());
                    break;
                }
                case 2: {
                    SystemComboBoxPropertyDescriptor comboDescriptor = new SystemComboBoxPropertyDescriptor(this.getKey(), this.getLabel(), this._property.getType().getEnumValues());
                    this._propertyDescriptor = comboDescriptor;
                    break;
                }
                default: {
                    this._propertyDescriptor = new TextPropertyDescriptor((Object)this.getKey(), this.getLabel());
                }
            }
        }
        return this._propertyDescriptor;
    }

    public void commit() {
    }

    public void revert() {
        if (this._originalProperty.getValue() != this._property.getValue()) {
            this._property.setValue(this._originalProperty.getValue());
        }
    }
}

