/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide.launch;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceContainerTypeDelegate;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public final class RemoteSystemSourceLocator
extends AbstractSourceContainer
implements ISourceContainerTypeDelegate {
    private static final String TYPE_ID = "com.nvidia.viper.ide.remote";

    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        if (TYPE_ID.equals(memento)) {
            return this;
        }
        return null;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        ILaunchConfiguration configuration = this.getDirector().getLaunchConfiguration();
        String connectionName = configuration.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, null);
        if (!CoreUtil.isNullOrEmpty((String)connectionName)) {
            return this.getRemoteFile(name, connectionName);
        }
        return null;
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        return TYPE_ID;
    }

    public String getName() {
        return "Remote system source locator";
    }

    private Object[] getRemoteFile(String name, String connectionName) throws CoreException {
        IRemoteConnection connection = IRemoteConnectionsService.GetConnection.getConnection((String)connectionName, (IProgressMonitor)new NullProgressMonitor());
        if (connection != null) {
            IFile file = connection.getFile(name, (IProgressMonitor)new NullProgressMonitor());
            return new Object[]{file};
        }
        return null;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }
}

