/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide.launch;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityAttributeKind;
import com.nvidia.viper.ide.Activator;
import com.nvidia.viper.ide.ProfilerImages;
import com.nvidia.viper.ide.launch.LaunchConfigurationAdapter;
import com.nvidia.viper.model.IProfileMultiProcess;
import com.nvidia.viper.ui.MultiProcessCombo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class ProfileTab
extends AbstractLaunchConfigurationTab {
    private Button startWithProfiling;
    private Button concurrent;
    private Button apiTrace;
    private Text timeout;
    private Button environmentProfiling;
    private Button uvmProfiling;
    private Button applicationReplay;
    private Button cpuProfiling;
    private Button openaccProfiling;
    private Button threadTracking;
    private MultiProcessCombo multiProcessCombo;
    private Text deviceBufferSizeText;
    private Text cdpBufferSizeText;

    public Image getImage() {
        return ProfilerImages.getProfileTabImage();
    }

    private void updateAppReplay() {
        boolean enabled = !this.getMultiProcessOptionType().isMultiprocess();
        this.applicationReplay.setEnabled(enabled);
        if (!enabled) {
            this.applicationReplay.setSelection(false);
            this.applicationReplay.setText(String.valueOf(ViperMessages.NewSession_Wizard_AppReplay_Label) + ViperMessages.NewSession_notSuppMultiProc);
        } else {
            this.applicationReplay.setText(ViperMessages.NewSession_Wizard_AppReplay_Label);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.multiProcessCombo = new MultiProcessCombo(composite);
        this.multiProcessCombo.getControl().setLayoutData((Object)new GridData(-1, -1, false, false, 3, 1));
        this.multiProcessCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProfileTab.this.setDirty(true);
                ProfileTab.this.updateAppReplay();
                ProfileTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(composite, 0).setText("Execution timeout:");
        this.timeout = this.createText(composite);
        this.timeout.setMessage(ViperMessages.Execution_TimeOut_Message);
        new Label(composite, 0).setText("seconds");
        this.startWithProfiling = this.createCheckbox(composite, "Start execution with profiling enabled");
        this.concurrent = this.createCheckbox(composite, "Enable concurrent kernel profiling");
        this.apiTrace = this.createCheckbox(composite, "Enable CUDA API tracing in the timeline");
        this.environmentProfiling = this.createCheckbox(composite, ViperMessages.NewSession_Wizard_EnvironmentProfiling_Label);
        this.uvmProfiling = this.createCheckbox(composite, ViperMessages.NewSession_Wizard_UvmProfiling_Label);
        this.applicationReplay = this.createCheckbox(composite, ViperMessages.NewSession_Wizard_AppReplay_Label);
        this.cpuProfiling = this.createCheckbox(composite, "Enable CPU profiling");
        this.openaccProfiling = this.createCheckbox(composite, ViperMessages.NewSession_Wizard_OpenAccProfiling_Label);
        this.threadTracking = this.createCheckbox(composite, ViperMessages.NewSession_Wizard_ThreadTracking_Label);
        this.updateAppReplay();
        new Label(composite, 0).setText(ViperMessages.Device_Buffersize_Message);
        this.deviceBufferSizeText = this.createText(composite);
        this.deviceBufferSizeText.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        new Label(composite, 0).setText(ViperMessages.Cdp_Buffersize_Message);
        this.cdpBufferSizeText = this.createText(composite);
        this.cdpBufferSizeText.setLayoutData((Object)new GridData(-1, -1, false, false, 2, 1));
        this.setControl((Control)composite);
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.isEmpty() ? true : e.text.matches("[0-9]+");
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProfileTab.this.setDirty(true);
                ProfileTab.this.updateLaunchConfigurationDialog();
            }
        });
        return text;
    }

    private Button createCheckbox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new DirtyOnChange());
        button.setLayoutData((Object)new GridData(-1, -1, false, false, 3, 1));
        return button;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("nvvp.startProfiling", true);
        configuration.setAttribute("nvvp.concurrentProfiling", true);
        configuration.setAttribute("nvvp.apiTraceProfiling", true);
        configuration.setAttribute("nvvp.environmentProfiling", false);
        configuration.setAttribute("nvvp.uvmProfiling", true);
        configuration.setAttribute("nvvp.appReplay", false);
        configuration.setAttribute("nvvp.timeout", -1);
        configuration.setAttribute("nvvp.filename", LaunchConfigurationAdapter.getDefaultSessionFile(configuration.getName()));
        configuration.setAttribute("nvvp.multiProcess", 0);
        configuration.setAttribute("nvvp.openaccProfiling", true);
        configuration.setAttribute("nvvp.threadTracking", false);
        int cdpBufferSize = CuptiActivityAttributeKind.CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP.getValue(CuptiActivityAttributeKind.ValueUnit.MB);
        int deviceBufferSize = CuptiActivityAttributeKind.CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE.getValue(CuptiActivityAttributeKind.ValueUnit.MB);
        configuration.setAttribute("nvvp.cdpbuffersize", cdpBufferSize);
        configuration.setAttribute("nvvp.devicebuffersize", deviceBufferSize);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.startWithProfiling.setSelection(configuration.getAttribute("nvvp.startProfiling", true));
            this.concurrent.setSelection(configuration.getAttribute("nvvp.concurrentProfiling", true));
            this.apiTrace.setSelection(configuration.getAttribute("nvvp.apiTraceProfiling", true));
            this.configureEnvProfilingCheckbox(configuration);
            this.configureUvmProfilingCheckbox(configuration);
            this.applicationReplay.setSelection(configuration.getAttribute("nvvp.appReplay", false));
            int time = configuration.getAttribute("nvvp.timeout", -1);
            String timeStr = time < 1 ? "" : Integer.toString(time);
            this.timeout.setText(timeStr);
            this.configureMultiProcessCombo(configuration);
            this.configureOpenAccProfilingCheckbox(configuration);
            this.configureThreadTrackingCheckbox(configuration);
            this.cdpBufferSizeText.setText(String.valueOf(configuration.getAttribute("nvvp.cdpbuffersize", CuptiActivityAttributeKind.CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP.getValue(CuptiActivityAttributeKind.ValueUnit.MB))));
            this.deviceBufferSizeText.setText(String.valueOf(configuration.getAttribute("nvvp.cdpbuffersize", CuptiActivityAttributeKind.CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE.getValue(CuptiActivityAttributeKind.ValueUnit.MB))));
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private void configureMultiProcessCombo(ILaunchConfiguration configuration) throws CoreException {
        int index = configuration.getAttribute("nvvp.multiProcess", 0);
        IProfileMultiProcess selection = (IProfileMultiProcess)this.multiProcessCombo.getElementAt(index);
        this.multiProcessCombo.setSelection((ISelection)new StructuredSelection((Object)selection));
    }

    private void disableForMacOS(ILaunchConfiguration configuration, String label, Button button, String attribute, boolean defaultSelection) throws CoreException {
        boolean enabled;
        boolean selection;
        if ("macosx".equals(Platform.getOS()) && !"org.eclipse.cdt.launch.remoteApplicationLaunchType".equals(configuration.getType().getIdentifier())) {
            label = String.valueOf(label) + ViperMessages.NewSession_notSuppOSX;
            selection = false;
            enabled = false;
        } else {
            selection = configuration.getAttribute(attribute, defaultSelection);
            enabled = true;
        }
        button.setText(label);
        button.setEnabled(enabled);
        button.setSelection(selection);
    }

    private void enableForOSArch(ILaunchConfiguration configuration, String label, Button button, String attribute, boolean defaultSelection, String[] os, String[] arch, String message) throws CoreException {
        boolean enabled;
        boolean selection;
        String s;
        boolean supportOS = false;
        boolean supportArch = false;
        String[] stringArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(Platform.getOS())) {
                supportOS = true;
                break;
            }
            ++n2;
        }
        stringArray = arch;
        n = arch.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(Platform.getOSArch())) {
                supportArch = true;
                break;
            }
            ++n2;
        }
        if (supportOS && supportArch && !"org.eclipse.cdt.launch.remoteApplicationLaunchType".equals(configuration.getType().getIdentifier())) {
            selection = configuration.getAttribute(attribute, defaultSelection);
            enabled = true;
        } else {
            label = String.valueOf(label) + message;
            selection = false;
            enabled = false;
        }
        button.setText(label);
        button.setEnabled(enabled);
        button.setSelection(selection);
    }

    private void configureEnvProfilingCheckbox(ILaunchConfiguration configuration) throws CoreException {
        this.disableForMacOS(configuration, ViperMessages.NewSession_Wizard_EnvironmentProfiling_Label, this.environmentProfiling, "nvvp.environmentProfiling", false);
    }

    private void configureUvmProfilingCheckbox(ILaunchConfiguration configuration) throws CoreException {
        this.disableForMacOS(configuration, ViperMessages.NewSession_Wizard_UvmProfiling_Label, this.uvmProfiling, "nvvp.uvmProfiling", true);
    }

    private void configureOpenAccProfilingCheckbox(ILaunchConfiguration configuration) throws CoreException {
        String[] os = new String[]{"linux"};
        String[] arch = new String[]{"x86_64"};
        this.enableForOSArch(configuration, ViperMessages.NewSession_Wizard_OpenAccProfiling_Label, this.openaccProfiling, "nvvp.openaccProfiling", true, os, arch, ViperMessages.NewSession_supportLinux64Only);
    }

    private void configureThreadTrackingCheckbox(ILaunchConfiguration configuration) throws CoreException {
        String[] os = new String[]{"linux", "macosx"};
        String[] arch = new String[]{"x86_64"};
        this.enableForOSArch(configuration, ViperMessages.NewSession_Wizard_ThreadTracking_Label, this.threadTracking, "nvvp.threadTracking", true, os, arch, ViperMessages.NewSession_supportPosix64Only);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("nvvp.startProfiling", this.startWithProfiling.getSelection());
        configuration.setAttribute("nvvp.concurrentProfiling", this.concurrent.getSelection());
        configuration.setAttribute("nvvp.apiTraceProfiling", this.apiTrace.getSelection());
        configuration.setAttribute("nvvp.environmentProfiling", this.environmentProfiling.getSelection());
        configuration.setAttribute("nvvp.uvmProfiling", this.uvmProfiling.getSelection());
        configuration.setAttribute("nvvp.appReplay", this.applicationReplay.getSelection());
        String timeStr = this.timeout.getText();
        int time = timeStr.isEmpty() ? -1 : Integer.parseInt(timeStr);
        configuration.setAttribute("nvvp.timeout", time);
        configuration.setAttribute("nvvp.multiProcess", this.getMultiProcessOption());
        configuration.setAttribute("nvvp.openaccProfiling", this.openaccProfiling.getSelection());
    }

    private IProfileMultiProcess.Type getMultiProcessOptionType() {
        StructuredSelection slection = (StructuredSelection)this.multiProcessCombo.getSelection();
        IProfileMultiProcess selected = (IProfileMultiProcess)slection.getFirstElement();
        return selected.getType();
    }

    private int getMultiProcessOption() {
        return this.getMultiProcessOptionType().ordinal();
    }

    public String getName() {
        return "Profiler";
    }

    public String getId() {
        return "com.nvidia.viper.ide.cudaProfiler.profileTab";
    }

    private final class DirtyOnChange
    extends SelectionAdapter {
        private DirtyOnChange() {
        }

        public void widgetSelected(SelectionEvent e) {
            ProfileTab.this.setDirty(true);
            ProfileTab.this.updateLaunchConfigurationDialog();
        }
    }
}

