/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.application;

import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.application.OpenFilesFromCommandLineJob;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ActionHider
implements IStartup,
IPerspectiveListener {
    private static final String[] HIDE_ACTIONS = new String[]{"org.eclipse.search.searchActionSet", "org.eclipse.ui.externaltools.ExternalToolsSet", "org.eclipse.ui.edit.text.actionSet.openExternalFile", "org.eclipse.ui.edit.text.actionSet.presentation", "org.eclipse.ui.edit.text.actionSet.openExternalFile", "org.eclipse.ui.edit.text.actionSet.annotationNavigation", "org.eclipse.ui.edit.text.actionSet.navigation", "org.eclipse.ui.edit.text.actionSet.convertLineDelimitersTo", "org.eclipse.rse.core.search.searchActionSet", "org.eclipse.ui.console", "org.eclipse.update.ui.softwareUpdates"};

    private void doStartup(final IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.hideActions(page);
        }
        window.addPerspectiveListener((IPerspectiveListener)this);
        if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.PRODUCT) {
            new OpenFilesFromCommandLineJob(window).schedule();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = window.getActivePage();
                IEditorReference[] refs = activePage.getEditorReferences();
                activePage.closeEditors(refs, false);
            }
        });
    }

    public void earlyStartup() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows.length > 0) {
            this.doStartup(windows[0]);
            return;
        }
        IWindowListener listener = new IWindowListener(){

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
                workbench.removeWindowListener((IWindowListener)this);
                ActionHider.this.doStartup(window);
            }
        };
        workbench.addWindowListener(listener);
    }

    private void hideActions(IWorkbenchPage page) {
        int i = 0;
        while (i < HIDE_ACTIONS.length) {
            this.hideAction(page, HIDE_ACTIONS[i]);
            ++i;
        }
    }

    private void hideAction(final IWorkbenchPage page, final String actionsetId) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                page.hideActionSet(actionsetId);
            }
        });
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.hideActions(page);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }
}

