/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.launch;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.internal.ui.launch.LaunchMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class CApplicationLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(IEditorPart editor, String mode) {
        this.searchAndLaunch(new Object[]{editor.getEditorInput()}, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    public void launch(IBinary bin, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(bin, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, String mode) {
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = this.getCLaunchConfigType();
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                IPath programPath = CDebugUtils.getProgramPath((ILaunchConfiguration)config);
                String projectName = CDebugUtils.getProjectName((ILaunchConfiguration)config);
                IPath name = bin.getResource().getProjectRelativePath();
                if (programPath != null && programPath.equals((Object)name) && projectName != null && projectName.equals(bin.getCProject().getProject().getName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            ICDebugConfiguration debugConfig = null;
            IProject project = bin.getResource().getProject();
            ICProjectDescription projDesc = CoreModel.getDefault().getProjectDescription(project);
            ICConfigurationDescription configDesc = projDesc.getActiveConfiguration();
            String configId = configDesc.getId();
            ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getActiveDebugConfigurations();
            int matchLength = 0;
            int i = 0;
            while (i < debugConfigs.length) {
                ICDebugConfiguration dc = debugConfigs[i];
                String[] patterns = dc.getSupportedBuildConfigPatterns();
                if (patterns != null) {
                    int j = 0;
                    while (j < patterns.length) {
                        if (patterns[j].length() > matchLength && configId.matches(patterns[j])) {
                            debugConfig = dc;
                            matchLength = patterns[j].length();
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (debugConfig == null) {
                String programCPU = bin.getCPU();
                String os = Platform.getOS();
                debugConfigs = CDebugCorePlugin.getDefault().getActiveDebugConfigurations();
                ArrayList<ICDebugConfiguration> debugList = new ArrayList<ICDebugConfiguration>(debugConfigs.length);
                int i2 = 0;
                while (i2 < debugConfigs.length) {
                    String platform = debugConfigs[i2].getPlatform();
                    if (debugConfigs[i2].supportsMode("run") && (platform.equals("*") || platform.equals(os)) && debugConfigs[i2].supportsCPU(programCPU)) {
                        debugList.add(debugConfigs[i2]);
                    }
                    ++i2;
                }
                debugConfigs = debugList.toArray(new ICDebugConfiguration[0]);
                if (debugConfigs.length == 1) {
                    debugConfig = debugConfigs[0];
                } else if (debugConfigs.length > 1) {
                    debugConfig = this.chooseDebugConfig(debugConfigs, mode);
                }
            }
            if (debugConfig != null) {
                configuration = this.createConfiguration(bin, debugConfig, mode);
            }
        } else {
            configuration = candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : this.chooseConfiguration(candidateConfigs, mode);
        }
        return configuration;
    }

    private String performSubstitution(String input) {
        IStringVariableManager svbm = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return svbm.performStringSubstitution(input);
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
            return input;
        }
    }

    private String getDynvarProgName(IBinary bin) {
        String projectName = bin.getCProject().getElementName();
        StringBuilder programName = new StringBuilder();
        programName.append("${config_name:");
        programName.append(projectName);
        programName.append("}/");
        programName.append(bin.getResource().getName());
        return programName.toString();
    }

    private String getProgramName(IBinary bin) {
        String dynProgName;
        String relativePath = bin.getResource().getProjectRelativePath().toString();
        return relativePath.equals(this.performSubstitution(dynProgName = this.getDynvarProgName(bin))) ? dynProgName : relativePath;
    }

    private ILaunchConfiguration createConfiguration(IBinary bin, ICDebugConfiguration debugConfig, String mode) {
        ILaunchConfiguration config = null;
        try {
            String projectName = bin.getCProject().getElementName();
            String programName = this.getProgramName(bin);
            ILaunchConfigurationType configType = this.getCLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(bin.getElementName()));
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
            wc.setMappedResources(new IResource[]{bin.getResource().getProject()});
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", debugConfig.getID());
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(bin.getCProject().getProject());
            if (projDes != null) {
                String buildConfigID = projDes.getActiveConfiguration().getId();
                wc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
            }
            ICDebuggerPage page = CDebugUIPlugin.getDefault().getDebuggerPage(debugConfig.getID());
            page.setDefaults(wc);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.applicationLaunchType");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        IWorkbenchWindow w = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getShell();
        }
        return null;
    }

    private ICDebugConfiguration chooseDebugConfig(ICDebugConfiguration[] debugConfigs, String mode) {
        LabelProvider provider = new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ICDebugConfiguration) {
                    return ((ICDebugConfiguration)element).getName();
                }
                return element.toString();
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)provider);
        dialog.setElements((Object[])debugConfigs);
        dialog.setTitle(this.getDebugConfigDialogTitleString(debugConfigs, mode));
        dialog.setMessage(this.getDebugConfigDialogMessageString(debugConfigs, mode));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        provider.dispose();
        if (result == 0) {
            return (ICDebugConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected String getDebugConfigDialogTitleString(ICDebugConfiguration[] configList, String mode) {
        return LaunchMessages.getString("CApplicationLaunchShortcut.LaunchDebugConfigSelection");
    }

    protected String getDebugConfigDialogMessageString(ICDebugConfiguration[] configList, String mode) {
        if (mode.equals("debug")) {
            return LaunchMessages.getString("CApplicationLaunchShortcut.ChooseConfigToDebug");
        }
        if (mode.equals("run")) {
            return LaunchMessages.getString("CApplicationLaunchShortcut.ChooseConfigToRun");
        }
        return LaunchMessages.getString("CApplicationLaunchShortcut.Invalid_launch_mode_1");
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.getLaunchSelectionDialogTitleString(configList, mode));
        dialog.setMessage(this.getLaunchSelectionDialogMessageString(configList, mode));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected String getLaunchSelectionDialogTitleString(List<ILaunchConfiguration> configList, String mode) {
        return LaunchMessages.getString("CApplicationLaunchShortcut.LaunchConfigSelection");
    }

    protected String getLaunchSelectionDialogMessageString(List<ILaunchConfiguration> binList, String mode) {
        if (mode.equals("debug")) {
            return LaunchMessages.getString("CApplicationLaunchShortcut.ChooseLaunchConfigToDebug");
        }
        if (mode.equals("run")) {
            return LaunchMessages.getString("CApplicationLaunchShortcut.ChooseLaunchConfigToRun");
        }
        return LaunchMessages.getString("CApplicationLaunchShortcut.Invalid_launch_mode_2");
    }

    protected IBinary chooseBinary(List<IBinary> binList, String mode) {
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements(binList.toArray());
        dialog.setTitle(this.getBinarySelectionDialogTitleString(binList, mode));
        dialog.setMessage(this.getBinarySelectionDialogMessageString(binList, mode));
        dialog.setUpperListLabel(LaunchMessages.getString("Launch.common.BinariesColon"));
        dialog.setLowerListLabel(LaunchMessages.getString("Launch.common.QualifierColon"));
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IBinary)dialog.getFirstResult();
        }
        return null;
    }

    protected String getBinarySelectionDialogTitleString(List<IBinary> binList, String mode) {
        return LaunchMessages.getString("CApplicationLaunchShortcut.CLocalApplication");
    }

    protected String getBinarySelectionDialogMessageString(List<IBinary> binList, String mode) {
        if (mode.equals("debug")) {
            return LaunchMessages.getString("CApplicationLaunchShortcut.ChooseLocalAppToDebug");
        }
        if (mode.equals("run")) {
            return LaunchMessages.getString("CApplicationLaunchShortcut.ChooseLocalAppToRun");
        }
        return LaunchMessages.getString("CApplicationLaunchShortcut.Invalid_launch_mode_3");
    }

    private static List<IBinary> getCProjectExecutables(ICProject cproject) {
        ArrayList<IBinary> rc = new ArrayList<IBinary>();
        try {
            IBinary[] bins = cproject.getBinaryContainer().getBinaries();
            int j = 0;
            while (j < bins.length) {
                if (bins[j].isExecutable() || bins[j].isSharedLib()) {
                    rc.add(bins[j]);
                }
                ++j;
            }
        }
        catch (CModelException cModelException) {}
        return rc;
    }

    private void searchAndLaunch(final Object[] elements, String mode) {
        if (elements != null && elements.length > 0) {
            IBinary bin = null;
            if (elements.length == 1 && elements[0] instanceof IBinary) {
                bin = (IBinary)elements[0];
            } else {
                int count;
                final ArrayList<IBinary> results = new ArrayList<IBinary>();
                final ArrayList projects = new ArrayList();
                ProgressMonitorDialog searchDialog = new ProgressMonitorDialog(this.getShell());
                IRunnableWithProgress searchRunnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InterruptedException {
                        int nElements = elements.length;
                        pm.beginTask("Looking for executables", nElements);
                        try {
                            Object[] objectArray = elements;
                            int n = elements.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ICProject cproject;
                                IResource r;
                                Object element = objectArray[n2];
                                SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
                                if (element instanceof IAdaptable && (r = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null && (cproject = CoreModel.getDefault().create(r.getProject())) != null) {
                                    projects.add(cproject);
                                    results.addAll(CApplicationLaunchShortcut.getCProjectExecutables(cproject));
                                }
                                if (pm.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                sub.done();
                                ++n2;
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                };
                try {
                    searchDialog.run(true, true, searchRunnable);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)LaunchMessages.getString("CApplicationLaunchShortcut.Application_Launcher"), (String)e.getMessage());
                    return;
                }
                if (results.size() == 0 && projects.size() > 0) {
                    ProgressMonitorDialog buildDialog = new ProgressMonitorDialog(this.getShell());
                    IRunnableWithProgress buildRunnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor pm) throws InterruptedException, InvocationTargetException {
                            pm.beginTask("Building executales", projects.size());
                            try {
                                for (ICProject cprj : projects) {
                                    SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
                                    try {
                                        try {
                                            IProject prj = cprj.getProject();
                                            if (prj != null) {
                                                prj.build(6, (IProgressMonitor)sub);
                                            }
                                            results.addAll(CApplicationLaunchShortcut.getCProjectExecutables(cprj));
                                        }
                                        catch (CoreException e) {
                                            throw new InvocationTargetException(e, e.getMessage());
                                        }
                                    }
                                    finally {
                                        sub.done();
                                    }
                                    if (!pm.isCanceled()) continue;
                                    throw new InterruptedException();
                                }
                            }
                            finally {
                                pm.done();
                            }
                        }
                    };
                    try {
                        buildDialog.run(true, true, buildRunnable);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    catch (InvocationTargetException e) {
                        MessageDialog.openError((Shell)this.getShell(), (String)LaunchMessages.getString("CApplicationLaunchShortcut.Application_Launcher"), (String)e.getMessage());
                        return;
                    }
                }
                if ((count = results.size()) == 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)LaunchMessages.getString("CApplicationLaunchShortcut.Application_Launcher"), (String)LaunchMessages.getString("CApplicationLaunchShortcut.Launch_failed_no_binaries"));
                } else {
                    bin = count > 1 ? this.chooseBinary(results, mode) : (IBinary)results.get(0);
                }
            }
            if (bin != null) {
                this.launch(bin, mode);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchMessages.getString("CApplicationLaunchShortcut.Application_Launcher"), (String)LaunchMessages.getString("CApplicationLaunchShortcut.Launch_failed_no_project_selected"));
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        List<IProject> projects;
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) != null) {
            if (firstElement instanceof IFile) {
                IFile file = (IFile)firstElement;
                return file.getProject();
            }
            if (firstElement instanceof Executable) {
                return ((Executable)firstElement).getProject();
            }
            if (firstElement instanceof IBinary) {
                return ((IBinary)firstElement).getResource().getProject();
            }
        }
        if ((projects = CApplicationLaunchShortcut.getProjectsFromSelection(selection)).size() > 0) {
            return (IResource)projects.get(0);
        }
        return null;
    }

    public static List<IProject> getProjectsFromSelection(ISelection selection) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (selection != null && !selection.isEmpty()) {
            if (selection instanceof ITextSelection) {
                IFile file;
                IEditorInput editorInput;
                IEditorPart ep;
                IWorkbenchWindow activeWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
                IWorkbenchPage wpage = activeWindow.getActivePage();
                if (wpage != null && (ep = wpage.getActiveEditor()) != null && (editorInput = ep.getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)editorInput).getFile()) != null) {
                    projects.add(file.getProject());
                }
            } else if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object element : structuredSelection) {
                    if (element == null) continue;
                    if (element instanceof ICProject) {
                        projects.add(((ICProject)element).getProject());
                        continue;
                    }
                    if (element instanceof IResource) {
                        projects.add(((IResource)element).getProject());
                        continue;
                    }
                    if (element instanceof ICElement) {
                        ICElement unit = (ICElement)element;
                        while (unit != null && !(unit instanceof ICProject)) {
                            unit = unit.getParent();
                        }
                        if (unit == null) continue;
                        projects.add(((ICProject)unit).getProject());
                        continue;
                    }
                    if (!(element instanceof IAdaptable)) continue;
                    Object adapter = ((IAdaptable)element).getAdapter(IResource.class);
                    if (adapter != null && adapter instanceof IResource) {
                        projects.add(((IResource)adapter).getProject());
                        continue;
                    }
                    adapter = ((IAdaptable)element).getAdapter(ICProject.class);
                    if (adapter == null || !(adapter instanceof ICProject)) continue;
                    projects.add(((ICProject)adapter).getProject());
                }
            }
        }
        return projects;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        IFile file;
        IEditorInput editorInput = editorpart.getEditorInput();
        if (editorInput instanceof IFileEditorInput && (file = ((IFileEditorInput)editorInput).getFile()) != null) {
            return file.getProject();
        }
        return null;
    }
}

