/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.source;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.Images;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import com.nvidia.cuda.ide.remote.ui.launch.RemoteLaunchHelper;
import java.io.File;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceContainerTypeDelegate;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RemoteSystemSourceContainer
extends AbstractSourceContainer
implements ISourceContainerTypeDelegate,
ISourceContainer,
IWorkbenchAdapter {
    public static final String TYPE_ID = "com.nvidia.cuda.ide.remote.remoteFiles";
    private final ConcurrentHashMap<String, Object[]> resolvedSources = new ConcurrentHashMap();

    private static IFile getLocalSynchronizedResourceForPath(IRemoteConnection connection, IPath path) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            SyncConfig[] configs = SyncConfigManager.getConfigs((IProject)project);
            if (configs != null) {
                SyncConfig[] syncConfigArray = configs;
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath projectRelativePath;
                    IFile file;
                    Path p;
                    String location;
                    SyncConfig config = syncConfigArray[n4];
                    if (connection.getName().equals(config.getConnectionName()) && (location = config.getLocation(project)) != null && (p = new Path(location)).isPrefixOf(path) && (file = project.getFile(projectRelativePath = path.removeFirstSegments(p.segmentCount()).makeRelative())) != null && file.exists()) {
                        return file;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private static boolean isRemoteFile(final IFile workbenchResource, final IProgressMonitor monitor) {
        try {
            return (Boolean)CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, Boolean>(){

                public Boolean runWithService(IRemoteConnectionsService service) throws CoreException {
                    return service.refreshLocalCopy(workbenchResource, monitor);
                }
            });
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)"Unable to refresh local copy of the remote file", (Object[])new Object[0]), 3);
            return false;
        }
    }

    public static IFile refreshIfLocalCopy(IRemoteConnection connection, String fileName, IProgressMonitor monitor) {
        File file = new Path(fileName).toFile();
        if (file.isFile()) {
            URI uri = file.toURI();
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Refreshing cached copies of the files", (int)files.length);
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile workbenchResource = iFileArray[n2];
                if (RemoteSystemSourceContainer.isRemoteFile(workbenchResource, (IProgressMonitor)subMonitor.newChild(1))) {
                    subMonitor.setWorkRemaining(0);
                    subMonitor.done();
                    return workbenchResource;
                }
                ++n2;
            }
            subMonitor.setWorkRemaining(0);
            subMonitor.done();
        } else if (monitor != null) {
            monitor.done();
        }
        return null;
    }

    public static boolean shouldUseRemoteContainer(ILaunchConfiguration configuration) throws CoreException {
        return ICudaRemoteDebugConstants.ExecutableTransferMode.fromLaunchConfiguration(configuration) != ICudaRemoteDebugConstants.ExecutableTransferMode.Upload;
    }

    public ISourceContainer createSourceContainer(String memento) {
        return this;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        IRemoteConnection connection;
        if (this.resolvedSources.containsKey(name)) {
            return this.resolvedSources.get(name);
        }
        ISourceLookupDirector director = this.getDirector();
        ILaunchConfiguration launchConfiguration = director.getLaunchConfiguration();
        if (RemoteSystemSourceContainer.shouldUseRemoteContainer(launchConfiguration) && (connection = RemoteLaunchHelper.getRemoteConnection(launchConfiguration, (IProgressMonitor)new NullProgressMonitor())) != null) {
            Object[] resolved = this.getRemoteSourceFile(connection, name);
            this.resolvedSources.putIfAbsent(name, resolved);
            return resolved;
        }
        return new Object[0];
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return Images.Source_Container.getImageDescriptor();
    }

    public String getLabel(Object o) {
        return this.getName();
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        return "remoteFiles";
    }

    public String getName() {
        return "Remote System Files";
    }

    public Object getParent(Object o) {
        return null;
    }

    private Object[] getRemoteSourceFile(IRemoteConnection connection, String name) {
        FindRemoteSourceFile runnable = new FindRemoteSourceFile(connection, name);
        runnable.schedule();
        try {
            runnable.join();
            IFile store = runnable.getStore();
            if (store != null) {
                return new Object[]{store};
            }
            return new Object[0];
        }
        catch (InterruptedException e) {
            Activator.log(e);
            return new Object[0];
        }
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    private static final class FindRemoteSourceFile
    extends Job {
        private final IRemoteConnection connection;
        private final String fileName;
        private IFile store;

        private FindRemoteSourceFile(IRemoteConnection connection, String name) {
            super("Resolving file on a remote system");
            this.connection = connection;
            this.setUser(false);
            this.fileName = name;
        }

        public IFile getStore() {
            return this.store;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Obtaining local copy of the source file", (int)2);
            try {
                try {
                    IRemoteConnection iRemoteConnection = this.connection;
                    synchronized (iRemoteConnection) {
                        IFile file = RemoteSystemSourceContainer.refreshIfLocalCopy(this.connection, this.fileName, (IProgressMonitor)m.newChild(1));
                        if (file != null) {
                            m.worked(1);
                            this.store = file;
                        } else {
                            Path compilationPath = new Path(this.fileName);
                            if (!monitor.isCanceled()) {
                                IFile f = RemoteSystemSourceContainer.getLocalSynchronizedResourceForPath(this.connection, (IPath)compilationPath);
                                this.store = f != null ? f : this.connection.getFile(compilationPath.toString(), (IProgressMonitor)m.newChild(1));
                            } else {
                                m.worked(1);
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    IStatus iStatus = CoreUtil.errorStatus((Throwable)e, (String)"Failed to resolve %s source file", (Object[])new Object[]{this.fileName});
                    m.done();
                    return iStatus;
                }
            }
            finally {
                m.done();
            }
            return Status.OK_STATUS;
        }
    }
}

