/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;

public class ManifestExplorer {
    private static ManifestExplorer sm_instance = null;
    private static Logger sm_logger = null;
    private Map<String, ExtensionManifest> m_manifestsById;
    private static final String DTP_ODA_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dataSource";
    private static final String PACKAGE_NAME = "org.eclipse.datatools.connectivity.oda.util.manifest";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ManifestExplorer getInstance() {
        if (sm_instance != null) return sm_instance;
        Class<ManifestExplorer> clazz = ManifestExplorer.class;
        synchronized (ManifestExplorer.class) {
            if (sm_instance != null) return sm_instance;
            sm_instance = new ManifestExplorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance() {
        Class<ManifestExplorer> clazz = ManifestExplorer.class;
        synchronized (ManifestExplorer.class) {
            sm_instance = null;
            sm_logger = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<ManifestExplorer> clazz = ManifestExplorer.class;
        synchronized (ManifestExplorer.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = Logger.getLogger(PACKAGE_NAME);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    private ManifestExplorer() {
    }

    public void refresh() {
        if (this.m_manifestsById == null || this.m_manifestsById.isEmpty()) {
            return;
        }
        this.m_manifestsById.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ExtensionManifest> getCachedManifests() {
        if (this.m_manifestsById == null) {
            ManifestExplorer manifestExplorer = this;
            synchronized (manifestExplorer) {
                if (this.m_manifestsById == null) {
                    this.m_manifestsById = Collections.synchronizedMap(new HashMap());
                }
            }
        }
        return this.m_manifestsById;
    }

    public Properties getDataSourceIdentifiers() {
        return this.getDataSourceIdentifiers(null);
    }

    public Properties getDataSourceIdentifiers(Filter dataSourceFilter) {
        ExtensionManifest[] odaManifests = this.getExtensionManifests(dataSourceFilter);
        Properties extensionIds = new Properties();
        int i = 0;
        while (i < odaManifests.length) {
            ExtensionManifest odaManifest = odaManifests[i];
            String dataSourceId = odaManifest.getDataSourceElementID();
            String dataSourceDisplayName = odaManifest.getDataSourceDisplayName();
            extensionIds.setProperty(dataSourceId, dataSourceDisplayName);
            ++i;
        }
        return extensionIds;
    }

    public ExtensionManifest getExtensionManifest(String dataSourceId) throws OdaException {
        ExtensionManifest manifest = this.getExtensionManifest(dataSourceId, DTP_ODA_EXT_POINT);
        if (manifest != null) {
            return manifest;
        }
        throw new IllegalArgumentException(Messages.bind((String)Messages.manifest_CANNOT_FIND_EXTENSION, (Object)dataSourceId));
    }

    public ExtensionManifest getExtensionManifest(String dataSourceId, String extensionPoint) throws OdaException {
        if (dataSourceId == null || dataSourceId.length() == 0) {
            throw new IllegalArgumentException(dataSourceId);
        }
        if (extensionPoint == null || extensionPoint.length() == 0) {
            throw new IllegalArgumentException(extensionPoint);
        }
        ExtensionManifest aManifest = this.getCachedManifests().get(dataSourceId);
        if (aManifest != null) {
            return aManifest;
        }
        IExtension[] extensions = ManifestExplorer.getExtensions(extensionPoint);
        IExtension dataSourceExtn = this.findExtension(dataSourceId, extensions);
        if (dataSourceExtn == null) {
            return null;
        }
        return this.getExtensionManifest(dataSourceExtn);
    }

    private ExtensionManifest getExtensionManifest(IExtension dataSourceExtn) throws OdaException {
        if (dataSourceExtn == null) {
            throw new OdaException(new IllegalArgumentException(Messages.manifest_nullArgument));
        }
        IConfigurationElement dataSourceElement = ManifestExplorer.getDataSourceElement(dataSourceExtn);
        assert (dataSourceElement != null);
        String dataSourceId = dataSourceElement.getAttribute("id");
        ExtensionManifest aManifest = this.getCachedManifests().get(dataSourceId);
        if (aManifest == null) {
            ExtensionManifest newManifest = new ExtensionManifest(dataSourceExtn);
            aManifest = this.addToCachedManifests(dataSourceId, newManifest);
        }
        return aManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtensionManifest addToCachedManifests(String dataSourceId, ExtensionManifest manifest) {
        ExtensionManifest cachedManifest;
        Map<String, ExtensionManifest> manifestMap;
        Map<String, ExtensionManifest> map = manifestMap = this.getCachedManifests();
        synchronized (map) {
            cachedManifest = manifestMap.get(dataSourceId);
            if (cachedManifest == null) {
                cachedManifest = manifest;
                manifestMap.put(dataSourceId, cachedManifest);
            }
        }
        return cachedManifest;
    }

    public ExtensionManifest[] getExtensionManifests() {
        return this.getExtensionManifests(DTP_ODA_EXT_POINT);
    }

    public ExtensionManifest[] getExtensionManifests(Filter collectionFilter) {
        return this.getExtensionManifests(DTP_ODA_EXT_POINT, collectionFilter);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint) {
        Filter aFilter = ManifestExplorer.createFilter();
        aFilter.setMissingDataSetTypesFilter(true);
        aFilter.setDeprecatedFilter(false);
        aFilter.setHideWrapper(false);
        return this.getExtensionManifests(extensionPoint, aFilter);
    }

    public ExtensionManifest[] getExtensionManifests(boolean includesAllExtensions) {
        return this.getExtensionManifests(DTP_ODA_EXT_POINT, includesAllExtensions);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint, boolean includesAllExtensions) {
        Filter aFilter = ManifestExplorer.createFilter();
        aFilter.setMissingDataSetTypesFilter(!includesAllExtensions);
        aFilter.setDeprecatedFilter(false);
        return this.getExtensionManifests(extensionPoint, aFilter);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint, Filter collectionFilter) {
        IExtension[] extensions = ManifestExplorer.getExtensions(extensionPoint);
        int length = extensions == null ? 0 : extensions.length;
        ArrayList<ExtensionManifest> manifestList = new ArrayList<ExtensionManifest>(length);
        int i = 0;
        while (i < length) {
            IExtension dataSourceExtn = extensions[i];
            try {
                ExtensionManifest manifest = this.getExtensionManifest(dataSourceExtn);
                boolean includeExtension = true;
                if (collectionFilter != null && !manifest.overrideFiltering()) {
                    if (collectionFilter.isMissingDataSetTypesFilterOn() && manifest.getDataSetTypeCount() <= 0) {
                        includeExtension = false;
                    } else if (collectionFilter.isDeprecatedFilterOn() && manifest.isDeprecated()) {
                        includeExtension = false;
                    } else if (collectionFilter.isHideWrapperFilterOn() && manifest.isWrapper()) {
                        includeExtension = false;
                    }
                }
                if (includeExtension) {
                    manifestList.add(manifest);
                }
            }
            catch (OdaException ex) {
                ManifestExplorer.getLogger().log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
            ++i;
        }
        int numOfValidExtensions = manifestList.size();
        return manifestList.toArray(new ExtensionManifest[numOfValidExtensions]);
    }

    private IExtension findExtension(String dataSourceId, IExtension[] extensions) throws OdaException {
        int length = extensions == null ? 0 : extensions.length;
        int i = 0;
        while (i < length) {
            block4: {
                IExtension extension = extensions[i];
                String extnDataSourceId = null;
                try {
                    IConfigurationElement dataSourceElement = ManifestExplorer.getDataSourceElement(extension);
                    extnDataSourceId = dataSourceElement.getAttribute("id");
                }
                catch (OdaException ex) {
                    ManifestExplorer.getLogger().log(Level.WARNING, "Ignoring invalid extension.", ex);
                    break block4;
                }
                if (extnDataSourceId != null && extnDataSourceId.equalsIgnoreCase(dataSourceId)) {
                    return extension;
                }
            }
            ++i;
        }
        return null;
    }

    public static IExtension[] getExtensions(String extPoint) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        if (pluginRegistry == null) {
            return null;
        }
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(extPoint);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getExtensions();
    }

    static IConfigurationElement getDataSourceElement(IExtension extension) throws OdaException {
        return ManifestUtil.getNamedElement(extension, "dataSource", "id");
    }

    static Hashtable<String, DataSetType> getDataSetElements(IExtension extension, String dataSourceElementId) throws OdaException {
        IConfigurationElement[] configElements = ManifestUtil.getNamedElements(extension, "dataSet", "id");
        Hashtable<String, DataSetType> dataSetElements = new Hashtable<String, DataSetType>();
        int numConfigElements = configElements.length;
        int i = 0;
        while (i < numConfigElements) {
            IConfigurationElement configElement = configElements[i];
            String dataSetTypeId = configElement.getAttribute("id");
            dataSetElements.put(dataSetTypeId, new DataSetType(configElement));
            ++i;
        }
        if (dataSetElements.size() < 1) {
            String msg = Messages.bind((String)Messages.manifest_NO_DATA_SET_TYPES_DEFINED, (Object)dataSourceElementId);
            if (numConfigElements >= 1) {
                throw new OdaException(msg);
            }
            ManifestExplorer.getLogger().log(Level.CONFIG, msg);
        }
        return dataSetElements;
    }

    static String getElementDisplayName(IConfigurationElement dsElement) {
        String displayName = dsElement.getAttribute("defaultDisplayName");
        if ((displayName == null || displayName.length() == 0) && (displayName = dsElement.getAttribute("name")) == null) {
            displayName = dsElement.getAttribute("id");
        }
        return displayName;
    }

    public int getDefaultOdaDataTypeCode(int nativeTypeCode, String odaDataSourceId, String dataSetType) {
        ExtensionManifest manifest;
        DataSetType setType;
        block4: {
            setType = null;
            try {
                manifest = this.getExtensionManifest(odaDataSourceId);
                if (manifest != null) break block4;
                return 0;
            }
            catch (OdaException odaException) {}
        }
        setType = manifest.getDataSetType(dataSetType);
        if (setType == null) {
            return 0;
        }
        return setType.getDefaultOdaDataTypeCode(nativeTypeCode);
    }

    public static Filter createFilter() {
        return ManifestExplorer.getInstance().new Filter();
    }

    public class Filter {
        private boolean m_noDataSetTypes = false;
        private boolean m_hideDeprecated = true;
        private boolean m_hideWrapper = true;

        Filter() {
        }

        public void setMissingDataSetTypesFilter(boolean hide) {
            this.m_noDataSetTypes = hide;
        }

        public void setDeprecatedFilter(boolean hide) {
            this.m_hideDeprecated = hide;
        }

        public void setHideWrapper(boolean hide) {
            this.m_hideWrapper = hide;
        }

        public boolean isMissingDataSetTypesFilterOn() {
            return this.m_noDataSetTypes;
        }

        public boolean isDeprecatedFilterOn() {
            return this.m_hideDeprecated;
        }

        public boolean isHideWrapperFilterOn() {
            return this.m_hideWrapper;
        }
    }
}

