/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblyRulerColumn;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.util.PropertyChangeEvent;

public class OpcodeRulerColumn
extends DisassemblyRulerColumn {
    public static final String ID = "org.eclipse.cdt.dsf.ui.disassemblyColumn.opcode";
    private static final int MAXWIDTH = 20;
    private int fRadix;
    private String fRadixPrefix;

    public OpcodeRulerColumn() {
        this.setForeground(this.getColor("disassembly.codeBytesColor"));
        this.setRadix(this.getPreferenceStore().getInt("disassembly.opcodeRadix"));
    }

    public void setRadix(int radix) {
        this.fRadix = radix;
        this.setShowRadixPrefix();
    }

    public void setShowRadixPrefix() {
        this.fRadixPrefix = this.fRadix == 16 ? "0x" : (this.fRadix == 8 ? "0" : null);
    }

    @Override
    protected String createDisplayString(int line) {
        int nChars = this.computeNumberOfCharacters();
        if (nChars > 0) {
            DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
            try {
                int offset = doc.getLineOffset(line);
                AddressRangePosition pos = doc.getDisassemblyPosition(offset);
                if (pos instanceof DisassemblyPosition && pos.length > 0 && pos.offset == offset && pos.fValid) {
                    DisassemblyPosition disassPos = (DisassemblyPosition)pos;
                    if (disassPos.fOpcodes != null) {
                        String str = disassPos.fOpcodes.toString(this.fRadix);
                        int prefixLength = 0;
                        if (this.fRadixPrefix != null) {
                            prefixLength = this.fRadixPrefix.length();
                        }
                        StringBuilder buf = new StringBuilder(nChars);
                        if (prefixLength != 0) {
                            buf.append(this.fRadixPrefix);
                        }
                        int i = str.length() + prefixLength;
                        while (i < nChars) {
                            buf.append('0');
                            ++i;
                        }
                        buf.append(str);
                        if (buf.length() > nChars) {
                            buf.delete(nChars, buf.length());
                        }
                        return buf.toString();
                    }
                } else if (pos != null && !pos.fValid) {
                    return "......................................................................".substring(0, nChars);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    @Override
    protected int computeNumberOfCharacters() {
        DisassemblyDocument doc = (DisassemblyDocument)this.getParentRuler().getTextViewer().getDocument();
        return Math.min(20, doc.getMaxOpcodeLength(this.fRadix));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        IPreferenceStore store = this.getPreferenceStore();
        boolean needRedraw = false;
        if ("disassembly.codeBytesColor".equals(property)) {
            this.setForeground(this.getColor(property));
            needRedraw = true;
        } else if ("disassembly.opcodeRadix".equals(property)) {
            this.setRadix(store.getInt(property));
            this.layout(false);
            needRedraw = true;
        }
        if (needRedraw) {
            this.redraw();
        }
    }
}

