/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.FilteredKernelList;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelList;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelTree;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.jface.preference.IPreferenceStore;

public final class KernelHierarchy {
    private final boolean flatModeOnly;
    private final DsfServicesTracker tracker;

    protected static ICudaApplication isDebugHierarchyRoot(ICudaRuntimeObject parent) {
        if (parent != null && parent.getType() == ElementType.application) {
            return (ICudaApplication)parent;
        }
        return null;
    }

    public static boolean isParentKernel(Kernel kernel, Kernel potentialParent) {
        if (kernel.equals(potentialParent)) {
            return true;
        }
        KernelCallSite callSite = kernel.getCallSite();
        return callSite != null && KernelHierarchy.isParentKernel(callSite.getParent(), potentialParent);
    }

    public KernelHierarchy(DsfServicesTracker tracker, boolean flatModeOnly) {
        this.tracker = tracker;
        this.flatModeOnly = flatModeOnly;
    }

    private IDelegate createDelegate(boolean isFiltering) {
        if (isFiltering) {
            return new FilteredKernelList(this.tracker);
        }
        return new KernelList();
    }

    public void getChildren(final ICudaRuntimeObject parent, final int offset, final int length, final DataRequestMonitor<IDMContext[]> rm, final ICudaElementFilter filter) {
        this.getDelegate(new DataRequestMonitor<IDelegate>(ImmediateExecutor.getInstance(), rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                ((IDelegate)this.getData()).getChildren(parent, offset, length, (DataRequestMonitor<IDMContext[]>)rm, filter);
            }
        });
    }

    private void getDelegate(final DataRequestMonitor<IDelegate> drm) {
        if (this.flatModeOnly) {
            drm.done((Object)new KernelList());
        } else if (this.isFiltering()) {
            this.isFilteringOut(new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), drm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    drm.done((Object)KernelHierarchy.this.createDelegate((Boolean)this.getData()));
                }
            });
        } else {
            IDelegate delegate;
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            String layout = preferenceStore.getString("device.kernels.mode");
            if ("device_kernels_child".equals(layout)) {
                delegate = new KernelTree();
            } else if ("device_kernels_top".equals(layout)) {
                delegate = new KernelList();
            } else {
                throw new IllegalStateException(layout);
            }
            drm.done((Object)delegate);
        }
    }

    public void getFilteredOutChildrenCount(final ICudaRuntimeObject parent, final DataRequestMonitor<Tuple<Integer, Integer, ?>> drm) {
        this.getDelegate(new DataRequestMonitor<IDelegate>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                ((IDelegate)this.getData()).getChildrenCount(parent, drm);
            }
        });
    }

    public void isCdpStackVisible(final DataRequestMonitor<Boolean> drm) {
        this.getDelegate(new DataRequestMonitor<IDelegate>(ImmediateExecutor.getInstance(), drm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                drm.done((Object)((IDelegate)this.getData()).isCdpStackVisible());
            }
        });
    }

    public boolean isFiltering() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String string = store.getString("device.kernels.mode");
        return string == null || "device_kernels_filtered".equals(store.getString("device.kernels.mode"));
    }

    private final void isFilteringOut(DataRequestMonitor<Boolean> drm) {
        IDebuggerUIState state = (IDebuggerUIState)this.tracker.getService(IDebuggerUIState.class);
        if (!this.isFiltering() || state == null) {
            drm.done((Object)false);
        } else {
            state.isFilteringOut(drm);
        }
    }

    public void getAncestor(final Kernel element, final VMDelta delta, final DataRequestMonitor<Kernel> drm) {
        this.getDelegate(new DataRequestMonitor<IDelegate>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                drm.done((Object)((IDelegate)this.getData()).getAncestor(element, delta));
            }
        });
    }

    public void isAncestor(final Kernel kernel, final VMDelta delta, final DataRequestMonitor<Boolean> drm) {
        this.getDelegate(new DataRequestMonitor<IDelegate>(ImmediateExecutor.getInstance(), drm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                drm.done((Object)((IDelegate)this.getData()).isParent(kernel, delta));
            }
        });
    }

    public static interface IDelegate {
        public void getChildren(ICudaRuntimeObject var1, int var2, int var3, DataRequestMonitor<IDMContext[]> var4, ICudaElementFilter var5);

        public void getChildrenCount(ICudaRuntimeObject var1, DataRequestMonitor<Tuple<Integer, Integer, ?>> var2);

        public boolean isCdpStackVisible();

        public Kernel getAncestor(Kernel var1, VMDelta var2);

        public boolean isParent(Kernel var1, VMDelta var2);
    }

    public static enum Mode {
        filtered,
        flat,
        tree;

    }
}

