/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui;

import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CMainTab;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CudaDebuggerCoreTab
extends CMainTab {
    protected Text fCudaCoreText;

    public CudaDebuggerCoreTab() {
        super(14);
    }

    protected void createCoreFileGroup(Composite parent, int colSpan) {
        Composite coreComp = new Composite(parent, 0);
        GridLayout coreLayout = new GridLayout();
        coreLayout.numColumns = 3;
        coreLayout.marginHeight = 0;
        coreLayout.marginWidth = 0;
        coreComp.setLayout((Layout)coreLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        coreComp.setLayoutData((Object)gd);
        Label cudaCoreLabel = new Label(coreComp, 0);
        cudaCoreLabel.setText("GPU core file");
        cudaCoreLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fCudaCoreText = new Text(coreComp, 2052);
        gd = new GridData(768);
        this.fCudaCoreText.setLayoutData((Object)gd);
        this.fCudaCoreText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CudaDebuggerCoreTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseForCudaCoreButton = this.createPushButton(coreComp, LaunchMessages.getString((String)"Launch.common.Browse_3"), null);
        browseForCudaCoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String text = CudaDebuggerCoreTab.this.handleBrowseButtonSelected(LaunchMessages.getString((String)"CMaintab.Core_Selection"));
                if (text != null) {
                    CudaDebuggerCoreTab.this.fCudaCoreText.setText(text);
                }
                CudaDebuggerCoreTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fCoreLabel = new Label(coreComp, 0);
        this.fCoreLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fCoreLabel.setText("Core file");
        this.fCoreText = new Text(coreComp, 2052);
        gd = new GridData(768);
        this.fCoreText.setLayoutData((Object)gd);
        this.fCoreText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CudaDebuggerCoreTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseForCoreButton = this.createPushButton(coreComp, LaunchMessages.getString((String)"Launch.common.Browse_3"), null);
        browseForCoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String text = CudaDebuggerCoreTab.this.handleBrowseButtonSelected(LaunchMessages.getString((String)"CMaintab.Core_Selection"));
                if (text != null) {
                    CudaDebuggerCoreTab.this.fCoreText.setText(text);
                }
                CudaDebuggerCoreTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void updateCoreFromConfig(ILaunchConfiguration config) {
        if (this.fCoreText != null) {
            String coreName = "";
            String cudaCoreName = "";
            try {
                coreName = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
                cudaCoreName = config.getAttribute("com.nvidia.cuda.ide.debug.cudaCoreFilePath", "");
            }
            catch (CoreException ce) {
                GdbUIPlugin.log((Throwable)ce);
            }
            this.fCoreText.setText(coreName);
            this.fCudaCoreText.setText(cudaCoreName);
            this.updateCoreFileLabel();
        }
    }

    protected String getSelectedCoreType() {
        return "CORE_FILE";
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        config.setAttribute("com.nvidia.cuda.ide.debug.cudaCoreFilePath", this.fCudaCoreText.getText());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fCudaCoreText.getText().length() == 0) {
            this.setErrorMessage("GPU core file is not specified");
            return false;
        }
        return super.isValid(config);
    }
}

