/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui;

import com.nvidia.cuda.ide.debug.core.Activator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class CudaDebugItemsLayout
extends ContributionItem
implements IPropertyChangeListener {
    private static final String[][] KERNELS_ITEMS = new String[][]{{"device_kernels_filtered", "Filtered Kernel List"}, {"device_kernels_top", "Flat Kernel List"}, {"device_kernels_child", "Kernel Hierarchy"}};
    private static final String[][] THREADS_ITEMS = new String[][]{{"debug_view_flat", "List"}, {"debug_view_tree", "Tree"}, {"debug_view_none", "Hide"}};
    private int current;
    private MenuItem[][] menuItems;
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public CudaDebugItemsLayout() {
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void createItems(Menu menu, final String[][] items, final String key, int j) {
        this.menuItems[j] = new MenuItem[items.length];
        int i = 0;
        while (i < items.length) {
            this.menuItems[j][i] = new MenuItem(menu, 16);
            this.menuItems[j][i].setText(items[i][1]);
            this.menuItems[j][i].setData((Object)i);
            final int ind = i;
            this.menuItems[j][i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CudaDebugItemsLayout.this.preferenceStore.setValue(key, items[ind][0]);
                }
            });
            ++i;
        }
    }

    public void dispose() {
        MenuItem[][] menuItemArray = this.menuItems;
        int n = this.menuItems.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem[] items;
            MenuItem[] menuItemArray2 = items = menuItemArray[n2];
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                MenuItem item = menuItemArray2[n4];
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                }
                ++n4;
            }
            ++n2;
        }
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public final void fill(Menu menu, int index) {
        this.menuItems = new MenuItem[2][];
        this.createItems(menu, KERNELS_ITEMS, "device.kernels.mode", 0);
        new MenuItem(menu, 2);
        this.createItems(menu, THREADS_ITEMS, "debug.view.cuda.layout", 1);
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.update();
    }

    public final void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("debug.view.cuda.layout".equals(property) | "device.kernels.mode".equals(property)) {
            this.update();
        }
    }

    public void update() {
        this.update(this.preferenceStore.getString("device.kernels.mode"), KERNELS_ITEMS, 0);
        this.update(this.preferenceStore.getString("debug.view.cuda.layout"), THREADS_ITEMS, 1);
    }

    private void update(String value, String[][] items, int j) {
        int i;
        int itemsCount = items.length;
        this.current = itemsCount - 1;
        if (value != null && value.trim().length() != 0) {
            i = 0;
            while (i < itemsCount) {
                if (value.trim().equals(items[i][0])) {
                    this.current = i;
                    break;
                }
                ++i;
            }
        }
        if (this.menuItems != null && this.menuItems[j] != null) {
            i = 0;
            while (i < this.menuItems[j].length) {
                this.menuItems[j][i].setSelection(i == this.current);
                ++i;
            }
        }
    }
}

