/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.util.Comparator;
import org.eclipse.birt.data.engine.olap.data.util.IComparableStructure;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.olap.data.util.IndexKeyObjectCreator;
import org.eclipse.birt.data.engine.olap.data.util.ObjectArrayUtil;

public class IndexKey
implements IComparableStructure {
    private Object[] key;
    private int[] offset;
    private int[] dimensionPos;

    @Override
    public Object[] getFieldValues() {
        Object[][] objectArrays = new Object[3][];
        objectArrays[0] = this.key;
        objectArrays[1] = new Integer[this.offset.length];
        int i = 0;
        while (i < this.offset.length) {
            objectArrays[1][i] = this.offset[i];
            ++i;
        }
        objectArrays[2] = new Integer[this.dimensionPos.length];
        i = 0;
        while (i < this.dimensionPos.length) {
            objectArrays[2][i] = this.dimensionPos[i];
            ++i;
        }
        return ObjectArrayUtil.convert(objectArrays);
    }

    public int compareTo(Object o) {
        assert (o instanceof IndexKey);
        IndexKey target = (IndexKey)o;
        int i = 0;
        while (i < this.getKey().length) {
            if (this.getKey()[i] == null && target.getKey()[i] != null) {
                return -1;
            }
            if (this.getKey()[i] == null && target.getKey()[i] == null) {
                return 0;
            }
            if (this.getKey()[i] != null && target.getKey()[i] == null) {
                return 1;
            }
            int result = 0;
            result = this.getKey()[i] instanceof Comparable ? ((Comparable)this.getKey()[i]).compareTo(target.getKey()[i]) : this.getKey()[i].toString().compareTo(target.getKey()[i].toString());
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    public static Comparator getKeyComparator() {
        return new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((IndexKey)obj1).compareTo(obj2);
            }
        };
    }

    public static Comparator getIndexComparator() {
        return new Comparator(){

            public int compare(Object obj1, Object obj2) {
                int[] index1 = ((IndexKey)obj1).getDimensionPos();
                int[] index2 = ((IndexKey)obj2).getDimensionPos();
                int i = 0;
                while (i < Math.min(index1.length, index2.length)) {
                    if (index1[i] < index2[i]) {
                        return -1;
                    }
                    if (index1[i] > index2[i]) {
                        return 1;
                    }
                    ++i;
                }
                if (index1.length < index2.length) {
                    return -1;
                }
                if (index1.length == index2.length) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public static IStructureCreator getCreator() {
        return new IndexKeyObjectCreator();
    }

    public void setKey(Object[] key) {
        this.key = key;
    }

    public Object[] getKey() {
        return this.key;
    }

    public void setOffset(int[] offset) {
        this.offset = offset;
    }

    public int[] getOffset() {
        return this.offset;
    }

    public void setDimensionPos(int[] dimensionPos) {
        this.dimensionPos = dimensionPos;
    }

    public int[] getDimensionPos() {
        return this.dimensionPos;
    }
}

