/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox;

import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.tools.Executable;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTool
implements ActionListener {
    public static ArrayList<String> versionsarray = new ArrayList();
    protected JInternalFrame internalFrame = null;
    protected ArrayList<AbstractArgument> arguments = new ArrayList();
    protected int menuoptions = 1;
    public static final int MENU_EXECUTE = 1;
    public static final int MENU_EXECUTE_SHOW = 2;
    public static final int MENU_EXECUTE_PRINT = 4;
    public static final int MENU_EXECUTE_PRINT_SILENT = 8;
    private Desktop awtdesktop = null;
    private JMenuBar menubar;

    public AbstractTool() {
        if (Desktop.isDesktopSupported()) {
            this.awtdesktop = Desktop.getDesktop();
        }
    }

    public void setArguments(ArrayList<AbstractArgument> arrayList) {
        this.arguments = arrayList;
    }

    public void setMainArguments(String[] stringArray) {
        int n = 0;
        for (AbstractArgument abstractArgument : this.arguments) {
            if (stringArray.length <= n) break;
            abstractArgument.setValue(stringArray[n]);
            ++n;
        }
    }

    public ArrayList<AbstractArgument> getArguments() {
        return this.arguments;
    }

    public Object getValue(String string) throws InstantiationException {
        for (AbstractArgument abstractArgument : this.arguments) {
            if (!string.equals(abstractArgument.getName())) continue;
            return abstractArgument.getArgument();
        }
        return null;
    }

    public void setInternalFrame(JInternalFrame jInternalFrame) {
        this.internalFrame = jInternalFrame;
    }

    public void setMenubar(JMenuBar jMenuBar) {
        this.menubar = jMenuBar;
    }

    public JInternalFrame getInternalFrame() {
        if (this.internalFrame == null) {
            this.createFrame();
        }
        return this.internalFrame;
    }

    public JMenuBar getMenubar() {
        JMenuItem jMenuItem;
        this.menubar = new JMenuBar();
        JMenu jMenu = new JMenu("Tool");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem2 = new JMenuItem("Usage");
        jMenuItem2.setMnemonic(85);
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Arguments");
        jMenuItem3.setMnemonic(65);
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        if ((this.menuoptions & 1) > 0) {
            jMenuItem = new JMenuItem("Execute");
            jMenuItem.setMnemonic(69);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        if ((this.menuoptions & 2) > 0) {
            jMenuItem = new JMenuItem("Execute+Open");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        if ((this.menuoptions & 4) > 0) {
            jMenuItem = new JMenuItem("Execute+Printdialog");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        if ((this.menuoptions & 8) > 0) {
            jMenuItem = new JMenuItem("Execute+Print");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Close");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        this.menubar.add(jMenu);
        if (!this.arguments.isEmpty()) {
            JMenu jMenu2 = new JMenu("Arguments");
            jMenu.setMnemonic(84);
            for (AbstractArgument abstractArgument : this.arguments) {
                JMenuItem jMenuItem4 = new JMenuItem(abstractArgument.getName());
                jMenuItem4.setToolTipText(abstractArgument.getDescription());
                jMenuItem4.addActionListener(abstractArgument);
                jMenu2.add(jMenuItem4);
            }
            this.menubar.add(jMenu2);
        }
        return this.menubar;
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer("java ");
        stringBuffer.append(this.getClass().getName());
        for (AbstractArgument abstractArgument : this.arguments) {
            stringBuffer.append(' ');
            stringBuffer.append(abstractArgument.getName());
        }
        stringBuffer.append('\n');
        for (AbstractArgument abstractArgument : this.arguments) {
            stringBuffer.append(abstractArgument.getUsage());
        }
        return stringBuffer.toString();
    }

    private String getArgs() {
        StringBuffer stringBuffer = new StringBuffer("Current arguments:\n");
        for (AbstractArgument abstractArgument : this.arguments) {
            stringBuffer.append("  ");
            stringBuffer.append(abstractArgument.getName());
            if (abstractArgument.getValue() == null) {
                stringBuffer.append(" = null\n");
                continue;
            }
            stringBuffer.append(" = '");
            stringBuffer.append(abstractArgument.toString());
            stringBuffer.append("'\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Close".equals(actionEvent.getActionCommand())) {
            System.out.println("=== " + this.getInternalFrame().getTitle() + " CLOSED ===");
            this.internalFrame.dispose();
        }
        if ("Usage".equals(actionEvent.getActionCommand())) {
            JOptionPane.showMessageDialog(this.internalFrame, this.getUsage());
        }
        if ("Arguments".equals(actionEvent.getActionCommand())) {
            JOptionPane.showMessageDialog(this.internalFrame, this.getArgs());
        }
        if ("Execute".equals(actionEvent.getActionCommand())) {
            this.execute();
        }
        if ("Execute+Open".equals(actionEvent.getActionCommand())) {
            this.execute();
            try {
                if (this.awtdesktop != null && this.awtdesktop.isSupported(Desktop.Action.OPEN)) {
                    this.awtdesktop.open(this.getDestPathPDF());
                } else {
                    Executable.openDocument(this.getDestPathPDF());
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        if ("Execute+Printdialog".equals(actionEvent.getActionCommand())) {
            this.execute();
            try {
                if (this.awtdesktop != null && this.awtdesktop.isSupported(Desktop.Action.PRINT)) {
                    this.awtdesktop.print(this.getDestPathPDF());
                } else {
                    Executable.printDocument(this.getDestPathPDF());
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        if ("Execute+Print".equals(actionEvent.getActionCommand())) {
            this.execute();
            try {
                Executable.printDocumentSilent(this.getDestPathPDF());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }

    protected abstract File getDestPathPDF() throws InstantiationException;

    protected abstract void createFrame();

    public abstract void execute();

    public abstract void valueHasChanged(AbstractArgument var1);

    protected static void addVersion(String string) {
        string = string.substring(5, string.length() - 2);
        versionsarray.add(string);
    }
}

