/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.calculator;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.engine.core.DataException;

public class NumberCalculator
implements ICalculator {
    @Override
    public Number add(Object a, Object b) throws DataException {
        return ((Number)a).doubleValue() + ((Number)b).doubleValue();
    }

    @Override
    public Number subtract(Object a, Object b) throws DataException {
        return ((Number)a).doubleValue() - ((Number)b).doubleValue();
    }

    @Override
    public Number multiply(Object a, Object b) throws DataException {
        return ((Number)a).doubleValue() * ((Number)b).doubleValue();
    }

    @Override
    public Number divide(Object dividend, Object divisor) throws DataException {
        return ((Number)dividend).doubleValue() / ((Number)divisor).doubleValue();
    }

    @Override
    public Number safeDivide(Object dividend, Object divisor, Number ifZero) throws DataException {
        try {
            return this.divide(dividend, divisor);
        }
        catch (ArithmeticException arithmeticException) {
            return ifZero;
        }
    }

    @Override
    public Object getTypedObject(Object obj) throws DataException {
        try {
            return DataTypeUtil.toDouble((Object)obj);
        }
        catch (BirtException e) {
            throw DataException.wrap((BirtException)e);
        }
    }
}

