/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.List;
import org.eclipse.birt.report.model.api.core.IAccessControl;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.DummyNameContext;
import org.eclipse.birt.report.model.core.namespace.INameContainer;
import org.eclipse.birt.report.model.core.namespace.INameContext;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public abstract class AbstractNameHelper
implements INameHelper,
IAccessControl {
    protected INameContext[] nameContexts = null;
    protected NameSpace[] cachedNameSpaces = null;

    public AbstractNameHelper() {
        this.initCachedNameSpaces();
    }

    protected void initCachedNameSpaces() {
        this.cachedNameSpaces = new NameSpace[this.getNameSpaceCount()];
        int i = 0;
        while (i < this.getNameSpaceCount()) {
            this.cachedNameSpaces[i] = new NameSpace();
            ++i;
        }
    }

    protected abstract void initialize();

    protected abstract int getNameSpaceCount();

    public INameContext getNameContext(int nameSpaceID) {
        if (nameSpaceID >= 0 && nameSpaceID < this.getNameSpaceCount()) {
            return this.nameContexts[nameSpaceID];
        }
        return new DummyNameContext();
    }

    @Override
    public void clear() {
        this.initCachedNameSpaces();
    }

    public NameSpace getCachedNameSpace(int id) {
        assert (id >= 0 && id < this.getNameSpaceCount());
        return this.cachedNameSpaces[id];
    }

    @Override
    public final void dropElement(int namespaceId, DesignElement element) {
        if (element == null) {
            return;
        }
        NameSpace ns = this.getCachedNameSpace(namespaceId);
        String name = element.getName();
        if (element instanceof StyleElement) {
            String string = name = name == null ? null : name.toLowerCase();
        }
        if (ns.getElement(name) == element) {
            ns.remove(element);
        }
    }

    @Override
    public NameSpace getNameSpace(int nameSpaceID) {
        return this.getNameContext(nameSpaceID).getNameSpace();
    }

    @Override
    public void makeUniqueName(int namespaceId, DesignElement element) {
        this.makeUniqueName(namespaceId, element, null);
    }

    @Override
    public void makeUniqueName(int namespaceId, DesignElement element, String prefix) {
        DesignElement cachedElement;
        if (element == null) {
            return;
        }
        String name = this.getUniqueName(namespaceId, element, prefix);
        if (name == null) {
            return;
        }
        NameSpace nameSpace = this.getCachedNameSpace(namespaceId);
        String validName = name;
        if (element instanceof StyleElement) {
            validName = validName.toLowerCase();
        }
        if ((cachedElement = nameSpace.getElement(validName)) == null) {
            element.setName(name.trim());
            nameSpace.insert(element);
        }
    }

    @Override
    public ElementRefValue resolve(DesignElement focus, String elementName, PropertyDefn propDefn, IElementDefn elementDefn) {
        ElementDefn targetDefn;
        if (!this.isValidReferenceProperty(propDefn)) {
            throw new IllegalArgumentException("Property should be element reference type or extends type");
        }
        ElementDefn elementDefn2 = targetDefn = propDefn == null ? null : (ElementDefn)propDefn.getTargetElementType();
        if (targetDefn == null) {
            if (elementDefn == null) {
                throw new IllegalArgumentException("The element definition should not be null");
            }
            targetDefn = (ElementDefn)elementDefn;
        }
        ElementDefn nameContainerDefn = (ElementDefn)targetDefn.getNameConfig().getNameContainer();
        assert (nameContainerDefn != null);
        if (this.getElement().getDefn().isKindOf(nameContainerDefn)) {
            int id = targetDefn.getNameSpaceID();
            return this.getNameContext(id).resolve(focus, elementName, propDefn, (ElementDefn)elementDefn);
        }
        ElementPropertyDefn propertyDefn = (ElementPropertyDefn)targetDefn.getNameConfig().getNameProperty();
        if (propertyDefn != null) {
            return this.resolveNameInNonameHost(focus, elementName, propDefn, targetDefn, nameContainerDefn);
        }
        return this.resolveName(focus, elementName, propDefn, targetDefn);
    }

    @Override
    public ElementRefValue resolve(DesignElement focus, DesignElement element, PropertyDefn propDefn, IElementDefn elementDefn) {
        ElementDefn targetDefn;
        if (element == null) {
            return null;
        }
        if (!this.isValidReferenceProperty(propDefn)) {
            throw new IllegalArgumentException("Property should be element reference type or extends type");
        }
        ElementDefn elementDefn2 = targetDefn = propDefn == null ? null : (ElementDefn)propDefn.getTargetElementType();
        if (targetDefn == null) {
            if (elementDefn == null) {
                throw new IllegalArgumentException("The element definition should not be null");
            }
            targetDefn = (ElementDefn)elementDefn;
        }
        if (!element.getDefn().isKindOf(targetDefn)) {
            Module module = element.getRoot();
            String namespace = module == null ? null : module.getNamespace();
            String name = element.getFullName();
            return new ElementRefValue(namespace, name);
        }
        ElementDefn nameContainerDefn = (ElementDefn)targetDefn.getNameConfig().getNameContainer();
        assert (nameContainerDefn != null);
        if (this.getElement().getDefn().isKindOf(nameContainerDefn)) {
            int id = targetDefn.getNameSpaceID();
            return this.getNameContext(id).resolve(focus, element, propDefn, (ElementDefn)elementDefn);
        }
        ElementPropertyDefn propertyDefn = (ElementPropertyDefn)targetDefn.getNameConfig().getNameProperty();
        return this.resolveElement(focus, element, propDefn, targetDefn);
    }

    @Override
    public boolean canContain(int nameSpaceID, String elementName) {
        return this.getNameContext(nameSpaceID).canContain(elementName);
    }

    @Override
    public List<DesignElement> getElements(int nameSpaceID, int level) {
        return this.getNameContext(nameSpaceID).getElements(level);
    }

    private NameResolveInfor getRootResolveInfor(String elementName, ElementDefn targetDefn) {
        NameResolveInfor searchInfor = new NameResolveInfor(targetDefn, elementName);
        IElementDefn moduleDefn = MetaDataDictionary.getInstance().getElement("Module");
        while (searchInfor != null) {
            ElementDefn holderDefn = (ElementDefn)searchInfor.elementDefn.getNameConfig().getNameContainer();
            if (holderDefn != null && holderDefn.isKindOf(moduleDefn)) {
                return searchInfor;
            }
            int index = searchInfor.elementName.lastIndexOf("/");
            String resolveName = index == -1 ? searchInfor.elementName : searchInfor.elementName.substring(0, index);
            targetDefn = searchInfor.elementDefn;
            NameResolveInfor nameResolveInfor = searchInfor = holderDefn == null ? null : new NameResolveInfor(holderDefn, resolveName);
        }
        return null;
    }

    private ElementRefValue resolveElement(DesignElement focus, DesignElement element, PropertyDefn propDefn, IElementDefn elementDefn) {
        assert (element != null);
        NameExecutor executor = new NameExecutor(this.getElement().getRoot(), element);
        INameHelper nameHelper = executor.getNameHelper();
        if (nameHelper != null) {
            return nameHelper.resolve(focus, element, propDefn, elementDefn);
        }
        return null;
    }

    private ElementRefValue resolveNameInNonameHost(DesignElement focus, String elementName, PropertyDefn propDefn, ElementDefn elementDefn, IElementDefn nameContainerDefn) {
        ElementPropertyDefn targetProperty;
        assert (elementName != null);
        assert (elementDefn != null);
        assert (nameContainerDefn != null);
        Module root = this.getElement().getRoot();
        if (root != null && (targetProperty = (ElementPropertyDefn)elementDefn.getNameConfig().getNameProperty()) != null) {
            Object value = root.getProperty(root, targetProperty);
            if (value instanceof List) {
                List valueList = (List)value;
                value = valueList.isEmpty() ? null : valueList.get(0);
            }
            if (value instanceof INameContainer) {
                return ((INameContainer)value).getNameHelper().resolve(focus, elementName, propDefn, (IElementDefn)elementDefn);
            }
        }
        return new ElementRefValue(StringUtil.extractNamespace(elementName), StringUtil.extractName(elementName));
    }

    private ElementRefValue resolveName(DesignElement focus, String elementName, PropertyDefn propDefn, ElementDefn elementDefn) {
        NameResolveInfor rootInfor;
        assert (elementName != null);
        assert (elementDefn != null);
        Module root = this.getElement().getRoot();
        if (root != null && (rootInfor = this.getRootResolveInfor(elementName, elementDefn)) != null) {
            int id = rootInfor.elementDefn.getNameSpaceID();
            AbstractNameHelper nameHelper = (AbstractNameHelper)root.getNameHelper();
            ElementRefValue refValue = nameHelper.getNameContext(id).resolve(focus, rootInfor.elementName, propDefn, rootInfor.elementDefn);
            if (refValue != null && refValue.isResolved()) {
                DesignElement parentTarget = refValue.getElement();
                assert (parentTarget instanceof INameContainer);
                return ((INameContainer)((Object)parentTarget)).getNameHelper().resolve(focus, elementName, propDefn, (IElementDefn)elementDefn);
            }
        }
        return new ElementRefValue(StringUtil.extractNamespace(elementName), StringUtil.extractName(elementName));
    }

    private boolean isValidReferenceProperty(PropertyDefn propDefn) {
        if (propDefn == null) {
            return true;
        }
        int typeCode = propDefn.getTypeCode();
        switch (typeCode) {
            case 15: 
            case 17: {
                return true;
            }
            case 20: {
                return propDefn.getSubTypeCode() == 15;
            }
        }
        return false;
    }

    protected static boolean isValidInNameSpace(NameSpace namespace, DesignElement element, String name) {
        DesignElement tmpElement = namespace.getElement(name);
        return tmpElement == null || tmpElement == element;
    }

    @Override
    public void cacheValues() {
    }

    @Override
    public String getUniqueName(int namespaceId, DesignElement element, String namePrefix) {
        if (element == null) {
            return null;
        }
        ElementDefn eDefn = (ElementDefn)element.getDefn();
        String name = element.getName();
        if (StringUtil.isBlank(name)) {
            name = namePrefix;
        }
        name = StringUtil.trimString(name);
        name = NamePropertyType.validateName(name);
        if (eDefn.getNameOption() == 0) {
            return null;
        }
        if (eDefn.getNameOption() == 1 && name == null && this.getElement().getRoot() instanceof ReportDesign) {
            return null;
        }
        NameSpace nameSpace = this.getCachedNameSpace(namespaceId);
        NameSpace moduleNameSpace = this.nameContexts[namespaceId].getNameSpace();
        if (name != null && AbstractNameHelper.isValidInNameSpace(nameSpace, element, name) && AbstractNameHelper.isValidInNameSpace(moduleNameSpace, element, name)) {
            return name;
        }
        if (name == null) {
            name = this.getDefaultName(element);
        }
        int index = 0;
        String baseName = name;
        while (nameSpace.contains(name) || moduleNameSpace.contains(name)) {
            name = String.valueOf(baseName) + ++index;
        }
        return name;
    }

    @Override
    public final String getUniqueName(int namespaceId, DesignElement element) {
        return this.getUniqueName(namespaceId, element, null);
    }

    protected String getDefaultName(DesignElement element) {
        String name = null;
        name = ModelMessages.getMessage("New." + element.getDefn().getName());
        name = name.trim();
        return name;
    }

    private static class NameResolveInfor {
        ElementDefn elementDefn = null;
        String elementName = null;

        NameResolveInfor(ElementDefn defn, String name) {
            this.elementDefn = defn;
            this.elementName = name;
        }
    }
}

