/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config.importer;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.importer.DomImportHelper;
import amazon.fws.clicommando.config.importer.HelpImportHelper;
import amazon.fws.clicommando.config.importer.ImportCommand;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.files.XmlFileUtils;
import java.net.URL;
import java.util.List;
import org.w3c.dom.Element;

public class XmlImport
implements ImportCommand {
    public Command importCommandFrom(URL url) {
        return this.importCommandFrom(url.getPath(), "");
    }

    public Command importCommandFrom(String pathRoot) {
        return this.importCommandFrom(pathRoot, "");
    }

    public Command importCommandFrom(String xmlPathRoot, String xmlPath) {
        List<Element> documents = XmlFileUtils.processXmlIntoDoms(xmlPathRoot, xmlPath);
        DomImportHelper domImp = new DomImportHelper();
        Command cmd = domImp.createCommandFromElements(documents);
        return cmd;
    }

    public void attachHelpToCommand(Command command, String pathRoot, String path) {
        block2: {
            try {
                List<Element> documents = XmlFileUtils.processXmlIntoDoms(pathRoot, path);
                HelpImportHelper helpImp = new HelpImportHelper();
                helpImp.addHelpTo(command, documents);
            }
            catch (ConfigurationErrorException e) {
                if (e.getRealReason().contains("Can't read from file:")) break block2;
                throw e;
            }
        }
    }
}

