/*
    oscpack -- Open Sound Control packet manipulation library
    http://www.audiomulch.com/~rossb/oscpack

    Copyright (c) 2004-2005 Ross Bencina <rossb@audiomulch.com>

    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files
    (the "Software"), to deal in the Software without restriction,
    including without limitation the rights to use, copy, modify, merge,
    publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so,
    subject to the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    Any person wishing to distribute modifications to the Software is
    requested to send the modifications to the original developer so that
    they can be incorporated into the canonical version.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
    ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef INCLUDED_OSC_EXCEPTION_H
#define INCLUDED_OSC_EXCEPTION_H

#include <exception>

namespace osc {

class Exception : public std::exception
{
    const char* what_;

  public:
    Exception() throw() {}
    Exception(const Exception& src) throw()
        : what_(src.what_)
    {
    }
    Exception(const char* w) throw()
        : what_(w)
    {
    }
    Exception& operator=(const Exception& src) throw()
    {
        what_ = src.what_;
        return *this;
    }
    virtual ~Exception() throw() {}
    virtual const char* what() const throw() { return what_; }
};

} // namespace osc

#endif /* INCLUDED_OSC_EXCEPTION_H */
